--[[ Copyright (c) 2024 ShimaKen

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. --]]

Font("unicode")
Language("日本語", "Japanese", "ja", "jp")
Inherit("english")
Encoding(utf8)
IsArabicNumerals(false)

main_menu = {
  new_game = "新しく始める",
  custom_campaign = "カスタムキャンペーン",
  custom_level = "カスタムシナリオ",
  continue = "続きから始める",
  load_game = "ロード",
  options = "オプション",
  map_edit = "マップエディター",
  savegame_version = "セーブデータのバージョン: ",
  updates_off = "アップデートをオフにする",
  version = "バージョン: ",
  exit = "ゲームを終了する",
}

tooltip.main_menu = {
  new_game = "キャンペーンの最初のレベルを開始します",
  network = "マルチプレイを開始します",
  custom_campaign = "コミュニティによって作成されたキャンペーンで遊びます",
  custom_level = "単一シナリオで遊びます",
  continue = "最後に遊んだところから再開します",
  load_game = "セーブデータを選択して再開します",
  options = "いろいろな設定をします",
  map_edit = "カスタムマップを作ります",
  exit = "いやいや、ゲームをやめないでください！",
  quit = "CorsixTHをやめようとしています。 本当にやめていいですか？",
}

new_game_window = {
  caption = "キャンペーン",
  player_name = "プレイヤー名",
  option_on = "オン",
  option_off = "オフ",
  difficulty = "難易度",
  easy = "ジュニア (イージー)",
  medium = "ドクター (ミディアム)",
  hard = "コンサルタント (ハード)",
  tutorial = "チュートリアル",
  start = "スタート",
  cancel = "キャンセル",
}

menu_options_warmth_colors = {
  choice_1 = "    赤  ",
  choice_2 = "    青 緑 赤  ",
  choice_3 = "    黄 橙 赤  ",
}

  date_format = {
  daymonth = "%2%/%1%",
}

custom_game_window = {
  caption = "カスタムシナリオ",
  free_build = "フリービルド",
  load_selected_level = "スタート",
}
tooltip.custom_game_window = {
  choose_game = "レベルをクリックすると詳細が表示されます",
  free_build = "お金や勝ち負けの条件なしでプレイしたい場合は、このボックスにチェックを入れてください",
  load_selected_level = "選択したレベルをロードして遊びます",
}

load_game_window = {
  caption = "ゲームをロードする (%1%)",
  load_button = "ロード",
}

save_game_window = {
  caption = "ゲームをセーブする (%1%)",
  new_save_game = "新しいセーブ",
  missing_filename = "新しくセーブデータ名を入力するか 上書きするセーブデータを選択してください",
  save_button = "セーブ",
}

folders_window = {
  caption = "フォルダの場所",
  data_label = "テーマホスピタルのデータ",
  font_label = "フォント",
  music_label = "ミュージック",
  savegames_label = "セーブデータ",
  screenshots_label = "スクリーンショット",
  -- next four are the captions for the browser window, which are called from the folder setting menu
  new_th_location = "ここで、新しくテーマホスピタルが インストールされたディレクトリ または ISOファイルを指定できます。 新しいディレクトリを選択するとすぐにゲームが再起動されます。 ファイル拡張子は現在表示されません。",
  savegames_location = "保存に使用するディレクトリを選択してください",
  music_location = "音楽に使用するディレクトリを選択してください",
  screenshots_location = "スクリーンショットに使用するディレクトリを選択してください",
  back  = "戻る",
}

tooltip.folders_window = {
  browse = "フォルダの場所を参照",
  data_location = "CorsixTHを実行するために必要な、元のテーマホスピタルをインストールしたディレクトリまたはISOファイルの場所",
  font_location = "選択した言語に必要なUnicode文字を表示できるフォントファイルの場所 。これを指定しない場合、元のゲームで提供されている文字種よりも多くの文字を必要とする言語を選択できなくなります。 例: 日本語、ロシア語や中国語",
  savegames_location = "デフォルトでは、保存ディレクトリは設定ファイルの隣にあり、セーブデータを保存するために使用されます。 または、使用するディレクトリを参照して独自のディレクトリを選択することもできます。",
  screenshots_location = "デフォルトでは、スクリーンショットは設定ファイルの隣にあるフォルダに保存されます。 または、使用するディレクトリを参照して独自のディレクトリを選択することもできます。",
  music_location = "ディレクトリを参照して音楽ファイルの場所を選択します。 (ディレクトリは既に存在している必要があります)",
  browse_data = "テーマホスピタルがインストールされている別の場所を選択します (現在の場所: %1% ) ",
  browse_font = "別のフォントを選択します ( 現在の場所: %1% ) ",
  browse_saves = "セーブデータを保存する別の場所を選択します ( 現在の場所: %1% ) ",
  browse_screenshots = "スクリーンショットを保存する別の場所を選択します ( 現在の場所: %1% ) ",
  browse_music = "音楽に使用する別の場所を選択します ( 現在の場所: %1% ) ",
  no_font_specified = "フォントが設定されていません！",
  not_specified = "フォルダが設定されていません！",
  default = "デフォルト設定のまま",
  reset_to_default = "デフォルト設定にリセットします",
  back  = "メニューを閉じて設定メニューに戻ります",
}

customise_window = {
  caption = "カスタム設定",
  option_on = "オン",
  option_off = "オフ",
  back = "戻る",
  movies = "グローバルムービーの設定",
  intro = "オープニングムービーの再生",
  paused = "一時停止中に建築する",
  volume = "音量を下げるホットキー",
  aliens = "エイリアンDNA病",
  fractured_bones = "骨折",
  average_contents = "いつもの設備",
  remove_destroyed_rooms = "破壊された部屋を撤去",
}

tooltip.customise_window = {
  movies = "すべてのムービーをオフに設定できます",
  intro = "オープニングムービーをオン/オフできます。 CorsixTHをロードするたびにオープニングムービーを再生したい場合は、グローバルムービーをオンにする必要があります",
  paused = "テーマホスピタルではゲームが一時停止されている場合、プレーヤーはメニューのみを使用できます。 これはCorsixTHでもデフォルト設定ですが、これをオンにすると、ゲームが一時停止されている間にすべての行動が許可されます",
  volume = "ボリュームを下げるボタンでケースブックも開いてしまう場合には、これをオンにしてケースブックのホットキーを Shift + C に変更します",
  aliens = "適切なアニメーションがないため、エイリアンDNA病の患者は緊急要請の場合のみに来院する設定をデフォルトとしています。 エイリアンDNA病の患者が緊急要請以外でも来院するようにするには、これをオフにします。",
  fractured_bones = "アニメーションが不十分であるため、骨折した女性患者が来院しない設定をデフォルトとしています。 骨折した女性患者も来院するようにするには、このオプションをオフにしてください。",
  average_contents = "部屋を建てるときにあなたがいつも追加する設備をゲームに記憶させたい場合は、このオプションをオンにしてください",
  remove_destroyed_rooms = "破壊された部屋を有料で撤去したい場合は、このオプションをオンにしてください",
  back = "メニューを閉じて設定メニューに戻ります",
}

options_window = {
  caption = "設定",
  fullscreen = "フルスクリーン",
  option_on = "オン",
  option_off = "オフ",
  check_for_updates = "アップデートの確認",
  option_enabled = "オン",
  option_disabled = "オフ",
  resolution = "解像度",
  capture_mouse = "カーソルの移動範囲",
  right_mouse_scrolling = "マップスクロール",
  right_mouse_scrolling_option_middle = "真ん中のボタン",
  right_mouse_scrolling_option_right = "右のボタン",
  custom_resolution = "カスタム...",
  width = "横幅 / width",
  height = "高さ / Height",
  audio = "オーディオ",
  customise = "カスタム設定",
  folder = "フォルダの場所",
  language = "言語",
  apply = "決定",
  cancel = "キャンセル",
  back = "戻る",
  scrollspeed = "スクロール速度",
  shift_scrollspeed = "スクロール速度 (+Shift)",
  zoom_speed = "ズーム速度",
  hotkey = "ホットキーの設定",
  jukebox = "ジュークボックス",
  change_resolution = "解像度の変更",
}

tooltip.options_window = {
  fullscreen = "ゲームをフルスクリーンモードとウィンドウモードのどちらで実行するかを設定できます",
  fullscreen_button = "オンにするとフルスクリーンモードになります",
  resolution = "ゲームの解像度を設定できます",
  select_resolution = "新しい解像度を選択してください",
  capture_mouse = "オンにするとマウスカーソルが画面外に出なくなります",
  right_mouse_scrolling = "マップをスクロールするマウスボタンを切り替えます",
  width = "ご希望の画面幅を入力してください",
  height = "ご希望の画面高さを入力してください",
  apply = "入力した解像度で決定する",
  cancel = "解像度を変更せずに戻る",
  audio_button = "すべての音楽をオン/オフする",
  audio_toggle = "オン / オフを設定してください",
  customise_button = "ゲーム体験のためのより詳細な設定ができます",
  folder_button = "フォルダオプションです",
  language = "ゲーム内の使用言語です",
  select_language = "言語を選択してください",
  language_dropdown_item = " %s を選択する",
  language_dropdown_no_font = "この言語を選択するためにはフォルダの設定からフォントを選択してください",
  back = "ウインドウを閉じて戻ります",
  scrollspeed = "スクロール速度を 1(遅い) から 10(速い) の間で設定します。デフォルトは2です。",
  shift_scrollspeed = "Shiftキーを押した時のスクロール速度を 1(遅い) から 10(速い) の間で設定します。 デフォルトは4です。",
  zoom_speed = "カメラのズーム速度を 10(遅い) から 1000(速い) の間で設定します。 デフォルトは80です。",
  apply_scrollspeed = "入力したスクロール速度で決定する",
  cancel_scrollspeed = "スクロール速度を変更せずに戻る",
  apply_shift_scrollspeed = "入力した+Shiftスクロール速度で決定する",
  cancel_shift_scrollspeed = "+Shiftスクロール速度を変更せずに戻る",
  apply_zoomspeed = "入力したズーム速度で決定する",
  cancel_zoomspeed = "ズーム速度を変更せずに戻る",
  hotkey = "ホットキーの設定を変更する",
  check_for_updates = "アップデートがないか確認する",
  jukebox = "ジュークボックスを開く",
}

menu_list_window = {
  name = "名前",
  back = "戻る",
  save_date = "更新日",
  ok = "決定",
}

update_window = {
  caption = "アップデートがあります！",
  new_version = "新しいバージョン:",
  current_version = "最新バージョン: ",
  download = "ダウンロードページヘ",
  ignore = "スキップしてメインメニューへ",
}

save_map_window = {
  caption = "マップをセーブする (%1%)",
  new_map = "新しいマップ",
  missing_filename = "新しくマップ名を入力するか 上書きするデータを選択してください",
  save_button = "セーブ",
}

hotkey_window = {
  caption_main = "ホットキーの割り当て",
  caption_panels = "パネルキー",
  button_accept = "決定",
  button_defaults = "デフォルトに戻す",
  button_cancel = "キャンセル",
  button_back = "戻る",
  button_toggleKeys = "トグルキー",
  button_gameSpeedKeys = "ゲームスピードキー",
  button_recallPosKeys = "元に戻すキー",
  panel_globalKeys = "グローバルキー",
  panel_generalInGameKeys = "一般的なゲーム内キー",
  panel_scrollKeys = "スクロールキー",
  panel_zoomKeys = "ズームキー",
  panel_gameSpeedKeys = "ゲームスピードキー",
  panel_toggleKeys = "トグルキー",
  panel_debugKeys = "デバッグキー",
  panel_storePosKeys = "場所を決定するキー",
  panel_recallPosKeys = "場所を元に戻すキー",
  panel_altPanelKeys = "代替パネルキー",
  global_confirm = "確認する",
  global_confirm_alt = "確認する Alt",
  global_cancel = "キャンセル",
  global_cancel_alt = "キャンセル Alt",
  global_fullscreen_toggle = "フルスクリーン",
  global_exitApp = "ゲームをやめる",
  global_resetApp = "ゲームをリセットする",
  global_releaseMouse = "マウスを放す",
  global_connectDebugger = "デバッガー",
  global_showLuaConsole = "Lua Console",
  global_runDebugScript = "Debug Script",
  global_screenshot = "スクリーンショット",
  global_stop_movie_alt = "ムービーを止める",
  global_window_close_alt = "ウィンドウを閉じる",
  ingame_scroll_up = "上へスクロール",
  ingame_scroll_down = "下へスクロール",
  ingame_scroll_left = "左へスクロール",
  ingame_scroll_right = "右へスクロール",
  ingame_scroll_shift = "スピードの変更",
  ingame_zoom_in = "ズームイン",
  ingame_zoom_in_more = "もっとズームイン",
  ingame_zoom_out = "ズームアウト",
  ingame_zoom_out_more = "もっとズームアウト",
  ingame_reset_zoom = "ズームのリセット",
  ingame_showmenubar = "メニューバーを表示する",
  ingame_showCheatWindow = "チートメニュー",
  ingame_loadMenu = "ゲームをロードする",
  ingame_saveMenu = "ゲームをセーブする",
  ingame_jukebox = "ジュークボックス",
  ingame_openFirstMessage = "レベルのメッセージ",
  ingame_pause = "一時停止",
  ingame_gamespeed_slowest = "最遅",
  ingame_gamespeed_slower = "遅め",
  ingame_gamespeed_normal = "普通",
  ingame_gamespeed_max = "最速",
  ingame_gamespeed_thensome = "早め",
  ingame_gamespeed_speedup = "スピードアップ",
  ingame_panel_bankManager = "銀行マネージャー",
  ingame_panel_bankStats = "口座の状況",
  ingame_panel_staffManage = "Manage Staff",
  ingame_panel_townMap = "タウンマップ",
  ingame_panel_casebook = "治療記録",
  ingame_panel_research = "研究",
  ingame_panel_status = "経営状態",
  ingame_panel_charts = "Charts",
  ingame_panel_policy = "方針",
  ingame_panel_map_alt = "タウンマップ 2",
  ingame_panel_research_alt = "研究 2",
  ingame_panel_casebook_alt = "治療記録 2",
  ingame_panel_casebook_alt02 = "治療記録 3",
  ingame_panel_buildRoom = "部屋を建てる",
  ingame_panel_furnishCorridor = "設備の設置",
  ingame_panel_editRoom = "部屋を編集する",
  ingame_panel_hireStaff = "スタッフを雇う",
  ingame_rotateobject = "設備を回転させる",
  ingame_quickSave = "クイックセーブ",
  ingame_quickLoad = "クイックロード",
  ingame_restartLevel = "レベルをリセットする",
  ingame_quitLevel = "レベルをやめる",
  ingame_setTransparent = "Transparent",
  ingame_toggleAnnouncements = "アナウンス",
  ingame_toggleSounds = "サウンド",
  ingame_toggleMusic = "音楽",
  ingame_toggleAdvisor = "アドバイザー",
  ingame_toggleInfo = "Info",
  ingame_poopLog = "Dump Log",
  ingame_poopStrings = "Dump Strings",
  ingame_patient_gohome = "家へ送り返す",
  ingame_storePosition_1 = "1",
  ingame_storePosition_2 = "2",
  ingame_storePosition_3 = "3",
  ingame_storePosition_4 = "4",
  ingame_storePosition_5 = "5",
  ingame_storePosition_6 = "6",
  ingame_storePosition_7 = "7",
  ingame_storePosition_8 = "8",
  ingame_storePosition_9 = "9",
  ingame_storePosition_0 = "10",
  ingame_recallPosition_1 = "1",
  ingame_recallPosition_2 = "2",
  ingame_recallPosition_3 = "3",
  ingame_recallPosition_4 = "4",
  ingame_recallPosition_5 = "5",
  ingame_recallPosition_6 = "6",
  ingame_recallPosition_7 = "7",
  ingame_recallPosition_8 = "8",
  ingame_recallPosition_9 = "9",
  ingame_recallPosition_0 = "10",
}

tooltip.hotkey_window = {
  button_accept = "ホットキーの設定を決定して保存する",
  button_defaults = "すべてのホットキーの設定をデフォルトに戻します",
  button_cancel = "変更をキャンセルしてオプションメニューに戻ります",
  caption_panels = "パネルキーの設定画面を開きます",
  button_gameSpeedKeys = "ゲームスピードを変更するキー設定の設定画面を開きます",
  button_recallPosKeys = "カメラポジションを変更するキー設定の設定画面を開きます",
  button_back_02 = "ホットキーの設定メイン画面に戻ります。 この画面での変更内容は適用・保存されます",
}

tooltip.new_game_window = {
  player_name = "あなたがこのゲーム内で遊びたい名前を入力してください",
  difficulty = "遊びたいゲームの難易度を選択してください",
  easy = "シミュレーションゲームを遊ぶのが初めてであればこちらをどうぞ",
  medium = "どれを選ぶべきか迷っているならこちらが中間択です",
  hard = "この種のゲームが得意で今回も挑戦がしたければこちらがオススメです",
  tutorial = "ゲームの遊び方の基本のキを学ぶにはクリックしてオンにしてください",
  start = "選択した内容でゲームを始めます",
  cancel = "やっぱり新しくゲームを始めるのやーめた！",
}

tooltip.totd_window = {
  previous = "前のヒントを表示します",
  next = "次のヒントを表示します",
}

tooltip.cheats_window = {
  close = "チートダイアログを閉じる",
  cheats = {
    money = "$10,000を資金に追加する",
    all_research = "すべての研究を完了する",
    emergency = "緊急要請を１件起こす",
    vip = "VIP来訪を１件起こす",
    toggle_earthquake = "地震イベントが起きるようにする",
    earthquake = "地震を発生させる",
    toggle_epidemic = "伝染病イベントが起きるようにする",
    epidemic = "伝染病を引き起こす可能性のある伝染性患者を作成します",
    show_infected = "発見された伝染病の感染者アイコンを表示/非表示にします",
    create_patient = "１人の新規患者をマップ境界に作成します",
    end_month = "月末にジャンプします",
    end_year = "年末にジャンプします",
    lose_level = "現在のレベルを失敗します",
    win_level = "現在のレベルをクリアします",
    increase_prices = "すべての料金を50%値上げします(最大200%まで)",
    decrease_prices = "すべての料金を50%値下げします(最小50%まで)",
    reset_death_count = "死者の数を０にリセットします",
    max_reputation = "病院の評判を最大に設定します",
  }
}

custom_campaign_window = {
  caption = "カスタムキャンペーン",
  start_selected_campaign = "キャンペーンを始める",
}

tooltip = {
  custom_campaign_window = {
    choose_campaign = "キャンペーンをクリックすると詳細が表示されます",
    start_selected_campaign = "キャンペーンの最初のレベルを開始します",
  },
  information = {
    close = "情報ダイアログを閉じる",
  },
  save_game_window = {
    save_game = "セーブデータ %s を上書きする",
    new_save_game = "新しいセーブデータの名前を入力する",
  },
  pay_rise_window = {
    accept = "支払い要求に応じる",
    decline = "支払うのではなく、代わりに解雇する",
  },
}

load_map_window = {
  caption = "マップをロードする (%1%)",
  load_button = "ロード",
}

dynamic_info = {
  patient = {
    emergency = "緊急事態: %s",
    guessed_diagnosis = "%s と推定診断",
    diagnosis_progress = "診断の進歩",
    actions = {
      sent_to_other_hospital = "他の病院へ送られました",
      prices_too_high = "料金が高すぎる - 家へ帰ります",
      no_gp_available = "新しい診断設備ができるのを待っています",
      waiting_for_treatment_rooms = "治療できる施設ができるのを待っています",
      dying = "死にかけ...",
      no_diagnoses_available = "正確な診断がされていません",
      epidemic_sent_home = "衛生検査官によって自宅に送られた",
      cured = "治った!",
      waiting_for_diagnosis_rooms = "診断設備が早くできるのを待っています",
      epidemic_contagious = "伝染病です!",
      awaiting_decision = "あなたの決定待ちです",
      sent_home = "家へ帰ります",
      fed_up = "すべて取得しました!",
      no_treatment_available = "治療する設備がありません!",
      on_my_way_to = "%s へ移動中",
      queueing_for = "%s の順番待ち",
      epidemic_vaccinated = "ワクチン接種済!",
    },
    diagnosed = "診断確定: %s ",
  },
  health_inspector = "衛生検査官",
  vip = "VIP",
  object = {
    times_used = "使用回数: %d",
    queue_size = "順番待ち: %d",
    strength = "強さ: %d",
    queue_expected = "列予想数: %d",
    strength_extra_info = "強度%d(最大強度 %d)"
  },
  staff = {
    actions = {
      going_to_repair = "%s へ修理に向かっています",
      fired = "クビにされました",
      waiting_for_patient = "患者待ち",
      wandering = "ブラブラしています",
      heading_for = "%s へ移動中",
      vaccine = "ワクチン",
    },
    tiredness = "疲労度",
--    psychiatrist_abbrev = "Псих.",
    ability = "能力:",
  },
}

handyman_window = {
  all_parcels = "全てのエリア",
  parcel = "エリア",
}
font_location_window = {
  caption = "フォントを選択してください (%1%)",
}

research = {
  allocated_amount = "資金配分",
  funds_allocation = "予算配分合計",
  categories = {
    diagnosis = "診断研究",
    cure = "治療研究",
    improvements = "改良研究",
    drugs = "薬品研究",
    specialisation = "特殊研究",
  },
}

progress_report = {
  more_drinks_machines = "もっと自販機を設置してください。",
  quite_unhappy = "人々は本当に不幸せです。",
  header = "進捗レポート",
  too_cold = "めちゃくちゃ寒いです。暖房機を設置してください。",
  percentage_pop = "% 母集団/人口",
  very_unhappy = "人々は不幸せです。",
  too_hot = "めちゃくちゃ暑いです。 暖房を調整してください。",
  win_criteria = "勝利条件",
  free_build = "自由建築",
}

policy = {
  staff_leave_rooms = "人手の足りない部屋へ行く",
  header = "病院の方針",
  staff_rest = "休憩させる疲労度",
  diag_procedure = "診断手法",
  diag_termination = "診断終了",
  sliders = {
    guess = "とにかく治療",
    send_home = "家に帰らせる",
    stop = "処置をストップ",
    staff_room = "休憩を取る",
  },
}
tooltip.policy = {
    staff_stay = "スタッフが配置された部屋から出ないようにするにはここをクリック",
    close = "方針画面を閉じる",
    staff_rest = "スタッフが休憩できるようになるまでの疲労度",
    staff_leave = "暇しているスタッフが人手を必要としている部屋に手伝いに行かせるにはここをクリック",
    diag_procedure = "医師の診断が「家に帰らせる」の値未満の場合は患者は自宅に送り返されます。 診断が「とにかく治療」以上の場合は患者は適切な治療が施されます。",
    diag_termination = "患者の診断は、医師の診断判定が「処置をストップ」の指す値と同じになるまでか、病院内全ての診断機で検査を受け終わるまで続きます。",
}
menu_charts = {
  casebook = "  (%1%) 帳簿  ",
  staff_listing = "  (%1%) スタッフリスト  ",
  briefing = "  BRIEFING  ",
  town_map = "  (%1%) タウンマップ  ",
  research = "  (%1%) 研究  ",
  status = "  (%1%) 経営状態  ",
  statement = "  (%1%) 状況報告  ",
  policy = "  (%1%) 方針  ",
  graphs = "  (%1%) グラフ  ",
  bank_manager = "  (%1%) 銀行マネージャー  ",
}

misc = {
  hospital_open = "開院",
  save_success = "セーブが成功しました",
  save_failed = "注意：セーブに失敗しました",
  low_res = "ローレゾ",
  no_heliport = "病気はまだ発見されていないか、この地図にはヘリポートがありません。 受付デスクを建てて受付係を雇う必要があるかもしれません。",
  grade_adverb = {
    extremely = "かなり",
    mildly = "そこそこ",
    moderately = "まぁまぁ",
  },
  not_yet_implemented = "(まだ実装されていません)",
  send_message = "プレイヤーにメッセージを送る %d",
  out_of_sync = "ゲームが同期されていません",
  balance = "銀行残高",
  load_failed = "セーブデータをロードできませんでした",
  mouse = "ネズミ",
--  done = "Зроблено",
--  force = "Прискорення",
  pause = "一時停止",
  send_message_all = "すべてのプレイヤーにメッセージを送信する",
  cant_treat_emergency = "病気が発見されていないため、あなたの病院はこの緊急事態を治療できません。 遠慮なくもう一度試してください。",
  epidemic_no_diseases = "伝染病を作成できません - 利用可能な伝染病はありません",
  earthquakes_on = "地震は無効になっています",
  earthquakes_off = "地震が再び有効になります",
  epidemics_off = "伝染病は無効になっています",
  epidemics_on = "伝染病が再び有効になります",
  epidemic_no_receptionist = "伝染病を作成できません - 受付デスクがないか受付係がいません",
  epidemic_no_icon_to_toggle = "感染したアイコンを表示/非表示にできません - アクティブな未検出の伝染病はありません",
}

staff_list = {
  morale = "モラル",
  tiredness = "疲労度",
  skill = "スキル",
  total_wages = "賃金",
}
build_room_window = {
  pick_room_type = "部屋のタイプを選択してください",
  pick_department = "部門を選択",
  cost = "コスト: ",
}
room_classes = {
  diagnosis =  "検査",
  treatment =  "治療",
  clinics =    "処置",
  facilities = "施設",
}
rooms_short = {
  gps_office =        "診察室",
  general_diag =      "検査室",
  ultrascan =         "超音波検査室",
  research_room =     "研究室",
  fracture_clinic =   "整骨科",
  staffroom =         "スタッフルーム",
  jelly_vat =         "ゼリー槽室",
  scanner =           "スキャナー室",
  decontamination =   "汚染除去室",
  pharmacy =          "薬局",
  cardiogram =        "心臓科",
  reception =         "受付",
  training_room =     "講義室",
  corridor_objects =  "廊下の配置",
  operating_theatre = "手術室",
  dna_fixer =         "DNA修復室",
  ward =              "病室",
  psychiatric =       "精神科",
  hair_restoration =  "増毛科",
  inflation =         "空気注入室",
  tongue_clinic =     "ベロ出し病クリニック",
  toilets =           "トイレ",
  electrolysis =      "電気脱毛室",
  x_ray =             "レントゲン室",
  blood_machine =     "血液調整機室",
  destroyed =         "破壊",
}
rooms_long = {
  gps_office = "診察室",
  general_diag = "検査室",
  ultrascan = "超音波検査室",
  research_room = "研究室",
  fracture_clinic = "整骨科",
  staffroom = "スタッフルーム",
  jelly_vat = "ゼリー槽室",
  scanner = "スキャナー室",
  inflation = "空気注入室",
  decontamination = "汚染除去室",
  corridors = "廊下",
  cardiogram = "心臓科",
  ward = "病室",
  training_room = "講義室",
  psychiatric = "精神科",
  operating_theatre = "手術室",
  dna_fixer = "DNA修復室",
  tongue_clinic = "ベロ出し病クリニック",
  hair_restoration = "増毛科",
  pharmacy = "薬局",
  toilets = "トイレ",
  electrolysis = "電気脱毛室",
  x_ray = "レントゲン室",
  blood_machine = "血液調整機室",
  emergency = "緊急事態",
  general = "一般",
}
buy_objects_window = {
  price = "単価: ",
  choose_items = "項目を選択する",
  total = "合計: ",
}
object = {
  chair = "イス",
  litter = "ガラクタ",
  sofa = "ソファー",
  operating_table = "手術台",
  bench = "ベンチ",
  scanner = "スキャナー",
  couch = "カウチ",
  blood_machine = "血液調整機",
  video_game = "ビデオゲーム",
  op_sink2 = "流し台",
  door = "ドア",
  auto_autopsy = "自動解剖機",
  reception_desk = "受付デスク",
  hair_restorer = "毛髪調整機",
  projector = "プロジェクター",
--  crash_trolley = "Аварійний візок",
  tv = "テレビ",
  ultrascanner = "超音波検査機",
  surgeon_screen = "外科医用スクリーン",
  jelly_moulder = "ゼリー槽",
  x_ray_viewer = "Ｘ線可視装置",
  radiation_shield = "放射線シールド",
  cardio = "心電計",
  slicer = "舌切り機",
  inflator = "空気注入機",
  dna_fixer = "DNA修復機",
  x_ray = "X線",
  litter_bomb = "ゴミ爆弾",
  desk = "デスク",
  pool_table = "ビリヤード台",
  bed = "ベッド",
  swing_door2 = "スイングドア",
  console = "コンソール",
  op_sink1 = "流し台",
  bookcase = "本棚",
  drinks_machine = "自販機",
  comfortable_chair = "安楽イス",
  skeleton = "骨格標本",
  computer = "コンピュータ",
  bin = "ゴミ箱",
  pharmacy_cabinet = "薬品棚",
  radiator = "暖房機",
  cast_remover = "整骨マシン",
  atom_analyser = "原子分析機",
  plant = "観葉植物",
  toilet = "トイレ",
  electrolyser = "電解槽",
  fire_extinguisher = "消火器",
  swing_door1 = "スイングドア",
  lecture_chair = "講義イス",
  screen = "スクリーン",
  toilet_sink = "流し台",
  shower = "シャワー",
  gates_of_hell = "地獄のゲート",
  cabinet = "キャビネット",
  lamp = "ランプ",
  entrance_left = "左開きドア",
  table2 = "テーブル",
  bed2 = "ベッド",
  bed3 = "ベッド",
  entrance_right = "右開きドア",
  table1 = "テーブル",
  rathole = "ネズミの巣穴",
}
room_descriptions = {
  gp = {
    [1] = "診察室//",
    [2] = "あなたの病院の治療の中心となるのはこの診察室です 。すべての患者は自分のどこが悪いのかを知るためにまず最初にここに送られます。 彼らはここからさらなる検査または治療のために各施設へ送られます。 患者が多すぎる場合は別の部屋を建ててください。 充実した設備と広々とした部屋は治療の効率を上げます。 これはすべての部屋に当てはまります。//",
    [3] = "どんな医師でも診察室で働くことができます。",
  },
  general_diag = {
    [1] = "検査室//",
    [2] =  "追加の検査が必要な患者はここに来ます。 この部屋では診察室よりも医師が患者をより詳細に診察することができます。 患者は診断を決定するために検査の結果を持って診察室へ戻ります。//",
    [3] = "どんな医師でも検査室で働くことができます。",
  },
  ultrascan = {
    [1] = "超音波検査室//",
    [2] = "超音波検査機は最高の検査ツールの1つです。 患者に最高の検査を提供したい場合はぜひ導入してください。 検査の後は再診察のため診察室に行きます。//",
    [3] = "どんな医師でも診察室で働くことができます。この装置は定期メンテナンスが必要です。",
  },
  scanner = {
    [1] = "スキャナー室//",
    [2] = "患者はスキャナーを使用してより正確な診断を受けます。 その後、再診察のため診察室に行きます。//",
    [3] = "装置を操作するには医師が必要です。この装置は定期メンテナンスが必要です。",
  },
  blood_machine = {
    [1] = "血液調整機室//",
    [2] = "血液調整機は、患者の血球の色をチェックして状態を判断します。 血液の調査を行った後は再診察のため診察室に行きます。//",
    [3] = "装置を操作するには医師が必要です。この装置は定期メンテナンスが必要です。",
  },
  x_ray = {
    [1] = "レントゲン室//",
    [2] = "レントゲンは特殊な放射線を利用して、患者の体内を撮影し、病気の原因の特定と治療に役立てます。//",
    [3] = "装置を操作するには医師が必要です。この装置は定期メンテナンスが必要です。",
  },
  cardiogram = {
    [1] = "心臓科//",
    [2] = "ここでは、まったくスポーツをしない患者が、血圧を激しく上昇させる嫌いなランニングをさせられます。 これらの指標は、医師が診断を下すのに役立ちます。//",
    [3] = "装置を操作するには医師が必要です。この装置は定期メンテナンスが必要です。",
  },
  fracture_clinic = {
    [1] = "整骨科//",
    [2] = "骨を折ってしまった不幸な患者がここに来ます。 接骨マシンが患者体内から不要な小骨を除去します。 石膏カッターは強力な工業用レーザーを使用して、患者がほとんど痛みを感じない間に硬化したギプスを切断します。//",
    [3] = "看護師のみが整骨科で働くことができます。この装置は定期メンテナンスが必要です。",
  },
  inflation = {
    [1] = "空気注入室//",
    [2] = "風船あたま病を持つ患者は、ここに来ます。 巨大化した頭蓋骨に穴を開けてから、適切な空気圧になるよう空気を注入します。//",
    [3] = "装置を操作するには医師が必要です。この装置は定期メンテナンスが必要です。",
  },
  jelly_vat = {
    [1] = "ゼリー槽室//",
    [2] = "ゼリー病で苦しんでいる患者は、ゼリー槽室へいかなければなりません。 ゼリー病はゼリー槽によって直されますが、なぜこの方法で直るかは、医学的に解明されていません。//",
    [3] = "装置を操作するには医師が必要です。この装置は定期メンテナンスが必要です。",
  },
  pharmacy = {
    [1] = "薬局//",
    [2] = "診断によって薬が必要とされた患者は、薬局を訪れるべきです。 新しい治療薬が開発されるに従って、薬局の忙しさも増していくことでしょう。 もし必要なら追加で薬局を建てるようにしましょう。//",
    [3] = "看護師のみが薬局で働くことができます。",
  },
  ward = {
    [1] = "病室//",
    [2] = "診断の間、観察のためにここで時間を過ごします。彼らはまた手術の前に休息も取ります。 横になってレモンティーを飲むという治療を受ける人もいます。//",
    [3] = "看護師のみが病室で働くことができます",
  },
  psych = {
    [1] = "精神科//",
    [2] = "精神疾患のある患者は精神科医のオフィスを訪れなければなりません。そこでは精神科医が快適な椅子に座って待っています。 それから彼らはカウチに横たわって診断され、最終的には魔法と賄賂で治療されます。//",
    [3] = "精神科医の資格を持つ医師のみが精神科で働くことができます",
  },
  operating_theatre = {
    [1] = "手術室//",
    [2] = "ここは、メス、時にはチェーンソーも必要になるような、様々な病気を治療する重要な部屋です。 適度に広い室内に、適切な設備が必要です。//",
    [3] = "外科医の資格を持つ２人の医師を必要とします。定期メンテナンスも必要です。",
  },
  dna_fixer = {
    [1] = "DNA修復室//",
    [2] = "宇宙人によって遺伝子組換を受けた人々は、DNAを体から抽出し、完全に精製して、患者のすべての細胞に戻さなければなりません。 DNA修復機は非常に繊細な機械ですので、事故に備え、部屋に消火器を用意するのが賢明です。//",
    [3] = "DNA修復機の扱いには、研究医の資格を持つ医師が必要です。定期メンテナンスも必要です。",
  },
  hair_restoration = {
    [1] = "増毛科//",
    [2] = "ハゲ病の極端な症状に苦しむ患者は、増毛科へ送られます。 医師が機械を操作し、患者の頭に新鮮な毛を植え付けます。 もちろん性格は治療できませんが．．．//",
    [3] = "装置を操作するには医師が必要です。この装置は定期メンテナンスが必要です。",
  },
  electrolysis = {
    [1] = "電気脱毛室",
    [2] = "毛むくじゃら病の患者はこの部屋へ送られます。 そこで電気脱毛機と呼ばれる特別な機械が電気的に毛を引き抜き、粘性のある混合溶液で毛穴を閉じます。//",
    [3] = "装置を操作するには医師が必要です。この装置は定期メンテナンスが必要です。",
  },
  slack_tongue = {
    [1] = "ベロだし病クリニック//",
    [2] = "ベロ出し病と診断された患者は、このクリニックに送られます。 医師は最新の精密な装置を使用して舌を伸ばしてちょん切って、舌を正しい長さに戻します。//",
    [3] = "装置を操作するには医師が必要です。この装置は定期メンテナンスが必要です。",
  },
  no_room = {
    [1] = "",
  },
  decontamination = {
    [1] = "汚染除去室//",
    [2] = "過剰な放射線を浴びた患者はすぐに汚染除去室に送られます。 この部屋には恐ろしい放射線と死の灰を洗い流すシャワーがあり、その後患者は髪をとかされます。//",
    [3] = "装置を操作するには医師が必要です。この装置は定期メンテナンスが必要です。",
  },
  tv_room = {
    [1] = "TV室は現在使用されていません",
  },
  staff_room = {
    [1] = "スタッフルーム//",
    [2] = "スタッフたちは働くことで疲れてしまいます。 彼らには休息と体力の回復のためにこの部屋が必要です。 疲れたスタッフは仕事が遅くなり、より多くの賃金を要求し始め、最終的には辞めてしまうかもしれません もちろんミスも多くなります。 広い部屋でテレビを見たりビデオゲームをしたりできるようにすると、より疲れから解放されるでしょう。 複数のスタッフが同時にゆっくりできるスペースがあることを確認してください。",
  },
  training = {
    [1] = "講義室//",
    [2] = "ジュニアとドクターは、この部屋で学習することで、貴重な追加スキルを習得できます。 外科医、精神科医、研究医のスキルを持つコンサルタントが、勉強中の医師にそれらのスキルを伝えていきます。//",
    [3] = "講義室はコンサルタントを必要とします。",
  },
  toilets = {
    [1] = "トイレ//",
    [2] = "自然の欲求に従って、患者はここにやってきます。 もし来院数が多い場合は、追加の個室と洗面台を建設できます。 他の場所に追加のトイレを建設することをも検討する必要があるかもしれません。",
  },
  research = {
    [1] = "研究室//",
    [2] = "この病院で最も賢明な医師たちは、新しい薬や設備を発明し、改良しています。 治癒率を高めるために信じられないほどのことを行う、病院の重要な部分です！//",
    [3] = "研究医の資格を持つ医師のみが研究室で働くことができます",
  },
}
place_objects_window = {
  place_objects_in_corridor = "これらの設備を廊下に設置します",
  drag_blueprint = "部屋を希望のサイズに拡張します。",
  place_door = "ドアを設置します",
  place_windows = "必要に応じて窓を追加し、「確認」をクリックします",
  confirm_or_buy_objects = "項目を追加、削除、または移動できます。",
  place_objects = "アイテムを選択して目的の場所に配置します。",
  pick_up_object = "アイテムをクリックして選択するか、別のオプションを選択します。",
}

tooltip = {
  build_room_window = {
    cost = "選択したアイテムの価格",
    room_classes = {
      diagnosis = "診断をするための部屋です",
      treatment = "治療をするための部屋です",
      clinic = "病気を治療するための個別クリニックです",
      facilities = "その他病院サービスのための設備です",
    },
    close = "ゲームに戻る",
  },
  hire_staff_window = {
    prev_person = "前の候補者",
    next_person = "次の候補者",
    salary = "給料",
    staff_ability = "能力",
    doctors = "医師を表示",
    nurses = "看護師を表示",
    handymen = "作業員を表示",
    receptionists = "受付係を表示",
    doctor_seniority = "学位 (ジュニア, ドクター, コンサルタント)",
    qualifications = "医師の追加スキル",
    surgeon = "外科医",
    psychiatrist = "精神科医",
    researcher = "研究者",
    hire = "雇う",
    cancel = "キャンセル",
  },
  place_objects_window = {
    confirm = "確認",
    cancel = "キャンセル",
    pick_up = "アイテムをつかむ",
    buy_sell = "買う/売る",
  },
  buy_objects_window = {
    cancel = "キャンセル",
    confirm = "アイテムを購入する",
    price = "アイテムの値段",
    increase = "購入数を1つ増やす",
    decrease = "購入数を1つ減らす",
    total_value = "注文アイテムの合計金額",
  },
   queue_window = {
    num_in_queue = "待機中の患者数",
    close = "このリクエストを閉じる",
    inc_queue_size = "最大待ち人数を増やす",
    patient = "患者をドラッグして順番待ちの順番を移動させます。 右クリックで患者を自宅に送るか、他の病院に送ります",
    end_of_queue = "患者をこのアイコンにドラッグして待機列の最後に移動させます",
    num_expected = "受付係に並ぼうとしている予想人数",
    max_queue_size = "受付係の最大待ち人数",
    dec_queue_size = "最大待ち人数を減らす",
    patient_dropdown = {
      reception = "患者を受付係に送る",
      hospital_1 = "患者を他の病院に送る",
      hospital_2 = "患者を他の病院に送る",
      hospital_3 = "患者を他の病院に送る",
      send_home = "患者を病院から追い出す",
    },
    front_of_queue = "患者をこのアイコンにドラッグして順番待ちの先頭に移動させます",
    num_entered = "これまでにこの部屋で治療された患者の数",
  },
  message = {
    button = "メッセージを開くには左クリック",
    button_dismiss = "メッセージを開くには左クリック、無視するには右クリック",
  },
  research_policy = {
    research_progress = "このカテゴリにおける次の発見への進捗: %1%/%2%",
    no_research = "このカテゴリでは現在研究が行われていません",
  },
  town_map = {
    close = "タウンマップ画面を終了",
    heat_inc = "設定温度を上げる",
    heat_dec = "設定温度を下げる",
    heating_bill = "暖房費",
    objects = "オブジェクトの表示切替",
    fire_extinguishers = "消火器の表示切替",
    plants = "観葉植物の表示切替",
    heat_level = "暖房レベル",
    radiators = "ラジエーターの表示切替",
    people = "人々の表示切替",
    balance = "銀行残高",
  },
  rooms = {
    gps_office = "診察室では、患者の診察をして、検査結果を受け取り病気の診断を行います",
    general_diag = "検査室は患者の簡単な診断に使用します。コストも安く、多くの場合、とても有効です。",
    cardiogram = "心臓科は患者の病気を診断するために使います",
    ultrascan = "超音波検査機は患者の病気を診断するために使います",
    scanner = "スキャナー室は患者の病気を診断するために使います",
    x_ray = "レントゲン室は患者の病気を診断するために使います",
    blood_machine = "血液調整機室は患者の病気を診断するために使います",
    fracture_clinic = "看護師は整骨マシンを使用して骨折した骨を元に戻します",
    inflation = "空気中入室では風船あたま病の治療が行われます",
    jelly_vat = "ゼリー槽室ではゼリー病の治療が行われます",
    hair_restoration = "増毛科ではハゲ病の治療が行われます",
    tongue_clinic = "ベロ出し病クリニックではベロ出し病の治療が行われます",
    dna_fixer = "DNA修復室ではエイリアンDNA病の治療が行われます",
    electrolysis = "電気脱毛室では毛むくじゃら病の治療が行われます",
    decontamination = "汚染除去室は患者の宇宙放射線を除去するために使います",
    pharmacy = "薬局では看護師が患者に薬を与えます",
    ward = "病室は診断と治療の両方に有効です。病状の観察が行われ、また手術前の休息も取ります。看護師が必要です。",
    operating_theatre = "手術室には２人の外科医資格を持った医師を必要とします",
    psychiatry = "精神科では心の病気を治療し、他の患者の診察を手助けしますが、精神科医のスキルを持つ医師が必要です。",
    training_room = "講義室では専門医が他の医師を教育します",
    research_room = "研究者スキルを持つ医師が研究室で新しい薬や機器を開発します",
    staffroom = "スタッフルームでは医師・看護師・作業員たちは休憩をして体力を回復します",
    toilets = "患者があなたの病院をトイレにしないようにトイレを建ててください！",
  },
  objects = {
    litter = "ゴミ: 捨てるためのゴミ箱が見つからなかったので、患者は床に放り投げました",
    bench = "ベンチ:患者１人分の座席を提供し、痛みを伴う処置の待ち時間をより快適にします。",
    sofa = "ソファ: スタッフルームで休んでいるスタッフは、他に何か気を紛らわす良い方法がない限り、静かにソファに座ります",
    video_game = "ビデオゲーム: スタッフをペトリスでリラックスさせましょう",
    auto_autopsy = "自動解剖機: 新治療法の発見に非常に役立ちます",
    reception_desk = "受付デスク: 受付係が患者を最初の診察室へ紹介します",
    tv = "テレビ: スタッフがお気に入りのメロドラマを見逃さないようにしてください。",
    inflator = "空気注入機: 風船あたま病を直します",
    desk = "医師が自分のパソコンを置く場所が必要です",
    pool_table = "ビリヤード台: スタッフはビリヤードのふりをすることができます",
    bed = "ベッド: 重病人がこの上で横になります",
    bookcase = "本棚: 医師を賢く見せる未開封の本のコレクション",
    drinks_machine = "自販機: 患者の喉の乾きを軽減し、小銭を稼ぐことができます",
    skeleton = "骨格標本: 解剖学のガイドとして、またハロウィンに使用されます",
    computer = "コンピュータ: 研究に重要です",
    bin = "ゴミ箱: 患者がここにゴミを捨てます",
    pharmacy_cabinet = "薬品棚: すべての医薬品が保管されています",
    radiator = "暖房機: 病院が凍りつくことから守ります",
    atom_analyser = "原子分析機: 研究室に設置するとすべての研究プロセスを高速化します",
    plant = "観葉植物: 患者の満足度を上げ、空気を浄化します",
    fire_extinguisher = "消火器: 機器の故障による危険を軽減します",
    lecture_chair = "講義イス: 生徒たちはここに座って、メモを取り、退屈して、ただ絵を描いています。 椅子を置けば置くほど、より多くの医師が勉強できるようになります。",
    toilet = "トイレ: 患者さん、ええと、トイレを使ってください",
    toilet_sink = "流し台: 衛生的な患者は汚れた手をそこで洗うことができます。 流し台が十分にないと、患者は不満を抱くでしょう。",
    cabinet = "キャビネット: 患者カード、メモ、検査結果が入っています",
  },
  machine_window = {
    repair = "修理のために作業員を呼びます",
    name = "名前",
    close = "閉じる",
    times_used = "使用回数",
    status = "ステータス",
    replace = "機械を交換する",
  },
  toolbar = {
    date = "日付",
    town_map = "タウンマップ",
    casebook = "治療の記録",
    reputation = "あなたの評判",
    edit = "部屋/設備を編集",
    charts = "グラフ",
    staff_list = "スタッフを管理する",
    objects = "アイテムを設置する",
    research = "研究",
    policy = "方針",
    status = "ステータス",
    hire = "スタッフを雇う",
    rooms = "部屋を建築",
    bank_button = "左クリックで銀行マネージャー、右クリックで銀行明細",
    balance = "残高",
  },
  casebook = {
    up = "上へスクロール",
    down = "下へスクロール",
    cured = "治療した患者の数",
    deaths = "死亡者数",
    increase = "金額を増やす",
    decrease = "金額を減らす",
    close = "治療記録を閉じる",
    earned_money = "現在までの利益",
    reputation = "治療または診断の評判",
    sent_home = "家に送り返された患者の数",
    treatment_charge = "治療費",
    research = "この治療に特化した研究予算を使用するにはここをクリックしてください",
    cure_requirement = {
      hire_staff = "この治療を行うためにスタッフを雇う必要があります",
      hire_staff_old = "この治療を行うために%sを雇う必要があります",
      ward_hire_nurse = "この治療を行うためには、病室に看護師が必要です",
      research_machine = "この治療に必要な機器を研究する必要があります",
      hire_surgeons = "手術を行うために2人の外科医を雇う必要があります",
      possible = "この治療を行うことができます",
      not_possible = "この治療を行うことはまだできません",
      build_room = "この治療を行うために部屋を建設する必要があります",
      hire_surgeon = "手術を行うために2人目の外科医を雇う必要があります",
      build_ward = "この治療を行うために病室を建設する必要があります",
    },
     cure_type = {
      drug_percentage = "この治療には薬を使用します - 現在薬は%d%%有効です",
      unknown = "まだこの治療を行う事はできません",
      psychiatrist = "精神科医がこの治療を行います",
      machine = "この治療には設備が必要です",
      drug = "この治療には薬を使用します",
      surgery = "この治療には手術が必要です",
    },
  },
  calls_dispatcher = {
    assigned = "このボックスは、対応するタスクに誰かが割り当てられている場合にマークされます。",
    task = "タスクの一覧 - タスクをクリックすると、割り当てられたスタッフのウィンドウが開き、タスクの場所までスクロールします。",
    close = "タスク管理画面を閉じる",
  },
  research = {
    cure_inc = "治療研究の割合を増やす",
    cure_dec = "治療研究の割合を減らす",
    specialisation_inc = "特別研究の割合を増やす",
    specialisation_dec = "特別研究の割合を減らす",
    improvements_inc = "改良研究の割合を増やす",
    improvements_dec = "改良研究の割合を減らす",
    diagnosis_inc = "診断研究の割合を増やす",
    diagnosis_dec = "診断研究の割合を減らす",
    drugs_inc = "薬品研究の割合を増やす",
    drugs_dec = "薬品研究の割合を減らす",
    allocated_amount = "割り当てられた予算の金額",
    close = "研究画面を閉じる",
  },

  watch = {
    hospital_opening = "建設時間: 病院が開院するまでの残り時間です。 GOボタンをクリックすると病院が即座に開院します。",
    emergency = "緊急事態: すべての緊急患者を治療するまでの残り時間です。",
    epidemic = "伝染病: 伝染病を隠蔽するための残り時間です。 この時間が切れるか、感染患者が病院を去ると、健康検査官が訪れます。 このボタンで予防接種モードのオン/オフを切り替えます。 患者をクリックして、看護師による予防接種を受けさせてください。",
  },
}

queue_window = {
  num_in_queue = "順番待ち",
  num_entered = "合計訪問数",
  max_queue_size = "最大待ち人数",
  num_expected = "列予想数",
}

staff_title = {
  junior = "ジュニア",
  doctor = "ドクター",
  consultant = "コンサルタント",
  surgeon = "外科医",
  psychiatrist = "精神科医",
  researcher = "研究医",
  nurse = "看護師",
  receptionist = "受付係",
  general = "作業員",
}

staff_class = {
  doctor = "医師",
  handyman = "作業員",
  receptionist = "受付係",
  nurse = "看護師",
  surgeon = "外科医",
}

staff_descriptions = {
  good = {
    [1] = "非常に迅速で勤勉な労働者。",
    [2] = "勤勉に働き、細部にまで気を配ります。",
    [3] = "文字通り何でもできます。",
    [4] = "信じられないほどフレンドリーで、いつも笑顔です。",
    [5] = "驚異的なスタミナ。ノンストップで働き続けます。",
    [6] = "非常に礼儀正しく、常にフレンドリーです。",
    [7] = "信じられないほど才能があり、有能です。",
    [8] = "仕事に対して非常に責任感があります。",
    [9] = "決して諦めず、完璧を目指して努力します。",
    [10] = "笑顔で人々を助けます。",
    [11] = "魅力的で礼儀正しく、いつも親切です。",
    [12] = "とてもやる気があり、献身的です。",
    [13] = "親切でとても勤勉です。",
    [14] = "忠実で友好的。ユーモアがある。",
    [15] = "慎重で温和。災害時に頼りになる。",
  },
  misc = {
    [1] = "象の置物を集めている。。",
    [2] = "スキューバダイビングが趣味。",
    [3] = "氷で彫刻を作る。",
    [4] = "『北の国から』の１話に出演した。",
    [5] = "スーパーカーのオーナー。",
    [6] = "ビールグラス用コースターの収集家。",
    [7] = "バンジージャンプが好き。",
    [8] = "ライブでダイブしがち。",
    [9] = "丘サーファー。",
    [10] = "川で遊ぶのが好き。",
    [11] = "ウィスキーのブレンドが趣味。",
    [12] = "熟練の日曜大工。",
    [13] = "フランス映画が好き。",
    [14] = "テーマパークでよく遊びます。",
    [15] = "大型免許を持っている。",
    [16] = "ラリーカードライバー。",
    [17] = "バイオリンとチェロを演奏します。",
    [18] = "撮り鉄。",
    [19] = "超犬好き。",
    [20] = "甘いものに目がない。",
    [21] = "お風呂好き。",
    [22] = "手芸インストラクター",
    [23] = "家庭菜園で取れた野菜を配る。",
    [24] = "非常勤特別巡査。",
    [25] = "元クイズショーの司会者",
    [26] = "戦争マニアで武器収集が趣味。",
    [27] = "部屋の模様替えが趣味。",
    [28] = "懐メロばかり聴く。",
    [29] = "昆虫マニア。",
    [30] = "コメディアンを野次るのが好き。",
    [31] = "議会傍聴マニア。",
    [32] = "庭いじりが好き。",
    [33] = "偽造時計を密輸します。",
    [34] = "ロックンロールバンドのボーカル。",
    [35] = "連続テレビ小説は欠かさない",
    [36] = "釣りバカ。",
    [37] = "趣味は御朱印集め。",
  },
  bad = {
    [1] = "仕事が遅く、話がつまらない。",
    [2] = "怠け者でやる気がない。",
    [3] = "無気力で訓練不足。",
    [4] = "横柄で失礼。人の神経を逆なでする。",
    [5] = "スタミナゼロ。態度悪し。",
    [6] = "キャベツのにおいがする。アホ。",
    [7] = "訳もなく怒っている。",
    [8] = "衝動的で集中力なし。軽率。",
    [9] = "役立たず。責任感は少々。",
    [10] = "無作法で陰口を叩く。",
    [11] = "おっちょこちょいでトラブルメーカー。",
    [12] = "無意味にリスクを負う。",
    [13] = "どうしようもない向こう見ず。",
    [14] = "ずる賢い破壊分子。",
    [15] = "傲慢で自信家。",
  },
}
tooltip = {
  handyman_window = {
    prio_machines = "修理の優先順位を上げる",
    prio_litter = "清掃の優先順位を上げる",
    prio_plants = "水やりの優先順位を上げる",
  },
  patient_window = {
    graph = "クリックすると、患者の健康状態グラフと検査履歴とが切り替わります",
    casebook = "患者の病気の詳細を表示",
    close = "閉じる",
    queue = "患者が並んでいる部屋の順番待ち列を表示",
    happiness = "患者様の満足度",
    warmth = "患者が感じる温かさ",
    center_view = "患者に焦点を当てる",
    thirst = "患者の喉の乾きのレベル",
    send_home = "患者を自宅へ帰らせる",
    abort_diagnosis = "検査が完了するまで待たずに、今すぐ治療を始めます",
  },
  staff_window = {
    doctor_seniority = "学位 (ジュニア、ドクター、コンサルタント)",
    psychiatrist = "精神科医",
    close = "ウィンドウを閉じる",
    ability = "能力",
    pick_up = "つかむ",
    sack = "解放する",
    surgeon = "外科医",
    happiness = "満足度",
    salary = "給料",
    name = "名前",
    tiredness = "疲労度",
    center_view = "左キー: 画面を中央に配置、右キー: 次の従業員を選択",
    skills = "スキル",
    researcher = "研究者",
    face = "スタッフの写真: クリックしてスタッフ管理画面へ移動",
  },
}

pay_rise = {
  definite_quit = "もう我慢できない！ どんな条件で引き止めても無駄だ！ この病院にはうんざりだ！",
  regular = {
    [1] = "もう疲れた。 休息と$%dの昇給がなければ病院をやめてやる！",
    [2] = "もうヘトヘトだ！ $%dの昇給と休息を要求する。 今すぐやれよ、悪徳経営者め！",
    [3] = "おいおい俺は馬車馬のように働いているんだぞ！ $%dのボーナスをくれればやめないでいてやる。",
    [4] = "不満しかないよ。 %dの賃金アップを要求する！ さもなければ出て行くよ。",
    [5] = "医療職は給料が高いと聞いていたのに！ $%dの給料アップをしないならゲームのプロデューサーに転職するよ。",
    [6] = "もううんざり。まともな給料を払って！ $%dの昇給で手をうってもいいよ。",
  },
  poached = "%s から%dのオファーを受けている。同じ給料を払わないなら辞めちゃうよ。",
}

confirmation = {
  abort_edit_room = "現在部屋を設置または編集中です。 必要なアイテムがすべて配置されていれば完了します。 配置されていない場合は削除されます。 続けますか?",
  return_to_blueprint = "部屋の設置モードに戻りますか？",
  delete_room = "この部屋を削除してもよろしいですか？",
  quit = "ゲームを終了します。本当によろしいですか？",
  needs_restart = "このオプションを変更するには、CorsixTHの再起動が必要です。 保存されていない内容はすべて失われます。 本当にこれを実行しますか？",
  overwrite_save = "ゲームは既にこの名前で保存されています。上書きしてもよろしいですか？",
  sack_staff = "このスタッフを解雇してよろしいですか？",
  replace_machine = "%s を$%dで置き換えてもよろしいですか?",
  restart_level = "レベルをリスタートしてもよろしいですか？",
  maximum_screen_size = "入力した画面解像度は 3000 x 2000 を超えています。 スムーズなフレームレートでゲームを処理できるハードウェアがある場合は、この解像度を変更できます。 続行してもよろしいですか？",
  remove_destroyed_room = "$%dかかりますが、破壊された部屋を撤去してもよろしいですか？",
  replace_machine_extra_info = "新しいマシンの状態は%d(現在 %d) になります。",
  quit_mapeditor = "マップエディターを終了してもよろしいですか？",
  restart_mapeditor = "マップエディターを再起動してもよろしいですか？",
}

diseases = {
  general_practice = {
    name = "一般診察",
  },
  diag_ward = {
    name = "日帰り入院",
  },
  diag_ultrascan = {
    name = "診断: 超音波検査",
  },
  diag_blood_machine = {
    name = "診断: 血液検査",
  },
  diag_x_ray = {
    name = "診断: レントゲン",
  },
  diag_psych = {
    name = "診断: 精神科",
  },
  diag_general_diag = {
    name = "診断: 一般検査",
  },
  diag_cardiogram = {
    name = "診断: 心臓科",
  },
  diag_scanner = {
    name = "診断: スキャナー",
  },
  autopsy = {
    name = "解剖",
  },
  third_degree_sideburns = {
    name = "もみあげ症候群",
    symptoms = "症状－巨大な髪型、ラメ入り衣装、厚底靴、派手派手な化粧等。",
    cause = "原因－70年代への強烈な回帰願望。",
    cure = "治療－精神科医が患者を現代に連れ戻すために、患者の格好がどんなにみっともないか理解させる。",
  },
  discrete_itching = {
    name = "かゆかゆ病",
    symptoms = "症状－常にひっかき傷を負っている。",
    cause = "原因－鋭い歯を持つ微小な昆虫に咬まれる。",
    cure = "治療－薬局で処方された、汗と一緒に放出される粘液質のシロップを飲む。これにより蚊が近寄れなくなります。",
  },
  the_squits = {
    name = "下痢",
    symptoms = "症状－ええと…言わなくても分かるでしょう？",
    cause = "原因－残り物のピザを食べる。",
    cure = "治療－落ち着きのない消化管を落ち着かせる特別製の胃腸薬を飲む。",
  },
  spare_ribs = {
    name = "スペアリブ病",
    symptoms = "症状－胸部の不快感。",
    cause = "原因－錠剤を飲まずに飲み込んだこと。",
    cure = "治療－余った肋骨は2人の外科医によって切除され、病院のロゴの入ったビニール袋に入れて患者に渡されます。",
  },
  serious_radiation = {
    name = "宇宙放射線病",
    symptoms = "症状－非常な不快感を覚える。",
    cause = "原因－チューインガムとプルトニウムを間違えて食べた。",
    cure = "治療－汚染物質を、汚染除去装置で綺麗に洗い流す。",
  },
  infectious_laughter = {
    name = "伝染性オヤジ病",
    cure = "治療－精神科医が患者に、症状の重大さを理解させる。",
    cause = "原因－昔からあるコメディー。",
    symptoms = "症状－ばか笑いと超つまらないフレーズの連発。",
  },
  hairyitis = {
    name = "毛むくじゃら病",
    cure = "治療－電気脱毛機で毛を取り去り、毛穴を塞ぐ。",
    cause = "原因－月の光に当たりすぎ。",
    symptoms = "症状－嗅覚の異常な発達。",
  },
  broken_heart = {
    name = "重度失恋病",
    cure = "治療－2人の外科医が開胸手術をして、息を止めながら優しく心臓を修復する。",
    cause = "原因－患者より金持ちで、若くて、やせている誰か。",
    symptoms = "症状－バカンスの写真を見て、長時間泣く。",
  },
  sweaty_palms = {
    name = "手に汗にぎり病",
    cure = "治療－精神科医がでっちあげの病気だということを患者に説明する。",
    cause = "原因－就職面接前の緊張。",
    symptoms = "症状－握手すると、水をたっぷり含んだスポンジを握ったような感じがする。",
  },
  transparency = {
    name = "スケスケ病",
    cure = "治療－薬局でよく冷えた色水を飲ませる。",
    cause = "原因－ヨーグルトを開けてから、蓋をなめる事。",
    symptoms = "症状－肉が透けて見える。",
  },
  alien_dna = {
    name = "エイリアンDNA病",
    cure = "治療－エイリアンのＤＮＡを機械的に除去する。",
    cause = "原因－凶悪なエイリアンに襲われる。",
    symptoms = "症状－外見が次第にエイリアン化し、街を破壊したいという欲望が生まれる。",
  },
  broken_wind = {
    name = "おなら病",
    cure = "治療－薬局で水分子を混合したスペシャルドリンクを素早く飲ませる。",
    cause = "原因－食事の後にジムでランニングマシンで走る。",
    symptoms = "症状－患者のすぐ後ろにいる人々を不快にさせる。",
  },
  baldness = {
    name = "ハゲ病",
    cure = "治療－強い痛みを伴う機械を使用して患者の頭に毛髪を融合させる。",
    cause = "原因－人気者になろうとして、嘘をつく。",
    symptoms = "症状－頭がツルピカになり、とても恥ずかしい。",
  },
  sleeping_illness = {
    name = "居眠り病",
    cure = "治療－看護婦が強力な興奮剤を大量に処方する。",
    cause = "原因－口蓋にある睡眠腺の異常活動。",
    symptoms = "症状－どこにでも飛び出したいという圧倒的な欲求。",
  },
  corrugated_ankles = {
    name = "足首うねうね病",
    cure = "治療－脱法ハーブとスパイスを混ぜたものを飲んで、足首をまっすぐにする。",
    cause = "原因－ガタガタ道の上を車で通る。",
    symptoms = "症状－履物が合わなくなる。",
  },
  tv_personalities = {
    name = "テレビ症候群",
    cure = "治療－精神科医が、患者にテレビを売ってラジオを買うように説得する。",
    cause = "原因－昼間にテレビを見過ぎる。",
    symptoms = "症状－料理番組を実演する妄想。",
  },
  slack_tongue = {
    name = "ベロだし病 ",
    cure = "治療－舌切り機で素早く、効率的に、また痛みを伴って舌をちょん切る。",
    cause = "原因－昼のメロドラマの噂のし過ぎ。",
    symptoms = "症状－舌が元の５倍の長さに腫れる",
  },
  king_complex = {
    name = "王様症候群",
    cure = "治療－精神科医が、患者にどれほどみっともなく見えるかを説明する。",
    cause = "王様の霊が患者に乗り移った。",
    symptoms = "症状－派手な衣装でチーズバーガーを食べる。",
  },
  invisibility = {
    name = "透明病",
    cure = "治療－薬局でカラフルな飲み物をたくさん飲と患者は姿を現します。",
    cause = "原因－放射性の目に見えないアリに噛まれた。",
    symptoms = "症状－患者は不快感を感じません。実際、多くの人がこの症状を利用して家族に悪ふざけをします。",
  },
  pregnancy = {
    name = "妊娠",
    cure = "治療－手術室で赤ちゃんを取り出して、洗ってから患者に見せます。",
    cause = "原因－都市エリアの停電。",
    symptoms = "症状－食生活と体型の変化。",
  },
  iron_lungs = {
    name = "鉄の肺病",
    cure = "治療－二人の外科医が手術をして固くなった肺を摘出してしまう。",
    cause = "原因－都市部のスモッグと焼き鳥屋の煙。",
    symptoms = "症状－火を吐いたり水中で叫んだりできる。",
  },
  chronic_nosehair = {
    name = "鼻毛ぼうぼう病",
    cure = "治療－薬局で看護婦に処方される、とてもまずい毛抜き剤を飲む。",
    cause = "原因－自分より目下の人を鼻で笑う。",
    symptoms = "症状－鳥の巣ができるほどの鼻毛が生える。",
  },
  fake_blood = {
    name = "熱血症候群",
    cure = "治療－精神科医が患者をなだめて患者の心を落ち着かせる。",
    cause = "原因－いつもジョークのネタにされてからかわれる。",
    symptoms = "症状－静脈内の赤い液体が衣服に触れると蒸発します。",
  },
  gastric_ejections = {
    name = "ゲロゲロ病",
    cure = "治療－吐き気を抑える特別製の胃腸薬を飲む。",
    cause = "原因－スパイシーなメキシコ＆インド料理。",
    symptoms = "症状－半分消化された食物がぐちゃぐちゃになって患者から排出されます。",
  },
  bloaty_head = {
    name = "風船あたま病",
    cure = "治療－頭を一度しぼませてから空気注入機でちょうどいい大きさまで膨らませる。",
    cause = "原因－チーズのにおいを嗅いだり、汚い雨水を飲んだりする。",
    symptoms = "症状－非常な不快感を覚える。",
  },
  fractured_bones = {
    name = "骨折",
    cure = "治療－整骨マシンのレーザーで骨の破片を除去する。",
    cause = "原因－高所からコンクリートへの落下。",
    symptoms = "症状－大きな音が鳴り、患肢が動かなくなる。",
  },
  jellyitis = {
    name = "ゼリー病",
    cure = "治療－患者を特別な部屋にあるゼリーの容器にしばらく浸す。",
    cause = "原因－ゼラチン質に富んだ食事と、過剰な運動。",
    symptoms = "症状－体がグニャグニャになり、よく転びはじめる。",
  },
  uncommon_cold = {
    name = "珍しい風邪",
    cure = "治療－薬局で特別な成分から作られた珍しい咳止め薬を一口飲む。",
    cause = "原因－空気中の鼻水菌。",
    symptoms = "症状－くしゃみ、鼻水、肺の変色。",
  },
  ruptured_nodules = {
    name = "小瘤破裂",
    cure = "治療－外科医２人で小瘤を摘出する。",
    cause = "原因－寒いのにバンジージャンプをする。",
    symptoms = "症状－正常にイスに座れなくなる。",
  },
  kidney_beans = {
    name = "豆入り腎臓病",
    cure = "治療－2人の外科医が腎臓の側面に触れずに豆を取り除く。",
    cause = "原因－飲み物に入っている氷を噛んで食べる。",
    symptoms = "症状－腹痛と、頻繁にトイレへ行く。 ",
  },
  heaped_piles = {
    name = "毛玉症候群",
    cure = "治療－強酸性の飲み物で体内の毛玉を強力に分解する。",
    cause = "原因－ウォータークーラーの周りに立つ。",
    symptoms = "症状－ビー玉の袋の上に座っているような気がする",
  },
  golf_stones = {
    name = "ゴルフ病",
    cure = "治療－ゴルフの悪影響を2人の外科医による手術によって除去する。",
    cause = "原因－ゴルフボールの中の有毒ガスの吸引。",
    symptoms = "症状－突発的に狂喜するか、強烈に恥ずかしがる。",
  },
  gut_rot = {
    name = "内蔵腐食病",
    cure = "治療－胃の中をコーティングする薬品を処方する。",
    cause = "原因－オマリー婦人の咳止め入りウィスキー。",
    symptoms = "症状－咳が出ない代わりに内蔵が溶けてしまう。",
  },
  unexpected_swelling = {
    name = "でぶでぶ病",
    cure = "治療－２人の外科医が手術で身体に穴を開ける。",
    cause = "原因－原因不明。",
    symptoms = "症状－腫れ。",
  },
 }

adviser = {
  level_progress = {
    halfway_won = "このレベルをクリアするまであと半分です。",
    close_to_win_increase_value = "もうすぐクリアです。 病院価値をあと$%dアップさせてください。",
    another_patient_killed = "ああ、大変！またを殺してしまいましたよ。 これで死亡者数は%d人になりました...",
    reputation_good_enough = "よし、病院の評判はこのレベルをクリアするのに十分です。 %d以上を保つよう心がけてください。 他の問題を解決すれば完了です。",
    financial_criteria_met = "このレベルの財務基準を満たしました。 引き続き病院が効率的に運営されていることを確認しながら、残高$%d以上を維持してください。",
    dont_kill_more_patients = "もう１人も患者を死なせるわけにはいきません！",
    hospital_value_enough = "病院の価値を%d以上に維持し、その他の問題に対処してこのレベルをクリアしましょう。",
    halfway_lost = "このレベルを失敗するまであと半分です。",
    three_quarters_lost = "このレベルはあと４分の１で失敗です。",
    three_quarters_won = "このレベルはクリアまであと４分の１です。",
    improve_reputation = "このレベルをクリアするには、%d以上の評判が必要です。",
    another_patient_cured = "よくやりました！ また１人患者が回復しました。 これで%d人目ですよ。",
    nearly_lost = "もうすぐゲームオーバーです！",
    cured_enough_patients = "このレベルをクリアするのに十分な患者を治療しました。 あとは病院をもっとまとめてください。",
    nearly_won = "もうすぐクリアです！",
  },
  vomit_wave = {
    started = "病院に嘔吐ウイルスが蔓延しているようです。病院をもっと清潔にしていれば、こんなことにはならなかったでしょう。作業員をもっと雇ったほうがいいかもしれません。",
    ended = "ふぅ!あのゲロ爆弾を引き起こしたウイルスはほぼ消滅したようですね。今後は病院を清潔に保ってください。",
  },
  warnings = {
    patient_stuck = "誰かが行き詰まっています。 病院をよりよく計画してください。",
    need_staffroom = "スタッフたちが休めるスタッフルームを建てましょう。",
    build_staffroom = "すぐにスタッフルームを建ててください。 スタッフは働きすぎて崩壊寸前です。 さあ、理性を取り戻してください！",
    doctors_tired = "医師は非常に疲れています。 早く休ませてあげてください。",
    doctors_tired2 = "医師はクタクタです。 すぐに休ませてあげてください。",
    nurses_tired = "看護師は非常に疲れています。 早く休ませてあげてください。",
    nurses_tired2 = "看護師はクタクタです。 すぐに休ませてあげてください。",
    handymen_tired = "作業員は非常に疲れています。 早く休ませてあげてください。",
    handymen_tired2 = "作業員はクタクタです。 すぐに休ませてあげてください。",
    receptionists_tired = "受付係は非常に疲れています。 早く休ませてあげてください。",
    receptionists_tired2 = "受付係はクタクタです。 すぐに休ませてあげてください。",
    staff_tired = "スタッフは非常に疲れています。 スタッフルームで休憩を取らせないと、過労で倒れてしまいますよ。",
    staff_overworked = "スタッフを働かせすぎです。 疲れとストレスで効率が悪くなり、悲惨なミスを犯し始めるでしょう。",
    doctor_crazy_overwork = "ああ大変！ 医師の1人が過労で気が狂ってしまいました。 すぐに休ませれば回復するかもしれません。",
    reduce_staff_rest_threshold = "設定画面でスタッフの休憩閾値を下げて、スタッフがもっと頻繁に休憩できるようにしてみてください。 単なる思い付きですが。",
    staff_unhappy = "スタッフに不満が広がっています。 彼らにボーナスを与えるか、もっと良い方法としてはスタッフルームを作ってみてください。 また、方針画面でスタッフの休憩基準を変更することもできます。",
    staff_unhappy2 = "スタッフに不満が広がっています。金銭面の不満も大きいようです。",
    falling_1 = "おい!おかしいじゃないか。 マウスをクリックする場所に気をつけろ。 誰かが怪我をするかもしれないぞ！",
    falling_2 = "ふざけるのはやめましょう。 何がしたいんですか？",
    falling_3 = "痛そう、きっと痛かったでしょうね。 誰か医師を呼んで！",
    falling_4 = "ここは病院であって、テーマパークではありません！",
    falling_5 = "ここは人を倒す場所じゃないですよ、彼らは病気なんですから！",
    falling_6 = "ここはボーリング場ではありません！ 病人をそんな風に扱うべきではありません！",

-- 【研究者】
    research_screen_open_1 = "研究画面にアクセスするには、研究室を建てる必要があります。",
    research_screen_open_2 = "現在のレベルでは研究は無効です。",
    researcher_needs_desk_1 = "研究者には作業用のデスクが必要です。",
    researcher_needs_desk_2 = "研究者は休憩をとらせてもらえて喜んでいます。 もっと多くのスタッフに研究させるつもりなら、それぞれに作業用のデスクを用意する必要があります。",
    researcher_needs_desk_3 = "各研究者が研究室で働くためには人数分のデスクが必要です。",

-- 【看護師】
    nurse_needs_desk_1 = "各看護師が病室で働くためには人数分のデスクが必要です。",
    nurse_needs_desk_2 = "看護師は休憩をとらせてもらえて喜んでいます。 病室で複数人働かせるためには、それぞれにデスクを用意する必要があります。",

-- 【作業員】
-- 観葉植物
    plants_dying = "観葉植物が枯れそうです。 もっと作業員を雇用してください。 枯れた観葉植物が好きな患者はいませんよ。",
    place_plants3 = "患者が病院の居心地が悪いと言っています。 観葉植物で病院内の雰囲気をかえてみては？",
    place_plants4 = "患者を元気づけるために、施設のあちこちに植物をもっと置いてください。",
    desperate_need_for_watering = "観葉植物に水やりをするために作業員を雇う必要があります。",
    too_many_plants = "観葉植物が多すぎます。 中はジャングルのようです。",
    place_plants2 = "みんな病院を去っていきます。 観葉植物で引き止めてみてはいかがですか？",
    plants_thirsty = "植物の世話をする必要があります。 水が欲しくなってきています。",
    change_priorities_to_plants = "観葉植物に水をまくように作業員の仕事の優先順位を変えなければなりません。 ",
    place_plants_to_keep_people = "人々が去っていきます。 観葉植物で引き止められるかもしれません。",
-- ゴミ
    litter_everywhere = "いたるところにゴミが散乱しています。 この問題に対処するために作業員を雇ってください。",
    people_did_it_on_the_floor = "患者の中には耐えられない人もいます。 清掃はとても大切な仕事です。",
    litter_catastrophy = "ゴミ問題が深刻化しています。 今すぐ作業員のチームを雇って対処してもらいましょう！",
    some_litter = "深刻な問題になる前に作業員にゴミを処分してもらいましょう。",
    too_much_litter = "ゴミの問題があります。 もっと作業員を雇えば解決できるかもしれません。",

-- 設備の修理
    machinery_slightly_damaged = "病院の設備が少し傷んできています。 メンテナンスをしっかりしてください。",
    machinery_damaged = "設備をすぐに直してください。 すぐに故障を起こしはじめますよ！",
    machinery_damaged2 = "設備修理のため、すぐに作業員を雇用してください！",
    machinery_very_damaged = "緊急です！ すぐに作業員を呼んで設備を修理させてください。もうすぐ壊れそうです！",
    machines_falling_apart = "設備が壊れかけています。 作業員をすぐに呼んでください！",
    machine_severely_damaged = "%sがもうすぐ修復不可能なまでに壊れそうです。",
    machinery_deteriorating = "設備が酷使されて壊れはじめましたよ！ 注意が必要です。",

-- 【受付係】
    queue_too_long_at_reception = "受付で待っている患者が多すぎます。 受付デスクをもう1つ設置し、受付係をもう1人雇ってください。",
    another_desk = "新しい受付係のために、もう1つ受付デスクを設置する必要があります。",
    reception_bottleneck = "受付がボトルネックになっています。受付係をもう1人雇いましょう。",
    no_desk = "いつかは受付デスクを作って受付係を雇うべきです！",
    no_desk_1 = "患者を病院に呼びたければ受付係を雇い、彼女の働くデスクを用意してあげないといけませんよ！",
    no_desk_2 = "よくやりました、これは世界記録に違いありません！ ほぼ1年経っても患者がいません！ この病院の経営を続けたいなら、受付係を雇って、彼女が働くための受付デスクを作る必要があります！",
    no_desk_3 = "素晴らしいですね、1年近くも受付スタッフがいないなんて！ どうやって患者を呼べるというのですか？ 今すぐ準備して、ぐずぐずするのはやめてください！",
    no_desk_4 = "受付係は、患者が到着したときに出迎えるための自分のワークステーションが必要です。",
    no_desk_5 = "そろそろ時間です。もうすぐ患者が到着し始めるはずです！",
    no_desk_6 = "受付係はいるので、彼女が働くために受付デスクをつくってはいかがですか？",
    no_desk_7 = "受付デスクは作ったので、次は受付係を雇ってみてはいかがですか？ これが準備できるまでは患者を診ることはできませんよ！",

-- 伝染病
    deal_with_epidemic_now = "伝染病が重大な問題になっています。 一刻も早く対処を！ もし今伝染病を防がなければ、ひどい事になりますよ！",
    epidemic_getting_serious = "伝染病が重大な問題になっています。 何か手を打って下さい！",
    many_epidemics = "同時に複数の伝染病が発生しているようです。 これは大惨事になる恐れがありますので、迅速に行動してください。",

-- 料金
    fair_prices = "%sの料金は公平でバランスが取れているようです。",
    charges_too_high = "料金が高すぎます。 短期的には大きな利益になりますが、最終的には患者が離れてしまいます。",
    high_prices = "%sの料金が高すぎます。 短期的には大きな利益になりますが、最終的には患者が離れてしまいます。",
    patient_not_paying = "患者が%sの支払いをしないで帰っていきます。 料金が高すぎるようです。",
    charges_too_low = "料金が安すぎます。 これでは患者が病院に来やすくはなりますが、一人あたりの利益はあまり上がりません。",
    low_prices = "%s の料金が安すぎます。 これで患者は病院に来るでしょうが、一人あたりの利益はあまり上がりません。",

-- 財務状況
    cash_low_consider_loan = "財政状況があまり良くないですね。 ローンを考えてみては？",
    money_very_low_take_loan = "銀行残高がひどく少ないです。 ローンがありますよ。",
    financial_trouble = "深刻な財政難に陥っています。 今すぐなんとかしてください。 あと$%d減ったらこのレベルを無駄にしてしまうことになります。",
    finanical_trouble2 = "財政状況が危機的です。 もしあと$%dを失えばこのレベルは失敗です。 ",
    financial_trouble3 = "銀行残高が少し心配です。 もっとお金を稼ぐことを考えてください。 あと$%dで大惨事です。",
    pay_back_loan = "お金がたっぷりあります。 ローンの返済について考えてみてはいかがですか？",
    money_low = "銀行残高が少なくなっています！",
    cannot_afford = "その人を雇うにはお金が足りません！",
    cannot_afford_2 = "それを買うためにはお金が足りません！",

-- 暖房
    patients_very_cold = "患者が寒がっています。 暖房機をもっと設置するか、設定温度を上げてください。",
    people_freezing = "信じられないことですが、このセントラルヒーティングの時代に、患者の中には凍えるほど寒い人もいます。 部屋を温めるために暖房機を設置して設定温度を上げてください。",
    patients_getting_hot = "患者が暑いと言っています。 暖房機を減らすか、設定温度を下げてください。",
    patients_too_hot = "患者は暑くなりすぎています。 暖房機をいくつか撤去するか、設定温度を下げるか、自販機をもっと設置してください。",
    staff_very_cold = "スタッフは寒いと文句を言っています。 暖房機をもっと設置するか、設定温度を上げてください。",
    staff_too_hot = "スタッフは暑いと文句を言っています。 暖房機を減らすか、設定温度を下げてください。",

-- 自販機
    patients_thirsty = "患者は喉が渇いています。自販機を設置した方がいいかもしれません。",
    patients_thirsty2 = "みんな喉が渇いていると文句を言っています！自販機をもっと設置するか、今ある自販機を彼らの近くに動かしてください。 ",
    patients_really_thirsty = "患者は本当に喉が渇いています。自販機をもっと設置するか、既存の自販機を最も長い列の近くに移動させてください",
    patients_very_thirsty = "患者たちは本当に喉の渇きに苦しんでいます。すぐに自販機を設置しないと、みんなコーラを求めて家に帰ってしまいますよ。",

-- 長イス
    more_benches = "もっと長イスを設置してあげてください。患者たちが立ちっぱなしで可哀想です。",
    people_have_to_stand = "病人たちが立ちっぱなしです。座れる場所を準備してあげてください。",

-- トイレ
    build_toilets = "今すぐにトイレを建ててください。さもないと不愉快なものを目にすることになりますよ。病院がどんな臭いになるか...",
    need_toilets = "患者にはトイレが必要です。もっと便利な場所にトイレを建ててください。",
    more_toilets = "トイレがもっと必要です。みんなもう我慢の限界です！",
    build_toilet_now = "今すぐトイレを建ててください。みんなもう我慢できません。ニヤニヤしないでください。これは深刻な問題です。",

-- 悪評
    nobody_cured_last_month = "先月は一人も治療できませんでした。",
    no_patients_last_month = "先月は新しい患者が一人も来ませんでした。 衝撃です！",
    hospital_is_rubbish = "あなたの病院はひどいと噂になっています。 患者たちは他の病院へ行き始めていますよ。",
    bankruptcy_imminent = "ああ、破産に向かってまっしぐらです 。気を付けて！",
    patients_unhappy = "患者はあなたの病院を嫌っています。 来院者を増やすために努力をしてください。",
    many_killed = "あなたは今までに%d人を殺してしまいました。 治療しなきゃいけないの、わかってますよね。",
    patient_leaving = "患者が１人去っていきます。 理由ですか？あなたのずさんな経営のせいです！！",
    patients_leaving = "患者が去っています。植物、ベンチ、飲料機などを設置して、来院者のために病院を改善してください。",
    patients_annoyed = "あなたの病院の運営方法に人々は非常に腹を立てています。 彼らを責めることはできません。 しっかりしてください、さもないと酷い結末に直面することになります！",
    queues_too_long = "待ち時間が長すぎます！",
    queue_too_long_send_doctor = "%sの待ち時間が長すぎます。 部屋に医師がいることを確認してください。",
  },
  competitors = {
    land_purchased = "%s が土地を購入しました。",
    hospital_opened = "競合する病院: %s がこの地域に開設されました。",
    staff_poached = "スタッフの 1 人が他の病院に引き抜かれました。",
  },
  research = {
    new_machine_researched = "新しい%sの研究が完了しました。",
    drug_improved = "%sの薬が研究部門によって改良されました。",
    drug_improved_1 = "%sの薬が研究部門によって改良されました。",
    drug_fully_researched = "%s の研究が100%完了しました。",
    new_drug_researched = "%sを治療する新しい薬が研究されました。",
    machine_improved = "%sが研究部門によって強化されました。",
    autopsy_discovered_rep_loss = "自動解剖機が発見されました。 一般大衆からの否定的な反応が予想されます。",
    new_available = "新しい%sが利用可能になりました。",
  },
  earthquake = {
    alert = "震警報！病院内の設備が損傷します。 メンテナンスが不十分だと破壊される可能性があります。",
    damage = "地震が病院内の%d台の機械と、%d人の患者にダメージを与えました。",
    ended = "うひゃー！ すごい地震でしたね？ 地震計では震度%dでした。",
  },
  multiplayer = {
    players_failed = "以下のプレイヤーは最後の目標を達成できませんでした: ",
    poaching = {
      not_interested = "ハッ！ 彼らはあなたの病院で働くことに興味がありません。 彼らは今いる場所で満足しています。",
      already_poached_by_someone = "なんてことでしょう！ 誰かがそのスタッフを引き抜こうとしています。",
      in_progress = "このスタッフがあなたの病院で働きたいかどうかお知らせします。",
    },
    objective_failed = "あなたは目標を達成できませんでした。",
    everyone_failed = "全員が最後の目的を達成できませんでした。そのため、全員がプレイを続行できます！",
    objective_completed = "あなたは目的を達成しました。おめでとうございます！",
  },
  epidemic = {
    serious_warning = "伝染病が重大な問題になっています。 何か手を打って下さい！",
    hurry_up = "伝染病が重大な問題になっています。 一刻も早く対処を！ もし今伝染病を防がなければ、ひどい事になりますよ！",
    multiple_epidemies = "同時に複数の伝染病が発生しているようです 。これは大惨事になる恐れがありますので、迅速に行動してください。",
  },
  cheats = {
    th_cheat = "おめでとうございます。 チートを解除しました！",
    norest_on_cheat = "えぇ、嘘でしょ！ スタッフはカフェインを摂りすぎて、もう休む必要を感じていないようです。",
    norest_off_cheat = "やれやれ。やっと興奮が収まったみたいです。 スタッフはこれでちゃんと休めるでしょう。",
    roujin_on_cheat = "Roujinのチャレンジが起動しました！ 今後数か月間の幸運を祈ります...",
    roujin_off_cheat = "Roujinのチャレンジが無効になりました。 すぐにすべて正常に戻ります。",
  },
  goals = {
    win = {
      money = "このレベルの財務基準を満たすには、あと$%d必要です。",
      reputation = "このレベルのクリア基準を満たすには、評判を%dまで上げてください。",
      value = "病院の価値を%dまで上げてください。",
      cure = "あと%d人の患者を治療すれば、このレベルをクリアするのに十分です。",
    },
    lose = {
      kill = "あと%d人の患者を殺せば、このレベルは失敗です！",
    },
  },
  room_forbidden_non_reachable_parts = "この場所に部屋を設置すると、病院の一部にアクセスできなくなります。",
  praise = {
    many_benches = "患者用の座席が十分に確保されました。素晴らしいです。",
    plants_thriving = "素晴らしい。植物は間違いなく元気に育っています。 とてもいいですね。 このまま続ければ、トロフィーをもらえるかもしれません。",
    plenty_of_benches = "座席が十分にあるので、問題ありません。",
    plants_are_well = "いいですね。植物をきちんと手入れしていますね。 素晴らしいです。",
    few_have_to_stand = "あなたの病院では、立っている人はほとんどいません。 患者たちも喜ぶでしょう。",
    many_plants = "素晴らしいです。植物がたくさんあります。 患者たちも喜ぶでしょう。",
    patients_cured = "%d人の患者が治癒されました。",
  },
  room_requirements = {
    pharmacy_need_nurse = "薬局には看護師を雇用しなければなりません。",
    psychiatry_need_psychiatrist = "精神科室を建設したので、精神科医を雇用する必要があります。",
    research_room_need_researcher = "研究室を使用するには、研究スキルを持つ医師を雇用する必要があります。",
    op_need_two_surgeons = "手術室で手術を行うために外科医を2人雇用するしてください。",
    op_need_another_surgeon = "手術室を使用できるようにするには、外科医をもう1人雇用する必要があります。",
    gps_office_need_doctor = "診察室で働く医師を雇用する必要があります。",
    reception_need_receptionist = "患者を案内するために受付係を雇用する必要があります。",
    ward_need_nurse = "病室には看護師を雇用しなければなりません。",
    training_room_need_consultant = "講義室を使用するにはコンサルタントを雇用する必要があります。",
    op_need_ward = "患者が手術を待てるように、病室を建てて下さい。",
  },
  surgery_requirements = {
    need_surgeon_ward = "手術を行うには、外科医をもう1人雇用し、病室を建設する必要があります。",
    need_surgeons_ward_op = "手術を行うには、外科医を2人雇用し、病室と手術室を建設する必要があります",
  },
  boiler_issue = {
    minimum_heat = "ああ、そこにいましたか。地下のボイラーが壊れました。 病院内の人々が寒さに襲われてしまうでしょう。",
    maximum_heat = "地下室のボイラーがおかしくなりました 。暖房機の出力が最大になっています。人々は溶け始めています! 自販機を置けば少し状況を改善できるでしょう。",
    resolved = "朗報です。ボイラーと暖房機は正常運転を再開しました。 温度は患者とスタッフにとって適切なものになるはずです。",
  },
  staff_advice = {
    need_handyman_litter = "病院にゴミが散乱しています。 片付けをするために作業員を雇用してください。",
    need_doctors = "もっと多くの医師が必要です。 最も長い待ち行列のある部屋に、最も優秀な医師を配置してみてください。",
    need_handyman_machines = "病院の機械をメンテナンスするには、作業員を雇用する必要があります。",
    too_many_doctors = "医師が多すぎます。 現在暇している医師もいます。",
    need_handyman_plants = "観葉植物に水やりをするために作業員を雇う必要があります。",
    need_nurses = "看護師をもっと雇用する必要があります。 病室と薬局には看護師が必要です。",
    too_many_nurses = "看護師を雇いすぎているようです。",
  },
  staff_place_advice = {
    only_researchers = "研究医資格を持っている医師のみが研究室で働くことができます。",
    not_enough_lecture_chairs = "各学生医師は座るための講義用の椅子が必要です！",
    only_psychiatrists = "精神科医資格を持っている医師のみが精神科で働くことができます。",
    receptionists_only_at_desk = "受付係のみが受付デスクで働くことができます。",
    only_surgeons = "外科医資格を持っている医師のみが手術室で働くことができます。",
    doctors_cannot_work_in_room = "医師は%sでは働けません。",
    only_nurses_in_room = "看護師のみが%sで働くことができます。",
    only_doctors_in_room = "医師のみが%sで働くことができます。",
    nurses_cannot_work_in_room = "看護師は%sでは働けません。",
  },
  build_advice = {
    door_not_reachable = "人々はそのドアにたどり着くことができません。考えてみてください。",
    blueprint_would_block = "その設置で他の部屋をブロックしてしまいます。 部屋のサイズを変更するか、別の場所に移動してみてください。",
    placing_object_blocks_door = "そのオブジェクトをそこに置くと、人々はドアにたどり着けなくなります。",
    blueprint_invalid = "この設置は無効です。",
  },
  information = {
    first_cure = "よくやりました！一人目の患者を治療しましたよ。",
    place_windows = "窓を設置すると部屋が明るくなり、スタッフのやる気も向上します。",
    extra_items = "部屋に追加のアイテムを設置することで、スタッフの快適性が高まり、パフォーマンスが向上します。",
    emergency = "緊急事態です！とにかく！急いで！早く!",
    epidemic_health_inspector = "伝染病のニュースが保健省の耳に入りました。 すぐに保健検査官の視察に備えてください。",
    epidemic = "病院で伝染病が発生しました。すぐに対処する必要があります。",
    handyman_adjust = "作業員の優先順位を調整することで、より効率的にゴミ掃除することができます。.",
    patient_abducted = "患者の1人がエイリアンに誘拐されています。",
    promotion_to_doctor = "1人のジュニアがドクターに昇格しました。",
    patient_leaving_too_expensive = "患者が%sの料金を支払わずに去っています。高すぎます。",
    promotion_to_specialist = "あなたの医師の1人が%sに昇格しました。",
    fax_received = "画面の左下に表示されたアイコンは、重要な情報や決定が必要なことを知らせるものです。",
    promotion_to_consultant = "１人のドクターがコンサルタントに昇格しました。",
    initial_general_advice = {
      place_radiators = "患者たちが寒がっています。メニューから暖房機をさらに設置できます。",
      first_patients_thirsty = "患者たちは喉が渇いています。彼らのために飲料機を設置してください。",
      research_now_available = "あなたは最初の研究室を建設しました。これで研究画面にアクセスできます。",
      psychiatric_symbol = "精神科医の資格を持つ医師は: |のアイコンを持ちます。",
      surgeon_symbol = "手術が可能な医師は: {のアイコンを持ちます。",
      research_symbol = "研究が可能な医師は: }のアイコンを持ちます。",
      taking_your_staff = "誰かがあなたのスタッフを引き抜いています。 彼らを引き留めるために戦わなければなりません。",
      epidemic_spreading = "病院で伝染病が発生しています。 感染した人が病院を出る前に治療してください。",
      first_epidemic = "あなたの病院で伝染病が発生しています。 隠蔽するか、白状するかを決めてください。",
      autopsy_available = "自動解剖機が開発されました。 これを使用して、厄介な患者や歓迎されない患者を処分し、研究に活用することができます。 警告 - この機械の使用は非常に物議を醸す可能性があります。",
      first_VIP = "最初の VIP訪問を受け入れようとしています。 VIPが不衛生なものや不機嫌な患者を見ないように注意してください。",
      machine_needs_repair = "修理が必要な機械があります。 煙が出ている機械を見つけてクリックしてください。 次に作業員便利屋ボタンをクリックしてください。",
      increase_heating = "人々は寒がっています。 タウンマップの画面から設定温度を上げてください。",
      rats_have_arrived = "病院にネズミがはびこっています。 マウスでマウスを撃退しましょう。",
      first_emergency = "緊急患者の頭上には青い光が点滅しています。 死ぬか時間切れになる前に治療してください。",
      decrease_heating = "人々は暑がっています。 タウンマップの画面から設定温度を上げてください。",
    },
    first_death = "あなたはたった今、初めて患者を殺してしまいました。 どんな気分ですか？",
    pay_rise = "スタッフの1人が仕事を辞めてやると脅しています。 彼らの要求に同意するか、彼らを解雇するかを選択してください。 左下のアイコンをクリックすると、どのスタッフが辞めると脅しているかがわかります。",
    larger_rooms = "部屋が広いと、スタッフはより大切にされていると感じ、パフォーマンスが向上します。",
    vip_arrived = "気をつけてください！ %sがあなたの病院を見学するために到着しました！ 彼を喜ばせるために、すべてをスムーズに進めてください。",
  },
  placement_info = {
    door_can_place = "このドアはここに配置できます。",
    door_cannot_place = "申し訳ありませんが、このドアはここに配置できません。",
    room_cannot_place = "この部屋はここに配置できません。",
    room_cannot_place_2 = "この部屋はここには配置できません。",
    object_can_place = "このオブジェクトはここに配置できます。",
    window_can_place = "この窓はここに配置できます。いいですね。",
    window_cannot_place = "あぁ、この窓はここには配置できません。",
    reception_can_place = "この受付デスクはここに配置できます。",
    reception_cannot_place = "この受付デスクはここに配置できません。",
    staff_cannot_place = "このスタッフはここに配置できません。申し訳ありません。",
    staff_can_place = "このスタッフはここに配置できます。",
    object_cannot_place = "ねぇ、このオブジェクトはここに配置できませんよ。",
  },
  tutorial = {
    place_receptionist = "受付係を動かして好きな場所に配置します。 賢いことに、受付係はデスクまでやって来ます。",
    accept_purchase = "点滅しているアイコンを左クリックして購入します。",
    click_gps_office = "点滅している線を左クリックして、診察室を選択します。",
    door_in_invalid_position = "おっと！ ドアを無効な位置に配置しようとしました。 設計図の壁の別の場所を試してください。",
    start_tutorial = "ミッション説明を読んでから、マウスの左ボタンをクリックしてチュートリアルを開始してください。",
    room_too_small = "この部屋の設計図は小さすぎるため赤くなっています。 さらにドラッグして大きくしてください。",
    hire_receptionist = "患者を部屋に案内するために受付係が必要になります。",
    hire_doctor = "病気の人を診断し治療するには医師が必要です。",
    room_in_invalid_position = "おっと、この設計図は無効です。 赤い部分は他の部屋や病院の壁と重なっている場所を示しています。",
    reception_invalid_position = "受付デスクがグレーアウトされているのは、無効な位置にあるからです。移動または回転させてみてください。",
    place_doctor = "医師を病院内のどこかに配置してください。 診断する患者がいれば、医師は診察室に向かいます。",
    select_doctors = "点滅しているアイコンを左クリックして、雇うことができる医師を確認してください。",
    build_reception = "こんにちは。まず、病院には受付デスクが必要です。 設備メニューから選んでください。",
    receptionist_invalid_position = "受付係をその場所に配置することはできません。",
    select_diagnosis_rooms = "点滅しているアイコンを左クリックして、診断設備のリストを表示してください。",
    click_and_drag_to_build = "診察室を建設するには、まずその大きさを決める必要があります。 左マウスボタンを押しながらドラッグして部屋のサイズを決めてください。",
    rotate_and_place_reception = "右マウスボタンをクリックしてデスクを回転させ、左マウスボタンで配置してください。",
    select_receptionists = "点滅しているアイコンを左クリックすると、現在雇うことができる受付係が表示されます。 アイコンの数字は候補者の人数を示しています。",
    next_receptionist = "これがリスト内の最初の受付係です。 点滅しているアイコンを左クリックして次の受付係を確認してください。",
    prev_receptionist = "点滅しているアイコンを左クリックして、前の受付係を確認してください。",
    choose_receptionist = "良い能力と適正な給与を持つ受付係を選び、点滅しているアイコンを左クリックして雇用してください。",
    confirm_room = "点滅しているアイコンを左クリックして部屋を設置するか、Xアイコンをクリックして前のステップに戻ってください。",
    place_objects = "右クリックで部屋のアイテムを回転させ、左クリックで配置してください。",
    choose_doctor = "各医師の能力をよく確認してから選んでください。",
    doctor_in_invalid_position = "おっと！ そこに医師を配置することはできません。",
    room_too_small_and_invalid = "設計図が小さすぎて無効な場所にあります。 設置を続けてください。",
    information_window = "ヘルプボックスは、あなたがちょうど建設した素敵な診察室についての情報を教えてくれます。",
    place_door = "設計図の壁に沿ってマウスを動かし、ドアを配置したい場所に作成してください。",
    place_windows = "ドアと同じように窓を配置してください。 窓は必須ではありませんが、スタッフが外を見ることができるとより幸せです。",
    window_in_invalid_position = "この窓は無効な場所にあります。 もしよろしければ壁の他の場所に配置してみてください。",
    room_big_enough = "設計図の大きさが十分になりました。 マウスボタンを離すと配置されます。必要に応じて移動またはサイズ変更ができます。",
    order_one_reception = "点滅しているラインを左マウスボタンで一度クリックして、受付デスクを注文してください。",
    build_pharmacy = "おめでとうございます！ それでは薬局を建設し、看護師を雇って稼働する病院を作ってください。",
    build_gps_office = "患者の病気の診断を開始するために診察室を建設してください。",
    object_in_invalid_position = "このアイテムは無効な場所にあります。 別の場所に配置するか、回転させて設置できるようにしてください。",
  },
}

totd_window = {
  previous = "前のヒント",
  tips = {
    [1] = "病院には受付デスクと診察室が必要です。 その後の必要設備は病院を訪れる患者の種類に応じて決まります。 薬局は常に良い選択肢ですけどね。",
    [2] = "空気注入機のような機械はメンテナンスが必要です。 修理のために作業員を1〜2人雇用してください。 さもないとスタッフや患者が危険にさらされます。",
    [3] = "スタッフはしばらくすると疲れてしまいます。 スタッフルームを建てて、スタッフがリラックスできるようにしてください。",
    [4] = "スタッフと患者が暖かく感じるように十分な暖房機を配置してください。 タウンマップを使用して、病院内でより多くの暖房が必要な場所を特定します。",
    [5] = "医師のスキルレベルは診断の質と速度に大きな影響を与えます。 診察室に熟練した医師を配置すると追加の検査施設はそれほど必要ありません。",
    [6] = "ジュニアやドクターは講義室でコンサルタントから学ぶことでスキルを向上させることができます。 コンサルタントが特別な資格（外科医、精神科医、または研究者）を持っている場合、そのスキルも教えられます。",
    [7] = "ヨーロッパの緊急番号（112）をファックス機に入力してみましたか？ サウンドがオンになっていることを確認してください！",
    [8] = "解像度や言語などの設定は、メインメニューとゲーム内のオプションウィンドウで調整できます。",
    [9] = "英語以外の言語を選択しましたが、至る所に英語のテキストがありますか？ 不足しているテキストをあなたの言語に翻訳する手助けをしてください！",
    [10] = "CorsixTHチームは強化を求めています！コーディング、翻訳、またはグラフィックスの作成に興味がありますか？Discordサーバー、Sub-Reddit、Matrixサーバーで連絡してください。リンクは私たちのウェブサイト（CorsixTH.com）にあります。",
    [11] = "バグを見つけた場合は、バグトラッカーに報告してください：th-issues.corsix.org",
    [12] = "各レベルには、次のレベルに進むために満たすべき要件があります。 レベル目標への進捗を確認するには、ステータスウィンドウをチェックしてください。",
    [13] = "既存の部屋を編集または削除したい場合は、下のツールバーにある編集ボタンを使用してください。",
    [14] = "待っている患者が多い場合、マウスカーソルをその部屋に重ねることで、その部屋を待っている患者をすぐに見つけることができます。",
    [15] = "部屋のドアをクリックして、その部屋の待ち状況を表示します。 待ち状況の並び替えや、患者を他の部屋に送るなどの微調整ができます。",
    [16] = "不満を持ったスタッフは頻繁に給与の引き上げを要求します。 スタッフが快適な環境で働いていることを確認して、それを防ぎます。",
    [17] = "病院で待っている間、患者は喉が渇くでしょう。 暖房の設定温度を上げるとさらに喉が渇きます！ 戦略的な場所に自動販売機を配置して追加の収入を得ましょう。",
    [18] = "すでに発見した病気であれば、診断プロセスを早期に中止して、推測により治療を行うことができます。 ただし、誤った治療のリスクが高まり、患者の死につながる可能性があるので注意してください。",
    [19] = "緊急事態は余裕のあるキャパシティがあれば、追加の資金を稼ぐ良い機会となります。",
    [20] = "ご存知でしたか？ 作業員を特定の作業に割り当てることができます。 スタッフのプロフィール画面でそれぞれの作業ボタンをクリックして割り当てしてください！",
  },
  next = "次のヒント",
}

fax = {
  emergency = {
    cure_not_possible_build = "この治療を行うために%sを建設する必要があります",
    location = "%sで事件が発生しました",
    choices = {
      accept = "まかせんかい！！",
      refuse = "ごめん。勘弁して。",
    },
    free_build = "もしこの混乱を収める事ができれば評判が上がりますが、もし失敗すればあなたの評判はがた落ちでしょう。",
    locations = {
      [1] = "サッチャー化学プラント",
      [2] = "まやかし大学",
      [3] = "宇宙園芸センター",
      [4] = "危険物質研究所",
      [5] = "モリスダンサーズ集会",
      [6] = "フロッグ&ブル パブ",
      [7] = "ビッグデーブ酒店と葬式商会",
      [8] = "タージカレーハウス",
      [9] = "バート中古石油化学製品商店",
    },
    num_disease = "現在%d人の%sの患者が治療を待っています。注意してください。",
    bonus = "この緊急事態に対応することで、最大$%dのボーナスが得られます。しかし、もし失敗すればあなたの評判はがた落ちでしょう。",
    cure_not_possible = "現時点ではこの病気を治療できません。",
    cure_possible = "必要な設備と技術は持っています。|きっとこの緊急事態を収拾できます！",
    cure_not_possible_build_and_employ = "%sを建設し、%sを雇う必要があります。",
    num_disease_singular = "現在1人の%s患者がいて、即時の対応が必要です。",
    cure_possible_drug_name_efficiency = "必要な機器と技術を既に持っています。必要な薬もあります。それは%sであり、効果は%d パーセントです。",
    cure_not_possible_employ = "%sを雇用する必要があります。",
  },
   epidemic = {
    cover_up_explanation_1 = "しかし、隠蔽を試みる場合、保健省が発見する前に、限られた時間内で感染した患者全員を治療する必要があります。",
    cover_up_explanation_2 = "保健省検査官が訪問し、伝染病の隠蔽がまだ進行中だと発見した場合、厳しい措置を取られる可能性があります。",
    disease_name = "医師が伝染性の病気%sを発見しました。",
    declare_explanation_fine = "もし伝染病を宣言すれば、罰金$%dを支払い評判を落とします。その代わりにすべての患者にワクチンが自動的に接種されます。",
    choices = {
      cover_up = "患者が１人も病院を出ないように気を付けながら、制限時間内で感染者全員を治療する。",
      declare = "伝染病を発表し、罰金を払い、評判を落とす。",
    },
  },
  disease_discovered = {
    close_text = "新しい症例が発見されました。",
    need_to_build = "これに対処するためには%sを建設しなければなりません。",
    need_to_employ = "この危機に対処するために%sを雇用してください。",
    need_to_build_and_employ = "%s を建設し、%sを雇用すればうまくいくでしょう。",
    discovered_name = "チームが新しい症例を発見しました。それは%sです。",
    can_cure = "この病気に対処することができます。",
  },
  vip_visit_query = {
    vip_name = "%s があなたの病院を訪問したいと希望しています。",
    choices = {
      invite = "VIPに正式な招待状を出す。",
      refuse = "言い訳をして、VIPの訪問を避ける。",
    },
  },
  diagnosis_failed = {
    situation = "すべての診断機を試しましたが、まだ何の病気か判りません。",
    choices = {
      take_chance = "イチかバチか治療する。",
      send_home = "患者を家に送り返す。",
      wait = "もっと診断室を建てるまで患者を待たせる。",
    },
    what_to_do_question = "この患者をどうしましょう？",
    partial_diagnosis_percentage_name = "%dパーセントの確率で「%s」だという結果が出ました。.",
  },
  emergency_result = {
    earned_money = "最大ボーナス$%dのうち、$%dを獲得しました。",
    close_text = "クリックして閉じる",
    saved_people = "あなたは%d人中%d人を救いました。",
  },
  choices = {
    accept_new_level = "次のレベルに進む",
    decline_new_level = "もう少しプレイを続ける",
    return_to_main_menu = "メインメニューに戻る",
  },
  vip_visit_result = {
    ordered_remarks = {
      [1] = "なんて素晴らしい病院だ。次に本当に具合が悪くなったら、絶対にここに入院するぞ。",
      [2] = "これこそが本当の病院だ！",
      [3] = "これは素晴らしい病院だ。いくつかの病院に入ったことがあるからわかりますよ。",
      [4] = "驚くべき病院経営です。招待してくださって感謝します。",
      [5] = "まあ、悪くはないですな...",
      [6] = "良い病院ですな。ところで皆さん、タージでカレーでもいかがです？",
      [7] = "ふむ、もっとひどい所も見て来ましたが...改善が必要なのは言うまでもないですな。",
      [8] = "いやいや、気分が悪くなっても、ここだけは来たくないですな。",
      [9] = "率直に言って何の変哲もない病院ですな。もっと期待していたんですが。",
      [10] = "なんでわざわざ来たんだろう？４時間連続のオペラの方がマシだ！",
      [11] = "目にしたものにがっかりしたよ。これを病院と呼ぶのか？豚小屋と言った方がお似合いだな！",
      [12] = "公の場で注目を浴び、こんな臭い場所を訪れさせられることにうんざりだ！もうこんな仕事辞めてやる。",
      [13] = "なんてひどい場所だ。ここを閉鎖するために運動を開始する！",
      [14] = "こんなに酷い病院は見たことがない。なんてざまだ！",
      [15] = "正直ショックを受けました。あれは病院と呼べる代物じゃない。一杯引っかけに行くぞ！",
    },
    cash_grant = "$%dの援助金を受けとりました。",
    vip_remarked_name = "あなたの病院を訪れた後、%sはこう発表しました。",
    close_text = "ご訪問いただきありがとうございました。",
    rep_loss = "それに応じて、あなたの評判は下がりました。",
    remarks = {
      [1] = "なんて素晴らしい病院だ。次に本当に具合が悪くなったら、絶対にここに入院するぞ。",
      [2] = "これこそが本当の病院だ！",
      [3] = "これは素晴らしい病院だ。いくつかの病院に入ったことがあるからわかりますよ。",
      [4] = "驚くべき病院経営です。招待してくださって感謝します。",
      [5] = "まあ、悪くはないですな...",
      [6] = "良い病院ですな。ところで皆さん、タージでカレーでもいかがです？",
      [7] = "ふむ、もっとひどい所も見て来ましたが...改善が必要なのは言うまでもないですな。",
      [8] = "いやいや、気分が悪くなっても、ここだけは来たくないですな。",
      [9] = "率直に言って何の変哲もない病院ですな。もっと期待していたんですが。",
      [10] = "なんでわざわざ来たんだろう？４時間連続のオペラの方がマシだ！",
      [11] = "目にしたものにがっかりしたよ。これを病院と呼ぶのか？豚小屋と言った方がお似合いだな！",
      [12] = "公の場で注目を浴び、こんな臭い場所を訪れさせられることにうんざりだ！もうこんな仕事辞めてやる。",
      [13] = "なんてひどい場所だ。ここを閉鎖するために運動を開始する！",
      [14] = "こんなに酷い病院は見たことがない。なんてざまだ！",
      [15] = "正直ショックを受けました。あれは病院と呼べる代物じゃない。一杯引っかけに行くぞ！",
      bad = {
        [1] = "なんでわざわざ来たんだろう？４時間連続のオペラの方がマシだ！",
        [2] = "目にしたものにがっかりしたよ。これを病院と呼ぶのか？豚小屋と言った方がお似合いだな！",
        [3] = "公の場で注目を浴び、こんな臭い場所を訪れさせられることにうんざりだ！もうこんな仕事辞めてやる。",
      },
      mediocre = {
        [1] = "ふむ、もっとひどい所も見て来ましたが...改善が必要なのは言うまでもないですな。",
        [2] = "いやいや、気分が悪くなっても、ここだけは来たくないですな。",
        [3] = "率直に言って何の変哲もない病院ですな。もっと期待していたんですが。",
      },
      super = {
        [1] = "なんて素晴らしい病院だ。次に本当に具合が悪くなったら、絶対にここに入院するぞ。",
        [2] = "これこそが本当の病院だ！",
        [3] = "これは素晴らしい病院だ。いくつかの病院に入ったことがあるからわかりますよ。",
      },
      very_bad = {
        [1] = "なんてひどい場所だ。ここを閉鎖するために運動を開始する！",
        [2] = "こんなに酷い病院は見たことがない。なんてざまだ！",
        [3] = "正直ショックを受けました。あれは病院と呼べる代物じゃない。一杯引っかけに行くぞ！",
      },
      free_build = {
        [1] = "とても素晴らしい病院ですね！ただ、資金の制限がなければ運営するのはそれほど難しくないですよね？",
        [2] = "私は経済学者ではありませんが、私でもこの病院を運営できると思います。この意味わかりますよね？",
        [3] = "とてもよく運営されている病院です。ただ、不況には気をつけてくださいね！…そうか、あなたには関係ない話でしたね。",
      },
      good = {
        [1] = "驚くべき病院経営です。招待してくださって感謝します。",
        [2] = "まあ、悪くはないですな...",
        [3] = "良い病院ですな。ところで皆さん、タージでカレーでもいかがです？",
      },
    },
    rep_boost = "この地域でのあなたの評判が向上しました。",
    telegram = "電報！",
  },
  disease_discovered_patient_choice = {
    guessed_percentage_name = "チームは患者の病状を推測する必要がありました。それが%sである確率は%dパーセントです。",
    need_to_employ = "この状況に対処するためには%sを雇用してください。",
    disease_name = "研究チームは新しい病気「%s」を発見しました。",
    choices = {
      wait = "患者をしばらく病院で待たせる。",
      send_home = "患者を自宅へ送り返す。",
      research = "患者を研究科に送る。",
    },
    need_to_build = "これに対処するためには%sを建設する必要があります。",
    need_to_build_and_employ = "%sを設置し、%sを雇用すればうまくいきます。",
    can_not_cure = "この病気を治療することはできません。",
    what_to_do_question = "患者をどうしますか？",
  },
  epidemic_result = {
    rep_loss_fine_amount = "新聞がこの伝染病事件を大きく取り上げるでしょう。あなたの評判は大きく傷つき、さらに罰金として$%dが科されます。",
    succeeded = {
      part_1_name = "検査官があなたの病院で%sが広まったという噂を聞きつけました。",
      part_2 = "しかしながら、検査官は噂を裏付ける証拠を見つける事ができませんでした。",
    },
    close_text = "やった！",
    hospital_evacuated = "健康委員会はあなたの病院を閉鎖する以外、手がありませんでした。",
    fine_amount = "政府は国家緊急事態を宣言し、罰金として%dが科されます。",
    compensation_amount = "政府はこの噂があなたの病院に与えた損害の代償金として$%dを授与することを決定しました。",
    failed = {
      part_1_name = "伝染病%sの発生を隠そうとした結果、",
      part_2 = "あなたの病院スタッフは地域に伝染病を広げてしまいました。",
    },
  },
}

vip_names = {
  [1] = "豊臣家康市長",
  [2] = "俳優ジェームズ・ポンド",
  [3] = "ハヤト=ミヤザキ監督",
  [4] = "野々口英世",
  [5] = "アバルート・アインシュイタン卿",
  [6] = "小泉進三郎 民主自由党代表",
  [7] = "チャーチル・チャップリソ市議会議員",
  [8] = "音楽家 ジャン・レノ",
  [9] = "大リーガー 小谷翔平",
  [10] = "アイザック ニュートソ三世",
  health_minister = "保健省大臣",
}

disease_discovered_patient_choice = {
  need_to_employ = "この状況に対処するためには%sを雇用してください。",
}

introduction_texts = {
  demo = " デモ病院へようこそ！//残念ながらデモ版にはこのレベルしか含まれていません。 しかし、ここにはあなたを忙しくさせるのに十分なものがたくさんあります！ 様々な病気に対応するためには異なる部屋が必要です。 時々緊急事態が発生することもあります。 また、研究室を使用して追加の部屋を研究する必要もあります。 あなたの目標は、$100,000を稼ぎ、病院の価値を$70,000にし、評判を700にすることです。 同時に、患者の少なくとも75％を治療してください。 評判が300を下回ったり、患者の40％以上を死亡させてしまうとゲームオーバーになります。//頑張ってください！",
  level1 = " 最初の病院へようこそ！//受付デスクを配置し、診察室を建設し、受付係と医師を雇うことで病院を運営し始めましょう。 それから患者が来るのを待ちます。 精神科を設置し、精神科の資格を持つ医師を雇うのも良いアイデアです。 薬局と看護師も患者を治療するために不可欠です。 風船あたま病の患者には注意してください。 空気注入室がそれをすぐに解決します。 10人の患者を治療し、評判が200以下にならないようにしましょう。",
  level2 = " このエリアにはより多くの種類の病気がありますので、研究科を建てることお勧めします。 より多くの患者を治療できるように病院を設計してください。 病院を清潔に保ち、できるだけ評判を高めるように心がけてください。 ベロだし病に対応するためには、ベロ出し病クリニックが必要です。 新しい病気を診断するために心臓科も建設できます。 これらの部屋はどちらも建設する前に研究する必要があります。 また、病院を拡張するために、追加の土地を購入することもできます。 タウンマップから購入が可能です。 評判300、銀行残高$10,000、40人の患者を治療することを目指してください。",
  level3 = " 今回は裕福なエリアに病院を設立します。 保健省はあなたがここで健全な収益を上げると期待しています。 最初に良い評判を得る必要がありますが、病院が順調に運営され始めたら、できるだけ多くの資金を稼ぐことに集中してください。 それだけではなく、緊急事態が発生する可能性もあります。 同じ症状を持つ人が同時に大挙して押し寄せて来ますが、全員を時間内に治療すれば評判向上と多額のボーナスを受け取れます。 王様症候群のような病気が発生する可能性があり、手術室と病室の建設を予算に組み込んでおくべきです。 $20,000を稼いで基準を達成してください。  ",
  level4 = " すべての患者を満足させ、できるだけ効率的に対応し、死者を最小限に抑えてください。 評判もできるだけ高く保つようにしてください。 あまりお金の事を心配しすぎるのも良くありません。 病院の評判が上がれば、お金は後から付いてきます。 医師の訓練を行い、能力を上げることもできます。 他の人よりも透けて見える患者もいるかもしれませんが、しっかり対処してください。 評判を500以上にしましょう。",
  level5 = " このレベルは様々な症例を扱う必要な忙しい病院になります。 登場する医師は皆、大学を出たばかりの初心者ですので、講義室を建てて適切なレベルに訓練することが重要です。 医者の訓練が可能なコンサルタントは３人しかいませんから、彼らの幸福度には気を付けて下さい。 さらに、この病院はサンアンドロイド断層の上に建っていることも注意が必要です。 地震のリスクが常に存在します。 地震は機械を破壊し、病院のスムーズな運営を妨げるでしょう。 評判を400まで上げ、$50,000を銀行に貯めて成功を収めてください。さらに200人の患者を治療してください。",
  level6 = " あなたの知識をフル活用して、スムーズでよく管理された病院を設立し、健全な利益を上げ、病気の人々が投げかけるすべての問題に対処できるようにしてください。 この地域の環境は特に細菌や感染症が繁殖しやすいことを意識してください。 徹底的な衛生管理が行わなければ、患者に伝染病が広がるのは避けられないでしょう。 $150,000を稼ぎ、病院の価値が$140,000を超えるようにしてください。",
  level7 = " ここでは保健省の厳しい目が光っています。 銀行残高を高く保ち、良い評判を得られるように気を付けてください。 不必要な死亡は許されません ― 死亡者は経営にとって最大の敵です。 一流のスタッフを常に揃えて、必要な機器がすべて揃っていることを確認してください。 評判600と銀行残高$200,000を目指してください。",
  level8 = " 効率よく利益を生み出す素晴らしい病院を作れるかどうかは、あなたにかかっています。この地域の住民はかなり裕福です。 彼らからいくら巻き上げられるかは、あなたの腕次第です。 人々を治療するのは素晴らしいことですが、それよりも本当に大切なのはお金もうけです。 病気の人々からできるだけ多くのお金を稼ぎましょう。 このレベルを完了するために$300,000を集めてください。",
  level9 = " 保健省の銀行口座にお金を入れ、大臣のための新しいリムジン代を支払った後、病人と困っている人々に役に立つ思いやりがありよく管理された病院を作ることに戻れます。 ここでは多くの異なる問題が発生することが予想されますが、よく訓練されたスタッフと必要な設備があれば、どんな問題も解決できるはずです。 病院の価値が$200,000であり、銀行に$400,000が必要です。 それ以下では、レベルをクリアすることはできません。",
  level10 = " 保健省は、この地域で発生するすべての病気に対応するだけでなく、薬の効き目にも集中するよう求めています。保健省検査官シックからの警告がありましたので、すべての薬が非常に効率的であることを確認してください。また、病院自体も非難の余地がないように、死亡者数も最低に抑えてください。ヒントとして、ゼリー槽のためにスペースを確保しておくことをお勧めします。すべての薬を少なくとも80％の効き目に開発し、評判を650にし、銀行に500,000ドルを貯めてクリアしましょう。",
  level11 = " 究極の病院を構築するチャンスが与えられました。 保健省があなたに期待するのは世界最高の病院です。 大金を稼ぎ、非常に高い評判を持ち、あらゆる可能性に対応することが期待されています。 これは重要な仕事です。 成功させるには特別な能力が必要でしょう。 また、この地域ではUFOの目撃情報もあるので、スタッフが予想外の訪問者に対応できるように準備してください。 病院の価値を240,000ドルにし、銀行に500,000ドルを貯め、評判を700にしてください。",
  level12 = " これが最大の挑戦です。あなたの仕事に感銘を受けた保健省は、あなたに最高の仕事を用意しました。 またもや究極の病院を建設し、巨万の富を稼ぎ、驚異的な評判を得ることです！ また、可能な限りすべての土地を購入し、すべての病気を治療し（すべてとは１つ残らずという意味です）、すべての賞を獲得することも期待されています。 できそうですか？ 650,000ドルを稼ぎ、750人を治療し、評判を800にしてクリアしましょう。",
  level13 = " 病院管理者としてのあなたの驚異的な手腕が、秘密特殊部隊の特別秘密部門の目に止まりました。 彼らはあなたにスペシャルボーナスを用意しています。 ネズミ汚染病院がネズミターミネーターを必要としています。 作業員がすべてのゴミを片付ける前に、できるだけ多くのネズミを撃たなければなりません。 準備OKですか？",
  level14 = " また新しい挑戦です。 それは完全に予期しない驚くべき病院です。 これを成功させれば、あなたは勝者の中の勝者となります。 ただし、簡単だとは思わないでください。これまでに直面する最高にタフなミッションです。幸運を祈ります！",
  level15 = "病院経営の基礎はこんなところです。 医師達は患者の診断に関して、あなたの助けを必要としています。 彼らを助けるには、検査室等の部屋を建ててあげましょう。",
  level16 = " 患者の診断がある程度進んだら、治療施設やクリニックを建設する必要があります。まず手始めに薬局を建てるのが良いでしょう。薬を投与するために看護師も必要です。",
  level17 = " 最後に一言。病院の評判には気をつけてください。 評判が良ければ、遠方から患者が訪れるようになります。 もし、たくさん死者を出したり、人々を不幸にさせなければ、このレベルをクリアするのはそう難しくないはずです！ さあ、やってみましょう。幸運を祈ります。頑張ってください！",
  level18 = "",
}

letter = {
  [1] = {
    [1] = "親愛なる%s様//",
    [2] = "素晴らしい！ 病院経営において素晴らしい手腕を発揮されました！ 我々保健省は、あなたがもっと大きな病院で働く気がないかお尋ねしたい。 あなたにぴったりのプロジェクトがあると思います。 あなたの給料は$%dになります。 御一考下さい。//",
    [3] = "%s病院での仕事に興味がありますか？",
  },
  [2] = {
    [1] = "親愛なる%s様//",
    [2] = "エクセレント！ あなたの病院での業績は素晴らしいです。 景色を変え、新しい挑戦を望むのであれば、新たなプロジェクトを用意しました。 無理をする必要はありませんが、やってみる価値は十分あると思います。 給与は$%dです。//",
    [3] = "%s病院での仕事を望みますか？",
  },
  [3] = {
    [1] = "親愛なる%s様//",
    [2] = "あなたはこの病院での在任期間中に大成功を収めました。 したがって、我々はあなたに大きな期待を寄せており、他の場所でのポジションを提供したいと考えています。 給与は$%dで、この新しい挑戦を気に入ってくれると思います。//",
    [3] = "s病院でのポジションに興味がありますか？",
  },
  [4] = {
    [1] = "親愛なる%s様//",
    [2] = "おめでとうございます！ 我々保健省一同は、あなたの病院運営手腕に非常に感銘を受けています。 あなたが保健省の金の卵であることは間違いありません。 ただ、あなたの能力を試す事ができるような、難しい仕事を好むのではないでしょうか。 給与は$%dですが、決定はあなたに委ねます。//",
    [3] = "%s病院での仕事を引き受けてくれますか？",
  },
  [5] = {
    [1] = "親愛なる%s様//",
    [2] = "再度のお願いです。 あなたがこの魅力的な病院を離れたくない気持ちは尊重します。 しかし、今一度のご検討をお願いします。 もし他の病院に移り、円滑に運営いただけるのであれば、素晴らしい給与$%dを提供します。//",
    [3] = "今すぐ%s病院に移りたいですか？",
  },
  [6] = {
    [1] = "親愛なる%s様//",
    [2] = "ご機嫌いかがですか。 あなたがこの素晴らしく運営された病院をどれほど愛しているかを理解しています。 しかしながら、今後のキャリアも考えるべきだと思います。 もし異動のご決断をいただけるなら、$%dの給与を用意しています。 再考の価値はあると思います。//",
    [3] = "%s病院でのポジションを希望しますか？",
  },
  [7] = {
    [1] = "親愛なる%s様//",
    [2] = "お久しぶりです。 保健省は、あなたが現在の病院に留まる決定を再考するかどうかをお聞きしたいです。 現在の素晴らしい病院に満足しているのは当然のことですが、あなたにとって更なる発展の時が来たのです。 より挑戦的なポストと給与$%dを受け入れるが、あなたのより良い未来に繋がっていると信じています。//",
    [3] = "%s病院でのポストを引き受けてくれますか？",
  },
  [8] = {
    [1] = "親愛なる%s様//",
    [2] = "ごきげんよう。 前回のお手紙では私共の申し出を受けて頂けませんでしたね。 今回は更なる好条件―新しい病院での最高のポジションと給与$%dを提案いたします。 前回の決定を再考頂けるのではと考えています。 いかがですか？ あなたにぴったりの仕事だと思います。//",
    [3] = "%s病院でのポジションを引き受けてくれますか？",
  },
  [9] = {
    [1] = "親愛なる%s様//",
    [2] = "あなたは医学の長い歴史の中で最も優れた病院経営者であることを証明しました。 この大きな成果は報われるべきですので、全病院協会の会長職を提供したいと思います。 給与は$%dです。 これからは、訪れる全ての病院で、熱狂的に歓迎されるでしょう！//",
    [3] = "これまでのすべてに感謝します。長い半引退生活を楽しんでください。//",
  },
  [10] = {
    [1] = "親愛なる%s様//",
    [2] = "おめでとうございます。 あなたは我々が任命したすべての病院を見事に運営していただきました。 この素晴らしい業績により、世界中の都市を自由に行き来する資格があります。 年金として$%dが支給されます。 全国を無料で旅行し、熱心な支持者にすべての病院の活動を宣伝していただければと思います。//",
    [3] = "私たちは皆、あなたを誇りに思っています。命を救うために尽力してくださったことに感謝しています。//",
  },
  [11] = {
    [1] = "親愛なる%s様//",
    [2] = "あなたの仕事ぶりはすべての人々のお手本でした。 多くの病院をこれほど見事に経営されたことに感謝と尊敬の意を表します。 私たちはあなたに生涯給与として$%dを提供し、オフィシャルオープンカーで都市から都市へ移動し、あなたがどのようにしてこれほどの成果を達成したかを講演していただきたいと考えています。//",
    [3] = "あなたはすべての知的階級の人々にとっての模範であり、世界中の誰もがあなたを人類の宝だと見なしています。//",
  },
  [12] = {
    [1] = "親愛なる%s様//",
    [2] = "今世紀始まって以来の最高の病院管理者としての成功したキャリアが終わりに近づいています。 あなたの国への影響にふさわしく、フェスティバルの開会、船の進水、トークショーの出演などを行うことだけで、保健省は給与として$%dを提供したいと考えています。 それは私たち全員とって素晴らしいPRとなるのです！//",
    [3] = "このポジションを受け入れてください。難しい仕事ではなく、どこに行くにも車と警察の護衛を提供します。//",
  },
  custom_level_completed = "よくやりました！このカスタムレベルのすべての目標を達成しました！",
  return_to_main_menu = "メインメニューに戻りますか？それともプレイを続けますか？",
  campaign_level_completed = "よくやりました！ レベルをクリアしました。 でも、まだ終わりではありません！ %s病院でのポジションに興味がありますか？",
  campaign_completed = "素晴らしい！ すべてのレベルをクリアしました。 これでリラックスして、インターネット上のフォーラムにあなたの成果を報告できますね。 お疲れ様でした！",
  dear_player = "親愛なる%s様",
  campaign_level_missing = "申し訳ありませんが、このキャンペーンの次のレベルが見つからないようです。 (名前：%s)",
}
information = {
  level_lost = {
    [1] = "残念！このレベルに失敗しました。次回はうまくいくといいですね！",
    [2] = "失敗の理由:",
    balance = "銀行残高が%d以下になりました。",
    reputation = "評判が%d以下になりました。",
    percentage_killed = "患者の%dパーセント以上を死亡させました",
    cheat = "これはあなたの選択ですか？それとも間違ったボタンを選択しましたか？それとも正しくチートすることすらできないのですか？面白くないですねぇ？",
  },
  cheat_not_possible = "このレベルではそのチートは使用できません。チートにも失敗しましたね。面白くないですよねぇ？",
  custom_game = "CorsixTHへようこそ。このカスタムマップを楽しんでください！",
  no_custom_game_in_demo = "申し訳ありませんが、デモバージョンではカスタムマップをプレイできません。",
  very_old_save = "このレベルを開始してからゲームに多くの更新がありました。すべての機能が意図通りに動作することを確認するために再開始を検討してください。",
  cannot_restart = "残念ながら、このカスタムゲームはリスタート機能が実装される前に保存されました。",
}

warnings = {
  newersave = "警告: より新しいバージョンのCorsixTHからセーブデータをロードしました。 クラッシュが発生する可能性があるため、続行は推奨されません。 自己責任でプレイしてください。",
  levelfile_variable_is_deprecated = "通知: レベル '%s' にはレベルファイル内に廃止予定の変数定義が含まれています。 '%LevelFile' は '%MapFile' に名前が変更されました。 マップの作成者にレベルを更新するように伝えてください。",
}

trophy_room = {
  reputation = "REPUTATION",
  cash = "CASH",
  pop_percentage = {
    awards = {
      [1] = "昨年度、あなたの病院は地域での高い支持率を得ました！！ よくやりました！",
      [2] = "おめでとうございます。 地域の全病院中最高の支持率を得ました。",
      [3] = "素晴らしい！ 地域の他病院すべての合計よりも高い支持率を獲得しました！",
    },
    penalty = {
      [1] = "今年の来院者数はあまりに低すぎます。 お金を稼ぐには患者が必要です。",
      [2] = "地域最低の支持率を記録しました。 非常に恥ずかしいことです。",
    },
  },
  curesvdeaths = {
    awards = {
      [1] = "昨年のあなたの病院の治療率は素晴らしいものでした。 お祝い申し上げます。",
    },
    penalty = {
      [1] = "あなたの病院の治療率は地域で最低です。 より多くの人を治療し、死なせないようにしてください。 がっかりさせないでください。",
    },
  },
  best_value_hosp = {
    trophies = {
      [1] = "あなたの病院の非常に高い価値を表彰します。 高価な設備は高い治療を提供します。 素晴らしいです！",
    },
    regional = {
      [1] = "ゲーム内で最も価値のある病院を持つことをお祝いします。 素晴らしい結果です！ この調子で続けてください。",
    },
    penalty = {
      [1] = "地域最低の病院価値を記録しました。 この恥ずべき事態に何か手を打ってください。 もっと高価なものを手に入れましょう！",
    },
  },
  rats_accuracy = {
    trophies = {
      [1] = "ネズミの射撃精度が%d%%であったことを称えて、シンジケートウォーズ賞を贈ります。",
      [2] = "昨年、病院で狙ったネズミの%d%%を退治するという正確無比な腕を称えて、このトロフィーを授与します。",
      [3] = "病院内のすべてのネズミの%d%%を殺したことを記念して、ダンジョンキーパートロフィーを授与します。 おめでとうございまチュ～！",
    },
  },
  no_deaths = {
    trophies = {
      [1] = "ノーお悔やみ賞の受賞おめでとう！ 昨年は１人の死人も出しませんでしたね。",
      [2] = "ライフ フォーエバー コーポレーションが、昨年の死亡者ゼロの達成を称え、このトロフィーを贈ります。",
      [3] = "あなたの素晴らしい病院で死亡者ゼロを達成したことで、サバイバル賞を授与されました。 素晴らしいです。",
    },
    awards = {
      [1] = "今年、あなたの病院での死亡者数が非常に少ないことを記念して、この賞を贈ります。 素晴らしいです。",
      [2] = "あなたの素晴らしい能力により、病院での死亡者数を最小限に抑えました。 この成果に非常に満足していいでしょう。",
    },
    regional = {
      [1] = "昨年、他のどの病院よりも低い患者死亡者数を記念して、この賞を贈ります。",
    },
    penalty = {
      [1] = "あなたの病院では昨年多数の死亡者数を出しました。 とても残念です。 より多くの人々を生き延びさせてください。",
      [2] = "あなたの病院は患者にとって危険でしかありません。 死亡させるのではなく、患者を治療してください。",
    },
  },
  gen_repairs = {
    awards = {
      [1] = "病院の機械をよく整備している作業員の働きに対して特別賞が授与されます。 よくやりました。 休暇をあげましょう。",
      [2] = "作業員たちは他のどの病院よりも優れたパフォーマンスを発揮しました。これは重要な成果であり、称賛に値します。",
      [3] = "あなたの病院の設備は素晴らしく整備されています。 作業員たちが示した献身は並外れたもので、素晴らしい仕事ぶりには脱帽です！！",
    },
    penalty = {
      [1] = "作業員は機械のメンテナンスをサボっています。 もっとよく監督するか、より多くの作業員を雇うべきです。",
      [2] = "機械のメンテナンスが最低です。 もっとスタッフが管理に気を使うよう躾けてください。",
    },
  },
  many_cured = {
    trophies = {
      [1] = "昨年、病院のほぼすべての患者を治療したことで、マリー・キュリー賞を受賞しました。 おめでとうございます。",
      [2] = "国際治療財団は、昨年あなたの病院で非常に多くの人々を治療したことを称え、キュアーオールトロフィーを授与します。",
      [3] = "昨年、病院の患者の大部分を治療したことで、「病気に負けないうがい薬」トロフィーが授与されました。",
    },
    awards = {
      [1] = "昨年、たくさんの人を治療したことにお祝いを申し上げます。 多くの人々があなたの仕事のおかげで元気になりました。",
      [2] = "他のどの病院よりも多くの患者を治療したことを称えて、この賞を受け取ってください。素晴らしい業績です。",
    },
    regional = {
      [1] = "他のすべての病院を合わせたよりも多くの患者を治療したことで、究極の治療賞を授与します。",
    },
    penalty = {
      [1] = "効果的な治療が提供できていません。 もっと治療の質を上げることに専念してください。",
      [2] = "あなたの病院は、他のどの病院よりも患者の治療率が低いです。 保健省を失望させています。 もう言うことはありません。",
    },
  },
  research = {
    regional_bad = {
      [1] = "地域内の他のすべての病院の方があなたの病院よりも研究が優れています。 研究は病院の進歩に非常に重要ですので、保健省はカンカンです。",
    },
    regional_good = {
      [1] = "薬と設備の研究に関して、昨年あなたの病院は地域で１番の成績を修めました！ 研究スタッフの頑張りの成果です。",
    },
    awards = {
      [1] = "あなたの病院の研究科は常に最新の技術を取り入れてきました。 研究スタッフはこの賞に値します。 素晴らしいです。",
      [2] = "昨年、期待以上の薬品や機器を研究しました。 この賞を保健省から受け取ってください。",
    },
    penalty = {
      [1] = "新治療法、設備、新薬の開発が遅れています。 技術の進歩は病院の進歩。 深刻な問題です。",
    },
  },
  consistant_rep = {
    trophies = {
      [1] = "今年最も完璧な基準と最高の評判を得たことで、内閣大臣賞を授与されます。 素晴らしいです！",
      [2] = "昨年、最高の評判を持つ病院としてSqueakiKlean賞を受賞したことをお祝いします。 当然の結果ですが。",
    },
  },
  sold_drinks = {
    trophies = {
      [1] = "病院内での甘い飲み物の消費を促進したあなたへ、世界歯科医協会からこのトロフィーと表彰状を授与されます。",
      [2] = "病院で今年売られた清涼飲料の数を記念して、ソフトドリンク小売業のコラコーラトロフィーが授与されました。",
      [3] = "飲料充填株式会社を代表して、今年病院で販売されたソフトドリンクの驚異的な数を称え、このチョコレートコーティングトロフィーを授与します。",
    },
  },
  rats_killed = {
    trophies = {
      [1] = "昨年病院で%d匹のネズミを撃退したことで、害虫撲滅トロフィーが授与されます。",
      [2] = "トロフィーの受賞です！ これは病院で%d匹のネズミを非情にも退治した功績によるものです。",
      [3] = "昨年病院で%d匹のネズミを退治した優れたスキルにより、ラットブラスタートロフィーを受賞しました。",
    },
  },
  happy_staff = {
    trophies = {
      [1] = "一生懸命働くスタッフをできるだけ幸せに保ったことで、スマイル賞を授与します。",
      [2] = "幸福のアダミ協会は、あなたの病院に不幸なスタッフが昨年１人も居なかったことを称え、このトロフィーを授与します。",
      [3] = "このトロフィー「大輝杯」は、昨年の1年間、すべてのスタッフを幸福に保ったあなたに与えられます。 笑顔があふれています！",
    },
    regional_good = {
      [1] = "あなたのスタッフは他のどの病院よりも幸せです。 幸せなスタッフは、より多くの利益とより少ない死亡者を意味します。 保健省もニッコリです。",
    },
    penalty = {
      [1] = "スタッフは皆不満を抱えています。 良いスタッフこそ病院の資産だと肝に命じて下さい。 スタッフをもっと幸せにしないと、いつか全員失うことになります。",
    },
    awards = {
      [1] = "スタッフがこの賞を贈ります。 改善の余地はありますが、全体的には良好な扱いを受けたと言っています。",
      [2] = "あなたのスタッフはあなたの下で働くことに非常に満足しており、笑顔が絶えません。 あなたは素晴らしい経営者です！",
    },
    regional_bad = {
      [1] = "あなたは気が付いていなかったかもしれませんが、昨年、あなたのスタッフは皆、不満を抱えながら働いてきました。 他のすべての病院はあなたの病院よりもスタッフを幸せにしています。",
    },
  },
  all_cured = {
    awards = {
      [1] = "昨年、病院のすべての患者を治療したことで、マリー・キュリー賞を受賞しました。 おめでとうございます。",
    },
    trophies = {
      [1] = "国際治療財団は、昨年あなたの病院を訪れるすべての患者を治療したことを称え、キュアーオールトロフィーを授与します。",
      [2] = "昨年、病院のすべての患者を治療したことで、「病気に負けないうがい薬」トロフィーが授与されました。",
    },
  },
  emergencies = {
    regional_bad = {
      [1] = "あなたの病院は緊急事態対応で地域で最悪です。 地域の緊急治療リーグの最下位に沈んでいるのは、あなたの責任です。",
    },
    regional_good = {
      [1] = "昨年、あなたの病院が他のどの病院よりも緊急事態に対処したことを認め、保健省からこの賞を授与します。",
    },
    award = {
      [1] = "おめでとうございます。 緊急事態への効率的かつ効果的な対応が、この特別賞をもたらしました。 よくやりました。",
      [2] = "あなたの緊急事態対応は卓越しています。 この最優秀緊急対応賞は、多くの病気や苦しみに対処する最高の能力を示したことを称えています。",
    },
    penalty = {
      [1] = "あなたの緊急時の対応はお粗末でした。 急患は正確で適切な処置を必要としてますが、あなたはそれを提供できませんでした。",
    },
  },
  happy_patients = {
    awards = {
      [1] = "昨年、あなたの病院に訪れた人たちはとても満足していました！ 誇らしいですね。",
      [2] = "ゲーム内の他のどの病院よりも、患者達はあなたの病院の治療にとても満足していました！",
    },
    penalty = {
      [1] = "治療を受けた人は、この病院のひどさに皆、顔をしかめています。 保健省の尊敬を得たいのであれば、もっと良い結果を出す必要があります。",
      [2] = "あなたの病院の患者たちは皆、この病院を最低だと言います。 患者の幸せをもっと考慮するべきです。",
    },
  },
  high_rep = {
    awards = {
      [1] = "上出来です。 昨年、かなり印象的な評判を築いた功績により小さな賞を受賞しました。",
      [2] = "素晴らしい！ 昨年度最高の評判を得たことにより賞を受賞しました！",
    },
    regional = {
      [1] = "いずれの病院よりも最高の評判を受けた功績で、ブルフロッグ賞をお受け取りください。 最高栄誉賞の受賞おめでとう！",
      [2] = "あなたの病院は今年度、他病院全てを合わせてもかなわないほどの評判を得ました！ 大きな成果です！",
    },
    penalty = {
      [1] = "昨年を通して非常に悪い評判を維持していたことで、懲戒処分を受けます。 改善を期待します。",
      [2] = "あなたの病院の評判は地域で最悪です。 恥ずかしいったらありゃしません。 もっと努力するか、転職先を探してください。",
    },
  },
  hosp_value = {
    awards = {
      [1] = "保健省は、あなたの病院の高い病院価値を表彰しています！ おめでとうございます！",
    },
    regional = {
      [1] = "あなたは財テク王です！！ あなたの病院は、地域内の他のすべての病院を合わせたよりも価値があります。",
    },
    penalty = {
      [1] = "あなたの病院の価値はお世辞にも高いとは言えません。 財政面での失敗が原因です。 良い病院は高価な病院であることを忘れないでください。",
    },
  },
  wait_times = {
    award = {
      [1] = "おめでとうございます。 あなたの病院は一貫して待ち時間が非常に短いと評価されています。 これは重要な賞です！",
    },
    penalty = {
      [1] = "待ち時間があなたの病院では長すぎます。常に許容できない行列があります。もっと患者の整理をうまくやってください。",
    },
  },
  cleanliness = {
    regional_good = {
      [1] = "あなたの病院は地域で最も清潔だと評価されています。 作業員たちは昇進に値します。 あなたも尊敬されて然るべきです。",
    },
    award = {
      [1] = "検査官はあなたの病院が非常に清潔であると評価しています。 清潔な病院は安全な病院です。 引き続き作業員たちにこの良い仕事を続けさせてください。",
    },
    regional_bad = {
      [1] = "あなたの病院は地域で１番の不潔さを誇っています。 周辺のすべての病院は廊下をもっと清潔に保っています。 あなたは医療界にとって恥です。 なんとかしてください。",
    },
  },
  healthy_plants = {
    awards = {
      [1] = "昨年、あなたは観葉植物を見事に育てたことを評しまして、緑育肥料賞を授与いたします。",
    },
    trophies = {
      [1] = "過去12ヶ月間にわたりすべての植物を良好な状態に保った功績で、観葉植物の友の会より、グリーントロフィー・オブ・ヘルスを授与いたします。",
      [2] = "昨年、病院の植物を最良の健康状態に保った功績で、グリーンフィンガートロフィーをお受け取りください。",
    },
  },
  happy_vips = {
    trophies = {
      [1] = "昨年病院を訪れたVIP達に好印象を与えたことにより、ノーベル賞を送ります。 皆あなたの病院に非常に好意的なコメントを寄せました。",
      [2] = "有名人エージェンシーから、あなたの病院を訪れたすべてのVIPを満足させたことで、セレブリティトロフィーを授与されることをお祝いします。 少し有名になり、ほぼ私たちの仲間入りです。",
      [3] = "あなたの病院を訪れたすべての著名人の生活を向上させたことで、VIP訪問賞を受賞しました。 素晴らしい！",
    },
  },
}

bank_manager = {
  current_loan = "現在のローン",
  interest_rate = "利率",
  interest_payment = "利息",
  hospital_value = "病院の価値",
  statistics_page = {
    date = "日付",
    money_in = "収入",
    money_out = "支出",
    balance = "残高",
    current_balance = "現在の残高",
    details = "詳細",
  },
  balance = "残高",
  insurance_owed = "未払の保険",
  inflation_rate = "インフレ率",
}
