#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Return of the Incredible Machine: Contraptions
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240930.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-incredible-machine-contraptions'
GAME_NAME='Return of the Incredible Machine: Contraptions'

ARCHIVE_BASE_0_NAME='setup_return_of_tim_contraptions_2.1.0.21.exe'
ARCHIVE_BASE_0_MD5='827015fe4244d09f5f5aee17db6f65cc'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='260000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.1.0.21'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_incredible_machine_mega_pack'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
*.cnt
*.dll
*.exe
*.gid
*.hlp
*.ini
*.inf
saved games'
CONTENT_GAME_DATA_FILES='
*.tbv
*.mid'
CONTENT_DOC_DATA_FILES='
*.txt'

USER_PERSISTENT_DIRECTORIES='
homemade
saved games'

## Mouse inputs do not register unless the game is run in a virtual desktop.
WINE_VIRTUAL_DESKTOP='auto'

APP_MAIN_EXE='contraptions.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
