/*
 * Decompiled with CFR 0.152.
 */
package $installer$.org.aspectj;

import $installer$.org.aspectj.FinishPane;
import $installer$.org.aspectj.InstallPane;
import $installer$.org.aspectj.Installer;
import $installer$.org.aspectj.IntroPane;
import $installer$.org.aspectj.LocationPane;
import $installer$.org.aspectj.Main;
import $installer$.org.aspectj.WizardPane;
import java.io.File;
import javax.swing.JOptionPane;

class AJDEForJBuilderInstaller
extends Installer {
    @Override
    public String getTitle() {
        return "AspectJ(TM) Support for JBuilder";
    }

    @Override
    public String getPrefix() {
        return "ajdeForJBuilder";
    }

    public AJDEForJBuilderInstaller() {
        InstallPane installPane = new InstallPane(false);
        this.setInstallPane(installPane);
        this.panes = new WizardPane[]{new IntroPane(), new LocationPane(){

            @Override
            public String getDefaultLocation() {
                if (context.onWindows()) {
                    String[] paths = new String[]{"c:\\JBuilder6\\lib\\ext", "c:\\apps\\JBuilder6\\lib\\ext", "c:\\Program Files\\JBuilder6\\lib\\ext"};
                    for (int pathIndex = 0; pathIndex < paths.length; ++pathIndex) {
                        if (!new File(paths[pathIndex]).exists()) continue;
                        return paths[pathIndex];
                    }
                    return "c:\\JBuilder6\\lib\\ext";
                }
                return "/usr/JBuilder6/lib/ext";
            }

            @Override
            public void verify() {
                File oldFile;
                int ret;
                File jbuilder = new File(this.location.getText() + "/../../lib/jbuilder.jar");
                if (!jbuilder.exists() && this.hasGui() && (ret = JOptionPane.showConfirmDialog(AJDEForJBuilderInstaller.this.frame, "The location you specified does not seem to be a valid JBuilder install directory. Continue?", "Confirm Install", 0, 3)) != 0) {
                    Main.exit(-1);
                }
                if ((oldFile = new File(this.location.getText() + "/ajbuilder.jar")).exists() && this.hasGui()) {
                    int ret2 = JOptionPane.showConfirmDialog(AJDEForJBuilderInstaller.this.frame, "This old version of AJDE for JBuilder (\"ajbuilder.jar\") exists and must be removed from the install directory. OK to delete?", "Confirm Delete", 0, 3);
                    if (ret2 != 0) {
                        Main.exit(-1);
                    } else {
                        oldFile.delete();
                    }
                }
            }
        }, installPane, new FinishPane()};
    }
}

