/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
// generated by Fast Light User Interface Designer (fluid) version 1.0104


#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Color_Chooser.H>


#include <interfacce.hpp>
#include <procedura.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>

#include <atomo.hpp>
#include <gruppo.hpp>
#include <util.hpp>

#include <bond_prop.hpp>


void legame_prop_scale_cb(Fl_Widget* w, void* d){
  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  legame_prop* p=dynamic_cast<legame_prop*>(w->parent());
  p->_scale=sl->value();
}


void legame_prop_ok_cb(Fl_Widget* w, void* d){
  legame_prop* p=dynamic_cast<legame_prop*>((w->parent()));

  Fl_Group* o=dynamic_cast<Fl_Group*>(p->child(1));

  for(int i=0;i<o->children();i++){
    Fl_Round_Button* bt=dynamic_cast<Fl_Round_Button*>(o->child(i));
    if(bt->value()){
      int ritval=-1;
      switch(i){
      case 0:
	ritval=LEGAME_SINGOLO;
	break;
      case 1:
	ritval=LEGAME_DOPPIO;
	break;
      case 2:            
	ritval=LEGAME_TRIPLO;
	break;
      case 3:            
	ritval=LEGAME_DOPPIO_TRATTEGGIATO;
	break;
      case 4:
	ritval= LEGAME_ESTERNO;
	break;
      case 5:       
	ritval=LEGAME_ESTERNO_OPP ;
	break;
      case 6:   
       	ritval=LEGAME_INTERNO ;
	break;
      case 7: 
      	ritval=LEGAME_INTERNO_OPP ;
	break;
      case 8:
	ritval=LEGAME_TRATTEGGIATO ;
	break;
      case 9: 
	ritval=LEGAME_ISPESSITO ;
	break;
      case 10:    
	ritval=LEGAME_STEREO_SCON ;
	break;

      }

      p->_radioval=ritval;
    }
  }

  p->hide();
}

void legame_prop_color_cb(Fl_Widget* w, void* d){
  legame_prop* p=dynamic_cast<legame_prop*>(w->parent());
  unsigned char r,g,b;
  int pushd=fl_color_chooser(_("pick a color..."), r, g, b);

  if(pushd){
    p->_r=r;
    p->_g=g;
    p->_b=b;
  }

}


void legame_prop_cancel_cb(Fl_Widget* w, void* d){
  legame_prop* p=dynamic_cast<legame_prop*>(w->parent());
  p->_radioval=-1;
  p->_r=-1;
  p->_g=-1;
  p->_b=-1;
  p->_scale=1;
  p->hide();
}


legame_prop::legame_prop(int x,int y,int w, int h, char* tit,int quale)
  :Fl_Window(x,y,w,h,tit),
   _r(-1),
   _g(-1),
   _b(-1),
   _scale(1)
 {
   static const int gap_box_windows=5;
   static const int gap_widget=5;
   static const int button_width=80;
   static const int button_height=25;
   static const int round_button_w=w-5*gap_box_windows;

    { Fl_Box* o = new Fl_Box(gap_box_windows, 4*gap_box_windows, 
			     w-2*gap_box_windows,245, 
			     _("Bond type"));
      o->box(FL_ENGRAVED_BOX);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    { Fl_Group* o = new Fl_Group(5, 25, 255, 245);
      { Fl_Round_Button* o = new Fl_Round_Button(15, 35, round_button_w, button_height, _("Single bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = new Fl_Round_Button(15, 55, round_button_w, button_height, _("Double bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = new Fl_Round_Button(15, 75, round_button_w, button_height, _("Triple bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = new Fl_Round_Button(15, 95, round_button_w, button_height, _("Double dashed bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = new Fl_Round_Button(15, 115, round_button_w, button_height, _("Stereospecific \"up\" bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = new Fl_Round_Button(15, 134, round_button_w, button_height, _("Stereospecific \"up\" reverse bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = new Fl_Round_Button(15, 155, round_button_w, button_height, _("Stereospecific \"down\" bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = new Fl_Round_Button(15, 176, 245, button_height, _("Stereospecific \"down\" reverse bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = new Fl_Round_Button(15, 195, round_button_w, button_height, _("Dashed bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = new Fl_Round_Button(15, 215, round_button_w, button_height, _("Bold bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = new Fl_Round_Button(15, 235, round_button_w, button_height, _("Unknown stereochemistry bond"));
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      o->end();
      if(quale<o->children()){
        Fl_Round_Button* bt=dynamic_cast<Fl_Round_Button*>(o->child(trasl_rev_tipo_leg(quale)));
        if(bt!=NULL){
          bt->set();
        }
      }

    }

    Fl_Box* scale_box = new Fl_Box(gap_box_windows, 285, 
				   w-button_width - gap_box_windows - gap_widget, 
				   button_height+static_cast<int>(1/4.* button_height), 
				   _("Scale"));
    scale_box->box(FL_ENGRAVED_BOX);
    scale_box->align(FL_ALIGN_TOP_LEFT);
    
    
    Fl_Value_Slider* scale_gap = new Fl_Value_Slider(scale_box->x()+gap_widget, 
						     scale_box->y()+gap_widget, 
						     scale_box->w()-2*gap_widget, 
						     scale_box->h()-2*gap_widget, 
						     _("Arrow gap:"));
    scale_gap->label("");
    scale_gap->type(FL_HORIZONTAL);
    scale_gap->step(0.01);
    scale_gap->align(FL_ALIGN_LEFT);
    scale_gap->range(0.001, 4);
    scale_gap->precision(2);
    scale_gap->value(1);
    scale_gap->callback(legame_prop_scale_cb);
    Fl_Button* color_button = new Fl_Button(w - button_width - gap_box_windows, 
					    scale_box->y(), 
					    button_width, scale_box->h(), _("Color"));
    color_button->callback(legame_prop_color_cb);
    


    { 
      Fl_Button* o = new Fl_Button(w/2-button_width, 327, button_width, 
				   button_height, _("Cancel"));
      o->callback(legame_prop_cancel_cb);
    }

    { Fl_Return_Button* o = new Fl_Return_Button(w/2, 
						 327, button_width, button_height, _("OK"));
      o->callback(legame_prop_ok_cb);
    }

    end();
    set_modal();
    dialog_position(this);    
 
}

int trasl_rev_tipo_leg(int quale){

     int ritval=-1;
      switch(quale){
      case LEGAME_SINGOLO:
	ritval=0;
	break;
      case LEGAME_DOPPIO:
      case LEGAME_DOPPIO_1:
      case LEGAME_DOPPIO_2:
	ritval=1;
	break;
      case LEGAME_TRIPLO:            
	ritval=2;
	break;
      case LEGAME_DOPPIO_TRATTEGGIATO:
      case LEGAME_DOPPIO_TRATTEGGIATO_1: 
      case LEGAME_DOPPIO_TRATTEGGIATO_2:
	ritval=3;
	break;
      case LEGAME_ESTERNO:
	ritval=4;
	break;
      case LEGAME_ESTERNO_OPP:       
	ritval=5;
	break;
      case LEGAME_INTERNO:   
       	ritval=6;
	break;
      case LEGAME_INTERNO_OPP: 
      	ritval=7;
	break;
      case LEGAME_TRATTEGGIATO:
	ritval=8;
	break;
      case LEGAME_ISPESSITO: 
	ritval=9;
	break;
      case LEGAME_STEREO_SCON:    
	ritval= 10;
	break;
      default:
	ritval=0;
      }

      return ritval;
}


vector<float> bond_win(int quale){
  legame_prop p(397, 330, 550, 360,_("Bond properties"),quale);
  p.show();
  while(p.shown()){
    Fl::wait();    
  }
  vector<float> risul;
  risul.push_back(p._r);
  risul.push_back(p._g);
  risul.push_back(p._b);
  risul.push_back(p._radioval);
  risul.push_back(p._scale);
  return risul;
}
