/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Copyright 2011, Blender Foundation.
 */

#ifndef __COM_CHANGEHSVOPERATION_H__
#define __COM_CHANGEHSVOPERATION_H__
#include "COM_MixOperation.h"

/**
 * this program converts an input color to an output value.
 * it assumes we are in sRGB color space.
 */
class ChangeHSVOperation : public NodeOperation {
 private:
  SocketReader *m_inputOperation;
  SocketReader *m_hueOperation;
  SocketReader *m_saturationOperation;
  SocketReader *m_valueOperation;

 public:
  /**
   * Default constructor
   */
  ChangeHSVOperation();

  void initExecution();
  void deinitExecution();

  /**
   * the inner loop of this program
   */
  void executePixelSampled(float output[4], float x, float y, PixelSampler sampler);
};
#endif
