/*
 * Copyright (C) 2025 The Phosh.mobi e.V.
 *
 * SPDX-License-Identifier: GPL-3.0+
 */

#pragma once

#include "cbd-channel-manager.h"

#include <glib.h>

G_BEGIN_DECLS

#define cbd_assert_cmp_channel_range(e, t) G_STMT_START {               \
    g_test_message ("Checking %d, %d-%d", t.level, t.start, t.end);     \
    if (e.level != t.level) {                                           \
      g_autofree char *__msg =                                          \
        g_strdup_printf ("Level %d != %d of element %d ", e.level, t.level, i); \
      g_assertion_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, __msg); \
    }                                                                   \
    if (e.start != t.start) {                                          \
      g_autofree char *__msg =                                          \
        g_strdup_printf ("Start channel %d != %d of element %d ", e.start, t.start, i); \
      g_assertion_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, __msg); \
    }                                                                   \
    if (e.end != t.end) {                                               \
      g_autofree char *__msg =                                          \
        g_strdup_printf ("End channel %d != %d of element %d ", e.end, t.end, i); \
      g_assertion_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, __msg); \
    }                                                                   \
  } G_STMT_END

#define cbd_assert_cmp_channels(c, e) G_STMT_START {                   \
    if (c->len != e->len) {                                             \
      g_autofree char *__msg =                                            \
        g_strdup_printf ("Arrays don't have same size: %d != %d", c->len, e->len); \
      g_assertion_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, __msg); \
    }                                                                   \
    for (int i = 0; i < e->len; i++) {                                  \
      CbdChannelsRange __range = g_array_index (c, CbdChannelsRange, i); \
      CbdChannelsRange __expected = g_array_index (e, CbdChannelsRange, i); \
      cbd_assert_cmp_channel_range (__range, __expected);               \
    }                                                                   \
  } G_STMT_END


GArray *cbd_test_channels_get_expected (const char *country);

G_END_DECLS
