# Manage Zanata definition 

IF(DEFINED _MANAGE_ZANATA_DEFINITION_)
    RETURN()
ENDIF(DEFINED _MANAGE_ZANATA_DEFINITION_)
SET(_MANAGE_ZANATA_DEFINITION_ "DEFINED")
SET(ZANATA_MAVEN_SUBCOMMAND_PREFIX "org.zanata:zanata-maven-plugin" )

## ZANATA_OPTIONS_NAME_<OPTION> <HAS_VALUE> [<defaultvalue>]
## OPTION_ID: Start with - : mvn/zanata-cli options
##            Start with  : cmake-fedora options
##            Others       : zanata-cli formatted long options
## HAS_VALUE: 0 (no value)
##            1 (optional value)
##            2 (mandatory value)

SET(ZANATA_OPTION_NAME_YES 0)
SET(ZANATA_OPTION_NAME_BATCH 0)
SET(ZANATA_OPTION_NAME_ERRORS 0)
SET(ZANATA_OPTION_NAME_DEBUG 0)
SET(ZANATA_OPTION_NAME_CLEAN_ZANATA_XML  0)
SET(ZANATA_OPTION_NAME_CLIENT_COMMAND  2)
SET(ZANATA_OPTION_NAME_ZANATA_EXECUTABLE 2)
SET(ZANATA_OPTION_NAME_ZANATA_EXECUTABLE_VAR_TYPE "FILEPATH")
SET(ZANATA_OPTION_NAME_COPY_TRANS 1)
SET(ZANATA_OPTION_NAME_CREATE_SKELETONS 1)
SET(ZANATA_OPTION_NAME_DISABLE_SSL_CERT 1)
SET(ZANATA_OPTION_NAME_ENCODE_TABS 1)
SET(ZANATA_OPTION_NAME_EXCLUDES 2)
SET(ZANATA_OPTION_NAME_GENERATE_ZANATA_XML 0)
SET(ZANATA_OPTION_NAME_INCLUDES 2)
SET(ZANATA_OPTION_NAME_LOCALES 2)
SET(ZANATA_OPTION_NAME_PROJECT 2)
SET(ZANATA_OPTION_NAME_PROJECT_VAR_TYPE "STRING")
SET(ZANATA_OPTION_NAME_PROJECT_CONFIG 2)
SET(ZANATA_OPTION_NAME_PROJECT_CONFIG_VAR_TYPE "FILEPATH")
SET(ZANATA_OPTION_NAME_PROJECT_DESC 2)
SET(ZANATA_OPTION_NAME_PROJECT_NAME 2)
SET(ZANATA_OPTION_NAME_PROJECT_TYPE 2)
SET(ZANATA_OPTION_NAME_PROJECT_TYPE_DEFAULT "gettext")
SET(ZANATA_OPTION_NAME_PROJECT_TYPE_VAR_TYPE "STRING")
SET(ZANATA_OPTION_NAME_SRC_DIR  2)
SET(ZANATA_OPTION_NAME_SRC_DIR_DEFAULT ".")
SET(ZANATA_OPTION_NAME_SRC_DIR_VAR_TYPE "FILEPATH")
SET(ZANATA_OPTION_NAME_TRANS_DIR 2)
SET(ZANATA_OPTION_NAME_TRANS_DIR_DEFAULT ".")
SET(ZANATA_OPTION_NAME_TRANS_DIR_VAR_TYPE "FILEPATH")
SET(ZANATA_OPTION_NAME_TRANS_DIR_PULL 2)
SET(ZANATA_OPTION_NAME_TRANS_DIR_PULL_VAR_TYPE "FILE_PATH")
SET(ZANATA_OPTION_NAME_TRANS_DIR_PULL 2)
SET(ZANATA_OPTION_NAME_URL 2)
SET(ZANATA_OPTION_NAME_URL_DEFAULT "https://translate.zanata.org/zanata/")
SET(ZANATA_OPTION_NAME_URL_VAR_TYPE "STRING")
SET(ZANATA_OPTION_NAME_USERNAME 2)
SET(ZANATA_OPTION_NAME_USER_CONFIG 2)
SET(ZANATA_OPTION_NAME_USER_CONFIG_VAR_TYPE "FILE_PATH")
SET(ZANATA_OPTION_NAME_VERSION 2)
SET(ZANATA_OPTION_NAME_VERSION_DEFAULT "master")
SET(ZANATA_OPTION_NAME_VERSION_VAR_TYPE "STRING")

SET(ZANATA_OPTION_INIT_LIST PROJECT PROJECT_CONFIG SRC_DIR TRANS_DIR TRANS_DIR_PULL URL USER_CONFIG VERSION)

SET(ZANATA_OPTION_ALIAS_YES "BATCH")
SET(ZANATA_OPTION_ALIAS_CLIENT_COMMAND "ZANATA_EXECUTABLE")

###== Start Option name substitute given sub-command
### Format: ZANATA_<BACKEND>_<SUBCOMMAND>_OPTION_NAME_<OPTION> <ACTUAL_NAME_IN_SUBCOMMAND>
###==== Start backend MVN and ZANATA_CLI
SET(ZANATA_MVN_PUT_PROJECT_OPTION_NAME_PROJECT "PROJECT_SLUG")
SET(ZANATA_MVN_PUT_PROJECT_OPTION_NAME_PROJECT_TYPE "DEFAULT_PROJECT_TYPE")
SET(ZANATA_MVN_PUT_VERSION_OPTION_NAME_PROJECT "VERSION_PROJECT")
SET(ZANATA_MVN_PUT_VERSION_OPTION_NAME_VERSION "VERSION_SLUG")
SET(ZANATA_MVN_PUSH_OPTION_NAME_VERSION "PROJECT_VERSION")
SET(ZANATA_MVN_PULL_OPTION_NAME_VERSION "PROJECT_VERSION")
SET(ZANATA_MVN_PULL_OPTION_NAME_TRANS_DIR_PULL "TRANS_DIR")

###==== Start backend ZANATA
SET(ZANATA_ZANATA_PULL_OPTION_NAME_TRANS_DIR_PULL "TRANS_DIR")
###== End Option name substitute given sub-command

SET(ZANATA_MVN_PUT_PROJECT_MANDATORY_OPTIONS "PROJECT" "PROJECT_NAME" "PROJECT_DESC" "PROJECT_TYPE")
SET(ZANATA_MVN_PUT_VERSION_MANDATORY_OPTIONS "PROJECT" "VERSION")
SET(ZANATA_MVN_PUSH_MANDATORY_OPTIONS "PROJECT_CONFIG")
SET(ZANATA_MVN_PULL_MANDATORY_OPTIONS "PROJECT_CONFIG")

SET(ZANATA_JAVA_PUT_PROJECT_MANDATORY_OPTIONS "PROJECT" "PROJECT_NAME" "PROJECT_DESC" "PROJECT_TYPE")
SET(ZANATA_JAVA_PUT_VERSION_MANDATORY_OPTIONS "PROJECT" "VERSION")
SET(ZANATA_JAVA_PUSH_MANDATORY_OPTIONS "PROJECT_CONFIG")
SET(ZANATA_JAVA_PULL_MANDATORY_OPTIONS "PROJECT_CONFIG")

SET(ZANATA_PYTHON_PUT_PROJECT_MANDATORY_OPTIONS "PROJECT" "PROJECT_NAME" "PROJECT_DESC" "PROJECT_TYPE")
SET(ZANATA_PYTHON_PUT_VERSION_MANDATORY_OPTIONS "PROJECT" "VERSION")
SET(ZANATA_PYTHON_PUSH_MANDATORY_OPTIONS "PROJECT_CONFIG")
SET(ZANATA_PYTHON_PULL_MANDATORY_OPTIONS "PROJECT_CONFIG")

SET(ZANATA_CLIENT_COMMON_VALID_OPTIONS "DISABLE_SSL_CERT" "URL" "USERNAME" "KEY" "USER_CONFIG" "PROJECT" "PROJECT_TYPE")
SET(ZANATA_CLIENT_PROJECT_VALID_OPTIONS "PROJECT_NAME" "PROJECT_DESC")
SET(ZANATA_CLIENT_VERSION_COMMON_VALID_OPTIONS "VERSION" )
SET(ZANATA_CLIENT_PUSH_PULL_VALID_OPTIONS "LOCALES" "PROJECT_CONFIG" "SRC_DIR" "TRANS_DIR" )
SET(ZANATA_CLIENT_PUSH_VALID_OPTIONS "COPY_TRANS" "EXCLUDES" "INCLUDES" )
SET(ZANATA_CLIENT_PULL_VALID_OPTIONS "CREATE_SKELETONS" "ENCODE_TABS" "TRANS_DIR_PULL")
SET(MANAGE_ZANATA_VALID_OPTIONS "GENERATE_ZANATA_XML" "CLEAN_ZANATA_XML"
    "CLIENT_COMMAND"
    ${ZANATA_CLIENT_GLOBAL_VALID_OPTIONS}
    ${ZANATA_CLIENT_COMMON_VALID_OPTIONS}
    ${ZANATA_CLIENT_PROJECT_VALID_OPTIONS}
    ${ZANATA_CLIENT_VERSION_COMMON_VALID_OPTIONS}
    ${ZANATA_CLIENT_PUSH_PULL_VALID_OPTIONS}
    ${ZANATA_CLIENT_PUSH_VALID_OPTIONS}
    ${ZANATA_CLIENT_PULL_VALID_OPTIONS}
    )

## Valid subcommand for each client
SET(ZANATA_SUBCOMMAND_PUT_PROJECT_VALID_OPTIONS
    ${ZANATA_CLIENT_COMMON_VALID_OPTIONS} ${ZANATA_CLIENT_PROJECT_VALID_OPTIONS}
    )
SET(ZANATA_SUBCOMMAND_PUT_VERSION_VALID_OPTIONS
    ${ZANATA_CLIENT_COMMON_VALID_OPTIONS} ${ZANATA_MVN_PUT_VERSION_MANDATORY_OPTIONS}
    )
SET(ZANATA_SUBCOMMAND_PUSH_VALID_OPTIONS
    ${ZANATA_CLIENT_COMMON_VALID_OPTIONS} ${ZANATA_CLIENT_PUSH_PULL_VALID_OPTIONS}
    ${ZANATA_CLIENT_PUSH_VALID_OPTIONS}
    )
SET(ZANATA_SUBCOMMAND_PULL_VALID_OPTIONS
    ${ZANATA_CLIENT_COMMON_VALID_OPTIONS} ${ZANATA_CLIENT_PUSH_PULL_VALID_OPTIONS}
    ${ZANATA_CLIENT_PULL_VALID_OPTIONS}
    )

