const std::map<std::string, std::pair<const char*, const char*>>
AbstractSystem::ExamplesMap{
    { "ciliasun.cfdg", {
u8"startshape SUN\n"
u8"\n"
u8"shape SUN\n"
u8"{\n"
u8"	loop 72 [r 5]\n"
u8"		LINER(-3\u20263) [y 5 sat 1 b 0.3]\n"
u8"}\n"
u8"\n"
u8"shape LINER(number angle)\n"
u8"rule {\n"
u8"	UTRIANGLE [y 0.5 s 0.86 r 0.5]\n"
u8"	LINER(=) [r angle b 0.1 hue 0.1 60\n"
u8"		y 0.75 x 0.4330125 s 0.97]\n"
u8"}\n"
u8"rule .1 {\n"
u8"	LINER(-3\u20263) []\n"
u8"}\n"
u8"\n"
u8"path UTRIANGLE {\n"
u8"	MOVETO(0, -0.5)\n"
u8"	loop 3 [r 120] {\n"
u8"		CURVEREL(\n"
u8"			0.25, sqrt(3)/4,\n"
u8"			-0.05, 0.025,\n"
u8"			0, sqrt(3)/8\n"
u8"		)\n"
u8"		CURVEREL(\n"
u8"			0.25, sqrt(3)/4,\n"
u8"			0.25 + 0.025, sqrt(3)/4 - 0.025,\n"
u8"			CF::Continuous\n"
u8"		)\n"
u8"	}\n"
u8"	CLOSEPOLY(CF::Align)\n"
u8"	FILL[]\n"
u8"}\n"
 ,
u8"startshape SUN\n"
u8"\n"
u8"rule SUN {\n"
u8"	72* {r 5} LINER { y 5   hue 0 sat 1  b 0.3\n"
u8" 				|hue 60   |sat 1 |b 1 }\n"
u8"}\n"
u8"\n"
u8"rule LINER { LINER1 { } }\n"
u8"rule LINER { LINER2 { } }\n"
u8"rule LINER { LINER3 { } }\n"
u8"rule LINER { LINER4 { } }\n"
u8"rule LINER { LINER5 { } }\n"
u8"rule LINER { LINER6 { } }\n"
u8"\n"
u8"rule LINER1 {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINER1 { r -1 b 0.1| hue 0.1|\n"
u8"		y 0.75 x 0.4330125\n"
u8"		 s 0.97 }\n"
u8" }\n"
u8"rule LINER2 {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINER2 { r -2 b 0.1| hue 0.1|\n"
u8"		y 0.75 x 0.4330125\n"
u8"		 s 0.97 }\n"
u8" }\n"
u8"rule LINER3 {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINER3 { r -3 b 0.1| hue 0.1|\n"
u8"		y 0.75 x 0.4330125\n"
u8"		 s 0.97 }\n"
u8" }\n"
u8"rule LINER4 {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINER4 { r 1 b 0.1| hue 0.1|\n"
u8"		y 0.75 x 0.4330125\n"
u8"		 s 0.97 }\n"
u8" }\n"
u8"rule LINER5 {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINER5 { r 2 b 0.1| hue 0.1|\n"
u8"		y 0.75 x 0.4330125\n"
u8"		 s 0.97 }\n"
u8" }\n"
u8"rule LINER6 {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINER6 { r 3 b 0.1| hue 0.1|\n"
u8"		y 0.75 x 0.4330125\n"
u8"		 s 0.97 }\n"
u8" }\n"
u8"\n"
u8"rule LINER1 .1 { LINER { } }\n"
u8"rule LINER2 .1 { LINER { } }\n"
u8"rule LINER3 .1 { LINER { } }\n"
u8"rule LINER4 .1 { LINER { } }\n"
u8"rule LINER5 .1 { LINER { } }\n"
u8"rule LINER6 .1 { LINER { } }\n"
u8"\n"
u8"// 0.754877 is the solution to\n"
u8"// x^2 + x^3 = 1\n"
u8"// this allows double backed\n"
u8"// triangles to exactly line up!\n"
u8"\n"
u8"\n"
u8"rule UTRIANGLE {\n"
u8"	TRIANGLE { r 42.5 s 0.525 }\n"
u8"}\n"
u8"rule TRIANGLE{\n"
u8"	ARM { r 0 }\n"
u8"	ARM { r 120 }\n"
u8"	ARM { r -120 }\n"
u8"}\n"
u8"\n"
u8"rule ARM {\n"
u8"	CIRCLE { }\n"
u8"	ARM { y 0.1 s 0.9 r 2 }\n"
u8"}\n"
    } },
    { "demo1.cfdg", {
u8"startshape FOREST\n"
u8"\n"
u8"shape FOREST\n"
u8"{\n"
u8"     SEED []\n"
u8"     SEED [x -20]\n"
u8"     SEED [x -40]\n"
u8"}\n"
u8"\n"
u8"shape SEED\n"
u8"rule {BRANCH []}\n"
u8"rule {BRANCH [rotate 1]}\n"
u8"rule {BRANCH [rotate -1]}\n"
u8"rule {BRANCH [rotate 2]}\n"
u8"rule {BRANCH [rotate -2]}\n"
u8"rule {FORK []}\n"
u8"\n"
u8"shape BRANCH\n"
u8"rule {LEFTBRANCH [flip 90]}\n"
u8"rule {LEFTBRANCH []}\n"
u8"\n"
u8"shape LEFTBRANCH\n"
u8"rule 4 {BLOCK [] LEFTBRANCH [y 0.885 rotate 0.1 size 0.99]}\n"
u8"rule 4 {BLOCK [] LEFTBRANCH [y 0.885 rotate 0.2 size 0.99]}\n"
u8"rule {BLOCK [] LEFTBRANCH [y 0.885 rotate 4 size 0.99]}\n"
u8"rule {BLOCK [] FORK []}\n"
u8"\n"
u8"\n"
u8"shape BLOCK\n"
u8"{\n"
u8"     SQUARE [rotate 1]\n"
u8"     SQUARE [rotate -1]\n"
u8"     SQUARE []\n"
u8"}\n"
u8"\n"
u8"shape FORK\n"
u8"rule {\n"
u8"     BRANCH [ ]\n"
u8"     BRANCH [size 0.5 rotate 40]\n"
u8"}\n"
u8"rule {\n"
u8"     BRANCH [ ]\n"
u8"     BRANCH [size 0.5 rotate -40]\n"
u8"}\n"
u8"rule {\n"
u8"     BRANCH [size 0.5 rotate -20]\n"
u8"     BRANCH [ ]\n"
u8"}\n"
u8"rule {\n"
u8"     BRANCH [size 0.7 y 0.1 rotate 20]\n"
u8"     BRANCH [size 0.7 y 0.1 rotate -20]\n"
u8"}\n"
 ,
u8"startshape FOREST\n"
u8"\n"
u8"rule FOREST {\n"
u8"     SEED {}\n"
u8"     SEED {x -20}\n"
u8"     SEED {x -40}\n"
u8"}\n"
u8"\n"
u8"rule SEED {BRANCH {}}\n"
u8"rule SEED {BRANCH {rotate 1}}\n"
u8"rule SEED {BRANCH {rotate -1}}\n"
u8"rule SEED {BRANCH {rotate 2}}\n"
u8"rule SEED {BRANCH {rotate -2}}\n"
u8"rule SEED {FORK {}}\n"
u8"\n"
u8"rule BRANCH {LEFTBRANCH {flip 90}}\n"
u8"rule BRANCH {LEFTBRANCH {}}\n"
u8"\n"
u8"rule LEFTBRANCH 4 {BLOCK {} LEFTBRANCH {y 0.885 rotate 0.1 size 0.99}}\n"
u8"rule LEFTBRANCH 4 {BLOCK {} LEFTBRANCH {y 0.885 rotate 0.2 size 0.99}}\n"
u8"rule LEFTBRANCH {BLOCK {} LEFTBRANCH {y 0.885 rotate 4 size 0.99}}\n"
u8"rule LEFTBRANCH {BLOCK {} FORK {}}\n"
u8"\n"
u8"\n"
u8"rule BLOCK {\n"
u8"     SQUARE {rotate 1}\n"
u8"     SQUARE {rotate -1}\n"
u8"     SQUARE {}\n"
u8"}\n"
u8"\n"
u8"rule FORK {\n"
u8"     BRANCH { }\n"
u8"     BRANCH {size 0.5 rotate 40}\n"
u8"}\n"
u8"rule FORK {\n"
u8"     BRANCH { }\n"
u8"     BRANCH {size 0.5 rotate -40}\n"
u8"}\n"
u8"rule FORK {\n"
u8"     BRANCH {size 0.5 rotate -20}\n"
u8"     BRANCH { }\n"
u8"}\n"
u8"rule FORK {\n"
u8"     BRANCH {size 0.7 y 0.1 rotate 20}\n"
u8"     BRANCH {size 0.7 y 0.1 rotate -20}\n"
u8"}\n"
    } },
    { "demo2.cfdg", {
u8"#\n"
u8"# An example, showing how to include another file.\n"
u8"# Note that the include path has to be absolute OR\n"
u8"# relative to the directory you run .cfdg in\n"
u8"#\n"
u8"\n"
u8"startshape thingy\n"
u8"import i_pix.cfdg\n"
u8"\n"
u8"shape thingy\n"
u8"{\n"
u8" point [y -1 rotate 180]\n"
u8" point []\n"
u8"}\n"
u8"\n"
u8"shape point\n"
u8"{\n"
u8"  C_5by5 []\n"
u8"  F_5by5 [x 1.2]\n"
u8"  D_5by5 [y -1.2]\n"
u8"  G_5by5 [y -1.2 x 1.2]\n"
u8"  point [y 2.0 x -2.5 rotate 20 size 0.6]\n"
u8"  point [y 2.0 x 2.5 rotate -20 size 0.6]\n"
u8"}\n"
 ,
u8"#\n"
u8"# An example, showing how to include another file.\n"
u8"# Note that the include path has to be absolute OR\n"
u8"# relative to the directory you run .cfdg in\n"
u8"#\n"
u8"\n"
u8"startshape thingy\n"
u8"include i_pix.cfdg\n"
u8"\n"
u8"rule thingy{\n"
u8" point {y -1 rotate 180}\n"
u8" point {}\n"
u8"}\n"
u8"\n"
u8"rule point {\n"
u8"  C_5by5 {}\n"
u8"  F_5by5 {x 1.2}\n"
u8"  D_5by5 {y -1.2}\n"
u8"  G_5by5 {y -1.2 x 1.2}\n"
u8"  point {y 2.0 x -2.5 rotate 20 size 0.6}\n"
u8"  point {y 2.0 x 2.5 rotate -20 size 0.6}\n"
u8"}\n"
    } },
    { "funky_flower.cfdg", {
u8"startshape GARDEN\n"
u8"import i_curves.cfdg\n"
u8"\n"
u8"shape GARDEN\n"
u8"rule {\n"
u8"  SEED []\n"
u8"}\n"
u8"\n"
u8"shape SEED\n"
u8"rule {\n"
u8"   curveleft_0_98_3 [x -2]\n"
u8"   curveleft_0_98_2 []\n"
u8"   curveleft_0_98_1 [x 2]\n"
u8"   LEFT_OR_RIGHT [x 4 size 4 y 1.3]\n"
u8"   curveright_0_98_1 [x 6]\n"
u8"   curveright_0_98_2 [x 8]\n"
u8"   curveright_0_98_3 [x 10]\n"
u8"}\n"
u8"\n"
u8"shape LEFT_OR_RIGHT\n"
u8"rule {  LEFT_FLOWER [] }\n"
u8"rule {  LEFT_FLOWER [flip 90] }\n"
u8"\n"
u8"shape LEFT_FLOWER\n"
u8"rule {\n"
u8"   curveleft_0_97_1 []\n"
u8"   FLOWER [x -13 y 25.3 size 1]\n"
u8"}\n"
u8"\n"
u8"shape FLOWER\n"
u8"rule {\n"
u8"   CIRCLE [size 2]\n"
u8"   loop 6 [r 60] NEW_SEED []\n"
u8"}\n"
u8"\n"
u8"shape NEW_SEED\n"
u8"rule {\n"
u8"   SEED [size 0.1 y 3]\n"
u8"}\n"
u8"\n"
 ,
u8"\n"
u8"startshape GARDEN\n"
u8"include i_curves.cfdg\n"
u8"\n"
u8"rule GARDEN {\n"
u8"  SEED {}\n"
u8"}\n"
u8"\n"
u8"rule SEED {\n"
u8"   curveleft_0_98_3 {x -2}\n"
u8"   curveleft_0_98_2 {}\n"
u8"   curveleft_0_98_1 {x 2}\n"
u8"   LEFT_OR_RIGHT {x 4 size 4 y 1.3}\n"
u8"   curveright_0_98_1 {x 2}\n"
u8"   curveright_0_98_2 {x 8}\n"
u8"   curveright_0_98_3 {x 10}\n"
u8"}\n"
u8"\n"
u8"rule LEFT_OR_RIGHT {  LEFT_FLOWER {} }\n"
u8"rule LEFT_OR_RIGHT {  LEFT_FLOWER {flip 90} }\n"
u8"\n"
u8"rule LEFT_FLOWER {\n"
u8"   curveleft_0_97_1 {}\n"
u8"   FLOWER {x -13 y 25.3 size 1}\n"
u8"}\n"
u8"\n"
u8"rule FLOWER {\n"
u8"   CIRCLE {size 2}\n"
u8"   6* {r 60} NEW_SEED {}\n"
u8"}\n"
u8"\n"
u8"rule NEW_SEED {\n"
u8"   SEED {size 0.1 y 3}\n"
u8"}\n"
    } },
    { "i_curves.cfdg", {
u8"// This is a library file that is included in other files\n"
u8"// It offers a family of curves\n"
u8"\n"
u8"startshape test_i_curves\n"
u8"\n"
u8" shape curveright_0_9_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_9_5 [ rotate -5 size 0.9 x -0.0124921 y 0.909067 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_9_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_9_4 [ rotate -4 size 0.9 x -0.0197055 y 0.917513 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_9_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_9_3 [ rotate -3 size 0.9 x -0.0270653 y 0.925832 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_9_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_9_2 [ rotate -2 size 0.9 x -0.0345691 y 0.934021 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_9_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_9_1 [ rotate -1 size 0.9 x -0.0422147 y 0.942078 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_9_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_9_0 [ rotate 0 size 0.9 x 0.0500008 y 0.950001 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_9_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_9_1 [ rotate 1 size 0.9 x 0.0422158 y 0.942079 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_9_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_9_2 [ rotate 2 size 0.9 x 0.0345701 y 0.934022 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_9_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_9_3 [ rotate 3 size 0.9 x 0.0270664 y 0.925833 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_9_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_9_4 [ rotate 4 size 0.9 x 0.0197066 y 0.917514 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_9_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_9_5 [ rotate 5 size 0.9 x 0.0124931 y 0.909068 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_91_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_91_5 [ rotate -5 size 0.91 x -0.00707531 y 0.913612 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_91_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_91_4 [ rotate -4 size 0.91 x -0.0143689 y 0.922152 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_91_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_91_3 [ rotate -3 size 0.91 x -0.0218104 y 0.930563 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_91_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_91_2 [ rotate -2 size 0.91 x -0.0293976 y 0.938843 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_91_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_91_1 [ rotate -1 size 0.91 x -0.0371282 y 0.94699 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_91_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_91_0 [ rotate 0 size 0.91 x 0.0450008 y 0.955001 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_91_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_91_1 [ rotate 1 size 0.91 x 0.0371293 y 0.946991 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_91_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_91_2 [ rotate 2 size 0.91 x 0.0293987 y 0.938844 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_91_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_91_3 [ rotate 3 size 0.91 x 0.0218115 y 0.930565 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_91_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_91_4 [ rotate 4 size 0.91 x 0.01437 y 0.922153 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_91_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_91_5 [ rotate 5 size 0.91 x 0.00707635 y 0.913614 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_92_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_92_5 [ rotate -5 size 0.92 x -0.00165855 y 0.918158 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_92_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_92_4 [ rotate -4 size 0.92 x -0.00903229 y 0.926791 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_92_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_92_3 [ rotate -3 size 0.92 x -0.0165556 y 0.935295 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_92_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_92_2 [ rotate -2 size 0.92 x -0.0242262 y 0.943666 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_92_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_92_1 [ rotate -1 size 0.92 x -0.0320417 y 0.951902 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_92_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_92_0 [ rotate 0 size 0.92 x 0.0400008 y 0.960001 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_92_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_92_1 [ rotate 1 size 0.92 x 0.0320428 y 0.951903 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_92_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_92_2 [ rotate 2 size 0.92 x 0.0242272 y 0.943667 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_92_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_92_3 [ rotate 3 size 0.92 x 0.0165567 y 0.935296 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_92_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_92_4 [ rotate 4 size 0.92 x 0.00903342 y 0.926793 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_92_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_92_5 [ rotate 5 size 0.92 x 0.00165959 y 0.918159 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_93_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_93_5 [ rotate -5 size 0.93 x 0.00375817 y 0.922703 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_93_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_93_4 [ rotate -4 size 0.93 x -0.00369572 y 0.93143 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_93_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_93_3 [ rotate -3 size 0.93 x -0.0113008 y 0.940026 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_93_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_93_2 [ rotate -2 size 0.93 x -0.0190547 y 0.948488 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_93_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_93_1 [ rotate -1 size 0.93 x -0.0269552 y 0.956814 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_93_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_93_0 [ rotate 0 size 0.93 x 0.0350009 y 0.965001 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_93_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_93_1 [ rotate 1 size 0.93 x 0.0269564 y 0.956815 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_93_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_93_2 [ rotate 2 size 0.93 x 0.0190558 y 0.948489 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_93_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_93_3 [ rotate 3 size 0.93 x 0.0113019 y 0.940027 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_93_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_93_4 [ rotate 4 size 0.93 x 0.00369686 y 0.931432 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_93_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_93_5 [ rotate 5 size 0.93 x -0.00375711 y 0.922704 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_94_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_94_5 [ rotate -5 size 0.94 x 0.00917493 y 0.927248 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_94_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_94_4 [ rotate -4 size 0.94 x 0.00164089 y 0.936069 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_94_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_94_3 [ rotate -3 size 0.94 x -0.00604596 y 0.944758 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_94_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_94_2 [ rotate -2 size 0.94 x -0.0138833 y 0.953311 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_94_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_94_1 [ rotate -1 size 0.94 x -0.0218687 y 0.961725 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_94_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_94_0 [ rotate 0 size 0.94 x 0.0300009 y 0.970001 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_94_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_94_1 [ rotate 1 size 0.94 x 0.0218699 y 0.961727 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_94_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_94_2 [ rotate 2 size 0.94 x 0.0138844 y 0.953312 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_94_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_94_3 [ rotate 3 size 0.94 x 0.00604711 y 0.944759 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_94_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_94_4 [ rotate 4 size 0.94 x -0.00163974 y 0.936071 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_94_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_94_5 [ rotate 5 size 0.94 x -0.00917386 y 0.927249 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_95_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_95_5 [ rotate -5 size 0.95 x 0.0145917 y 0.931793 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_95_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_95_4 [ rotate -4 size 0.95 x 0.0069775 y 0.940708 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_95_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_95_3 [ rotate -3 size 0.95 x 0 y 0.949489 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_95_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_95_2 [ rotate -2 size 0.95 x -0.00871182 y 0.958133 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_95_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_95_1 [ rotate -1 size 0.95 x -0.0167822 y 0.966637 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_95_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_95_0 [ rotate 0 size 0.95 x 0.0250009 y 0.975001 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_95_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_95_1 [ rotate 1 size 0.95 x 0.0167834 y 0.966639 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_95_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_95_2 [ rotate 2 size 0.95 x 0.00871294 y 0.958134 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_95_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_95_3 [ rotate 3 size 0.95 x 0 y 0.94949 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_95_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_95_4 [ rotate 4 size 0.95 x -0.00697634 y 0.94071 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_95_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_95_5 [ rotate 5 size 0.95 x -0.0145906 y 0.931794 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_96_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_96_5 [ rotate -5 size 0.96 x 0.0200085 y 0.936338 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_96_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_96_4 [ rotate -4 size 0.96 x 0.0123141 y 0.945347 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_96_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_96_3 [ rotate -3 size 0.96 x 0.00446371 y 0.954221 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_96_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_96_2 [ rotate -2 size 0.96 x -0.00354036 y 0.962956 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_96_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_96_1 [ rotate -1 size 0.96 x -0.0116957 y 0.971549 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_96_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_96_0 [ rotate 0 size 0.96 x 0.0200009 y 0.980001 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_96_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_96_1 [ rotate 1 size 0.96 x 0.0116969 y 0.971551 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_96_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_96_2 [ rotate 2 size 0.96 x 0.00354149 y 0.962957 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_96_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_96_3 [ rotate 3 size 0.96 x -0.00446254 y 0.954222 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_96_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_96_4 [ rotate 4 size 0.96 x -0.0123129 y 0.945349 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_96_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_96_5 [ rotate 5 size 0.96 x -0.0200074 y 0.93634 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_97_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_97_5 [ rotate -5 size 0.97 x 0.0254252 y 0.940884 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_97_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_97_4 [ rotate -4 size 0.97 x 0.0176507 y 0.949986 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_97_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_97_3 [ rotate -3 size 0.97 x 0.00971855 y 0.958952 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_97_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_97_2 [ rotate -2 size 0.97 x 0.0016311 y 0.967778 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_97_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_97_1 [ rotate -1 size 0.97 x -0.00660916 y 0.976461 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_97_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_97_0 [ rotate 0 size 0.97 x 0.0150009 y 0.985001 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_97_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_97_1 [ rotate 1 size 0.97 x 0.00661039 y 0.976463 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_97_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_97_2 [ rotate 2 size 0.97 x -0.00162996 y 0.967779 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_97_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_97_3 [ rotate 3 size 0.97 x -0.00971737 y 0.958953 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_97_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_97_4 [ rotate 4 size 0.97 x -0.0176495 y 0.949988 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_97_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_97_5 [ rotate 5 size 0.97 x -0.0254241 y 0.940885 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_98_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_98_5 [ rotate -5 size 0.98 x 0.030842 y 0.945429 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_98_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_98_4 [ rotate -4 size 0.98 x 0.0229873 y 0.954625 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_98_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_98_3 [ rotate -3 size 0.98 x 0.0149734 y 0.963684 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_98_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_98_2 [ rotate -2 size 0.98 x 0.00680257 y 0.9726 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_98_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_98_1 [ rotate -1 size 0.98 x -0.00152265 y 0.981373 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_98_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_98_0 [ rotate 0 size 0.98 x 0.0100009 y 0.990001 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_98_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_98_1 [ rotate 1 size 0.98 x 0.00152389 y 0.981375 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_98_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_98_2 [ rotate 2 size 0.98 x -0.00680141 y 0.972602 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_98_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_98_3 [ rotate 3 size 0.98 x -0.0149722 y 0.963685 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_98_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_98_4 [ rotate 4 size 0.98 x -0.0229861 y 0.954627 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_98_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_98_5 [ rotate 5 size 0.98 x -0.0308409 y 0.94543 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_99_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_99_5 [ rotate -5 size 0.99 x 0.0362587 y 0.949974 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_99_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_99_4 [ rotate -4 size 0.99 x 0.028324 y 0.959264 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_99_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_99_3 [ rotate -3 size 0.99 x 0.0202282 y 0.968415 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_99_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_99_2 [ rotate -2 size 0.99 x 0.011974 y 0.977423 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_0_99_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_0_99_1 [ rotate -1 size 0.99 x 0.00356386 y 0.986285 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_99_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_99_0 [ rotate 0 size 0.99 x 0.0050009 y 0.995001 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_99_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_99_1 [ rotate 1 size 0.99 x -0.00356261 y 0.986287 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_99_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_99_2 [ rotate 2 size 0.99 x -0.0119729 y 0.977424 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_99_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_99_3 [ rotate 3 size 0.99 x -0.020227 y 0.968416 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_99_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_99_4 [ rotate 4 size 0.99 x -0.0283227 y 0.959266 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_0_99_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_0_99_5 [ rotate 5 size 0.99 x -0.0362576 y 0.949975 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_5 [ rotate -5 size 1 x 0.0416755 y 0.954519 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_4 [ rotate -4 size 1 x 0.0336605 y 0.963903 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_3 [ rotate -3 size 1 x 0.025483 y 0.973146 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_2 [ rotate -2 size 1 x 0.0171454 y 0.982245 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_1 [ rotate -1 size 1 x 0.00865033 y 0.991197 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_0 [ rotate 0 size 1 x 0 y 1 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_1 [ rotate 1 size 1 x -0.00864906 y 0.991199 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_2 [ rotate 2 size 1 x -0.0171443 y 0.982247 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_3 [ rotate 3 size 1 x -0.0254818 y 0.973148 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_4 [ rotate 4 size 1 x -0.0336593 y 0.963905 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_5 [ rotate 5 size 1 x -0.0416743 y 0.954521 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_01_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_01_5 [ rotate -5 size 1.01 x 0.0470922 y 0.959064 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_01_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_01_4 [ rotate -4 size 1.01 x 0.0389971 y 0.968542 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_01_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_01_3 [ rotate -3 size 1.01 x 0.0307379 y 0.977878 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_01_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_01_2 [ rotate -2 size 1.01 x 0.0223169 y 0.987068 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_01_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_01_1 [ rotate -1 size 1.01 x 0.0137368 y 0.996109 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_01_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_01_0 [ rotate 0 size 1.01 x -0.00499905 y 1.005 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_01_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_01_1 [ rotate 1 size 1.01 x -0.0137356 y 0.996111 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_01_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_01_2 [ rotate 2 size 1.01 x -0.0223157 y 0.987069 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_01_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_01_3 [ rotate 3 size 1.01 x -0.0307366 y 0.977879 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_01_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_01_4 [ rotate 4 size 1.01 x -0.0389959 y 0.968544 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_01_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_01_5 [ rotate 5 size 1.01 x -0.0470911 y 0.959066 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_02_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_02_5 [ rotate -5 size 1.02 x 0.0525089 y 0.96361 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_02_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_02_4 [ rotate -4 size 1.02 x 0.0443337 y 0.973181 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_02_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_02_3 [ rotate -3 size 1.02 x 0.0359927 y 0.982609 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_02_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_02_2 [ rotate -2 size 1.02 x 0.0274883 y 0.99189 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_02_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_02_1 [ rotate -1 size 1.02 x 0.0188233 y 1.00102 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_02_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_02_0 [ rotate 0 size 1.02 x -0.00999901 y 1.01 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_02_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_02_1 [ rotate 1 size 1.02 x -0.018822 y 1.00102 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_02_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_02_2 [ rotate 2 size 1.02 x -0.0274871 y 0.991892 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_02_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_02_3 [ rotate 3 size 1.02 x -0.0359914 y 0.982611 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_02_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_02_4 [ rotate 4 size 1.02 x -0.0443325 y 0.973183 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_02_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_02_5 [ rotate 5 size 1.02 x -0.0525078 y 0.963611 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_03_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_03_5 [ rotate -5 size 1.03 x 0.0579257 y 0.968155 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_03_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_03_4 [ rotate -4 size 1.03 x 0.0496704 y 0.977821 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_03_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_03_3 [ rotate -3 size 1.03 x 0.0412475 y 0.987341 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_03_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_03_2 [ rotate -2 size 1.03 x 0.0326598 y 0.996713 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_03_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_03_1 [ rotate -1 size 1.03 x 0.0239099 y 1.00593 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_03_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_03_0 [ rotate 0 size 1.03 x -0.014999 y 1.015 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_03_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_03_1 [ rotate 1 size 1.03 x -0.0239086 y 1.00593 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_03_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_03_2 [ rotate 2 size 1.03 x -0.0326586 y 0.996714 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_03_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_03_3 [ rotate 3 size 1.03 x -0.0412463 y 0.987342 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_03_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_03_4 [ rotate 4 size 1.03 x -0.0496691 y 0.977822 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_03_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_03_5 [ rotate 5 size 1.03 x -0.0579246 y 0.968156 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_04_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_04_5 [ rotate -5 size 1.04 x 0.0633425 y 0.9727 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_04_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_04_4 [ rotate -4 size 1.04 x 0.0550069 y 0.98246 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_04_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_04_3 [ rotate -3 size 1.04 x 0.0465023 y 0.992072 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_04_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_04_2 [ rotate -2 size 1.04 x 0.0378313 y 1.00154 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_04_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_04_1 [ rotate -1 size 1.04 x 0.0289963 y 1.01085 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_04_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_04_0 [ rotate 0 size 1.04 x -0.019999 y 1.02 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_04_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_04_1 [ rotate 1 size 1.04 x -0.028995 y 1.01085 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_04_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_04_2 [ rotate 2 size 1.04 x -0.03783 y 1.00154 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_04_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_04_3 [ rotate 3 size 1.04 x -0.0465011 y 0.992074 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_04_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_04_4 [ rotate 4 size 1.04 x -0.0550057 y 0.982461 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_04_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_04_5 [ rotate 5 size 1.04 x -0.0633413 y 0.972701 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_05_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_05_5 [ rotate -5 size 1.05 x 0.0687592 y 0.977245 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_05_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_05_4 [ rotate -4 size 1.05 x 0.0603435 y 0.987099 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_05_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_05_3 [ rotate -3 size 1.05 x 0.0517571 y 0.996804 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_05_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_05_2 [ rotate -2 size 1.05 x 0.0430027 y 1.00636 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_05_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_05_1 [ rotate -1 size 1.05 x 0.0340828 y 1.01576 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_05_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_05_0 [ rotate 0 size 1.05 x -0.024999 y 1.025 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_05_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_05_1 [ rotate 1 size 1.05 x -0.0340815 y 1.01576 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_05_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_05_2 [ rotate 2 size 1.05 x -0.0430014 y 1.00636 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_05_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_05_3 [ rotate 3 size 1.05 x -0.0517558 y 0.996805 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_05_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_05_4 [ rotate 4 size 1.05 x -0.0603422 y 0.9871 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_05_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_05_5 [ rotate 5 size 1.05 x -0.068758 y 0.977246 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_06_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_06_5 [ rotate -5 size 1.06 x 0.074176 y 0.98179 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_06_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_06_4 [ rotate -4 size 1.06 x 0.0656802 y 0.991738 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_06_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_06_3 [ rotate -3 size 1.06 x 0.057012 y 1.00154 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_06_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_06_2 [ rotate -2 size 1.06 x 0.0481742 y 1.01118 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_06_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_06_1 [ rotate -1 size 1.06 x 0.0391693 y 1.02067 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_06_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_06_0 [ rotate 0 size 1.06 x -0.029999 y 1.03 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_06_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_06_1 [ rotate 1 size 1.06 x -0.039168 y 1.02067 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_06_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_06_2 [ rotate 2 size 1.06 x -0.0481729 y 1.01118 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_06_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_06_3 [ rotate 3 size 1.06 x -0.0570107 y 1.00154 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_06_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_06_4 [ rotate 4 size 1.06 x -0.0656789 y 0.991739 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_06_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_06_5 [ rotate 5 size 1.06 x -0.0741748 y 0.981792 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_07_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_07_5 [ rotate -5 size 1.07 x 0.0795927 y 0.986336 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_07_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_07_4 [ rotate -4 size 1.07 x 0.0710168 y 0.996377 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_07_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_07_3 [ rotate -3 size 1.07 x 0.0622668 y 1.00627 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_07_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_07_2 [ rotate -2 size 1.07 x 0.0533456 y 1.016 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_07_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_07_1 [ rotate -1 size 1.07 x 0.0442559 y 1.02558 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_07_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_07_0 [ rotate 0 size 1.07 x -0.034999 y 1.035 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_07_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_07_1 [ rotate 1 size 1.07 x -0.0442545 y 1.02558 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_07_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_07_2 [ rotate 2 size 1.07 x -0.0533444 y 1.016 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_07_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_07_3 [ rotate 3 size 1.07 x -0.0622655 y 1.00627 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_07_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_07_4 [ rotate 4 size 1.07 x -0.0710155 y 0.996378 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_07_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_07_5 [ rotate 5 size 1.07 x -0.0795915 y 0.986337 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_08_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_08_5 [ rotate -5 size 1.08 x 0.0850095 y 0.990881 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_08_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_08_4 [ rotate -4 size 1.08 x 0.0763534 y 1.00102 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_08_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_08_3 [ rotate -3 size 1.08 x 0.0675217 y 1.011 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_08_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_08_2 [ rotate -2 size 1.08 x 0.0585171 y 1.02083 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_08_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_08_1 [ rotate -1 size 1.08 x 0.0493424 y 1.03049 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_08_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_08_0 [ rotate 0 size 1.08 x -0.039999 y 1.04 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_08_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_08_1 [ rotate 1 size 1.08 x -0.049341 y 1.03049 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_08_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_08_2 [ rotate 2 size 1.08 x -0.0585158 y 1.02083 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_08_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_08_3 [ rotate 3 size 1.08 x -0.0675204 y 1.011 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_08_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_08_4 [ rotate 4 size 1.08 x -0.0763521 y 1.00102 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_08_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_08_5 [ rotate 5 size 1.08 x -0.0850083 y 0.990882 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_09_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_09_5 [ rotate -5 size 1.09 x 0.0904263 y 0.995426 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_09_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_09_4 [ rotate -4 size 1.09 x 0.08169 y 1.00565 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_09_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_09_3 [ rotate -3 size 1.09 x 0.0727765 y 1.01573 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_09_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_09_2 [ rotate -2 size 1.09 x 0.0636886 y 1.02565 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_09_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_09_1 [ rotate -1 size 1.09 x 0.0544289 y 1.03541 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_09_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_09_0 [ rotate 0 size 1.09 x -0.044999 y 1.045 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_09_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_09_1 [ rotate 1 size 1.09 x -0.0544275 y 1.03541 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_09_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_09_2 [ rotate 2 size 1.09 x -0.0636873 y 1.02565 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_09_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_09_3 [ rotate 3 size 1.09 x -0.0727752 y 1.01573 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_09_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_09_4 [ rotate 4 size 1.09 x -0.0816887 y 1.00566 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_09_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_09_5 [ rotate 5 size 1.09 x -0.090425 y 0.995427 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_1_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_1_5 [ rotate -5 size 1.1 x 0.095843 y 0.999971 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_1_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_1_4 [ rotate -4 size 1.1 x 0.0870266 y 1.01029 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_1_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_1_3 [ rotate -3 size 1.1 x 0.0780314 y 1.02046 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_1_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_1_2 [ rotate -2 size 1.1 x 0.06886 y 1.03047 ]\n"
u8"}\n"
u8"\n"
u8" shape curveright_1_1_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveright_1_1_1 [ rotate -1 size 1.1 x 0.0595154 y 1.04032 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_1_0\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_1_0 [ rotate 0 size 1.1 x -0.049999 y 1.05 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_1_1\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_1_1 [ rotate 1 size 1.1 x -0.059514 y 1.04032 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_1_2\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_1_2 [ rotate 2 size 1.1 x -0.0688587 y 1.03047 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_1_3\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_1_3 [ rotate 3 size 1.1 x -0.07803 y 1.02046 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_1_4\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_1_4 [ rotate 4 size 1.1 x -0.0870253 y 1.0103 ]\n"
u8"}\n"
u8"\n"
u8"shape curveleft_1_1_5\n"
u8"rule {\n"
u8" SQUARE [ ]\n"
u8" curveleft_1_1_5 [ rotate 5 size 1.1 x -0.0958418 y 0.999973 ]\n"
u8"}\n"
u8"\n"
u8"\n"
u8"shape test_i_curves\n"
u8"rule {\n"
u8"    test_i_curves_0_9  [ x -35 y -40 ]\n"
u8"    test_i_curves_0_91 [ x   0 y -40 ]\n"
u8"    test_i_curves_0_92 [ x  35 y -40 ]\n"
u8"    test_i_curves_0_93 [ x -40 y -20 ]\n"
u8"    test_i_curves_0_94 [ x   0 y -20 ]\n"
u8"    test_i_curves_0_95 [ x  40 y -20 ]\n"
u8"    test_i_curves_0_96 [ x -55 y   0 ]\n"
u8"    test_i_curves_0_97 [ x   0 y   0 ]\n"
u8"    test_i_curves_0_98 [ x  55 y   0 ]\n"
u8"    test_i_curves_0_99 [ x   0 y  40 ]\n"
u8"}\n"
u8"\n"
u8"shape test_i_curves_0_9\n"
u8"rule {\n"
u8"    curveright_0_9_5 [ x 10 ]\n"
u8"    curveright_0_9_4 [ x 8 ]\n"
u8"    curveright_0_9_3 [ x 6 ]\n"
u8"    curveright_0_9_2 [ x 4 ]\n"
u8"    curveright_0_9_1 [ x 2 ]\n"
u8"    curveleft_0_9_0 [ ]\n"
u8"    curveleft_0_9_1 [ x -2 ]\n"
u8"    curveleft_0_9_2 [ x -4 ]\n"
u8"    curveleft_0_9_3 [ x -6 ]\n"
u8"    curveleft_0_9_4 [ x -8 ]\n"
u8"    curveleft_0_9_5 [ x -10 ]\n"
u8"}\n"
u8"\n"
u8"shape test_i_curves_0_91\n"
u8"rule {\n"
u8"    curveright_0_91_5 [ x 10 ]\n"
u8"    curveright_0_91_4 [ x 8 ]\n"
u8"    curveright_0_91_3 [ x 6 ]\n"
u8"    curveright_0_91_2 [ x 4 ]\n"
u8"    curveright_0_91_1 [ x 2 ]\n"
u8"    curveleft_0_91_0 [ ]\n"
u8"    curveleft_0_91_1 [ x -2 ]\n"
u8"    curveleft_0_91_2 [ x -4 ]\n"
u8"    curveleft_0_91_3 [ x -6 ]\n"
u8"    curveleft_0_91_4 [ x -8 ]\n"
u8"    curveleft_0_91_5 [ x -10 ]\n"
u8"}\n"
u8"\n"
u8"shape test_i_curves_0_92\n"
u8"rule {\n"
u8"    curveright_0_92_5 [ x 10 ]\n"
u8"    curveright_0_92_4 [ x 8 ]\n"
u8"    curveright_0_92_3 [ x 6 ]\n"
u8"    curveright_0_92_2 [ x 4 ]\n"
u8"    curveright_0_92_1 [ x 2 ]\n"
u8"    curveleft_0_92_0 [ ]\n"
u8"    curveleft_0_92_1 [ x -2 ]\n"
u8"    curveleft_0_92_2 [ x -4 ]\n"
u8"    curveleft_0_92_3 [ x -6 ]\n"
u8"    curveleft_0_92_4 [ x -8 ]\n"
u8"    curveleft_0_92_5 [ x -10 ]\n"
u8"}\n"
u8"\n"
u8"shape test_i_curves_0_93\n"
u8"rule {\n"
u8"    curveright_0_93_5 [ x 10 ]\n"
u8"    curveright_0_93_4 [ x 8 ]\n"
u8"    curveright_0_93_3 [ x 6 ]\n"
u8"    curveright_0_93_2 [ x 4 ]\n"
u8"    curveright_0_93_1 [ x 2 ]\n"
u8"    curveleft_0_93_0 [ ]\n"
u8"    curveleft_0_93_1 [ x -2 ]\n"
u8"    curveleft_0_93_2 [ x -4 ]\n"
u8"    curveleft_0_93_3 [ x -6 ]\n"
u8"    curveleft_0_93_4 [ x -8 ]\n"
u8"    curveleft_0_93_5 [ x -10 ]\n"
u8"}\n"
u8"\n"
u8"shape test_i_curves_0_94\n"
u8"rule {\n"
u8"    curveright_0_94_5 [ x 10 ]\n"
u8"    curveright_0_94_4 [ x 8 ]\n"
u8"    curveright_0_94_3 [ x 6 ]\n"
u8"    curveright_0_94_2 [ x 4 ]\n"
u8"    curveright_0_94_1 [ x 2 ]\n"
u8"    curveleft_0_94_0 [ ]\n"
u8"    curveleft_0_94_1 [ x -2 ]\n"
u8"    curveleft_0_94_2 [ x -4 ]\n"
u8"    curveleft_0_94_3 [ x -6 ]\n"
u8"    curveleft_0_94_4 [ x -8 ]\n"
u8"    curveleft_0_94_5 [ x -10 ]\n"
u8"}\n"
u8"\n"
u8"shape test_i_curves_0_95\n"
u8"rule {\n"
u8"    curveright_0_95_5 [ x 10 ]\n"
u8"    curveright_0_95_4 [ x 8 ]\n"
u8"    curveright_0_95_3 [ x 6 ]\n"
u8"    curveright_0_95_2 [ x 4 ]\n"
u8"    curveright_0_95_1 [ x 2 ]\n"
u8"    curveleft_0_95_0 [ ]\n"
u8"    curveleft_0_95_1 [ x -2 ]\n"
u8"    curveleft_0_95_2 [ x -4 ]\n"
u8"    curveleft_0_95_3 [ x -6 ]\n"
u8"    curveleft_0_95_4 [ x -8 ]\n"
u8"    curveleft_0_95_5 [ x -10 ]\n"
u8"}\n"
u8"\n"
u8"shape test_i_curves_0_96\n"
u8"rule {\n"
u8"    curveright_0_96_5 [ x 10 ]\n"
u8"    curveright_0_96_4 [ x 8 ]\n"
u8"    curveright_0_96_3 [ x 6 ]\n"
u8"    curveright_0_96_2 [ x 4 ]\n"
u8"    curveright_0_96_1 [ x 2 ]\n"
u8"    curveleft_0_96_0 [ ]\n"
u8"    curveleft_0_96_1 [ x -2 ]\n"
u8"    curveleft_0_96_2 [ x -4 ]\n"
u8"    curveleft_0_96_3 [ x -6 ]\n"
u8"    curveleft_0_96_4 [ x -8 ]\n"
u8"    curveleft_0_96_5 [ x -10 ]\n"
u8"}\n"
u8"\n"
u8"shape test_i_curves_0_97\n"
u8"rule {\n"
u8"    curveright_0_97_5 [ x 10 ]\n"
u8"    curveright_0_97_4 [ x 8 ]\n"
u8"    curveright_0_97_3 [ x 6 ]\n"
u8"    curveright_0_97_2 [ x 4 ]\n"
u8"    curveright_0_97_1 [ x 2 ]\n"
u8"    curveleft_0_97_0 [ ]\n"
u8"    curveleft_0_97_1 [ x -2 ]\n"
u8"    curveleft_0_97_2 [ x -4 ]\n"
u8"    curveleft_0_97_3 [ x -6 ]\n"
u8"    curveleft_0_97_4 [ x -8 ]\n"
u8"    curveleft_0_97_5 [ x -10 ]\n"
u8"}\n"
u8"\n"
u8"shape test_i_curves_0_98\n"
u8"rule {\n"
u8"    curveright_0_98_5 [ x 10 ]\n"
u8"    curveright_0_98_4 [ x 8 ]\n"
u8"    curveright_0_98_3 [ x 6 ]\n"
u8"    curveright_0_98_2 [ x 4 ]\n"
u8"    curveright_0_98_1 [ x 2 ]\n"
u8"    curveleft_0_98_0 [ ]\n"
u8"    curveleft_0_98_1 [ x -2 ]\n"
u8"    curveleft_0_98_2 [ x -4 ]\n"
u8"    curveleft_0_98_3 [ x -6 ]\n"
u8"    curveleft_0_98_4 [ x -8 ]\n"
u8"    curveleft_0_98_5 [ x -10 ]\n"
u8"}\n"
u8"\n"
u8"shape test_i_curves_0_99\n"
u8"rule {\n"
u8"    curveright_0_99_5 [ x 10 ]\n"
u8"    curveright_0_99_4 [ x 8 ]\n"
u8"    curveright_0_99_3 [ x 6 ]\n"
u8"    curveright_0_99_2 [ x 4 ]\n"
u8"    curveright_0_99_1 [ x 2 ]\n"
u8"    curveleft_0_99_0 [ ]\n"
u8"    curveleft_0_99_1 [ x -2 ]\n"
u8"    curveleft_0_99_2 [ x -4 ]\n"
u8"    curveleft_0_99_3 [ x -6 ]\n"
u8"    curveleft_0_99_4 [ x -8 ]\n"
u8"    curveleft_0_99_5 [ x -10 ]\n"
u8"}\n"
u8"\n"
 ,
u8"// This is a library file that is included in other files\n"
u8"// It offers a family of curves\n"
u8"\n"
u8"startshape test_i_curves\n"
u8"\n"
u8" rule curveright_0_9_5 {\n"
u8" SQUARE { }\n"
u8" curveright_0_9_5 { rotate -5 size 0.9 x -0.0124921 y 0.909067 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_9_4 {\n"
u8" SQUARE { }\n"
u8" curveright_0_9_4 { rotate -4 size 0.9 x -0.0197055 y 0.917513 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_9_3 {\n"
u8" SQUARE { }\n"
u8" curveright_0_9_3 { rotate -3 size 0.9 x -0.0270653 y 0.925832 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_9_2 {\n"
u8" SQUARE { }\n"
u8" curveright_0_9_2 { rotate -2 size 0.9 x -0.0345691 y 0.934021 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_9_1 {\n"
u8" SQUARE { }\n"
u8" curveright_0_9_1 { rotate -1 size 0.9 x -0.0422147 y 0.942078 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_9_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_9_0 { rotate 0 size 0.9 x 0.0500008 y 0.950001 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_9_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_9_1 { rotate 1 size 0.9 x 0.0422158 y 0.942079 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_9_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_9_2 { rotate 2 size 0.9 x 0.0345701 y 0.934022 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_9_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_9_3 { rotate 3 size 0.9 x 0.0270664 y 0.925833 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_9_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_9_4 { rotate 4 size 0.9 x 0.0197066 y 0.917514 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_9_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_9_5 { rotate 5 size 0.9 x 0.0124931 y 0.909068 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_91_5 {\n"
u8" SQUARE { }\n"
u8" curveright_0_91_5 { rotate -5 size 0.91 x -0.00707531 y 0.913612 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_91_4 {\n"
u8" SQUARE { }\n"
u8" curveright_0_91_4 { rotate -4 size 0.91 x -0.0143689 y 0.922152 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_91_3 {\n"
u8" SQUARE { }\n"
u8" curveright_0_91_3 { rotate -3 size 0.91 x -0.0218104 y 0.930563 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_91_2 {\n"
u8" SQUARE { }\n"
u8" curveright_0_91_2 { rotate -2 size 0.91 x -0.0293976 y 0.938843 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_91_1 {\n"
u8" SQUARE { }\n"
u8" curveright_0_91_1 { rotate -1 size 0.91 x -0.0371282 y 0.94699 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_91_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_91_0 { rotate 0 size 0.91 x 0.0450008 y 0.955001 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_91_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_91_1 { rotate 1 size 0.91 x 0.0371293 y 0.946991 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_91_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_91_2 { rotate 2 size 0.91 x 0.0293987 y 0.938844 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_91_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_91_3 { rotate 3 size 0.91 x 0.0218115 y 0.930565 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_91_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_91_4 { rotate 4 size 0.91 x 0.01437 y 0.922153 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_91_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_91_5 { rotate 5 size 0.91 x 0.00707635 y 0.913614 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_92_5 {\n"
u8" SQUARE { }\n"
u8" curveright_0_92_5 { rotate -5 size 0.92 x -0.00165855 y 0.918158 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_92_4 {\n"
u8" SQUARE { }\n"
u8" curveright_0_92_4 { rotate -4 size 0.92 x -0.00903229 y 0.926791 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_92_3 {\n"
u8" SQUARE { }\n"
u8" curveright_0_92_3 { rotate -3 size 0.92 x -0.0165556 y 0.935295 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_92_2 {\n"
u8" SQUARE { }\n"
u8" curveright_0_92_2 { rotate -2 size 0.92 x -0.0242262 y 0.943666 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_92_1 {\n"
u8" SQUARE { }\n"
u8" curveright_0_92_1 { rotate -1 size 0.92 x -0.0320417 y 0.951902 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_92_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_92_0 { rotate 0 size 0.92 x 0.0400008 y 0.960001 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_92_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_92_1 { rotate 1 size 0.92 x 0.0320428 y 0.951903 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_92_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_92_2 { rotate 2 size 0.92 x 0.0242272 y 0.943667 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_92_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_92_3 { rotate 3 size 0.92 x 0.0165567 y 0.935296 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_92_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_92_4 { rotate 4 size 0.92 x 0.00903342 y 0.926793 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_92_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_92_5 { rotate 5 size 0.92 x 0.00165959 y 0.918159 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_93_5 {\n"
u8" SQUARE { }\n"
u8" curveright_0_93_5 { rotate -5 size 0.93 x 0.00375817 y 0.922703 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_93_4 {\n"
u8" SQUARE { }\n"
u8" curveright_0_93_4 { rotate -4 size 0.93 x -0.00369572 y 0.93143 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_93_3 {\n"
u8" SQUARE { }\n"
u8" curveright_0_93_3 { rotate -3 size 0.93 x -0.0113008 y 0.940026 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_93_2 {\n"
u8" SQUARE { }\n"
u8" curveright_0_93_2 { rotate -2 size 0.93 x -0.0190547 y 0.948488 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_93_1 {\n"
u8" SQUARE { }\n"
u8" curveright_0_93_1 { rotate -1 size 0.93 x -0.0269552 y 0.956814 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_93_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_93_0 { rotate 0 size 0.93 x 0.0350009 y 0.965001 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_93_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_93_1 { rotate 1 size 0.93 x 0.0269564 y 0.956815 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_93_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_93_2 { rotate 2 size 0.93 x 0.0190558 y 0.948489 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_93_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_93_3 { rotate 3 size 0.93 x 0.0113019 y 0.940027 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_93_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_93_4 { rotate 4 size 0.93 x 0.00369686 y 0.931432 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_93_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_93_5 { rotate 5 size 0.93 x -0.00375711 y 0.922704 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_94_5 {\n"
u8" SQUARE { }\n"
u8" curveright_0_94_5 { rotate -5 size 0.94 x 0.00917493 y 0.927248 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_94_4 {\n"
u8" SQUARE { }\n"
u8" curveright_0_94_4 { rotate -4 size 0.94 x 0.00164089 y 0.936069 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_94_3 {\n"
u8" SQUARE { }\n"
u8" curveright_0_94_3 { rotate -3 size 0.94 x -0.00604596 y 0.944758 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_94_2 {\n"
u8" SQUARE { }\n"
u8" curveright_0_94_2 { rotate -2 size 0.94 x -0.0138833 y 0.953311 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_94_1 {\n"
u8" SQUARE { }\n"
u8" curveright_0_94_1 { rotate -1 size 0.94 x -0.0218687 y 0.961725 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_94_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_94_0 { rotate 0 size 0.94 x 0.0300009 y 0.970001 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_94_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_94_1 { rotate 1 size 0.94 x 0.0218699 y 0.961727 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_94_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_94_2 { rotate 2 size 0.94 x 0.0138844 y 0.953312 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_94_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_94_3 { rotate 3 size 0.94 x 0.00604711 y 0.944759 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_94_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_94_4 { rotate 4 size 0.94 x -0.00163974 y 0.936071 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_94_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_94_5 { rotate 5 size 0.94 x -0.00917386 y 0.927249 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_95_5 {\n"
u8" SQUARE { }\n"
u8" curveright_0_95_5 { rotate -5 size 0.95 x 0.0145917 y 0.931793 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_95_4 {\n"
u8" SQUARE { }\n"
u8" curveright_0_95_4 { rotate -4 size 0.95 x 0.0069775 y 0.940708 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_95_3 {\n"
u8" SQUARE { }\n"
u8" curveright_0_95_3 { rotate -3 size 0.95 x 0 y 0.949489 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_95_2 {\n"
u8" SQUARE { }\n"
u8" curveright_0_95_2 { rotate -2 size 0.95 x -0.00871182 y 0.958133 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_95_1 {\n"
u8" SQUARE { }\n"
u8" curveright_0_95_1 { rotate -1 size 0.95 x -0.0167822 y 0.966637 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_95_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_95_0 { rotate 0 size 0.95 x 0.0250009 y 0.975001 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_95_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_95_1 { rotate 1 size 0.95 x 0.0167834 y 0.966639 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_95_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_95_2 { rotate 2 size 0.95 x 0.00871294 y 0.958134 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_95_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_95_3 { rotate 3 size 0.95 x 0 y 0.94949 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_95_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_95_4 { rotate 4 size 0.95 x -0.00697634 y 0.94071 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_95_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_95_5 { rotate 5 size 0.95 x -0.0145906 y 0.931794 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_96_5 {\n"
u8" SQUARE { }\n"
u8" curveright_0_96_5 { rotate -5 size 0.96 x 0.0200085 y 0.936338 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_96_4 {\n"
u8" SQUARE { }\n"
u8" curveright_0_96_4 { rotate -4 size 0.96 x 0.0123141 y 0.945347 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_96_3 {\n"
u8" SQUARE { }\n"
u8" curveright_0_96_3 { rotate -3 size 0.96 x 0.00446371 y 0.954221 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_96_2 {\n"
u8" SQUARE { }\n"
u8" curveright_0_96_2 { rotate -2 size 0.96 x -0.00354036 y 0.962956 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_96_1 {\n"
u8" SQUARE { }\n"
u8" curveright_0_96_1 { rotate -1 size 0.96 x -0.0116957 y 0.971549 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_96_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_96_0 { rotate 0 size 0.96 x 0.0200009 y 0.980001 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_96_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_96_1 { rotate 1 size 0.96 x 0.0116969 y 0.971551 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_96_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_96_2 { rotate 2 size 0.96 x 0.00354149 y 0.962957 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_96_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_96_3 { rotate 3 size 0.96 x -0.00446254 y 0.954222 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_96_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_96_4 { rotate 4 size 0.96 x -0.0123129 y 0.945349 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_96_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_96_5 { rotate 5 size 0.96 x -0.0200074 y 0.93634 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_97_5 {\n"
u8" SQUARE { }\n"
u8" curveright_0_97_5 { rotate -5 size 0.97 x 0.0254252 y 0.940884 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_97_4 {\n"
u8" SQUARE { }\n"
u8" curveright_0_97_4 { rotate -4 size 0.97 x 0.0176507 y 0.949986 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_97_3 {\n"
u8" SQUARE { }\n"
u8" curveright_0_97_3 { rotate -3 size 0.97 x 0.00971855 y 0.958952 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_97_2 {\n"
u8" SQUARE { }\n"
u8" curveright_0_97_2 { rotate -2 size 0.97 x 0.0016311 y 0.967778 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_97_1 {\n"
u8" SQUARE { }\n"
u8" curveright_0_97_1 { rotate -1 size 0.97 x -0.00660916 y 0.976461 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_97_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_97_0 { rotate 0 size 0.97 x 0.0150009 y 0.985001 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_97_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_97_1 { rotate 1 size 0.97 x 0.00661039 y 0.976463 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_97_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_97_2 { rotate 2 size 0.97 x -0.00162996 y 0.967779 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_97_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_97_3 { rotate 3 size 0.97 x -0.00971737 y 0.958953 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_97_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_97_4 { rotate 4 size 0.97 x -0.0176495 y 0.949988 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_97_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_97_5 { rotate 5 size 0.97 x -0.0254241 y 0.940885 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_98_5 {\n"
u8" SQUARE { }\n"
u8" curveright_0_98_5 { rotate -5 size 0.98 x 0.030842 y 0.945429 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_98_4 {\n"
u8" SQUARE { }\n"
u8" curveright_0_98_4 { rotate -4 size 0.98 x 0.0229873 y 0.954625 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_98_3 {\n"
u8" SQUARE { }\n"
u8" curveright_0_98_3 { rotate -3 size 0.98 x 0.0149734 y 0.963684 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_98_2 {\n"
u8" SQUARE { }\n"
u8" curveright_0_98_2 { rotate -2 size 0.98 x 0.00680257 y 0.9726 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_98_1 {\n"
u8" SQUARE { }\n"
u8" curveright_0_98_1 { rotate -1 size 0.98 x -0.00152265 y 0.981373 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_98_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_98_0 { rotate 0 size 0.98 x 0.0100009 y 0.990001 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_98_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_98_1 { rotate 1 size 0.98 x 0.00152389 y 0.981375 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_98_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_98_2 { rotate 2 size 0.98 x -0.00680141 y 0.972602 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_98_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_98_3 { rotate 3 size 0.98 x -0.0149722 y 0.963685 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_98_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_98_4 { rotate 4 size 0.98 x -0.0229861 y 0.954627 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_98_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_98_5 { rotate 5 size 0.98 x -0.0308409 y 0.94543 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_99_5 {\n"
u8" SQUARE { }\n"
u8" curveright_0_99_5 { rotate -5 size 0.99 x 0.0362587 y 0.949974 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_99_4 {\n"
u8" SQUARE { }\n"
u8" curveright_0_99_4 { rotate -4 size 0.99 x 0.028324 y 0.959264 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_99_3 {\n"
u8" SQUARE { }\n"
u8" curveright_0_99_3 { rotate -3 size 0.99 x 0.0202282 y 0.968415 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_99_2 {\n"
u8" SQUARE { }\n"
u8" curveright_0_99_2 { rotate -2 size 0.99 x 0.011974 y 0.977423 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_0_99_1 {\n"
u8" SQUARE { }\n"
u8" curveright_0_99_1 { rotate -1 size 0.99 x 0.00356386 y 0.986285 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_99_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_99_0 { rotate 0 size 0.99 x 0.0050009 y 0.995001 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_99_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_99_1 { rotate 1 size 0.99 x -0.00356261 y 0.986287 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_99_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_99_2 { rotate 2 size 0.99 x -0.0119729 y 0.977424 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_99_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_99_3 { rotate 3 size 0.99 x -0.020227 y 0.968416 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_99_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_99_4 { rotate 4 size 0.99 x -0.0283227 y 0.959266 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_0_99_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_0_99_5 { rotate 5 size 0.99 x -0.0362576 y 0.949975 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_5 { rotate -5 size 1 x 0.0416755 y 0.954519 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_4 { rotate -4 size 1 x 0.0336605 y 0.963903 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_3 { rotate -3 size 1 x 0.025483 y 0.973146 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_2 { rotate -2 size 1 x 0.0171454 y 0.982245 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_1 { rotate -1 size 1 x 0.00865033 y 0.991197 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_0 { rotate 0 size 1 x 0 y 1 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_1 { rotate 1 size 1 x -0.00864906 y 0.991199 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_2 { rotate 2 size 1 x -0.0171443 y 0.982247 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_3 { rotate 3 size 1 x -0.0254818 y 0.973148 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_4 { rotate 4 size 1 x -0.0336593 y 0.963905 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_5 { rotate 5 size 1 x -0.0416743 y 0.954521 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_01_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_01_5 { rotate -5 size 1.01 x 0.0470922 y 0.959064 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_01_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_01_4 { rotate -4 size 1.01 x 0.0389971 y 0.968542 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_01_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_01_3 { rotate -3 size 1.01 x 0.0307379 y 0.977878 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_01_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_01_2 { rotate -2 size 1.01 x 0.0223169 y 0.987068 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_01_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_01_1 { rotate -1 size 1.01 x 0.0137368 y 0.996109 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_01_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_01_0 { rotate 0 size 1.01 x -0.00499905 y 1.005 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_01_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_01_1 { rotate 1 size 1.01 x -0.0137356 y 0.996111 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_01_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_01_2 { rotate 2 size 1.01 x -0.0223157 y 0.987069 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_01_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_01_3 { rotate 3 size 1.01 x -0.0307366 y 0.977879 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_01_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_01_4 { rotate 4 size 1.01 x -0.0389959 y 0.968544 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_01_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_01_5 { rotate 5 size 1.01 x -0.0470911 y 0.959066 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_02_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_02_5 { rotate -5 size 1.02 x 0.0525089 y 0.96361 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_02_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_02_4 { rotate -4 size 1.02 x 0.0443337 y 0.973181 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_02_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_02_3 { rotate -3 size 1.02 x 0.0359927 y 0.982609 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_02_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_02_2 { rotate -2 size 1.02 x 0.0274883 y 0.99189 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_02_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_02_1 { rotate -1 size 1.02 x 0.0188233 y 1.00102 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_02_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_02_0 { rotate 0 size 1.02 x -0.00999901 y 1.01 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_02_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_02_1 { rotate 1 size 1.02 x -0.018822 y 1.00102 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_02_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_02_2 { rotate 2 size 1.02 x -0.0274871 y 0.991892 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_02_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_02_3 { rotate 3 size 1.02 x -0.0359914 y 0.982611 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_02_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_02_4 { rotate 4 size 1.02 x -0.0443325 y 0.973183 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_02_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_02_5 { rotate 5 size 1.02 x -0.0525078 y 0.963611 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_03_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_03_5 { rotate -5 size 1.03 x 0.0579257 y 0.968155 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_03_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_03_4 { rotate -4 size 1.03 x 0.0496704 y 0.977821 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_03_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_03_3 { rotate -3 size 1.03 x 0.0412475 y 0.987341 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_03_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_03_2 { rotate -2 size 1.03 x 0.0326598 y 0.996713 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_03_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_03_1 { rotate -1 size 1.03 x 0.0239099 y 1.00593 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_03_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_03_0 { rotate 0 size 1.03 x -0.014999 y 1.015 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_03_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_03_1 { rotate 1 size 1.03 x -0.0239086 y 1.00593 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_03_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_03_2 { rotate 2 size 1.03 x -0.0326586 y 0.996714 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_03_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_03_3 { rotate 3 size 1.03 x -0.0412463 y 0.987342 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_03_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_03_4 { rotate 4 size 1.03 x -0.0496691 y 0.977822 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_03_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_03_5 { rotate 5 size 1.03 x -0.0579246 y 0.968156 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_04_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_04_5 { rotate -5 size 1.04 x 0.0633425 y 0.9727 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_04_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_04_4 { rotate -4 size 1.04 x 0.0550069 y 0.98246 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_04_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_04_3 { rotate -3 size 1.04 x 0.0465023 y 0.992072 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_04_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_04_2 { rotate -2 size 1.04 x 0.0378313 y 1.00154 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_04_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_04_1 { rotate -1 size 1.04 x 0.0289963 y 1.01085 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_04_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_04_0 { rotate 0 size 1.04 x -0.019999 y 1.02 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_04_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_04_1 { rotate 1 size 1.04 x -0.028995 y 1.01085 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_04_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_04_2 { rotate 2 size 1.04 x -0.03783 y 1.00154 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_04_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_04_3 { rotate 3 size 1.04 x -0.0465011 y 0.992074 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_04_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_04_4 { rotate 4 size 1.04 x -0.0550057 y 0.982461 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_04_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_04_5 { rotate 5 size 1.04 x -0.0633413 y 0.972701 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_05_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_05_5 { rotate -5 size 1.05 x 0.0687592 y 0.977245 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_05_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_05_4 { rotate -4 size 1.05 x 0.0603435 y 0.987099 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_05_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_05_3 { rotate -3 size 1.05 x 0.0517571 y 0.996804 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_05_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_05_2 { rotate -2 size 1.05 x 0.0430027 y 1.00636 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_05_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_05_1 { rotate -1 size 1.05 x 0.0340828 y 1.01576 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_05_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_05_0 { rotate 0 size 1.05 x -0.024999 y 1.025 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_05_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_05_1 { rotate 1 size 1.05 x -0.0340815 y 1.01576 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_05_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_05_2 { rotate 2 size 1.05 x -0.0430014 y 1.00636 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_05_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_05_3 { rotate 3 size 1.05 x -0.0517558 y 0.996805 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_05_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_05_4 { rotate 4 size 1.05 x -0.0603422 y 0.9871 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_05_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_05_5 { rotate 5 size 1.05 x -0.068758 y 0.977246 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_06_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_06_5 { rotate -5 size 1.06 x 0.074176 y 0.98179 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_06_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_06_4 { rotate -4 size 1.06 x 0.0656802 y 0.991738 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_06_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_06_3 { rotate -3 size 1.06 x 0.057012 y 1.00154 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_06_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_06_2 { rotate -2 size 1.06 x 0.0481742 y 1.01118 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_06_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_06_1 { rotate -1 size 1.06 x 0.0391693 y 1.02067 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_06_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_06_0 { rotate 0 size 1.06 x -0.029999 y 1.03 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_06_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_06_1 { rotate 1 size 1.06 x -0.039168 y 1.02067 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_06_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_06_2 { rotate 2 size 1.06 x -0.0481729 y 1.01118 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_06_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_06_3 { rotate 3 size 1.06 x -0.0570107 y 1.00154 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_06_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_06_4 { rotate 4 size 1.06 x -0.0656789 y 0.991739 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_06_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_06_5 { rotate 5 size 1.06 x -0.0741748 y 0.981792 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_07_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_07_5 { rotate -5 size 1.07 x 0.0795927 y 0.986336 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_07_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_07_4 { rotate -4 size 1.07 x 0.0710168 y 0.996377 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_07_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_07_3 { rotate -3 size 1.07 x 0.0622668 y 1.00627 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_07_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_07_2 { rotate -2 size 1.07 x 0.0533456 y 1.016 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_07_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_07_1 { rotate -1 size 1.07 x 0.0442559 y 1.02558 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_07_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_07_0 { rotate 0 size 1.07 x -0.034999 y 1.035 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_07_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_07_1 { rotate 1 size 1.07 x -0.0442545 y 1.02558 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_07_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_07_2 { rotate 2 size 1.07 x -0.0533444 y 1.016 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_07_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_07_3 { rotate 3 size 1.07 x -0.0622655 y 1.00627 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_07_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_07_4 { rotate 4 size 1.07 x -0.0710155 y 0.996378 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_07_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_07_5 { rotate 5 size 1.07 x -0.0795915 y 0.986337 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_08_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_08_5 { rotate -5 size 1.08 x 0.0850095 y 0.990881 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_08_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_08_4 { rotate -4 size 1.08 x 0.0763534 y 1.00102 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_08_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_08_3 { rotate -3 size 1.08 x 0.0675217 y 1.011 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_08_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_08_2 { rotate -2 size 1.08 x 0.0585171 y 1.02083 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_08_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_08_1 { rotate -1 size 1.08 x 0.0493424 y 1.03049 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_08_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_08_0 { rotate 0 size 1.08 x -0.039999 y 1.04 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_08_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_08_1 { rotate 1 size 1.08 x -0.049341 y 1.03049 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_08_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_08_2 { rotate 2 size 1.08 x -0.0585158 y 1.02083 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_08_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_08_3 { rotate 3 size 1.08 x -0.0675204 y 1.011 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_08_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_08_4 { rotate 4 size 1.08 x -0.0763521 y 1.00102 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_08_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_08_5 { rotate 5 size 1.08 x -0.0850083 y 0.990882 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_09_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_09_5 { rotate -5 size 1.09 x 0.0904263 y 0.995426 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_09_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_09_4 { rotate -4 size 1.09 x 0.08169 y 1.00565 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_09_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_09_3 { rotate -3 size 1.09 x 0.0727765 y 1.01573 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_09_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_09_2 { rotate -2 size 1.09 x 0.0636886 y 1.02565 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_09_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_09_1 { rotate -1 size 1.09 x 0.0544289 y 1.03541 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_09_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_09_0 { rotate 0 size 1.09 x -0.044999 y 1.045 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_09_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_09_1 { rotate 1 size 1.09 x -0.0544275 y 1.03541 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_09_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_09_2 { rotate 2 size 1.09 x -0.0636873 y 1.02565 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_09_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_09_3 { rotate 3 size 1.09 x -0.0727752 y 1.01573 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_09_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_09_4 { rotate 4 size 1.09 x -0.0816887 y 1.00566 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_09_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_09_5 { rotate 5 size 1.09 x -0.090425 y 0.995427 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_1_5 {\n"
u8" SQUARE { }\n"
u8" curveright_1_1_5 { rotate -5 size 1.1 x 0.095843 y 0.999971 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_1_4 {\n"
u8" SQUARE { }\n"
u8" curveright_1_1_4 { rotate -4 size 1.1 x 0.0870266 y 1.01029 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_1_3 {\n"
u8" SQUARE { }\n"
u8" curveright_1_1_3 { rotate -3 size 1.1 x 0.0780314 y 1.02046 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_1_2 {\n"
u8" SQUARE { }\n"
u8" curveright_1_1_2 { rotate -2 size 1.1 x 0.06886 y 1.03047 }\n"
u8"}\n"
u8"\n"
u8" rule curveright_1_1_1 {\n"
u8" SQUARE { }\n"
u8" curveright_1_1_1 { rotate -1 size 1.1 x 0.0595154 y 1.04032 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_1_0 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_1_0 { rotate 0 size 1.1 x -0.049999 y 1.05 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_1_1 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_1_1 { rotate 1 size 1.1 x -0.059514 y 1.04032 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_1_2 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_1_2 { rotate 2 size 1.1 x -0.0688587 y 1.03047 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_1_3 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_1_3 { rotate 3 size 1.1 x -0.07803 y 1.02046 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_1_4 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_1_4 { rotate 4 size 1.1 x -0.0870253 y 1.0103 }\n"
u8"}\n"
u8"\n"
u8"rule curveleft_1_1_5 {\n"
u8" SQUARE { }\n"
u8" curveleft_1_1_5 { rotate 5 size 1.1 x -0.0958418 y 0.999973 }\n"
u8"}\n"
u8"\n"
u8"\n"
u8"rule test_i_curves {\n"
u8"    test_i_curves_0_9  { x -35 y -40 }\n"
u8"    test_i_curves_0_91 { x   0 y -40 }\n"
u8"    test_i_curves_0_92 { x  35 y -40 }\n"
u8"    test_i_curves_0_93 { x -40 y -20 }\n"
u8"    test_i_curves_0_94 { x   0 y -20 }\n"
u8"    test_i_curves_0_95 { x  40 y -20 }\n"
u8"    test_i_curves_0_96 { x -55 y   0 }\n"
u8"    test_i_curves_0_97 { x   0 y   0 }\n"
u8"    test_i_curves_0_98 { x  55 y   0 }\n"
u8"    test_i_curves_0_99 { x   0 y  40 }\n"
u8"}\n"
u8"\n"
u8"rule test_i_curves_0_9 {\n"
u8"    curveright_0_9_5 { x 10 }\n"
u8"    curveright_0_9_4 { x 8 }\n"
u8"    curveright_0_9_3 { x 6 }\n"
u8"    curveright_0_9_2 { x 4 }\n"
u8"    curveright_0_9_1 { x 2 }\n"
u8"    curveleft_0_9_0 { }\n"
u8"    curveleft_0_9_1 { x -2 }\n"
u8"    curveleft_0_9_2 { x -4 }\n"
u8"    curveleft_0_9_3 { x -6 }\n"
u8"    curveleft_0_9_4 { x -8 }\n"
u8"    curveleft_0_9_5 { x -10 }\n"
u8"}\n"
u8"\n"
u8"rule test_i_curves_0_91 {\n"
u8"    curveright_0_91_5 { x 10 }\n"
u8"    curveright_0_91_4 { x 8 }\n"
u8"    curveright_0_91_3 { x 6 }\n"
u8"    curveright_0_91_2 { x 4 }\n"
u8"    curveright_0_91_1 { x 2 }\n"
u8"    curveleft_0_91_0 { }\n"
u8"    curveleft_0_91_1 { x -2 }\n"
u8"    curveleft_0_91_2 { x -4 }\n"
u8"    curveleft_0_91_3 { x -6 }\n"
u8"    curveleft_0_91_4 { x -8 }\n"
u8"    curveleft_0_91_5 { x -10 }\n"
u8"}\n"
u8"\n"
u8"rule test_i_curves_0_92 {\n"
u8"    curveright_0_92_5 { x 10 }\n"
u8"    curveright_0_92_4 { x 8 }\n"
u8"    curveright_0_92_3 { x 6 }\n"
u8"    curveright_0_92_2 { x 4 }\n"
u8"    curveright_0_92_1 { x 2 }\n"
u8"    curveleft_0_92_0 { }\n"
u8"    curveleft_0_92_1 { x -2 }\n"
u8"    curveleft_0_92_2 { x -4 }\n"
u8"    curveleft_0_92_3 { x -6 }\n"
u8"    curveleft_0_92_4 { x -8 }\n"
u8"    curveleft_0_92_5 { x -10 }\n"
u8"}\n"
u8"\n"
u8"rule test_i_curves_0_93 {\n"
u8"    curveright_0_93_5 { x 10 }\n"
u8"    curveright_0_93_4 { x 8 }\n"
u8"    curveright_0_93_3 { x 6 }\n"
u8"    curveright_0_93_2 { x 4 }\n"
u8"    curveright_0_93_1 { x 2 }\n"
u8"    curveleft_0_93_0 { }\n"
u8"    curveleft_0_93_1 { x -2 }\n"
u8"    curveleft_0_93_2 { x -4 }\n"
u8"    curveleft_0_93_3 { x -6 }\n"
u8"    curveleft_0_93_4 { x -8 }\n"
u8"    curveleft_0_93_5 { x -10 }\n"
u8"}\n"
u8"\n"
u8"rule test_i_curves_0_94 {\n"
u8"    curveright_0_94_5 { x 10 }\n"
u8"    curveright_0_94_4 { x 8 }\n"
u8"    curveright_0_94_3 { x 6 }\n"
u8"    curveright_0_94_2 { x 4 }\n"
u8"    curveright_0_94_1 { x 2 }\n"
u8"    curveleft_0_94_0 { }\n"
u8"    curveleft_0_94_1 { x -2 }\n"
u8"    curveleft_0_94_2 { x -4 }\n"
u8"    curveleft_0_94_3 { x -6 }\n"
u8"    curveleft_0_94_4 { x -8 }\n"
u8"    curveleft_0_94_5 { x -10 }\n"
u8"}\n"
u8"\n"
u8"rule test_i_curves_0_95 {\n"
u8"    curveright_0_95_5 { x 10 }\n"
u8"    curveright_0_95_4 { x 8 }\n"
u8"    curveright_0_95_3 { x 6 }\n"
u8"    curveright_0_95_2 { x 4 }\n"
u8"    curveright_0_95_1 { x 2 }\n"
u8"    curveleft_0_95_0 { }\n"
u8"    curveleft_0_95_1 { x -2 }\n"
u8"    curveleft_0_95_2 { x -4 }\n"
u8"    curveleft_0_95_3 { x -6 }\n"
u8"    curveleft_0_95_4 { x -8 }\n"
u8"    curveleft_0_95_5 { x -10 }\n"
u8"}\n"
u8"\n"
u8"rule test_i_curves_0_96 {\n"
u8"    curveright_0_96_5 { x 10 }\n"
u8"    curveright_0_96_4 { x 8 }\n"
u8"    curveright_0_96_3 { x 6 }\n"
u8"    curveright_0_96_2 { x 4 }\n"
u8"    curveright_0_96_1 { x 2 }\n"
u8"    curveleft_0_96_0 { }\n"
u8"    curveleft_0_96_1 { x -2 }\n"
u8"    curveleft_0_96_2 { x -4 }\n"
u8"    curveleft_0_96_3 { x -6 }\n"
u8"    curveleft_0_96_4 { x -8 }\n"
u8"    curveleft_0_96_5 { x -10 }\n"
u8"}\n"
u8"\n"
u8"rule test_i_curves_0_97 {\n"
u8"    curveright_0_97_5 { x 10 }\n"
u8"    curveright_0_97_4 { x 8 }\n"
u8"    curveright_0_97_3 { x 6 }\n"
u8"    curveright_0_97_2 { x 4 }\n"
u8"    curveright_0_97_1 { x 2 }\n"
u8"    curveleft_0_97_0 { }\n"
u8"    curveleft_0_97_1 { x -2 }\n"
u8"    curveleft_0_97_2 { x -4 }\n"
u8"    curveleft_0_97_3 { x -6 }\n"
u8"    curveleft_0_97_4 { x -8 }\n"
u8"    curveleft_0_97_5 { x -10 }\n"
u8"}\n"
u8"\n"
u8"rule test_i_curves_0_98 {\n"
u8"    curveright_0_98_5 { x 10 }\n"
u8"    curveright_0_98_4 { x 8 }\n"
u8"    curveright_0_98_3 { x 6 }\n"
u8"    curveright_0_98_2 { x 4 }\n"
u8"    curveright_0_98_1 { x 2 }\n"
u8"    curveleft_0_98_0 { }\n"
u8"    curveleft_0_98_1 { x -2 }\n"
u8"    curveleft_0_98_2 { x -4 }\n"
u8"    curveleft_0_98_3 { x -6 }\n"
u8"    curveleft_0_98_4 { x -8 }\n"
u8"    curveleft_0_98_5 { x -10 }\n"
u8"}\n"
u8"\n"
u8"rule test_i_curves_0_99 {\n"
u8"    curveright_0_99_5 { x 10 }\n"
u8"    curveright_0_99_4 { x 8 }\n"
u8"    curveright_0_99_3 { x 6 }\n"
u8"    curveright_0_99_2 { x 4 }\n"
u8"    curveright_0_99_1 { x 2 }\n"
u8"    curveleft_0_99_0 { }\n"
u8"    curveleft_0_99_1 { x -2 }\n"
u8"    curveleft_0_99_2 { x -4 }\n"
u8"    curveleft_0_99_3 { x -6 }\n"
u8"    curveleft_0_99_4 { x -8 }\n"
u8"    curveleft_0_99_5 { x -10 }\n"
u8"}\n"
    } },
    { "i_pix.cfdg", {
u8"// This is a library file that is included in other files\n"
u8"// It offers a dot-matix like alphabet based on a 5 by 5 grid\n"
u8"\n"
u8"startshape the5by5_test\n"
u8"\n"
u8"shape the5by5_test\n"
u8"{\n"
u8"	random_test []\n"
u8"	the5by5_line []\n"
u8"}\n"
u8"\n"
u8"shape random_test\n"
u8"{\n"
u8"	loop 5 [y 1.2] random_test_row [x 24.0 y -21.0]\n"
u8"}\n"
u8"\n"
u8"shape random_test_row\n"
u8"{\n"
u8"	loop 5 [x 1.2] RANDOM_ALNUM_5by5 []\n"
u8"}\n"
u8"\n"
u8"\n"
u8"shape the5by5_line\n"
u8"{\n"
u8"A_5by5 [x 0]\n"
u8"B_5by5 [x 1.2 ]\n"
u8"C_5by5 [x 2.4]\n"
u8"D_5by5 [x 3.6]\n"
u8"E_5by5 [x 4.8]\n"
u8"F_5by5 [x 6.0]\n"
u8"G_5by5 [x 7.2]\n"
u8"H_5by5 [x 8.4]\n"
u8"I_5by5 [x 9.6]\n"
u8"J_5by5 [x 10.8]\n"
u8"K_5by5 [x 12.0]\n"
u8"L_5by5 [x 13.2]\n"
u8"M_5by5 [x 14.4]\n"
u8"N_5by5 [x 15.6]\n"
u8"O_5by5 [x 16.8]\n"
u8"P_5by5 [x 18.0]\n"
u8"Q_5by5 [x 19.2]\n"
u8"R_5by5 [x 20.4]\n"
u8"S_5by5 [x 21.6]\n"
u8"T_5by5 [x 22.8]\n"
u8"U_5by5 [x 24.0]\n"
u8"V_5by5 [x 25.2]\n"
u8"W_5by5 [x 26.4]\n"
u8"X_5by5 [x 27.6]\n"
u8"Y_5by5 [x 28.8]\n"
u8"Z_5by5 [x 30.0]\n"
u8"the5by5_line [y -2.4 size 0.90 x 0.2]\n"
u8"NUM_0_5by5 [y -1.2 x 0]\n"
u8"NUM_1_5by5 [y -1.2 x 1.2]\n"
u8"NUM_2_5by5 [y -1.2 x 2.4]\n"
u8"NUM_3_5by5 [y -1.2 x 3.6]\n"
u8"NUM_4_5by5 [y -1.2 x 4.8]\n"
u8"NUM_5_5by5 [y -1.2 x 6.0]\n"
u8"NUM_6_5by5 [y -1.2 x 7.2]\n"
u8"NUM_7_5by5 [y -1.2 x 8.4]\n"
u8"NUM_8_5by5 [y -1.2 x 9.6]\n"
u8"NUM_9_5by5 [y -1.2 x 10.8]\n"
u8"}\n"
u8"\n"
u8"shape pix_5by5_00\n"
u8"{ block_5by5 [size 0.20 x -0.4 y 0.4] }\n"
u8"shape pix_5by5_10\n"
u8"{ block_5by5 [size 0.20 x -0.2 y 0.4] }\n"
u8"shape pix_5by5_20\n"
u8"{ block_5by5 [size 0.20 x 0.0 y 0.4] }\n"
u8"shape pix_5by5_30\n"
u8"{ block_5by5 [size 0.20 x 0.2 y 0.4] }\n"
u8"shape pix_5by5_40\n"
u8"{ block_5by5 [size 0.20 x 0.4 y 0.4] }\n"
u8"shape pix_5by5_01\n"
u8"{ block_5by5 [size 0.20 x -0.4 y 0.2] }\n"
u8"shape pix_5by5_11\n"
u8"{ block_5by5 [size 0.20 x -0.2 y 0.2] }\n"
u8"shape pix_5by5_21\n"
u8"{ block_5by5 [size 0.20 x 0.0 y 0.2] }\n"
u8"shape pix_5by5_31\n"
u8"{ block_5by5 [size 0.20 x 0.2 y 0.2] }\n"
u8"shape pix_5by5_41\n"
u8"{ block_5by5 [size 0.20 x 0.4 y 0.2] }\n"
u8"shape pix_5by5_02\n"
u8"{ block_5by5 [size 0.20 x -0.4 y 0.0] }\n"
u8"shape pix_5by5_12\n"
u8"{ block_5by5 [size 0.20 x -0.2 y 0.0] }\n"
u8"shape pix_5by5_22\n"
u8"{ block_5by5 [size 0.20 x 0.0 y 0.0] }\n"
u8"shape pix_5by5_32\n"
u8"{ block_5by5 [size 0.20 x 0.2 y 0.0] }\n"
u8"shape pix_5by5_42\n"
u8"{ block_5by5 [size 0.20 x 0.4 y 0.0] }\n"
u8"shape pix_5by5_03\n"
u8"{ block_5by5 [size 0.20 x -0.4 y -0.2] }\n"
u8"shape pix_5by5_13\n"
u8"{ block_5by5 [size 0.20 x -0.2 y -0.2] }\n"
u8"shape pix_5by5_23\n"
u8"{ block_5by5 [size 0.20 x 0.0 y -0.2] }\n"
u8"shape pix_5by5_33\n"
u8"{ block_5by5 [size 0.20 x 0.2 y -0.2] }\n"
u8"shape pix_5by5_43\n"
u8"{ block_5by5 [size 0.20 x 0.4 y -0.2] }\n"
u8"shape pix_5by5_04\n"
u8"{ block_5by5 [size 0.20 x -0.4 y -0.4] }\n"
u8"shape pix_5by5_14\n"
u8"{ block_5by5 [size 0.20 x -0.2 y -0.4] }\n"
u8"shape pix_5by5_24\n"
u8"{ block_5by5 [size 0.20 x 0.0 y -0.4] }\n"
u8"shape pix_5by5_34\n"
u8"{ block_5by5 [size 0.20 x 0.2 y -0.4] }\n"
u8"shape pix_5by5_44\n"
u8"{ block_5by5 [size 0.20 x 0.4 y -0.4] }\n"
u8"\n"
u8"shape block_5by5\n"
u8"{\n"
u8"SQUARE [size 0.7]\n"
u8"}\n"
u8"\n"
u8"shape A_5by5\n"
u8"{\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_44 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_43 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_11 []\n"
u8"pix_5by5_31 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_13 []\n"
u8"pix_5by5_23 []\n"
u8"pix_5by5_33 []\n"
u8"\n"
u8"}\n"
u8"shape B_5by5\n"
u8"{\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_31 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_43 []\n"
u8"}\n"
u8"\n"
u8"shape C_5by5\n"
u8"{\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_44 []\n"
u8"}\n"
u8"shape D_5by5\n"
u8"{\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_43 []\n"
u8"}\n"
u8"shape E_5by5\n"
u8"{\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_44 []\n"
u8"}\n"
u8"\n"
u8"shape F_5by5\n"
u8"{\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_40 []\n"
u8"}\n"
u8"\n"
u8"shape G_5by5\n"
u8"{\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_43 []\n"
u8"}\n"
u8"\n"
u8"shape H_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_43 []\n"
u8"pix_5by5_44 []\n"
u8"}\n"
u8"\n"
u8"shape I_5by5\n"
u8"{\n"
u8"H_5by5 [rotate 90]\n"
u8"}\n"
u8"\n"
u8"\n"
u8"shape J_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_31 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_33 []\n"
u8"pix_5by5_40 []\n"
u8"}\n"
u8"\n"
u8"shape K_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_23 []\n"
u8"pix_5by5_21 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_44 []\n"
u8"pix_5by5_44 []\n"
u8"}\n"
u8"\n"
u8"shape L_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_44 []\n"
u8"\n"
u8"}\n"
u8"\n"
u8"shape M_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_43 []\n"
u8"pix_5by5_44 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_21 []\n"
u8"pix_5by5_30 []\n"
u8"}\n"
u8"\n"
u8"shape N_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_43 []\n"
u8"pix_5by5_44 []\n"
u8"pix_5by5_11 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_33 []\n"
u8"}\n"
u8"\n"
u8"\n"
u8"shape O_5by5\n"
u8"{\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_43 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_34 []\n"
u8"}\n"
u8"\n"
u8"shape P_5by5\n"
u8"{\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_41 []\n"
u8"}\n"
u8"\n"
u8"shape Q_5by5\n"
u8"{\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_33 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_44 []\n"
u8"\n"
u8"}\n"
u8"\n"
u8"shape R_5by5\n"
u8"{\n"
u8"P_5by5[]\n"
u8"pix_5by5_33 []\n"
u8"pix_5by5_44 []\n"
u8"}\n"
u8"\n"
u8"shape S_5by5\n"
u8"{\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_43 []\n"
u8"\n"
u8"}\n"
u8"\n"
u8"shape T_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_21 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_23 []\n"
u8"pix_5by5_24 []\n"
u8"}\n"
u8"\n"
u8"shape U_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_43 []\n"
u8"}\n"
u8"\n"
u8"shape V_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_13 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_33 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_42 []\n"
u8"}\n"
u8"\n"
u8"shape W_5by5\n"
u8"{\n"
u8"M_5by5 [rotate 180]\n"
u8"}\n"
u8"\n"
u8"shape X_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_11 []\n"
u8"pix_5by5_13 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_31 []\n"
u8"pix_5by5_33 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_44 []\n"
u8"}\n"
u8"\n"
u8"shape Y_5by5\n"
u8"{\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_11 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_31 []\n"
u8"pix_5by5_23 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_40 []\n"
u8"}\n"
u8"\n"
u8"shape Z_5by5\n"
u8"{\n"
u8"N_5by5 [rotate 90]\n"
u8"}\n"
u8"\n"
u8"shape RANDOM_LETTER_5by5\n"
u8"rule { A_5by5 []}\n"
u8"rule { B_5by5 []}\n"
u8"rule { C_5by5 []}\n"
u8"rule { D_5by5 []}\n"
u8"rule { E_5by5 []}\n"
u8"rule { F_5by5 []}\n"
u8"rule { G_5by5 []}\n"
u8"rule { H_5by5 []}\n"
u8"rule { I_5by5 []}\n"
u8"rule { J_5by5 []}\n"
u8"rule { K_5by5 []}\n"
u8"rule { L_5by5 []}\n"
u8"rule { M_5by5 []}\n"
u8"rule { N_5by5 []}\n"
u8"rule { O_5by5 []}\n"
u8"rule { P_5by5 []}\n"
u8"rule { Q_5by5 []}\n"
u8"rule { R_5by5 []}\n"
u8"rule { S_5by5 []}\n"
u8"rule { T_5by5 []}\n"
u8"rule { U_5by5 []}\n"
u8"rule { V_5by5 []}\n"
u8"rule { W_5by5 []}\n"
u8"rule { X_5by5 []}\n"
u8"rule { Y_5by5 []}\n"
u8"rule { Z_5by5 []}\n"
u8"\n"
u8"//generate numbers randomly\n"
u8"shape RANDOM_NUMBER_5by5\n"
u8"rule { NUM_0_5by5 [] }\n"
u8"rule { NUM_1_5by5 [] }\n"
u8"rule { NUM_2_5by5 [] }\n"
u8"rule { NUM_3_5by5 [] }\n"
u8"rule { NUM_4_5by5 [] }\n"
u8"rule { NUM_5_5by5 [] }\n"
u8"rule { NUM_6_5by5 [] }\n"
u8"rule { NUM_7_5by5 [] }\n"
u8"rule { NUM_8_5by5 [] }\n"
u8"rule { NUM_9_5by5 [] }\n"
u8"\n"
u8"shape RANDOM_ALNUM_5by5\n"
u8"rule 26 { RANDOM_LETTER_5by5 [] }\n"
u8"rule 10 { RANDOM_NUMBER_5by5 [] }\n"
u8"\n"
u8"\n"
u8"shape NUM_0_5by5\n"
u8"{\n"
u8"//make 0\n"
u8"\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_43 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_31 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_13 []\n"
u8"}\n"
u8"\n"
u8"shape NUM_1_5by5\n"
u8"{\n"
u8"//make 1\n"
u8"\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_21 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_23 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_44 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_10 []\n"
u8"}\n"
u8"\n"
u8"shape NUM_2_5by5\n"
u8"{\n"
u8"//make 2\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_44 []\n"
u8"pix_5by5_13 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_10 []\n"
u8"}\n"
u8"\n"
u8"shape NUM_3_5by5\n"
u8"{\n"
u8"//make 3\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_43 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_10 []\n"
u8"}\n"
u8"\n"
u8"shape NUM_4_5by5\n"
u8"{\n"
u8"//make 4\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_13 []\n"
u8"pix_5by5_23 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_31 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_33 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_43 []\n"
u8"}\n"
u8"\n"
u8"shape NUM_5_5by5\n"
u8"{\n"
u8"//make 5\n"
u8"\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_43 []\n"
u8"}\n"
u8"\n"
u8"shape NUM_6_5by5\n"
u8"{\n"
u8"//make 6\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_02 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_43 []\n"
u8"}\n"
u8"\n"
u8"shape NUM_7_5by5\n"
u8"{\n"
u8"//make 7\n"
u8"\n"
u8"pix_5by5_00 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_23 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_40 []\n"
u8"pix_5by5_41 []\n"
u8"}\n"
u8"\n"
u8"shape NUM_8_5by5\n"
u8"{\n"
u8"//make 8\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_03 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_43 []\n"
u8"pix_5by5_41 []\n"
u8"}\n"
u8"\n"
u8"shape NUM_9_5by5\n"
u8"rule {\n"
u8"//make 9\n"
u8"pix_5by5_01 []\n"
u8"pix_5by5_04 []\n"
u8"pix_5by5_10 []\n"
u8"pix_5by5_12 []\n"
u8"pix_5by5_14 []\n"
u8"pix_5by5_20 []\n"
u8"pix_5by5_22 []\n"
u8"pix_5by5_24 []\n"
u8"pix_5by5_30 []\n"
u8"pix_5by5_32 []\n"
u8"pix_5by5_34 []\n"
u8"pix_5by5_41 []\n"
u8"pix_5by5_42 []\n"
u8"pix_5by5_43 []\n"
u8"}\n"
 ,
u8"// This is a library file that is included in other files\n"
u8"// It offers a dot-matix like alphabet based on a 5 by 5 grid\n"
u8"\n"
u8"startshape the5by5_test\n"
u8"\n"
u8"rule the5by5_test {\n"
u8"	random_test {}\n"
u8"	the5by5_line {}\n"
u8"}\n"
u8"\n"
u8"rule random_test {\n"
u8"	5* {y 1.2} random_test_row {x 24.0 y -21.0}\n"
u8"}\n"
u8"\n"
u8"rule random_test_row {\n"
u8"	5* {x 1.2} RANDOM_ALNUM_5by5 {}\n"
u8"}\n"
u8"\n"
u8"\n"
u8"rule the5by5_line {\n"
u8"A_5by5 {x 0}\n"
u8"B_5by5 {x 1.2 }\n"
u8"C_5by5 {x 2.4}\n"
u8"D_5by5 {x 3.6}\n"
u8"E_5by5 {x 4.8}\n"
u8"F_5by5 {x 6.0}\n"
u8"G_5by5 {x 7.2}\n"
u8"H_5by5 {x 8.4}\n"
u8"I_5by5 {x 9.6}\n"
u8"J_5by5 {x 10.8}\n"
u8"K_5by5 {x 12.0}\n"
u8"L_5by5 {x 13.2}\n"
u8"M_5by5 {x 14.4}\n"
u8"N_5by5 {x 15.6}\n"
u8"O_5by5 {x 16.8}\n"
u8"P_5by5 {x 18.0}\n"
u8"Q_5by5 {x 19.2}\n"
u8"R_5by5 {x 20.4}\n"
u8"S_5by5 {x 21.6}\n"
u8"T_5by5 {x 22.8}\n"
u8"U_5by5 {x 24.0}\n"
u8"V_5by5 {x 25.2}\n"
u8"W_5by5 {x 26.4}\n"
u8"X_5by5 {x 27.6}\n"
u8"Y_5by5 {x 28.8}\n"
u8"Z_5by5 {x 30.0}\n"
u8"the5by5_line {y -2.4 size 0.90 x 0.2}\n"
u8"NUM_0_5by5 {y -1.2 x 0}\n"
u8"NUM_1_5by5 {y -1.2 x 1.2}\n"
u8"NUM_2_5by5 {y -1.2 x 2.4}\n"
u8"NUM_3_5by5 {y -1.2 x 3.6}\n"
u8"NUM_4_5by5 {y -1.2 x 4.8}\n"
u8"NUM_5_5by5 {y -1.2 x 6.0}\n"
u8"NUM_6_5by5 {y -1.2 x 7.2}\n"
u8"NUM_7_5by5 {y -1.2 x 8.4}\n"
u8"NUM_8_5by5 {y -1.2 x 9.6}\n"
u8"NUM_9_5by5 {y -1.2 x 10.8}\n"
u8"}\n"
u8"\n"
u8"rule pix_5by5_00 { block_5by5 {size 0.20 x -0.4 y 0.4} }\n"
u8"rule pix_5by5_10 { block_5by5 {size 0.20 x -0.2 y 0.4} }\n"
u8"rule pix_5by5_20 { block_5by5 {size 0.20 x 0.0 y 0.4} }\n"
u8"rule pix_5by5_30 { block_5by5 {size 0.20 x 0.2 y 0.4} }\n"
u8"rule pix_5by5_40 { block_5by5 {size 0.20 x 0.4 y 0.4} }\n"
u8"rule pix_5by5_01 { block_5by5 {size 0.20 x -0.4 y 0.2} }\n"
u8"rule pix_5by5_11 { block_5by5 {size 0.20 x -0.2 y 0.2} }\n"
u8"rule pix_5by5_21 { block_5by5 {size 0.20 x 0.0 y 0.2} }\n"
u8"rule pix_5by5_31 { block_5by5 {size 0.20 x 0.2 y 0.2} }\n"
u8"rule pix_5by5_41 { block_5by5 {size 0.20 x 0.4 y 0.2} }\n"
u8"rule pix_5by5_02 { block_5by5 {size 0.20 x -0.4 y 0.0} }\n"
u8"rule pix_5by5_12 { block_5by5 {size 0.20 x -0.2 y 0.0} }\n"
u8"rule pix_5by5_22 { block_5by5 {size 0.20 x 0.0 y 0.0} }\n"
u8"rule pix_5by5_32 { block_5by5 {size 0.20 x 0.2 y 0.0} }\n"
u8"rule pix_5by5_42 { block_5by5 {size 0.20 x 0.4 y 0.0} }\n"
u8"rule pix_5by5_03 { block_5by5 {size 0.20 x -0.4 y -0.2} }\n"
u8"rule pix_5by5_13 { block_5by5 {size 0.20 x -0.2 y -0.2} }\n"
u8"rule pix_5by5_23 { block_5by5 {size 0.20 x 0.0 y -0.2} }\n"
u8"rule pix_5by5_33 { block_5by5 {size 0.20 x 0.2 y -0.2} }\n"
u8"rule pix_5by5_43 { block_5by5 {size 0.20 x 0.4 y -0.2} }\n"
u8"rule pix_5by5_04 { block_5by5 {size 0.20 x -0.4 y -0.4} }\n"
u8"rule pix_5by5_14 { block_5by5 {size 0.20 x -0.2 y -0.4} }\n"
u8"rule pix_5by5_24 { block_5by5 {size 0.20 x 0.0 y -0.4} }\n"
u8"rule pix_5by5_34 { block_5by5 {size 0.20 x 0.2 y -0.4} }\n"
u8"rule pix_5by5_44 { block_5by5 {size 0.20 x 0.4 y -0.4} }\n"
u8"\n"
u8"rule block_5by5 {\n"
u8"SQUARE {size 0.7}\n"
u8"}\n"
u8"\n"
u8"rule A_5by5 {\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_44 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_43 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_11 {}\n"
u8"pix_5by5_31 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_13 {}\n"
u8"pix_5by5_23 {}\n"
u8"pix_5by5_33 {}\n"
u8"\n"
u8"}\n"
u8"rule B_5by5 {\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_31 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_43 {}\n"
u8"}\n"
u8"\n"
u8"rule C_5by5 {\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_44 {}\n"
u8"}\n"
u8"rule D_5by5 {\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_43 {}\n"
u8"}\n"
u8"rule E_5by5 {\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_44 {}\n"
u8"}\n"
u8"\n"
u8"rule F_5by5 {\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_40 {}\n"
u8"}\n"
u8"\n"
u8"rule G_5by5 {\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_43 {}\n"
u8"}\n"
u8"\n"
u8"rule H_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_43 {}\n"
u8"pix_5by5_44 {}\n"
u8"}\n"
u8"\n"
u8"rule I_5by5 {\n"
u8"H_5by5 {rotate 90}\n"
u8"}\n"
u8"\n"
u8"\n"
u8"rule J_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_31 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_33 {}\n"
u8"pix_5by5_40 {}\n"
u8"}\n"
u8"\n"
u8"rule K_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_23 {}\n"
u8"pix_5by5_21 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_44 {}\n"
u8"pix_5by5_44 {}\n"
u8"}\n"
u8"\n"
u8"rule L_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_44 {}\n"
u8"\n"
u8"}\n"
u8"\n"
u8"rule M_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_43 {}\n"
u8"pix_5by5_44 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_21 {}\n"
u8"pix_5by5_30 {}\n"
u8"}\n"
u8"\n"
u8"rule N_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_43 {}\n"
u8"pix_5by5_44 {}\n"
u8"pix_5by5_11 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_33 {}\n"
u8"}\n"
u8"\n"
u8"\n"
u8"rule O_5by5 {\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_43 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_34 {}\n"
u8"}\n"
u8"\n"
u8"rule P_5by5 {\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_41 {}\n"
u8"}\n"
u8"\n"
u8"rule Q_5by5 {\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_33 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_44 {}\n"
u8"\n"
u8"}\n"
u8"\n"
u8"rule R_5by5 {\n"
u8"P_5by5{}\n"
u8"pix_5by5_33 {}\n"
u8"pix_5by5_44 {}\n"
u8"}\n"
u8"\n"
u8"rule S_5by5 {\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_43 {}\n"
u8"\n"
u8"}\n"
u8"\n"
u8"rule T_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_21 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_23 {}\n"
u8"pix_5by5_24 {}\n"
u8"}\n"
u8"\n"
u8"rule U_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_43 {}\n"
u8"}\n"
u8"\n"
u8"rule V_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_13 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_33 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_42 {}\n"
u8"}\n"
u8"\n"
u8"rule W_5by5 {\n"
u8"M_5by5 {rotate 180}\n"
u8"}\n"
u8"\n"
u8"rule X_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_11 {}\n"
u8"pix_5by5_13 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_31 {}\n"
u8"pix_5by5_33 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_44 {}\n"
u8"}\n"
u8"\n"
u8"rule Y_5by5 {\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_11 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_31 {}\n"
u8"pix_5by5_23 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_40 {}\n"
u8"}\n"
u8"\n"
u8"rule Z_5by5 {\n"
u8"N_5by5 {rotate 90}\n"
u8"}\n"
u8"\n"
u8"rule RANDOM_LETTER_5by5 { A_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { B_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { C_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { D_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { E_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { F_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { G_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { H_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { I_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { J_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { K_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { L_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { M_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { N_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { O_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { P_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { Q_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { R_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { S_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { T_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { U_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { V_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { W_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { X_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { Y_5by5 {}}\n"
u8"rule RANDOM_LETTER_5by5 { Z_5by5 {}}\n"
u8"\n"
u8"//generate numbers randomly\n"
u8"rule RANDOM_NUMBER_5by5 { NUM_0_5by5 {} }\n"
u8"rule RANDOM_NUMBER_5by5 { NUM_1_5by5 {} }\n"
u8"rule RANDOM_NUMBER_5by5 { NUM_2_5by5 {} }\n"
u8"rule RANDOM_NUMBER_5by5 { NUM_3_5by5 {} }\n"
u8"rule RANDOM_NUMBER_5by5 { NUM_4_5by5 {} }\n"
u8"rule RANDOM_NUMBER_5by5 { NUM_5_5by5 {} }\n"
u8"rule RANDOM_NUMBER_5by5 { NUM_6_5by5 {} }\n"
u8"rule RANDOM_NUMBER_5by5 { NUM_7_5by5 {} }\n"
u8"rule RANDOM_NUMBER_5by5 { NUM_8_5by5 {} }\n"
u8"rule RANDOM_NUMBER_5by5 { NUM_9_5by5 {} }\n"
u8"\n"
u8"rule RANDOM_ALNUM_5by5 26 { RANDOM_LETTER_5by5 {} }\n"
u8"rule RANDOM_ALNUM_5by5 10 { RANDOM_NUMBER_5by5 {} }\n"
u8"\n"
u8"\n"
u8"rule NUM_0_5by5 {\n"
u8"//make 0\n"
u8"\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_43 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_31 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_13 {}\n"
u8"}\n"
u8"\n"
u8"rule NUM_1_5by5 {\n"
u8"//make 1\n"
u8"\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_21 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_23 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_44 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_10 {}\n"
u8"}\n"
u8"\n"
u8"rule NUM_2_5by5 {\n"
u8"//make 2\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_44 {}\n"
u8"pix_5by5_13 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_10 {}\n"
u8"}\n"
u8"\n"
u8"rule NUM_3_5by5 {\n"
u8"//make 3\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_43 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_10 {}\n"
u8"}\n"
u8"\n"
u8"rule NUM_4_5by5 {\n"
u8"//make 4\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_13 {}\n"
u8"pix_5by5_23 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_31 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_33 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_43 {}\n"
u8"}\n"
u8"\n"
u8"rule NUM_5_5by5 {\n"
u8"//make 5\n"
u8"\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_43 {}\n"
u8"}\n"
u8"\n"
u8"rule NUM_6_5by5 {\n"
u8"//make 6\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_02 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_43 {}\n"
u8"}\n"
u8"\n"
u8"rule NUM_7_5by5 {\n"
u8"//make 7\n"
u8"\n"
u8"pix_5by5_00 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_23 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_40 {}\n"
u8"pix_5by5_41 {}\n"
u8"}\n"
u8"\n"
u8"rule NUM_8_5by5 {\n"
u8"//make 8\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_03 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_43 {}\n"
u8"pix_5by5_41 {}\n"
u8"}\n"
u8"\n"
u8"rule NUM_9_5by5 {\n"
u8"//make 9\n"
u8"pix_5by5_01 {}\n"
u8"pix_5by5_04 {}\n"
u8"pix_5by5_10 {}\n"
u8"pix_5by5_12 {}\n"
u8"pix_5by5_14 {}\n"
u8"pix_5by5_20 {}\n"
u8"pix_5by5_22 {}\n"
u8"pix_5by5_24 {}\n"
u8"pix_5by5_30 {}\n"
u8"pix_5by5_32 {}\n"
u8"pix_5by5_34 {}\n"
u8"pix_5by5_41 {}\n"
u8"pix_5by5_42 {}\n"
u8"pix_5by5_43 {}\n"
u8"}\n"
    } },
    { "i_polygons.cfdg", {
u8"startshape polygontest\n"
u8"\n"
u8"// This is kind of a dumb way to define a general regular polygon path.\n"
u8"// But it matches the existing polygon shapes.\n"
u8"path polygon(number sides) {\n"
u8"	MOVETO(	 0.5*cos(180/sides),\n"
u8"			-0.5*sin(180/sides))\n"
u8"	loop sides - 1 [r (360/sides)]\n"
u8"		LINETO(	0.5*cos(180/sides),\n"
u8"				0.5*sin(180/sides))\n"
u8"	CLOSEPOLY()\n"
u8"	FILL[]\n"
u8"}\n"
u8"\n"
u8"shape polygontest\n"
u8"{\n"
u8"	polygonRightTriangle []\n"
u8"	CIRCLE [x 2]\n"
u8"	SQUARE [size 1.0 0.1 x 4 rotate 45]\n"
u8"	TRIANGLE [x 6]\n"
u8"	SQUARE [x 8]\n"
u8"	polygon5sided [x 0 y 2]\n"
u8"	polygon6sided [x 2 y 2]\n"
u8"	polygon7sided [x 4 y 2]\n"
u8"	polygon8sided [x 6 y 2]\n"
u8"	polygon9sided [x 8 y 2]\n"
u8"	polygon10sided [x 0 y 4]\n"
u8"	polygon11sided [x 2 y 4]\n"
u8"	polygon12sided [x 4 y 4]\n"
u8"	polygon13sided [x 6 y 4]\n"
u8"	polygon14sided [x 8 y 4]\n"
u8"	polygon15sided [x 0 y 6]\n"
u8"	polygon16sided [x 2 y 6]\n"
u8"	polygon17sided [x 4 y 6]\n"
u8"	polygon18sided [x 6 y 6]\n"
u8"	polygon19sided [x 8 y 6]\n"
u8"	polygon20sided [x 0 y 8]\n"
u8"	polygon21sided [x 2 y 8]\n"
u8"	polygon22sided [x 4 y 8]\n"
u8"	polygon23sided [x 6 y 8]\n"
u8"	polygon24sided [x 8 y 8]\n"
u8"}\n"
u8"\n"
u8"// This is a unit right triangle\n"
u8"shape polygonRightTriangle\n"
u8"{\n"
u8"	TRIANGLE [[ size 1 1.155 x 0.165 y -0.144 skew 30 0 ]]\n"
u8"}\n"
u8"\n"
u8"\n"
u8"shape polygon5sided\n"
u8"{\n"
u8"	polygon(5)[]\n"
u8"	loop 5 [r 72] SQUARE [[rotate 0 size 0.404509 0.587785 x 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon6sided\n"
u8"{\n"
u8"	loop 3 [r 60] SQUARE [[rotate 0 size 0.866025 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon7sided\n"
u8"{\n"
u8"	loop 7 [r 51.4286] SQUARE [[rotate 0 size 0.450484 0.433884 x 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon8sided\n"
u8"{\n"
u8"	loop 4 [r 45] SQUARE [[rotate 0 size 0.92388 0.382683]]\n"
u8"}\n"
u8"\n"
u8"shape polygon9sided\n"
u8"{\n"
u8"	loop 9 [r 40] SQUARE [[rotate 0 size 0.469846 0.34202 x 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon10sided\n"
u8"{\n"
u8"	loop 5 [r 36] SQUARE [[rotate 0 size 0.951057 0.309017]]\n"
u8"}\n"
u8"\n"
u8"shape polygon11sided\n"
u8"{\n"
u8"	loop 11 [r 32.7273] SQUARE [[rotate 0 size 0.479746 0.281733 x 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon12sided\n"
u8"{\n"
u8"	loop 6 [r 30] SQUARE [[rotate 0 size 0.965926 0.258819]]\n"
u8"}\n"
u8"\n"
u8"shape polygon13sided\n"
u8"{\n"
u8"	loop 13 [r 27.6923] SQUARE [[rotate 0 size 0.485471 0.239316 x 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon14sided\n"
u8"{\n"
u8"	loop 7 [r 25.7143] SQUARE [[rotate 0 size 0.974928 0.222521]]\n"
u8"}\n"
u8"\n"
u8"shape polygon15sided\n"
u8"{\n"
u8"	loop 15 [r 24] SQUARE [[rotate 0 size 0.489074 0.207912 x 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon16sided\n"
u8"{\n"
u8"	loop 8 [r 22.5] SQUARE [[rotate 0 size 0.980785 0.19509]]\n"
u8"}\n"
u8"\n"
u8"shape polygon17sided\n"
u8"{\n"
u8"	loop 17 [r 21.1765] SQUARE [[rotate 0 size 0.491487 0.18375 x 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon18sided\n"
u8"{\n"
u8"	loop 9 [r 20] SQUARE [[rotate 0 size 0.984808 0.173648]]\n"
u8"}\n"
u8"\n"
u8"shape polygon19sided\n"
u8"{\n"
u8"	loop 19 [r 18.9474] SQUARE [[rotate 0 size 0.493181 0.164595 x 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon20sided\n"
u8"{\n"
u8"	loop 10 [r 18] SQUARE [[rotate 0 size 0.987688 0.156434]]\n"
u8"}\n"
u8"\n"
u8"shape polygon21sided\n"
u8"{\n"
u8"	loop 21 [r 17.1429] SQUARE [[rotate 0 size 0.494415 0.149042 x 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon22sided\n"
u8"{\n"
u8"	loop 11 [r 16.3636] SQUARE [[rotate 0 size 0.989821 0.142315]]\n"
u8"}\n"
u8"\n"
u8"shape polygon23sided\n"
u8"{\n"
u8"	loop 23 [r 15.6522] SQUARE [[rotate 0 size 0.495343 0.136167 x 0.5]]\n"
u8"}\n"
u8"\n"
u8"shape polygon24sided\n"
u8"{\n"
u8"	loop 12 [r 15] SQUARE [[rotate 0 size 0.991445 0.130526]]\n"
u8"}\n"
 ,
u8"startshape polygontest\n"
u8"\n"
u8"rule polygontest {\n"
u8"	polygonRightTriangle {}\n"
u8"	CIRCLE {x 2}\n"
u8"	SQUARE {size 1.0 0.1 x 4 rotate 45}\n"
u8"	TRIANGLE {x 6}\n"
u8"	SQUARE {x 8}\n"
u8"	polygon5sided {x 0 y 2}\n"
u8"	polygon6sided {x 2 y 2}\n"
u8"	polygon7sided {x 4 y 2}\n"
u8"	polygon8sided {x 6 y 2}\n"
u8"	polygon9sided {x 8 y 2}\n"
u8"	polygon10sided {x 0 y 4}\n"
u8"	polygon11sided {x 2 y 4}\n"
u8"	polygon12sided {x 4 y 4}\n"
u8"	polygon13sided {x 6 y 4}\n"
u8"	polygon14sided {x 8 y 4}\n"
u8"	polygon15sided {x 0 y 6}\n"
u8"	polygon16sided {x 2 y 6}\n"
u8"	polygon17sided {x 4 y 6}\n"
u8"	polygon18sided {x 6 y 6}\n"
u8"	polygon19sided {x 8 y 6}\n"
u8"	polygon20sided {x 0 y 8}\n"
u8"	polygon21sided {x 2 y 8}\n"
u8"	polygon22sided {x 4 y 8}\n"
u8"	polygon23sided {x 6 y 8}\n"
u8"	polygon24sided {x 8 y 8}\n"
u8"}\n"
u8"\n"
u8"// This is a unit right triangle\n"
u8"rule polygonRightTriangle {\n"
u8"	TRIANGLE [ size 1 1.155 x 0.165 y -0.144 skew 30 0 ]\n"
u8"}\n"
u8"\n"
u8"\n"
u8"rule polygon5sided {\n"
u8"	5* {r 72} SQUARE [rotate 0 size 0.404509 0.587785 x 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon6sided {\n"
u8"	3* {r 60} SQUARE [rotate 0 size 0.866025 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon7sided {\n"
u8"	7* {r 51.4286} SQUARE [rotate 0 size 0.450484 0.433884 x 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon8sided {\n"
u8"	4* {r 45} SQUARE [rotate 0 size 0.92388 0.382683]\n"
u8"}\n"
u8"\n"
u8"rule polygon9sided {\n"
u8"	9* {r 40} SQUARE [rotate 0 size 0.469846 0.34202 x 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon10sided {\n"
u8"	5* {r 36} SQUARE [rotate 0 size 0.951057 0.309017]\n"
u8"}\n"
u8"\n"
u8"rule polygon11sided {\n"
u8"	11* {r 32.7273} SQUARE [rotate 0 size 0.479746 0.281733 x 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon12sided {\n"
u8"	6* {r 30} SQUARE [rotate 0 size 0.965926 0.258819]\n"
u8"}\n"
u8"\n"
u8"rule polygon13sided {\n"
u8"	13* {r 27.6923} SQUARE [rotate 0 size 0.485471 0.239316 x 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon14sided {\n"
u8"	7* {r 25.7143} SQUARE [rotate 0 size 0.974928 0.222521]\n"
u8"}\n"
u8"\n"
u8"rule polygon15sided {\n"
u8"	15* {r 24} SQUARE [rotate 0 size 0.489074 0.207912 x 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon16sided {\n"
u8"	8* {r 22.5} SQUARE [rotate 0 size 0.980785 0.19509]\n"
u8"}\n"
u8"\n"
u8"rule polygon17sided {\n"
u8"	17* {r 21.1765} SQUARE [rotate 0 size 0.491487 0.18375 x 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon18sided {\n"
u8"	9* {r 20} SQUARE [rotate 0 size 0.984808 0.173648]\n"
u8"}\n"
u8"\n"
u8"rule polygon19sided {\n"
u8"	19* {r 18.9474} SQUARE [rotate 0 size 0.493181 0.164595 x 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon20sided {\n"
u8"	10* {r 18} SQUARE [rotate 0 size 0.987688 0.156434]\n"
u8"}\n"
u8"\n"
u8"rule polygon21sided {\n"
u8"	21* {r 17.1429} SQUARE [rotate 0 size 0.494415 0.149042 x 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon22sided {\n"
u8"	11* {r 16.3636} SQUARE [rotate 0 size 0.989821 0.142315]\n"
u8"}\n"
u8"\n"
u8"rule polygon23sided {\n"
u8"	23* {r 15.6522} SQUARE [rotate 0 size 0.495343 0.136167 x 0.5]\n"
u8"}\n"
u8"\n"
u8"rule polygon24sided {\n"
u8"	12* {r 15} SQUARE [rotate 0 size 0.991445 0.130526]\n"
u8"}\n"
    } },
    { "lesson2.cfdg", {
u8"/* CFDG Lesson */\n"
u8"\n"
u8"startshape TOC\n"
u8"\n"
u8"shape TOC\n"
u8"{\n"
u8"    CHAPTER5 [ x 0 y 0 ]\n"
u8"    CHAPTER6 [ x 10 y 0 ]\n"
u8"    CHAPTER7 [ x 0 y -10 ]\n"
u8"    CHAPTER8 [ x 10 y -10 ]\n"
u8"\n"
u8"    TITLES [ ]\n"
u8"}\n"
u8"\n"
u8"shape CHAPTER5\n"
u8"{\n"
u8"    ## SKEW TRANSFORM ##\n"
u8"    SierpinskiTri [ x 2 y 4 size 6.0 ]\n"
u8"    SQUARE [ x 0.5 y 5.5 skew 15 15 size 2 ]\n"
u8"	// a skew transform (also called\n"
u8"	// a shear) pushes a shape parallel\n"
u8"	// to the x axis or y axis or both.\n"
u8"	// The two numbers following\n"
u8"}\n"
u8"\n"
u8"shape SierpinskiTri\n"
u8"{\n"
u8"	polygonRightTriangle [ ]\n"
u8"	hole [ b 1 ]\n"
u8"}\n"
u8"\n"
u8"shape hole\n"
u8"{\n"
u8"	polygonRightTriangle [ size -0.495 x 0.25 y -0.25 ]\n"
u8"	hole [ b -0.2 size 0.5 x -0.25 y -0.25 ]\n"
u8"	hole [ b -0.2 size 0.5 x  0.25 y -0.25 ]\n"
u8"	hole [ b -0.2 size 0.5 x  0.25 y  0.25 ]\n"
u8"}\n"
u8"\n"
u8"shape polygonRightTriangle\n"
u8"{\n"
u8"	TRIANGLE [[ size 1 1.155 x 0.165 y -0.144 skew 30 0 ]]\n"
u8"}\n"
u8"\n"
u8"shape CHAPTER6\n"
u8" {\n"
u8"    ## FLIP TRANSFORM ##\n"
u8"    HEART [ x 2 y 1 size 0.12 0.1]\n"
u8"	// A flip transform reflects a\n"
u8"	// shape across a line at the\n"
u8"	// specified angle.\n"
u8"}\n"
u8"\n"
u8"import i_curves.cfdg\n"
u8"\n"
u8"shape HEART\n"
u8"{\n"
u8"    curveright_0_99_1 [ r 64 ]\n"
u8"    curveright_0_99_1 [ flip 90 r -64 ]\n"
u8"    HEART [ s 0.9 y 2.5 ]\n"
u8"}\n"
u8"\n"
u8"shape CHAPTER7\n"
u8"{\n"
u8"    ## TRANSFORM ORDERING ##\n"
u8"    TranSquare [ s 0.5 x 1 y 5 ]\n"
u8"    TranCircle [ s 0.5 x 1 y 3 ]\n"
u8"    TranTriangle [ s 0.5 x -1 y 1 ]\n"
u8"    SquareLine [ x -1 y 7 ]\n"
u8"	// When transforms are in curly\n"
u8"	// braces then they are applied\n"
u8"	// in a fixed order:\n"
u8"	// 1) Translate\n"
u8"	// 2) Rotate\n"
u8"	// 3) Scale\n"
u8"	// 4) Skew\n"
u8"	// 5) Reflect\n"
u8"	// Only one transform of each\n"
u8"	// type is allowed (all but the\n"
u8"	// last are ignored).\n"
u8"\n"
u8"	// When transforms are in square\n"
u8"	// braces then they are applied\n"
u8"	// in the order they are found\n"
u8"	// and there can be multiple\n"
u8"	// occurrences of a given type\n"
u8"	// of transform.\n"
u8"}\n"
u8"\n"
u8"shape TranSquare\n"
u8"{\n"
u8"    SQUARE [[ r 45 x 4 s 3 ]]\n"
u8"    SQUARE [[ b 0.2 x 4 s 3 ]]\n"
u8"    SQUARE [[ b 0.4 x 4 ]]\n"
u8"    SQUARE [[ b 0.7 ]]\n"
u8"	// Ordering a rotate before a\n"
u8"	// translate (x or y) causes the\n"
u8"	// translate to be rotated. This\n"
u8"	// saves\n"
u8"}\n"
u8"shape TranCircle\n"
u8"{\n"
u8"    Ellipse [[ x 4 r 45 s 3 ]]\n"
u8"    Ellipse [[ b 0.2 r 45 s 3 ]]\n"
u8"    Ellipse [[ b 0.4 s 3  ]]\n"
u8"    Ellipse [[ b 0.7 ]]\n"
u8"	// This happens to be the order\n"
u8"	// that CF uses when the transforms\n"
u8"	// are enclosed in curly braces.\n"
u8"}\n"
u8"shape TranTriangle\n"
u8"{\n"
u8"    TRIANGLE [[ s 3 x 4 r 45 ]]\n"
u8"    TRIANGLE [[ b 0.2 x 4 r 45 ]]\n"
u8"    TRIANGLE [[ b 0.4 r 45 ]]\n"
u8"    TRIANGLE [[ b 0.7 ]]\n"
u8"	// Putting the scale before the\n"
u8"	// translate scales the translate\n"
u8"	// as well\n"
u8"}\n"
u8"shape SquareLine\n"
u8"{\n"
u8"	SQUARE []\n"
u8"	SquareLine [[ y -0.5 s 0.75 y -0.5 ]]\n"
u8"	// Transforms can be specified\n"
u8"	// more than once and subsequent\n"
u8"	// transforms are modified by the\n"
u8"	// ones before them. In the above\n"
u8"	// idiom the squares are always\n"
u8"	// just touching, even when you\n"
u8"	// change the scale amount.\n"
u8"}\n"
u8"shape Ellipse\n"
u8"{\n"
u8"	CIRCLE [ s 1 0.5 ]\n"
u8"}\n"
u8"\n"
u8"\n"
u8"\n"
u8"shape CHAPTER8\n"
u8" {\n"
u8"    ## COLOR ##\n"
u8"	// Coming soon.\n"
u8"}\n"
u8"\n"
u8"\n"
u8"\n"
u8"## Utilities ##\n"
u8"import i_pix.cfdg\n"
u8"// The \"include\" statement reads\n"
u8"// in all the rules from another file.\n"
u8"// Any \"startshape\" in the included\n"
u8"// file is ignored.\n"
u8"\n"
u8"shape TITLES\n"
u8"{\n"
u8"	TITLE5 [ x 0 y 8.5 ]\n"
u8"	TITLE6 [ x 10 y 8.5 ]\n"
u8"	TITLE7 [ x 0 y -1.5 ]\n"
u8"	TITLE8 [ x 10 y -1.5 ]\n"
u8"}\n"
u8"shape TITLE5\n"
u8"{\n"
u8"	F_5by5 [ x 0 ]\n"
u8"	I_5by5 [ x 1.2 ]\n"
u8"	V_5by5 [ x 2.4 ]\n"
u8"	E_5by5 [ x 3.6 ]\n"
u8"}\n"
u8"shape TITLE6\n"
u8"{\n"
u8"	S_5by5 [ x 0 ]\n"
u8"	I_5by5 [ x 1.2 ]\n"
u8"	X_5by5 [ x 2.4 ]\n"
u8"}\n"
u8"shape TITLE7\n"
u8"{\n"
u8"	S_5by5 [ x 0 ]\n"
u8"	E_5by5 [ x 1.2 ]\n"
u8"	V_5by5 [ x 2.4 ]\n"
u8"	E_5by5 [ x 3.6 ]\n"
u8"	N_5by5 [ x 4.8 ]\n"
u8"}\n"
u8"shape TITLE8\n"
u8"{\n"
u8"	E_5by5 [ x 0 ]\n"
u8"	I_5by5 [ x 1.2 ]\n"
u8"	G_5by5 [ x 2.4 ]\n"
u8"	H_5by5 [ x 3.6 ]\n"
u8"	T_5by5 [ x 4.8 ]\n"
u8"}\n"
 ,
u8"/* CFDG Lesson */\n"
u8"\n"
u8"startshape TOC\n"
u8"\n"
u8"rule TOC {\n"
u8"    CHAPTER5 { x 0 y 0 }\n"
u8"    CHAPTER6 { x 10 y 0 }\n"
u8"    CHAPTER7 { x 0 y -10 }\n"
u8"    CHAPTER8 { x 10 y -10 }\n"
u8"\n"
u8"    TITLES { }\n"
u8"}\n"
u8"\n"
u8"rule CHAPTER5 {\n"
u8"    ## SKEW TRANSFORM ##\n"
u8"    SierpinskiTri { x 2 y 4 size 6.0 }\n"
u8"    SQUARE { x 0.5 y 5.5 skew 15 15 size 2 }\n"
u8"	// a skew transform (also called\n"
u8"	// a shear) pushes a shape parallel\n"
u8"	// to the x axis or y axis or both.\n"
u8"	// The two numbers following\n"
u8"}\n"
u8"\n"
u8"rule SierpinskiTri {\n"
u8"	polygonRightTriangle { }\n"
u8"	hole { b 1 }\n"
u8"}\n"
u8"\n"
u8"rule hole {\n"
u8"	polygonRightTriangle { size -0.495 x 0.25 y -0.25 }\n"
u8"	hole { b -0.2 size 0.5 x -0.25 y -0.25 }\n"
u8"	hole { b -0.2 size 0.5 x  0.25 y -0.25 }\n"
u8"	hole { b -0.2 size 0.5 x  0.25 y  0.25 }\n"
u8"}\n"
u8"\n"
u8"rule polygonRightTriangle {\n"
u8"	TRIANGLE [ size 1 1.155 x 0.165 y -0.144 skew 30 0 ]\n"
u8"}\n"
u8"\n"
u8"rule CHAPTER6 {\n"
u8"    ## FLIP TRANSFORM ##\n"
u8"    HEART { x 2 y 1 size 0.12 0.1}\n"
u8"	// A flip transform reflects a\n"
u8"	// shape across a line at the\n"
u8"	// specified angle.\n"
u8"}\n"
u8"\n"
u8"include i_curves.cfdg\n"
u8"\n"
u8"rule HEART {\n"
u8"    curveright_0_99_1 { r 64 }\n"
u8"    curveright_0_99_1 { flip 90 r -64 }\n"
u8"    HEART { s 0.9 y 2.5 }\n"
u8"}\n"
u8"\n"
u8"rule CHAPTER7 {\n"
u8"    ## TRANSFORM ORDERING ##\n"
u8"    TranSquare { s 0.5 x 1 y 5 }\n"
u8"    TranCircle { s 0.5 x 1 y 3 }\n"
u8"    TranTriangle { s 0.5 x -1 y 1 }\n"
u8"    SquareLine { x -1 y 7 }\n"
u8"	// When transforms are in curly\n"
u8"	// braces then they are applied\n"
u8"	// in a fixed order:\n"
u8"	// 1) Translate\n"
u8"	// 2) Rotate\n"
u8"	// 3) Scale\n"
u8"	// 4) Skew\n"
u8"	// 5) Reflect\n"
u8"	// Only one transform of each\n"
u8"	// type is allowed (all but the\n"
u8"	// last are ignored).\n"
u8"\n"
u8"	// When transforms are in square\n"
u8"	// braces then they are applied\n"
u8"	// in the order they are found\n"
u8"	// and there can be multiple\n"
u8"	// occurrences of a given type\n"
u8"	// of transform.\n"
u8"}\n"
u8"\n"
u8"rule TranSquare {\n"
u8"    SQUARE [ r 45 x 4 s 3 ]\n"
u8"    SQUARE [ b 0.2 x 4 s 3 ]\n"
u8"    SQUARE [ b 0.4 x 4 ]\n"
u8"    SQUARE [ b 0.7 ]\n"
u8"	// Ordering a rotate before a\n"
u8"	// translate (x or y) causes the\n"
u8"	// translate to be rotated. This\n"
u8"	// saves\n"
u8"}\n"
u8"rule TranCircle {\n"
u8"    Ellipse [ x 4 r 45 s 3 ]\n"
u8"    Ellipse [ b 0.2 r 45 s 3 ]\n"
u8"    Ellipse [ b 0.4 s 3  ]\n"
u8"    Ellipse [ b 0.7 ]\n"
u8"	// This happens to be the order\n"
u8"	// that CF uses when the transforms\n"
u8"	// are enclosed in curly braces.\n"
u8"}\n"
u8"rule TranTriangle {\n"
u8"    TRIANGLE [ s 3 x 4 r 45 ]\n"
u8"    TRIANGLE [ b 0.2 x 4 r 45 ]\n"
u8"    TRIANGLE [ b 0.4 r 45 ]\n"
u8"    TRIANGLE [ b 0.7 ]\n"
u8"	// Putting the scale before the\n"
u8"	// translate scales the translate\n"
u8"	// as well\n"
u8"}\n"
u8"rule SquareLine {\n"
u8"	SQUARE {}\n"
u8"	SquareLine [ y -0.5 s 0.75 y -0.5 ]\n"
u8"	// Transforms can be specified\n"
u8"	// more than once and subsequent\n"
u8"	// transforms are modified by the\n"
u8"	// ones before them. In the above\n"
u8"	// idiom the squares are always\n"
u8"	// just touching, even when you\n"
u8"	// change the scale amount.\n"
u8"}\n"
u8"rule Ellipse {\n"
u8"	CIRCLE { s 1 0.5 }\n"
u8"}\n"
u8"\n"
u8"\n"
u8"\n"
u8"rule CHAPTER8 {\n"
u8"    ## COLOR ##\n"
u8"	// Coming soon.\n"
u8"}\n"
u8"\n"
u8"\n"
u8"\n"
u8"## Utilities ##\n"
u8"include i_pix.cfdg\n"
u8"// The \"include\" statement reads\n"
u8"// in all the rules from another file.\n"
u8"// Any \"startshape\" in the included\n"
u8"// file is ignored.\n"
u8"\n"
u8"rule TITLES {\n"
u8"	TITLE5 { x 0 y 8.5 }\n"
u8"	TITLE6 { x 10 y 8.5 }\n"
u8"	TITLE7 { x 0 y -1.5 }\n"
u8"	TITLE8 { x 10 y -1.5 }\n"
u8"}\n"
u8"rule TITLE5 {\n"
u8"	F_5by5 { x 0 }\n"
u8"	I_5by5 { x 1.2 }\n"
u8"	V_5by5 { x 2.4 }\n"
u8"	E_5by5 { x 3.6 }\n"
u8"}\n"
u8"rule TITLE6 {\n"
u8"	S_5by5 { x 0 }\n"
u8"	I_5by5 { x 1.2 }\n"
u8"	X_5by5 { x 2.4 }\n"
u8"}\n"
u8"rule TITLE7 {\n"
u8"	S_5by5 { x 0 }\n"
u8"	E_5by5 { x 1.2 }\n"
u8"	V_5by5 { x 2.4 }\n"
u8"	E_5by5 { x 3.6 }\n"
u8"	N_5by5 { x 4.8 }\n"
u8"}\n"
u8"rule TITLE8 {\n"
u8"	E_5by5 { x 0 }\n"
u8"	I_5by5 { x 1.2 }\n"
u8"	G_5by5 { x 2.4 }\n"
u8"	H_5by5 { x 3.6 }\n"
u8"	T_5by5 { x 4.8 }\n"
u8"}\n"
    } },
    { "lesson.cfdg", {
u8"/* CFDG Lesson */\n"
u8"\n"
u8"startshape TOC\n"
u8"	// each grammar file must\n"
u8"	// have a \"startshape\"\n"
u8"	// statement to say which\n"
u8"	// shape to begin with\n"
u8"\n"
u8"shape TOC\n"
u8"{\n"
u8"	// a \"rule\" statement says how\n"
u8"	// to compose a shape out of\n"
u8"	// other shapes\n"
u8"\n"
u8"    CHAPTER1 [ x 0 y 0 ]\n"
u8"    CHAPTER2 [ x 10 y 0 ]\n"
u8"    CHAPTER3 [ x 0 y -10 ]\n"
u8"    CHAPTER4 [ x 10 y -10 ]\n"
u8"	// each entry in the rule\n"
u8"	// names a shape to draw and\n"
u8"	// some \"adjustments\" in curly\n"
u8"	// braces\n"
u8"\n"
u8"    TITLES [ ]\n"
u8"}\n"
u8"\n"
u8"shape CHAPTER1\n"
u8"{\n"
u8"    ## BASIC SHAPES ##\n"
u8"    SQUARE [ x 2 y 5 size 3 ]\n"
u8"    CIRCLE [ x 6 y 5 size 3 ]\n"
u8"    TRIANGLE [ x 4 y 2 size 3 ]\n"
u8"	// these shapes are special:\n"
u8"	// they draw a shape into the\n"
u8"	// image, centered at the\n"
u8"	// current location\n"
u8"    SHAPES [ y 1 size 3 ]\n"
u8"	// This tells you the relative\n"
u8"	// sizes and positions of each\n"
u8"	// basic shape.\n"
u8"}\n"
u8"\n"
u8"shape SHAPES\n"
u8"{\n"
u8"	SQUARE []\n"
u8"	CIRCLE [b 0.3]\n"
u8"	TRIANGLE [b 0.5]\n"
u8"	TRIANGLE [r 60 b 0.7]\n"
u8"}\n"
u8"\n"
u8"shape CHAPTER2\n"
u8"{\n"
u8"    ## BASIC ADJUSTMENTS ##\n"
u8"    SQUARE [ ]\n"
u8"	// empty adjustments\n"
u8"	// this is the lone square in\n"
u8"	// chapter 2's area\n"
u8"\n"
u8"    SQUARE [ x 3 y 7 ]\n"
u8"	// adjust location\n"
u8"\n"
u8"	// even though adjustments\n"
u8"	// are written after the shape\n"
u8"	// they are applied before!\n"
u8"\n"
u8"    SQUARE [ x 5 y 7 rotate 30 ]\n"
u8"	// adjust rotation\n"
u8"    SQUARE [ x 3 y 5 size 0.75 ]\n"
u8"	// adjust size\n"
u8"\n"
u8"	// notice that rotation and size\n"
u8"	// are adjusted after location\n"
u8"\n"
u8"    SQUARE [ x 5 y 5\n"
u8"        brightness 0.5 ]\n"
u8"	// adjust brightness\n"
u8"\n"
u8"    SQUARE [ x 7 y 6\n"
u8"	// shorthands:\n"
u8"        r 45 // for rotate\n"
u8"        s 0.7 // for size\n"
u8"        b 0.7 // for brightness\n"
u8"    ]\n"
u8"\n"
u8"    FOURSQUARE [ x 5 y 1\n"
u8"        size 0.2 rotate 10 ]\n"
u8"	// adjustments are cumulative\n"
u8"}\n"
u8"shape FOURSQUARE\n"
u8"{\n"
u8"    SQUARE [ x 0 y 0 size 5  3]\n"
u8"    SQUARE [ x 0 y 5 size 2 4 ]\n"
u8"    SQUARE [ x 5 y 5 size 3 ]\n"
u8"    SQUARE [ x 5 y 0 size 2 ]\n"
u8"	// even though these are\n"
u8"	// at locations and sizes\n"
u8"	// that seem big, they have\n"
u8"	// all been relocated, scaled\n"
u8"	// and rotated when the rule\n"
u8"	// for CHAPTER2 used\n"
u8"	// FOURSQUARE\n"
u8"	// Two SQUAREs have been\n"
u8"	// have been turned into\n"
u8"	// rectangles\n"
u8"}\n"
u8"\n"
u8"shape CHAPTER3\n"
u8"{\n"
u8"    ## RECURSION ##\n"
u8"    SPIRAL [ x 0 y 3 ]\n"
u8"}\n"
u8"shape SPIRAL\n"
u8"{\n"
u8"    CIRCLE [ size 0.5 ]\n"
u8"    SPIRAL [ y 0.2\n"
u8"         rotate -3\n"
u8"         size 0.995 ]\n"
u8"	// a shape can use itself so\n"
u8"	// long as it keeps getting\n"
u8"	// smaller\n"
u8"\n"
u8"	// the system will stop the\n"
u8"	// recursion when the shapes\n"
u8"	// get too small to see\n"
u8"}\n"
u8"\n"
u8"shape CHAPTER4\n"
u8"{\n"
u8"    ## RANDOMNESS ##\n"
u8"    TREE [ x 1 y 0 ]\n"
u8"    TREE [ x 6 y 0 ]\n"
u8"    TREE [ x 1 y 4 ]\n"
u8"    TREE [ x 6 y 4 ]\n"
u8"	// even though these are the\n"
u8"	// same shape used four\n"
u8"	// times, each looks different\n"
u8"}\n"
u8"shape TREE\n"
u8"rule 20 {\n"
u8"	// first rule for TREE\n"
u8"    CIRCLE [ size 0.25 ]\n"
u8"    TREE [ y 0.1 size 0.97 ]\n"
u8"}\n"
u8"rule 1.5 {\n"
u8"	// second rule for TREE\n"
u8"    BRANCH [  ]\n"
u8"}\n"
u8"// When expanding a TREE, a\n"
u8"// rule is picked randomly.\n"
u8"// The first rule has been given a\n"
u8"// weight of 20, the second of 1.5,\n"
u8"// so the first will be picked\n"
u8"// proportionally more often\n"
u8"\n"
u8"shape BRANCH\n"
u8"{\n"
u8"    BRANCH_LEFT [ ]\n"
u8"    BRANCH_RIGHT [ ]\n"
u8"}\n"
u8"shape BRANCH_LEFT\n"
u8"rule {\n"
u8"    TREE [ rotate 20 ]\n"
u8"}\n"
u8"rule {\n"
u8"    TREE [ rotate 30 ]\n"
u8"}\n"
u8"rule {\n"
u8"    TREE [ rotate 40 ]\n"
u8"}\n"
u8"rule {\n"
u8"	// empty rules are okay\n"
u8"}\n"
u8"// If no weight is given for a rule\n"
u8"// the weight is 1.  Hence, the\n"
u8"// above four rules are picked\n"
u8"// equally randomly\n"
u8"\n"
u8"shape BRANCH_RIGHT\n"
u8"rule {\n"
u8"    TREE [ rotate -20 ]\n"
u8"}\n"
u8"rule {\n"
u8"    TREE [ rotate -30 ]\n"
u8"}\n"
u8"rule {\n"
u8"    TREE [ rotate -40 ]\n"
u8"}\n"
u8"rule {\n"
u8"	// empty rules are okay\n"
u8"}\n"
u8"\n"
u8"\n"
u8"\n"
u8"## Utilities ##\n"
u8"import i_pix.cfdg\n"
u8"// The \"include\" statement reads\n"
u8"// in all the rules from another file.\n"
u8"// Any \"startshape\" in the included\n"
u8"// file is ignored.\n"
u8"\n"
u8"shape TITLES\n"
u8"{\n"
u8"	TITLE1 [ x 0 y 8.5 ]\n"
u8"	TITLE2 [ x 10 y 8.5 ]\n"
u8"	TITLE3 [ x 0 y -1.5 ]\n"
u8"	TITLE4 [ x 10 y -1.5 ]\n"
u8"}\n"
u8"shape TITLE1\n"
u8"{\n"
u8"	O_5by5 [ x 0 ]\n"
u8"	N_5by5 [ x 1.2 ]\n"
u8"	E_5by5 [ x 2.4 ]\n"
u8"}\n"
u8"shape TITLE2\n"
u8"{\n"
u8"	T_5by5 [ x 0 ]\n"
u8"	W_5by5 [ x 1.2 ]\n"
u8"	O_5by5 [ x 2.4 ]\n"
u8"}\n"
u8"shape TITLE3\n"
u8"{\n"
u8"	T_5by5 [ x 0 ]\n"
u8"	H_5by5 [ x 1.2 ]\n"
u8"	R_5by5 [ x 2.4 ]\n"
u8"	E_5by5 [ x 3.6 ]\n"
u8"	E_5by5 [ x 4.8 ]\n"
u8"}\n"
u8"shape TITLE4\n"
u8"{\n"
u8"	F_5by5 [ x 0 ]\n"
u8"	O_5by5 [ x 1.2 ]\n"
u8"	U_5by5 [ x 2.4 ]\n"
u8"	R_5by5 [ x 3.6 ]\n"
u8"}\n"
 ,
u8"/* CFDG Lesson */\n"
u8"\n"
u8"startshape TOC\n"
u8"	// each grammar file must\n"
u8"	// have a \"startshape\"\n"
u8"	// statement to say which\n"
u8"	// shape to begin with\n"
u8"\n"
u8"rule TOC {\n"
u8"	// a \"rule\" statement says how\n"
u8"	// to compose a shape out of\n"
u8"	// other shapes\n"
u8"\n"
u8"    CHAPTER1 { x 0 y 0 }\n"
u8"    CHAPTER2 { x 10 y 0 }\n"
u8"    CHAPTER3 { x 0 y -10 }\n"
u8"    CHAPTER4 { x 10 y -10 }\n"
u8"	// each entry in the rule\n"
u8"	// names a shape to draw and\n"
u8"	// some \"adjustments\" in curly\n"
u8"	// braces\n"
u8"\n"
u8"    TITLES { }\n"
u8"}\n"
u8"\n"
u8"rule CHAPTER1 {\n"
u8"    ## BASIC SHAPES ##\n"
u8"    SQUARE { x 2 y 5 size 3 }\n"
u8"    CIRCLE { x 6 y 5 size 3 }\n"
u8"    TRIANGLE { x 4 y 2 size 3 }\n"
u8"	// these shapes are special:\n"
u8"	// they draw a shape into the\n"
u8"	// image, centered at the\n"
u8"	// current location\n"
u8"    SHAPES { y 1 size 3 }\n"
u8"	// This tells you the relative\n"
u8"	// sizes and positions of each\n"
u8"	// basic shape.\n"
u8"}\n"
u8"\n"
u8"rule SHAPES {\n"
u8"	SQUARE {}\n"
u8"	CIRCLE {b 0.3}\n"
u8"	TRIANGLE {b 0.5}\n"
u8"	TRIANGLE {r 60 b 0.7}\n"
u8"}\n"
u8"\n"
u8"rule CHAPTER2 {\n"
u8"    ## BASIC ADJUSTMENTS ##\n"
u8"    SQUARE { }\n"
u8"	// empty adjustments\n"
u8"	// this is the lone square in\n"
u8"	// chapter 2's area\n"
u8"\n"
u8"    SQUARE { x 3 y 7 }\n"
u8"	// adjust location\n"
u8"\n"
u8"	// even though adjustments\n"
u8"	// are written after the shape\n"
u8"	// they are applied before!\n"
u8"\n"
u8"    SQUARE { x 5 y 7 rotate 30 }\n"
u8"	// adjust rotation\n"
u8"    SQUARE { x 3 y 5 size 0.75 }\n"
u8"	// adjust size\n"
u8"\n"
u8"	// notice that rotation and size\n"
u8"	// are adjusted after location\n"
u8"\n"
u8"    SQUARE { x 5 y 5\n"
u8"        brightness 0.5 }\n"
u8"	// adjust brightness\n"
u8"\n"
u8"    SQUARE { x 7 y 6\n"
u8"	// shorthands:\n"
u8"        r 45 // for rotate\n"
u8"        s 0.7 // for size\n"
u8"        b 0.7 // for brightness\n"
u8"    }\n"
u8"\n"
u8"    FOURSQUARE { x 5 y 1\n"
u8"        size 0.2 rotate 10 }\n"
u8"	// adjustments are cumulative\n"
u8"}\n"
u8"rule FOURSQUARE {\n"
u8"    SQUARE { x 0 y 0 size 5  3}\n"
u8"    SQUARE { x 0 y 5 size 2 4 }\n"
u8"    SQUARE { x 5 y 5 size 3 }\n"
u8"    SQUARE { x 5 y 0 size 2 }\n"
u8"	// even though these are\n"
u8"	// at locations and sizes\n"
u8"	// that seem big, they have\n"
u8"	// all been relocated, scaled\n"
u8"	// and rotated when the rule\n"
u8"	// for CHAPTER2 used\n"
u8"	// FOURSQUARE\n"
u8"	// Two SQUAREs have been\n"
u8"	// have been turned into\n"
u8"	// rectangles\n"
u8"}\n"
u8"\n"
u8"rule CHAPTER3 {\n"
u8"    ## RECURSION ##\n"
u8"    SPIRAL { x 0 y 3 }\n"
u8"}\n"
u8"rule SPIRAL {\n"
u8"    CIRCLE { size 0.5 }\n"
u8"    SPIRAL { y 0.2\n"
u8"         rotate -3\n"
u8"         size 0.995 }\n"
u8"	// a shape can use itself so\n"
u8"	// long as it keeps getting\n"
u8"	// smaller\n"
u8"\n"
u8"	// the system will stop the\n"
u8"	// recursion when the shapes\n"
u8"	// get too small to see\n"
u8"}\n"
u8"\n"
u8"rule CHAPTER4 {\n"
u8"    ## RANDOMNESS ##\n"
u8"    TREE { x 1 y 0 }\n"
u8"    TREE { x 6 y 0 }\n"
u8"    TREE { x 1 y 4 }\n"
u8"    TREE { x 6 y 4 }\n"
u8"	// even though these are the\n"
u8"	// same shape used four\n"
u8"	// times, each looks different\n"
u8"}\n"
u8"rule TREE 20 {\n"
u8"	// first rule for TREE\n"
u8"    CIRCLE { size 0.25 }\n"
u8"    TREE { y 0.1 size 0.97 }\n"
u8"}\n"
u8"rule TREE 1.5 {\n"
u8"	// second rule for TREE\n"
u8"    BRANCH {  }\n"
u8"}\n"
u8"// When expanding a TREE, a\n"
u8"// rule is picked randomly.\n"
u8"// The first rule has been given a\n"
u8"// weight of 20, the second of 1.5,\n"
u8"// so the first will be picked\n"
u8"// proportionally more often\n"
u8"\n"
u8"rule BRANCH {\n"
u8"    BRANCH_LEFT { }\n"
u8"    BRANCH_RIGHT { }\n"
u8"}\n"
u8"rule BRANCH_LEFT {\n"
u8"    TREE { rotate 20 }\n"
u8"}\n"
u8"rule BRANCH_LEFT {\n"
u8"    TREE { rotate 30 }\n"
u8"}\n"
u8"rule BRANCH_LEFT {\n"
u8"    TREE { rotate 40 }\n"
u8"}\n"
u8"rule BRANCH_LEFT {\n"
u8"	// empty rules are okay\n"
u8"}\n"
u8"// If no weight is given for a rule\n"
u8"// the weight is 1.  Hence, the\n"
u8"// above four rules are picked\n"
u8"// equally randomly\n"
u8"\n"
u8"rule BRANCH_RIGHT {\n"
u8"    TREE { rotate -20 }\n"
u8"}\n"
u8"rule BRANCH_RIGHT {\n"
u8"    TREE { rotate -30 }\n"
u8"}\n"
u8"rule BRANCH_RIGHT {\n"
u8"    TREE { rotate -40 }\n"
u8"}\n"
u8"rule BRANCH_RIGHT {\n"
u8"	// empty rules are okay\n"
u8"}\n"
u8"\n"
u8"\n"
u8"\n"
u8"## Utilities ##\n"
u8"include i_pix.cfdg\n"
u8"// The \"include\" statement reads\n"
u8"// in all the rules from another file.\n"
u8"// Any \"startshape\" in the included\n"
u8"// file is ignored.\n"
u8"\n"
u8"rule TITLES {\n"
u8"	TITLE1 { x 0 y 8.5 }\n"
u8"	TITLE2 { x 10 y 8.5 }\n"
u8"	TITLE3 { x 0 y -1.5 }\n"
u8"	TITLE4 { x 10 y -1.5 }\n"
u8"}\n"
u8"rule TITLE1 {\n"
u8"	O_5by5 { x 0 }\n"
u8"	N_5by5 { x 1.2 }\n"
u8"	E_5by5 { x 2.4 }\n"
u8"}\n"
u8"rule TITLE2 {\n"
u8"	T_5by5 { x 0 }\n"
u8"	W_5by5 { x 1.2 }\n"
u8"	O_5by5 { x 2.4 }\n"
u8"}\n"
u8"rule TITLE3 {\n"
u8"	T_5by5 { x 0 }\n"
u8"	H_5by5 { x 1.2 }\n"
u8"	R_5by5 { x 2.4 }\n"
u8"	E_5by5 { x 3.6 }\n"
u8"	E_5by5 { x 4.8 }\n"
u8"}\n"
u8"rule TITLE4 {\n"
u8"	F_5by5 { x 0 }\n"
u8"	O_5by5 { x 1.2 }\n"
u8"	U_5by5 { x 2.4 }\n"
u8"	R_5by5 { x 3.6 }\n"
u8"}\n"
    } },
    { "mtree.cfdg", {
u8"startshape PLANT\n"
u8"\n"
u8"shape PLANT\n"
u8"{\n"
u8"	EITHER [x -2]\n"
u8"	EITHER [x 2]\n"
u8"}\n"
u8"\n"
u8"shape BOTH\n"
u8"{\n"
u8"	BL [rotate 30]\n"
u8"	BL [rotate -30 flip 90]\n"
u8"}\n"
u8"\n"
u8"shape EITHER\n"
u8"rule {BL[]}\n"
u8"rule {BL[flip 90]}\n"
u8"\n"
u8"shape BL\n"
u8"{\n"
u8"	CIRCLE []\n"
u8"	WL [size 0.95 y 1.6]\n"
u8"}\n"
u8"\n"
u8"shape WL\n"
u8"rule 10 {BL [rotate randint(3, 8)]}\n"
u8"rule {BOTH []}\n"
u8"rule {BL [rotate -10 flip 90]}\n"
u8"\n"
 ,
u8"startshape PLANT\n"
u8"\n"
u8"rule PLANT {\n"
u8"	EITHER {x -2}\n"
u8"	EITHER {x 2}\n"
u8"}\n"
u8"\n"
u8"rule BOTH {\n"
u8"	BL {rotate 30}\n"
u8"	BL {rotate -30 flip 90}\n"
u8"}\n"
u8"\n"
u8"rule EITHER {BL{}}\n"
u8"rule EITHER {BL{flip 90}}\n"
u8"\n"
u8"rule BL {\n"
u8"	CIRCLE {}\n"
u8"	WL {size 0.95 y 1.6}\n"
u8"}\n"
u8"\n"
u8"rule WL {BL {rotate 3}}\n"
u8"rule WL {BL {rotate 4}}\n"
u8"rule WL {BL {rotate 5}}\n"
u8"rule WL {BL {rotate 6}}\n"
u8"rule WL {BL {rotate 7}}\n"
u8"rule WL {BL {rotate 3}}\n"
u8"rule WL {BL {rotate 4}}\n"
u8"rule WL {BL {rotate 5}}\n"
u8"rule WL {BL {rotate 6}}\n"
u8"rule WL {BL {rotate 7}}\n"
u8"rule WL {BOTH {}}\n"
u8"rule WL {BL {rotate -10 flip 90}}\n"
u8"\n"
    } },
    { "octopi.cfdg", {
u8"startshape family\n"
u8"\n"
u8"shape family\n"
u8"{\n"
u8"octopus []\n"
u8"family [x 10 y 2 s 0.3 r -10]\n"
u8"family [x 0 y 10 s 0.3 r 10]\n"
u8"\n"
u8"}\n"
u8"\n"
u8"shape octopus\n"
u8"{\n"
u8"octopus_leg1 [r 90 s 0.7]\n"
u8"octopus_leg1 [r 100]\n"
u8"octopus_leg1 [r 80]\n"
u8"octopus_leg1 [r 110]\n"
u8"octopus_leg1 [r 180 s 0.7 flip 90]\n"
u8"octopus_leg1 [r 190 flip 90]\n"
u8"octopus_leg1 [r 170 flip 90]\n"
u8"octopus_leg1 [r 200 flip 90]\n"
u8"CIRCLE [s 5 x 2 y 2]\n"
u8"CIRCLE [s 5 x 2.5 y 2.5]\n"
u8"CIRCLE [s 5 x 3 y 3]\n"
u8"CIRCLE [b 1 x 1 y 3]\n"
u8"CIRCLE [b 1 x 3 y 2]\n"
u8"CIRCLE [s 0.7 x 1.1 y 2.9]\n"
u8"CIRCLE [s 0.7 x 2.9 y 1.9]\n"
u8"}\n"
u8"\n"
u8"shape octopus_leg1\n"
u8"{\n"
u8"unit []\n"
u8"octopus_leg1 [x 1 y 1 r 10 s 0.95]\n"
u8"octopus_leg1 [s 0.2 x 1 y 1 r 90]\n"
u8"}\n"
u8"\n"
u8"shape unit\n"
u8"{\n"
u8"seed []\n"
u8"seed [r 90]\n"
u8"}\n"
u8"\n"
u8"shape seed\n"
u8"{\n"
u8"CIRCLE [x -0.5]\n"
u8"SQUARE []\n"
u8"CIRCLE [x 0.5]\n"
u8"}\n"
 ,
u8"startshape family\n"
u8"\n"
u8"rule family {\n"
u8"octopus {}\n"
u8"family {x 10 y 2 s 0.3 r -10}\n"
u8"family {x 0 y 10 s 0.3 r 10}\n"
u8"\n"
u8"}\n"
u8"\n"
u8"rule octopus {\n"
u8"octopus_leg1 {r 90 s 0.7}\n"
u8"octopus_leg1 {r 100}\n"
u8"octopus_leg1 {r 80}\n"
u8"octopus_leg1 {r 110}\n"
u8"octopus_leg1 {r 180 s 0.7 flip 90}\n"
u8"octopus_leg1 {r 190 flip 90}\n"
u8"octopus_leg1 {r 170 flip 90}\n"
u8"octopus_leg1 {r 200 flip 90}\n"
u8"CIRCLE {s 5 x 2 y 2}\n"
u8"CIRCLE {s 5 x 2.5 y 2.5}\n"
u8"CIRCLE {s 5 x 3 y 3}\n"
u8"CIRCLE {b 1 x 1 y 3}\n"
u8"CIRCLE {b 1 x 3 y 2}\n"
u8"CIRCLE {s 0.7 x 1.1 y 2.9}\n"
u8"CIRCLE {s 0.7 x 2.9 y 1.9}\n"
u8"}\n"
u8"\n"
u8"rule octopus_leg1 {\n"
u8"unit {}\n"
u8"octopus_leg1 {x 1 y 1 r 10 s 0.95}\n"
u8"octopus_leg1 {s 0.2 x 1 y 1 r 90}\n"
u8"}\n"
u8"\n"
u8"rule unit {\n"
u8"seed {}\n"
u8"seed {r 90}\n"
u8"}\n"
u8"\n"
u8"rule seed {\n"
u8"CIRCLE {x -0.5}\n"
u8"SQUARE {}\n"
u8"CIRCLE {x 0.5}\n"
u8"}\n"
    } },
    { "quadcity.cfdg", {
u8"startshape WHOLE\n"
u8"\n"
u8"shape WHOLE\n"
u8"{\n"
u8"	QUAD [ x -0.5 y -0.5 ]\n"
u8"	QUAD [ x  0.5 y -0.5 ]\n"
u8"	QUAD [ x  0.5 y  0.5 ]\n"
u8"	QUAD [ x -0.5 y  0.5 ]\n"
u8"}\n"
u8"\n"
u8"shape QUAD\n"
u8"rule {\n"
u8"	FILLIT [ ]\n"
u8"}\n"
u8"rule 5 {\n"
u8"	WHOLE [ size 0.45 r 2 ]\n"
u8"}\n"
u8"rule 0.5 {\n"
u8"	// nothing\n"
u8"}\n"
u8"\n"
u8"shape FILLIT\n"
u8"{\n"
u8"	SQUARE [\n"
u8"		size 0.8\n"
u8"	]\n"
u8"}\n"
 ,
u8"startshape WHOLE\n"
u8"\n"
u8"rule WHOLE {\n"
u8"	QUAD { x -0.5 y -0.5 }\n"
u8"	QUAD { x  0.5 y -0.5 }\n"
u8"	QUAD { x  0.5 y  0.5 }\n"
u8"	QUAD { x -0.5 y  0.5 }\n"
u8"}\n"
u8"\n"
u8"rule QUAD {\n"
u8"	FILL { }\n"
u8"}\n"
u8"rule QUAD 5 {\n"
u8"	WHOLE { size 0.45 r 2 }\n"
u8"}\n"
u8"rule QUAD 0.5 {\n"
u8"	// nothing\n"
u8"}\n"
u8"\n"
u8"rule FILL {\n"
u8"	SQUARE {\n"
u8"		size 0.8\n"
u8"	}\n"
u8"}\n"
    } },
    { "rose.cfdg", {
u8"startshape plant\n"
u8"\n"
u8"shape rose1\n"
u8"{\n"
u8"   loop 4 [r 90] petal [r -15\u202615 x 0.9 s 0.9 1.8]\n"
u8"   rose1 [ r 14 s 0.92 hue 0.12 60  ]\n"
u8"}\n"
u8"\n"
u8"\n"
u8"shape petal\n"
u8"{\n"
u8"	CIRCLE []\n"
u8"	CIRCLE [ s 0.975 x -0.025 hue 0.1 60  ]\n"
u8"	CIRCLE [ s 0.95 x -0.05 hue 0.2 60  ]\n"
u8"	CIRCLE [ s 0.925 x -0.075 hue 0.3 60  ]\n"
u8"	CIRCLE [ s 0.90 x -0.10 hue 0.4 60  ]\n"
u8"}\n"
u8"\n"
u8"shape stem\n"
u8"{\n"
u8"	CIRCLE [s 2 6 r -15 y -3 x -.5]\n"
u8"	CIRCLE [s 2 6 r -15 y -3 x -0.35 sat -1 b 1]\n"
u8"	leaf [[ y -4 x -1.625 r 30 s 0.15 ]]\n"
u8"	leaf [[ y -4 x -1.625 flip 80 r 30 s 0.15 ]]\n"
u8"}\n"
u8"\n"
u8"shape plant\n"
u8"{\n"
u8"	rose1 [ b 1 sat 1]\n"
u8"	stem [ b 0.4 sat 1 hue 120 z -1]\n"
u8"}\n"
u8"\n"
u8"shape leaf\n"
u8"{\n"
u8"	loop 4 [[y 0.5 s 0.95 y 0.5 r 1]]\n"
u8"		SQUARE []\n"
u8"	finally {\n"
u8"		CIRCLE [[r 7 s 7.5 15 y 0.5]]\n"
u8"		CIRCLE [[r 7 s 7.5 15 b 0.2 y 0.5 s 0.80 0.90]]\n"
u8"		leaf []\n"
u8"	}\n"
u8"}\n"
 ,
u8"startshape plant\n"
u8"\n"
u8"rule rose1 {\n"
u8"   4* {r 90} petal {}\n"
u8"   rose1 { r 14 s 0.92 hue 0.12| }\n"
u8"}\n"
u8"\n"
u8"\n"
u8"rule petal {\n"
u8"   petal1 {r 15 x 0.9 s 0.9 1.8}\n"
u8"}\n"
u8"\n"
u8"rule petal {\n"
u8"   petal1 {r -15 x 0.9 s 0.9 1.8}\n"
u8"}\n"
u8"\n"
u8"rule petal1 {\n"
u8"	CIRCLE {}\n"
u8"	CIRCLE { s 0.975 x -0.025 hue 0.1| }\n"
u8"	CIRCLE { s 0.95 x -0.05 hue 0.2| }\n"
u8"	CIRCLE { s 0.925 x -0.075 hue 0.3| }\n"
u8"	CIRCLE { s 0.90 x -0.10 hue 0.4| }\n"
u8"}\n"
u8"\n"
u8"rule stem {\n"
u8"	CIRCLE {s 2 6 r -15 y -3 x -.5}\n"
u8"	CIRCLE {s 2 6 r -15 y -3 x -0.35 sat -1 b 1}\n"
u8"	leaf { r 30 y -3 x -2.2 }\n"
u8"	leaf { r -45 y -3.15 x -0.8  }\n"
u8"}\n"
u8"\n"
u8"rule leaf {\n"
u8"	CIRCLE [s 0.75 2 y 0.25]\n"
u8"	CIRCLE [s 0.75 2 b 0.2 y 0.25 s 0.80 0.90]\n"
u8"	TRIANGLE [y -0.25 s 0.1 3 ]\n"
u8"	leaf { s 0.86 y 0.25 }\n"
u8"}\n"
u8"\n"
u8"rule plant {\n"
u8"	rose1 { b 1 sat 1 |hue 60}\n"
u8"	stem { b 0.4 sat 1 hue 120}\n"
u8"}\n"
    } },
    { "sierpinski.cfdg", {
u8"startshape Top\n"
u8"\n"
u8"shape Top\n"
u8"{\n"
u8"	Sierpinski [ r -13.5 b 0.5 ]\n"
u8"}\n"
u8"\n"
u8"shape SierpinskiOrig\n"
u8"{\n"
u8"	Shape [ ]\n"
u8"	Sierpinski [ s 0.5 r 5\n"
u8"		y -1 x 0  ]\n"
u8"	Sierpinski [  s 0.5 r 5\n"
u8"		y 0.5 x -0.866025  ]\n"
u8"	Sierpinski [ s 0.5 r 5\n"
u8"		y 0.5 x 0.866025  ]\n"
u8"}\n"
u8"shape Sierpinski\n"
u8"{\n"
u8"	Shape [ ]\n"
u8"	Sierpinski [ s 0.6 r 5 b 0.2\n"
u8"		y -1.5 x 0  ]\n"
u8"	Sierpinski [  s 0.6 r 5 b -0.2\n"
u8"		y 0.75 x -1.2990375  ]\n"
u8"	Sierpinski [ s 0.6 r 5\n"
u8"		y 0.75 x 1.2990375  ]\n"
u8"}\n"
u8"\n"
u8"# comment out all but one of these rules for Shape:\n"
u8"shape Shape\n"
u8"{ CIRCLE [ ] }\n"
u8"#rule Shape { Triangle { s 0.5 } }\n"
u8"#rule Shape { Triangle { } }\n"
u8"	// this last one fills the image\n"
u8"\n"
u8"shape Triangle\n"
u8"{\n"
u8"	Arm [ r 0 ]\n"
u8"	Arm [ r 120 ]\n"
u8"	Arm [ r -120 ]\n"
u8"}\n"
u8"\n"
u8"shape Arm\n"
u8"{\n"
u8"	CIRCLE [ ]\n"
u8"	Arm [ y 0.1 s 0.9 ]\n"
u8"}\n"
 ,
u8"startshape Top\n"
u8"\n"
u8"rule Top {\n"
u8"	Sierpinski { r -13.5 b 0.5 }\n"
u8"}\n"
u8"\n"
u8"rule SierpinskiOrig {\n"
u8"	Shape { }\n"
u8"	Sierpinski { s 0.5 r 5\n"
u8"		y -1 x 0  }\n"
u8"	Sierpinski {  s 0.5 r 5\n"
u8"		y 0.5 x -0.866025  }\n"
u8"	Sierpinski { s 0.5 r 5\n"
u8"		y 0.5 x 0.866025  }\n"
u8"}\n"
u8"rule Sierpinski {\n"
u8"	Shape { }\n"
u8"	Sierpinski { s 0.6 r 5 b 0.2\n"
u8"		y -1.5 x 0  }\n"
u8"	Sierpinski {  s 0.6 r 5 b -0.2\n"
u8"		y 0.75 x -1.2990375  }\n"
u8"	Sierpinski { s 0.6 r 5\n"
u8"		y 0.75 x 1.2990375  }\n"
u8"}\n"
u8"\n"
u8"# comment out all but one of these rules for Shape:\n"
u8"rule Shape { CIRCLE { } }\n"
u8"#rule Shape { Triangle { s 0.5 } }\n"
u8"#rule Shape { Triangle { } }\n"
u8"	// this last one fills the image\n"
u8"\n"
u8"rule Triangle {\n"
u8"	Arm { r 0 }\n"
u8"	Arm { r 120 }\n"
u8"	Arm { r -120 }\n"
u8"}\n"
u8"\n"
u8"rule Arm {\n"
u8"	CIRCLE { }\n"
u8"	Arm { y 0.1 s 0.9 }\n"
u8"}\n"
    } },
    { "snowflake.cfdg", {
u8"startshape SPIKE\n"
u8"\n"
u8"CF::Symmetry = CF::Dihedral, 6\n"
u8"\n"
u8"shape SPIKE\n"
u8"rule {\n"
u8"	SQUARE []\n"
u8"	SPIKE [y 0.95 s 0.97]\n"
u8"}\n"
u8"rule 0.03 {\n"
u8"	SQUARE []\n"
u8"	SPIKE [r 60]\n"
u8"	SPIKE [r -60]\n"
u8"	SPIKE [y 0.95 s 0.97]\n"
u8"}\n"
 ,
u8"startshape SNOWFLAKE\n"
u8"\n"
u8"rule SNOWFLAKE {\n"
u8"	6* {r 60} SPIKE {}\n"
u8"}\n"
u8"\n"
u8"rule SPIKE {\n"
u8"	SQUARE {}\n"
u8"	SPIKE { y 0.95 s 0.97 }\n"
u8"}\n"
u8"rule SPIKE 0.03 {\n"
u8"	SQUARE {}\n"
u8"	SPIKE { r 60 }\n"
u8"	SPIKE { r -60 }\n"
u8"	SPIKE { y 0.95 s 0.97  }\n"
u8"}\n"
    } },
    { "tangle.cfdg", {
u8"startshape SPIKES\n"
u8"\n"
u8"shape SPIKES\n"
u8"{\n"
u8"	loop 4 [r 90] SPIKE []\n"
u8"}\n"
u8"\n"
u8"shape SPIKE\n"
u8"rule {\n"
u8"	LSPIKE []\n"
u8"}\n"
u8"rule {\n"
u8"	LSPIKE [ flip 90 ]\n"
u8"}\n"
u8"\n"
u8"shape LSPIKE\n"
u8"rule {\n"
u8"	SQUARE []\n"
u8"	LSPIKE [ y 0.98 s 0.99 r 1]\n"
u8"}\n"
u8"rule 0.01 {\n"
u8"	SPIKE [ r 90 ]\n"
u8"	SPIKE [ r -90 ]\n"
u8"	LSPIKE [ y 0.98 s 0.99  r 1]\n"
u8"}\n"
 ,
u8"startshape SPIKES\n"
u8"\n"
u8"rule SPIKES {\n"
u8"	4* {r 90} SPIKE {}\n"
u8"}\n"
u8"\n"
u8"rule SPIKE {\n"
u8"	LSPIKE {}\n"
u8"}\n"
u8"rule SPIKE {\n"
u8"	LSPIKE { flip 90 }\n"
u8"}\n"
u8"\n"
u8"rule LSPIKE {\n"
u8"	SQUARE {}\n"
u8"	LSPIKE { y 0.98 s 0.99 r 1}\n"
u8"}\n"
u8"rule LSPIKE 0.01 {\n"
u8"	SPIKE { r 90 }\n"
u8"	SPIKE { r -90 }\n"
u8"	LSPIKE { y 0.98 s 0.99  r 1}\n"
u8"}\n"
    } },
    { "triples.cfdg", {
u8"startshape TRIPLES\n"
u8"\n"
u8"shape TRIPLES\n"
u8"{\n"
u8"	LINES [ r 0 ]\n"
u8"	LINES [ r 120 ]\n"
u8"	LINES [ r -120 ]\n"
u8"}\n"
u8"\n"
u8"shape LINES\n"
u8"{\n"
u8"	UTRIANGLE [ y 0.5 ]\n"
u8"	LINES [ r 20 b 0.15 y 0.75 x -0.4330125  s 0.754877 ]\n"
u8"	LINER [ r -60 b 0.15 y 0.75 x 0.4330125  s 0.754877 ]\n"
u8"}\n"
u8"\n"
u8"shape LINER\n"
u8"{\n"
u8"	UTRIANGLE [ y 0.5 ]\n"
u8"	LINER [ r -15\u2026-6 b 0.02\n"
u8"		y 0.75 x 0.4330125  s 0.754877 ]\n"
u8"}\n"
u8"\n"
u8"// 0.754877 is the solution to\n"
u8"// x^2 + x^3 = 1\n"
u8"// this allows double backed\n"
u8"// triangles to exactly line up!\n"
u8"\n"
u8"\n"
u8"shape TESTU\n"
u8"{\n"
u8"	TESTU_background [ ]\n"
u8"	UTRIANGLE [ ]\n"
u8"	UTRIANGLE [ y 0.5 x -0.866025 b 0.5 r 60 ]\n"
u8"	UTRIANGLE [ y 0.5 x +0.866025 b 0.5 r 60 ]\n"
u8"}\n"
u8"shape TESTU_background\n"
u8"{\n"
u8"	CIRCLE [  b 0.5 ]\n"
u8"	CIRCLE  [ y -1 ]\n"
u8"	CIRCLE [ y -0.5 x -0.866025 ]\n"
u8"	CIRCLE [ y -0.5 x 0.866025 ]\n"
u8"	CIRCLE [ y 0.5 x -0.866025 ]\n"
u8"	CIRCLE [ y 0.5 x 0.866025 ]\n"
u8"	CIRCLE  [ y 1 ]\n"
u8"}\n"
u8"\n"
u8"shape UTRIANGLE\n"
u8"{\n"
u8"	transform [ r 42.5 s 0.525 ] {\n"
u8"		ARM [ r 0 ]\n"
u8"		ARM [ r 120 ]\n"
u8"		ARM [ r -120 ]\n"
u8"	}\n"
u8"}\n"
u8"\n"
u8"shape ARM\n"
u8"{\n"
u8"	CIRCLE [ ]\n"
u8"	ARM [ y 0.1 s 0.9 r 2 ]\n"
u8"}\n"
 ,
u8"startshape TRIPLES\n"
u8"\n"
u8"rule TRIPLES {\n"
u8"	LINES { r 0 }\n"
u8"	LINES { r 120 }\n"
u8"	LINES { r -120 }\n"
u8"}\n"
u8"\n"
u8"rule LINES {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINES { r 20 b 0.15 y 0.75 x -0.4330125  s 0.754877 }\n"
u8"	LINER { r -60 b 0.15 y 0.75 x 0.4330125  s 0.754877 }\n"
u8" }\n"
u8"rule LINER { LINER15 { } }\n"
u8"rule LINER { LINER12 { } }\n"
u8"rule LINER { LINER9 { } }\n"
u8"rule LINER { LINER6 { } }\n"
u8"rule LINER15 {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINER { r -15 b 0.02\n"
u8"		y 0.75 x 0.4330125  s 0.754877 }\n"
u8" }\n"
u8"rule LINER12 {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINER { r -12 b 0.02\n"
u8"		y 0.75 x 0.4330125  s 0.754877 }\n"
u8" }\n"
u8"rule LINER9 {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINER { r -9 b 0.02\n"
u8"		y 0.75 x 0.4330125  s 0.754877 }\n"
u8" }\n"
u8"rule LINER6 {\n"
u8"	UTRIANGLE { y 0.5 }\n"
u8"	LINER { r -6 b 0.02\n"
u8"		y 0.75 x 0.4330125  s 0.754877 }\n"
u8" }\n"
u8"\n"
u8"// 0.754877 is the solution to\n"
u8"// x^2 + x^3 = 1\n"
u8"// this allows double backed\n"
u8"// triangles to exactly line up!\n"
u8"\n"
u8"\n"
u8"rule TESTU {\n"
u8"	TESTU_background { }\n"
u8"	UTRIANGLE { }\n"
u8"	UTRIANGLE { y 0.5 x -0.866025 b 0.5 r 60 }\n"
u8"	UTRIANGLE { y 0.5 x +0.866025 b 0.5 r 60 }\n"
u8"}\n"
u8"rule TESTU_background {\n"
u8"	CIRCLE {  b 0.5 }\n"
u8"	CIRCLE  { y -1 }\n"
u8"	CIRCLE { y -0.5 x -0.866025 }\n"
u8"	CIRCLE { y -0.5 x 0.866025 }\n"
u8"	CIRCLE { y 0.5 x -0.866025 }\n"
u8"	CIRCLE { y 0.5 x 0.866025 }\n"
u8"	CIRCLE  { y 1 }\n"
u8"}\n"
u8"\n"
u8"rule UTRIANGLE {\n"
u8"	TRIANGLE { r 42.5 s 0.525 }\n"
u8"}\n"
u8"rule TRIANGLE{\n"
u8"	ARM { r 0 }\n"
u8"	ARM { r 120 }\n"
u8"	ARM { r -120 }\n"
u8"}\n"
u8"\n"
u8"rule ARM {\n"
u8"	CIRCLE { }\n"
u8"	ARM { y 0.1 s 0.9 r 2 }\n"
u8"}\n"
    } },
    { "underground.cfdg", {
u8"startshape MAP\n"
u8"\n"
u8"shape MAP\n"
u8"{\n"
u8"	LOGO [ ]\n"
u8"	ROUTE [ x 80 y 80 rotate 90 ]\n"
u8"}\n"
u8"\n"
u8"shape ROUTE\n"
u8"rule {\n"
u8"	LINES [ brightness 0.2 ]\n"
u8"}\n"
u8"rule {\n"
u8"	LINES [ brightness -0.2 ]\n"
u8"}\n"
u8"shape LINES\n"
u8"{\n"
u8"	LINE [ ]\n"
u8"	LINE [ rotate 180 ]\n"
u8"}\n"
u8"\n"
u8"shape LINE\n"
u8"rule 1000 {\n"
u8"	CIRCLE [ ]\n"
u8"	LINE [ y 0.1 ]\n"
u8"}\n"
u8"// turns\n"
u8"rule 1 { LINE [ rotate 45 ] }\n"
u8"rule 1 { LINE [ rotate -45 ] }\n"
u8"rule 1 { LINE [ rotate 90 ] }\n"
u8"rule 1 { LINE [ rotate -90 ] }\n"
u8"\n"
u8"// station\n"
u8"rule 4 {\n"
u8"	SQUARE [\n"
u8"		size 3\n"
u8"		rotate 45\n"
u8"	]\n"
u8"	LINE [ ]\n"
u8"}\n"
u8"\n"
u8"// interchange\n"
u8"rule 0.5 {\n"
u8"	LINE [ ]\n"
u8"	ROUTE [ rotate 90 ]\n"
u8"}\n"
u8"\n"
u8"// terminus\n"
u8"rule 1 {\n"
u8"	CIRCLE [ size 3 ]\n"
u8"	CIRCLE [ size 1\n"
u8"		brightness 1 ]\n"
u8"}\n"
u8"\n"
u8"shape LOGO\n"
u8"{\n"
u8"	CIRCLE [\n"
u8"		size 5\n"
u8"		brightness 0.5\n"
u8"	]\n"
u8"	CIRCLE [\n"
u8"		size 3.5\n"
u8"		brightness 1.0\n"
u8"	]\n"
u8"	SQUARE [ s 6 1 ]\n"
u8"}\n"
 ,
u8"startshape MAP\n"
u8"\n"
u8"rule MAP {\n"
u8"	LOGO { }\n"
u8"	ROUTE { x 80 y 80 rotate 90 }\n"
u8"}\n"
u8"\n"
u8"rule ROUTE {\n"
u8"	LINES { brightness 0.2 }\n"
u8"}\n"
u8"rule ROUTE {\n"
u8"	LINES { brightness -0.2 }\n"
u8"}\n"
u8"rule LINES {\n"
u8"	LINE { }\n"
u8"	LINE { rotate 180 }\n"
u8"}\n"
u8"\n"
u8"rule LINE 1000 {\n"
u8"	CIRCLE { }\n"
u8"	LINE { y 0.1 }\n"
u8"}\n"
u8"// turns\n"
u8"rule LINE 1 { LINE { rotate 45 } }\n"
u8"rule LINE 1 { LINE { rotate -45 } }\n"
u8"rule LINE 1 { LINE { rotate 90 } }\n"
u8"rule LINE 1 { LINE { rotate -90 } }\n"
u8"\n"
u8"// station\n"
u8"rule LINE 4 {\n"
u8"	SQUARE {\n"
u8"		size 3\n"
u8"		rotate 45\n"
u8"	}\n"
u8"	LINE { }\n"
u8"}\n"
u8"\n"
u8"// interchange\n"
u8"rule LINE 0.5 {\n"
u8"	LINE { }\n"
u8"	ROUTE { rotate 90 }\n"
u8"}\n"
u8"\n"
u8"// terminus\n"
u8"rule LINE 1 {\n"
u8"	CIRCLE { size 3 }\n"
u8"	CIRCLE { size 1\n"
u8"		brightness 1 }\n"
u8"}\n"
u8"\n"
u8"rule LOGO {\n"
u8"	CIRCLE {\n"
u8"		size 5\n"
u8"		brightness 0.5\n"
u8"	}\n"
u8"	CIRCLE {\n"
u8"		size 3.5\n"
u8"		brightness 1.0\n"
u8"	}\n"
u8"	SQUARE { x -2.5 }\n"
u8"	SQUARE { x -1.5 }\n"
u8"	SQUARE { x -0.5 }\n"
u8"	SQUARE { x  0.5 }\n"
u8"	SQUARE { x  1.5 }\n"
u8"	SQUARE { x  2.5 }\n"
u8"	SQUARE { x -2.0 }\n"
u8"	SQUARE { x -1.0 }\n"
u8"	SQUARE { x  0 }\n"
u8"	SQUARE { x  1.0 }\n"
u8"	SQUARE { x  2.0 }\n"
u8"}\n"
    } },
    { "weighting_demo.cfdg", {
u8"startshape SEED1\n"
u8"\n"
u8"shape SEED1\n"
u8"rule {\n"
u8" SQUARE[]\n"
u8" SEED1 [y 1.2 size 0.99 rotate 1.5 brightness 0.03]\n"
u8"}\n"
u8"\n"
u8"rule 0.05 {SEED1 [flip 90]}\n"
u8"\n"
u8"rule 0.05 {\n"
u8" SQUARE[]\n"
u8" SEED1 [y 1.2 s 0.99 r 1.5 b -0.5 flip 90]\n"
u8" SEED1 [y 1.2 x 1.2 s 0.6 r -60 b -0.5]\n"
u8" SEED1 [y 1.2 x -1.2 s 0.5 r 60 b -0.5 flip 90]\n"
u8"}\n"
u8"\n"
 ,
u8"startshape SEED1\n"
u8"\n"
u8"rule SEED1 {\n"
u8" SQUARE{}\n"
u8" SEED1 {y 1.2 size 0.99 rotate 1.5 brightness 0.03}\n"
u8"}\n"
u8"\n"
u8"rule SEED1 0.05 {SEED1 {flip 90}}\n"
u8"\n"
u8"rule SEED1 0.05 {\n"
u8" SQUARE{}\n"
u8" SEED1 {y 1.2 s 0.99 r 1.5 b -0.5 flip 90}\n"
u8" SEED1 {y 1.2 x 1.2 s 0.6 r -60 b -0.5}\n"
u8" SEED1 {y 1.2 x -1.2 s 0.5 r 60 b -0.5 flip 90}\n"
u8"}\n"
u8"\n"
    } },
    { "welcome.cfdg", {
u8"startshape WELCOME\n"
u8"\n"
u8"shape WELCOME\n"
u8"{\n"
u8"	MESSAGE [ hue 225 sat 0.7 b 0.6 ]\n"
u8"	VINEL [ sat 1 hue 120\n"
u8"		x 3 y -55\n"
u8"		r 0 b 0.5 s 10\n"
u8"	]\n"
u8"	VINEL [ flip 90\n"
u8"		sat 1 hue 120\n"
u8"		x 85 y -55\n"
u8"		r 0 b 0.5 s 10\n"
u8"	]\n"
u8"}\n"
u8"\n"
u8"shape MESSAGE\n"
u8"{\n"
u8"	W [ x 0 ]\n"
u8"	E [ x 12 ]\n"
u8"	L [ x 24 ]\n"
u8"	C [ x 34 ]\n"
u8"	O [ x 46 ]\n"
u8"	M [ x 64 ]\n"
u8"	E [ x 80 ]\n"
u8"}\n"
u8"\n"
u8"shape W\n"
u8"{\n"
u8"	LINE [ r -7 ]\n"
u8"	LINE [ r 7 ]\n"
u8"	LINE [ x 6 r -7 ]\n"
u8"	LINE [ x 6 r 7 ]\n"
u8"}\n"
u8"\n"
u8"shape E\n"
u8"{\n"
u8"	LINE [ s 0.9 ]\n"
u8"	LINE [ s 0.9 -1 y 24 ]\n"
u8"	LINE [ s 0.4 r -90 y 0 ]\n"
u8"	LINE [ s 0.4 r -90 y 12 ]\n"
u8"	LINE [ s 0.4 r -90 y 24 ]\n"
u8"}\n"
u8"\n"
u8"shape L\n"
u8"{\n"
u8"	LINE [ ]\n"
u8"	LINE [ s 0.4 x 0.4 r -90 y 0 ]\n"
u8"}\n"
u8"\n"
u8"shape C\n"
u8"{\n"
u8"	ARCL [ y 12 flip 90 ]\n"
u8"	ARCL [ y 12 r 180 ]\n"
u8"}\n"
u8"\n"
u8"shape O\n"
u8"{\n"
u8"	ARCL [ y 12 flip 90]\n"
u8"	ARCL [ y 12 r 180 ]\n"
u8"	ARCL [ y 12 x 14 r 180 flip 90]\n"
u8"	ARCL [ y 12 x 14 ]\n"
u8"}\n"
u8"\n"
u8"shape M\n"
u8"{\n"
u8"	LINE [ y 24 r 180 ]\n"
u8"	LINE [ y 24 r  -160 s 0.75 ]\n"
u8"	LINE [ y 24 x 12 r 160 s 0.75 ]\n"
u8"	LINE [ y 24 x 12 r 180 ]\n"
u8"}\n"
u8"\n"
u8"shape LINE\n"
u8"{\n"
u8"	TRIANGLE [[ s 1 30 y 0.26 ]]\n"
u8"	//MARK { }\n"
u8"	//LINE { size 0.98 y 0.5 }\n"
u8"}\n"
u8"\n"
u8"shape ARCL\n"
u8"{\n"
u8"	MARK [ ]\n"
u8"	ARCL [ size 0.97 y 0.55 r 1.5 ]\n"
u8"}\n"
u8"\n"
u8"shape MARK\n"
u8"{\n"
u8"	SQUARE [ ]\n"
u8"}\n"
u8"\n"
u8"\n"
u8"shape VINEL\n"
u8"{\n"
u8"	STEML [ ]\n"
u8"	STEML [ x 1 r 5 flip 0 ]\n"
u8"	VINEL [ x 2 size 0.9 r 10 ]\n"
u8"}\n"
u8"\n"
u8"shape STEML\n"
u8"{\n"
u8"	GOL [ r 20 s 0.1 ]\n"
u8"	END [ s 0.2 r 120 hue 150\n"
u8"		x 1.3 y -0.6 b -0.3]\n"
u8"}\n"
u8"shape GOL\n"
u8"{\n"
u8"	CIRCLE [ ]\n"
u8"	GOL [ x 0.3 r -1 s 0.985 ]\n"
u8"}\n"
u8"\n"
u8"\n"
u8"shape END\n"
u8"{\n"
u8"	CIRCLE [ x -0.5 y 0.0 s 1.0 ]\n"
u8"	CIRCLE [ x 0.45 y 0.6 s 0.9 ]\n"
u8"	CIRCLE [ x -0.4 y 1.2 s 0.8 ]\n"
u8"	CIRCLE [ x 0.35 y 1.8 s 0.7 ]\n"
u8"	CIRCLE [ x -0.3 y 2.4 s 0.6 ]\n"
u8"}\n"
u8"\n"
 ,
u8"startshape WELCOME\n"
u8"\n"
u8"rule WELCOME {\n"
u8"	MESSAGE { hue 225 sat 0.7 b 0.6 }\n"
u8"	VINEL { sat 1 hue 120\n"
u8"		x 3 y -55\n"
u8"		r 0 b 0.5 s 10\n"
u8"	}\n"
u8"	VINEL { flip 90\n"
u8"		sat 1 hue 120\n"
u8"		x 85 y -55\n"
u8"		r 0 b 0.5 s 10\n"
u8"	}\n"
u8"}\n"
u8"\n"
u8"rule MESSAGE {\n"
u8"	W { x 0 }\n"
u8"	E { x 12 }\n"
u8"	L { x 24 }\n"
u8"	C { x 34 }\n"
u8"	O { x 46 }\n"
u8"	M { x 64 }\n"
u8"	E { x 80 }\n"
u8"}\n"
u8"\n"
u8"rule W {\n"
u8"	LINE { r -7 }\n"
u8"	LINE { r 7 }\n"
u8"	LINE { x 6 r -7 }\n"
u8"	LINE { x 6 r 7 }\n"
u8"}\n"
u8"\n"
u8"rule E {\n"
u8"	LINE { }\n"
u8"	LINE { s 0.4 r -90 y 0 }\n"
u8"	LINE { s 0.4 r -90 y 12 }\n"
u8"	LINE { s 0.4 r -90 y 24 }\n"
u8"}\n"
u8"\n"
u8"rule L {\n"
u8"	LINE { }\n"
u8"	LINE { s 0.4 x 0.4 r -90 y 0 }\n"
u8"}\n"
u8"\n"
u8"rule C {\n"
u8"	ARCL { y 12 flip 90 }\n"
u8"	ARCL { y 12 r 180 }\n"
u8"}\n"
u8"\n"
u8"rule O {\n"
u8"	ARCL { y 12 flip 90}\n"
u8"	ARCL { y 12 r 180 }\n"
u8"	ARCL { y 12 x 14 r 180 flip 90}\n"
u8"	ARCL { y 12 x 14 }\n"
u8"}\n"
u8"\n"
u8"rule M {\n"
u8"	LINE { y 24 r 180 }\n"
u8"	LINE { y 24 r  -160 s 0.75 }\n"
u8"	LINE { y 24 x 12 r 160 s 0.75 }\n"
u8"	LINE { y 24 x 12 r 180 }\n"
u8"}\n"
u8"\n"
u8"rule LINE {\n"
u8"	TRIANGLE [ s 1 30 y 0.26 ]\n"
u8"	//MARK { }\n"
u8"	//LINE { size 0.98 y 0.5 }\n"
u8"}\n"
u8"\n"
u8"rule ARCL {\n"
u8"	MARK { }\n"
u8"	ARCL { size 0.97 y 0.55 r 1.5 }\n"
u8"}\n"
u8"\n"
u8"rule MARK {\n"
u8"	SQUARE { }\n"
u8"}\n"
u8"\n"
u8"\n"
u8"rule VINEL {\n"
u8"	STEML { }\n"
u8"	STEML { x 1 r 5 flip 0 }\n"
u8"	VINEL { x 2 size 0.9 r 10 }\n"
u8"}\n"
u8"\n"
u8"rule STEML {\n"
u8"	GOL { r 20 s 0.1 }\n"
u8"	END { s 0.2 r 120 hue 150\n"
u8"		x 1.3 y -0.6 b -0.3}\n"
u8"}\n"
u8"rule GOL {\n"
u8"	CIRCLE { }\n"
u8"	GOL { x 0.3 r -1 s 0.985 }\n"
u8"}\n"
u8"\n"
u8"\n"
u8"rule END {\n"
u8"	CIRCLE { x -0.5 y 0.0 s 1.0 }\n"
u8"	CIRCLE { x 0.45 y 0.6 s 0.9 }\n"
u8"	CIRCLE { x -0.4 y 1.2 s 0.8 }\n"
u8"	CIRCLE { x 0.35 y 1.8 s 0.7 }\n"
u8"	CIRCLE { x -0.3 y 2.4 s 0.6 }\n"
u8"}\n"
u8"\n"
    } },
    { "ziggy.cfdg", {
u8"startshape Trident\n"
u8"\n"
u8"shape Trident\n"
u8"{\n"
u8"	ZigL [ x 0 b 0.02 ]\n"
u8"	Zig [ ]\n"
u8"	ZagL [ x 0 b 0.02 flip 90]\n"
u8"	CIRCLE [ x 10 y 10 s 6 b 0.75 ]\n"
u8"	CIRCLE [ x -10 y 10 s 6 b 0.75 ]\n"
u8"//	CIRCLE { x 17 y 15 s 4 b 0.75 }\n"
u8"//	CIRCLE { x -17 y 15 s 4 b 0.75 }\n"
u8"}\n"
u8"\n"
u8"shape Zig\n"
u8"{\n"
u8"	Seg [ x -0.5 r -45 ]\n"
u8"	Zag [ y 1 s 0.97 ]\n"
u8"}\n"
u8"shape Zag\n"
u8"{\n"
u8"	Seg [ x 0.5 r 45 ]\n"
u8"	Zig [ y 1 s 0.97 ]\n"
u8"}\n"
u8"\n"
u8"shape ZigL\n"
u8"{\n"
u8"	Seg [ x -0.5 r -45 ]\n"
u8"	ZagL [ y 1 s 0.97 r 2 ]\n"
u8"}\n"
u8"shape ZagL\n"
u8"{\n"
u8"	Seg [ x 0.5 r 45 ]\n"
u8"	ZigL [ y 1 s 0.97 r 2 ]\n"
u8"}\n"
u8"\n"
u8"shape ZigL\n"
u8"rule 0.1 { Trident [ ] }\n"
u8"\n"
u8"shape Seg\n"
u8"{\n"
u8"	SQUARE [ y 0.6925 s 0.5 1.885 ]\n"
u8"}\n"
 ,
u8"startshape Trident\n"
u8"\n"
u8"rule Trident {\n"
u8"	ZigL { x 0 b 0.02 }\n"
u8"	Zig { }\n"
u8"	ZagL { x 0 b 0.02 flip 90}\n"
u8"	CIRCLE { x 10 y 10 s 6 b 0.75 }\n"
u8"	CIRCLE { x -10 y 10 s 6 b 0.75 }\n"
u8"//	CIRCLE { x 17 y 15 s 4 b 0.75 }\n"
u8"//	CIRCLE { x -17 y 15 s 4 b 0.75 }\n"
u8"}\n"
u8"\n"
u8"rule Zig {\n"
u8"	Seg { x -0.5 r -45 }\n"
u8"	Zag { y 1 s 0.97 }\n"
u8"}\n"
u8"rule Zag {\n"
u8"	Seg { x 0.5 r 45 }\n"
u8"	Zig { y 1 s 0.97 }\n"
u8"}\n"
u8"\n"
u8"rule ZigL {\n"
u8"	Seg { x -0.5 r -45 }\n"
u8"	ZagL { y 1 s 0.97 r 2 }\n"
u8"}\n"
u8"rule ZagL {\n"
u8"	Seg { x 0.5 r 45 }\n"
u8"	ZigL { y 1 s 0.97 r 2 }\n"
u8"}\n"
u8"\n"
u8"rule ZigL 0.1 { Trident { } }\n"
u8"\n"
u8"rule Seg {\n"
u8"	SQUARE { y 0.6925 s 0.5 1.885 }\n"
u8"	//SQUARE { y 0 s 0.5 }\n"
u8"	//SQUARE { y 0.49 s 0.5 }\n"
u8"	//SQUARE { y 0.92 s 0.5 }\n"
u8"	//SQUARE { y 1.385 s 0.5 }\n"
u8"}\n"
    } },
};
