/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Collections;

namespace Cowbell.Base
{
	public class CliUtils
	{
		/* public methods */
		public static bool QueryWithYesNo (string question, bool yes_default)
		{
			do {

				string query = String.Format (Catalog.GetString ("{0} [Y/n] "), question);
				if (!yes_default) {
					query = String.Format (Catalog.GetString ("{0} [y/N] "), question);
				}

				string resp = Query (query);
				resp = resp.ToLower ();

				if (resp == String.Empty) {
					return yes_default;
				} else if (resp.StartsWith (Catalog.GetString ("y"))) {
					return true;
				} else if (resp.StartsWith (Catalog.GetString ("n"))) {
					return false;
				}
			} while (true);
		}

		public static string Query (string question)
		{
			Console.Write (question);
			return Console.ReadLine ();
		}
	}
}
