/* 
  DB Mixer 
  ======== 
  Description: 
    interface controller for an external mixer to work with the DBMix system. 
 
    Copyright (c) 2000, 2001 Simon Mark Werner 
 
    DBMix Author: Robert Michael S Dean 
    exmixer Author: Simon Mark Werner 
    Version: 1.0 
 
 
   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version. 
 
   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of 
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
   GNU General Public License for more details. 
 
   You should have received a copy of the GNU General Public License 
   along with this program; if not, write to the Free Software 
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 
 */ 
 
#define MAX_DEV 2 /* Change MAX_DEV to the number of devices to use */ 
#define MAX_AXES 4 /* Maximum number of axis to use per device */ 
#define MAX_BUT 4  /* Maximum number of buttons to use per device */ 
 
#define NAME_LENGTH 128 
#define FILENAME_LENGTH 128 
#define STR_LEN 128 
 
#define PRN(i) printf("%d. Got here!\n",i); 
 
/* Aliases to make things a look tidier */ 
#define N_AXES emix[dev_id].dev->num_axes 
#define N_BUT emix[dev_id].dev->num_buttons 
 
#define D_NAME emix[dev_id].dev->name 
#define D_FILENAME emix[dev_id].dev->filename 
#define D_ENABLED emix[dev_id].dev->enabled 
#define D_FD emix[dev_id].dev->fd 
#define D_GTAG emix[dev_id].dev->g_tag 
#define D_DEV_FRAME emix[dev_id].dev->device_frame 
#define D_TABLE emix[dev_id].dev->table 
#define D_CB_ENABLED emix[dev_id].dev->cb_enabled 
#define D_ENTRY emix[dev_id].dev->dev_entry 
#define D_COMBO emix[dev_id].dev->dev_combo 
 
#define A_VAL emix[dev_id].axis[axis_id].val 
#define A_MIN emix[dev_id].axis[axis_id].min 
#define A_CEN emix[dev_id].axis[axis_id].center 
#define A_MAX emix[dev_id].axis[axis_id].max 
#define A_FLIP emix[dev_id].axis[axis_id].flip 
#define A_ASSIGN emix[dev_id].axis[axis_id].assigned 
#define A_CHAN emix[dev_id].axis[axis_id].channel 
#define A_ASSIGN_ENT emix[dev_id].axis[axis_id].assign_entry 
#define A_ASSIGN_CMB emix[dev_id].axis[axis_id].assign_combo 
#define A_CHAN_ENT emix[dev_id].axis[axis_id].chan_entry 
#define A_CHAN_CMB emix[dev_id].axis[axis_id].chan_combo 
 
#define B_ASSIGN emix[dev_id].button[but_id].assigned 
#define B_CHAN emix[dev_id].button[but_id].channel 
#define B_VAL emix[dev_id].button[but_id].val 
#define B_PRESSED emix[dev_id].button[but_id].pressed 
#define B_ASSIGN_ENT emix[dev_id].button[but_id].assign_entry 
#define B_ASSIGN_CMB emix[dev_id].button[but_id].assign_combo 
#define B_CHAN_ENT emix[dev_id].button[but_id].chan_entry 
#define B_CHAN_CMB emix[dev_id].button[but_id].chan_combo 
 
/* Axis controls */ 
#define EM_A_NULL 0 
#define EM_A_PITCH 1 
#define EM_A_VOLUME 2 
#define EM_A_CUE_VOLUME 3 
#define EM_A_MAIN_VOLUME 4 
#define EM_A_CROSS_FADE 5 
#define EM_A_FADE_SPEED 6 
#define EM_A_BALANCE 7 
 
/* Button controls */ 
#define EM_B_NULL 0 
#define EM_B_PAUSE 1 
#define EM_B_UNPAUSE 2 
#define EM_B_PLAY 3 
#define EM_B_STOP 4 
#define EM_B_EJECT 5 
#define EM_B_REWIND 6 
#define EM_B_FAST_FORWARD 7 
#define EM_B_NEXT 8 
#define EM_B_PREV 9 
#define EM_B_PUNCH_LEFT 10 
#define EM_B_PUNCH_RIGHT 11 
#define EM_B_CUE 12 
#define EM_B_MUTE 13 
 
typedef struct js_device_s { 
    int fd;           /* not initialized */ 
    char num_axes; 
    char num_buttons; 
    int version; 
    char name[NAME_LENGTH]; 
    char filename[FILENAME_LENGTH]; 
    int enabled;    /* Flag to enable the current exmixer */ 
    gint g_tag;     /* Descriptor returned by gtk_input_add() */ 
 
    /* Widgets used for preferences window */ 
    GtkWidget *device_frame; 
    GtkWidget *table; 
    GtkWidget *cb_enabled; 
    GtkWidget *dev_combo; 
    GtkWidget *dev_entry; 
} js_device; 
 
typedef struct js_axis_s { 
    int min;       /* Minimum axis value */ 
    int center;       /* Center axis value */ 
    int max;       /* Maximum axis value */ 
    int flip;       /* Is the axis reversed? */ 
    int assigned;   /* To which Adjustment is this axis assigned? */ 
    int channel;    /* To which channel is it assigned? */ 
    int val;       /* is the button currently pressed */ 
    
    /* Widgets used for preferences window */ 
    GtkWidget *assign_combo; 
    GtkWidget *assign_entry; 
    
    GtkWidget *chan_combo; 
    GtkWidget *chan_entry; 
} js_axis; 
 
typedef struct js_button_s { 
//    int __bufa[3];  /* Just to remove a bug  :-) */ 
    int assigned;    /* To which scroll type is this axis assigned? */ 
    int channel;    /* To which channel is it assigned? */ 
    int val;       /* The current value of the axis */ 
    int pressed;    /* Used to check the state of the button */ 
//    int __bufb[3];  /* Just to remove a bug  :-) */ 
    
    /* Widgets used for preferences window */ 
    GtkWidget *assign_combo; 
    GtkWidget *assign_entry; 
    
    GtkWidget *chan_combo; 
    GtkWidget *chan_entry; 
} js_button; 
 
struct ext_mixer { 
    js_device *dev; 
    js_axis *axis; 
    js_button *button; 
} emix[MAX_DEV]; 
 
void exmixer_start( void ); /* Start the exmixer */ 
void exmixer_stop( void );  /* Stop the exmixer */ 
void exmixer_clear( void ); /* Create and clear all the exmixer settings */ 
void exmixer_start_device( int ); /* Start an exmixer device */ 
void exmixer_disable_device( int ); /* Disable an exmixer device */ 
 
void set_calibration( int ); /* True passed if we use on-the-fly calibration */ 
void print_js_settings( int ); /* Print out the joystick details to screen (only works in DBMIX_DEBUG mode) */ 
 
