#ifndef _CREATE_INODE_H
#define _CREATE_INODE_H

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "et/com_err.h"
#include "e2p/e2p.h"
#include "ext2fs/ext2fs.h"

struct hdlink_s
{
	dev_t src_dev;
	ino_t src_ino;
	ext2_ino_t dst_ino;
};

struct hdlinks_s
{
	int count;
	int size;
	struct hdlink_s *hdl;
};

struct file_info {
	char *path;
	size_t path_len;
	size_t path_max_len;
};

#define HDLINK_CNT	(4)

/* flags for populate_fs3 */
#define POPULATE_FS_NO_COPY_XATTRS	0x0001
#define POPULATE_FS_LINK_APPEND		0x0002

struct fs_ops_callbacks {
	errcode_t (* create_new_inode)(ext2_filsys fs, const char *target_path,
		const char *name, ext2_ino_t parent_ino, ext2_ino_t root,
		mode_t mode);
	errcode_t (* end_create_new_inode)(ext2_filsys fs,
		const char *target_path, const char *name,
		ext2_ino_t parent_ino, ext2_ino_t root, mode_t mode);
};

/* For populating the filesystem */
extern errcode_t populate_fs(ext2_filsys fs, ext2_ino_t parent_ino,
			     const char *source_dir, ext2_ino_t root);
extern errcode_t populate_fs2(ext2_filsys fs, ext2_ino_t parent_ino,
			      const char *source_dir, ext2_ino_t root,
			      struct fs_ops_callbacks *fs_callbacks);
extern errcode_t populate_fs3(ext2_filsys fs, ext2_ino_t parent_ino,
			      const char *source_dir, ext2_ino_t root,
			      int flags,
			      struct fs_ops_callbacks *fs_callbacks);
extern errcode_t do_mknod_internal(ext2_filsys fs, ext2_ino_t cwd,
				   const char *name, unsigned int st_mode,
				   unsigned int st_rdev);
extern errcode_t do_symlink_internal(ext2_filsys fs, ext2_ino_t cwd,
				     const char *name, char *target,
				     ext2_ino_t root);
extern errcode_t do_mkdir_internal(ext2_filsys fs, ext2_ino_t cwd,
				   const char *name, unsigned long flags,
				   ext2_ino_t root);
extern errcode_t do_write_internal(ext2_filsys fs, ext2_ino_t cwd,
				   const char *src, const char *dest,
				   unsigned long flags, ext2_ino_t root);
extern errcode_t add_link(ext2_filsys fs, ext2_ino_t parent_ino,
			  ext2_ino_t ino, const char *name);
extern errcode_t set_inode_extra(ext2_filsys fs, ext2_ino_t ino,
				 const struct stat *st);

#endif /* _CREATE_INODE_H */
