// SPDX-License-Identifier: GPL-2.0-only
/*
 * Copyright (C) 2013-2014 Red Hat
 * Author: Rob Clark <robdclark@gmail.com>
 *
 * Copyright (c) 2014,2017 The Linux Foundation. All rights reserved.
 */

#include "adreno_gpu.h"
#include "a6xx_gpu.h"
#include "a6xx.xml.h"
#include "a6xx_gmu.xml.h"

static const struct adreno_reglist a612_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000081},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01202222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x05522022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

/* For a615 family (a615, a616, a618 and a619) */
static const struct adreno_reglist a615_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0,  0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0,  0x0000F3CF},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0,  0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP1,  0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP1, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0,  0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST_TP1,  0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP1, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP1, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP1, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP1, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE,  0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_UCHE, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE,  0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002020},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU1, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU2, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU3, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU1, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU2, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU3, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x05022022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a620_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE, 0x00000777},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a630_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_SP1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_SP2, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_SP3, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02022220},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP1, 0x02022220},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP2, 0x02022220},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP3, 0x02022220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP1, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP2, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP3, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_HYST_SP1, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_HYST_SP2, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_HYST_SP3, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP1, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP2, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP3, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP2, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP3, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP2, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP3, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP1, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP2, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP3, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST_TP1, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST_TP2, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST_TP3, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP1, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP2, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP3, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP1, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP2, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP3, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP1, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP2, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP3, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP2, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP3, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP2, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP3, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP2, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP3, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP1, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP2, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP3, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_UCHE, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB2, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB3, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB1, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB2, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB3, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU1, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU2, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU3, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU1, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU2, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU3, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x05022022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a640_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000F3CF},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x05222022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a650_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000F3CF},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE, 0x00000777},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a660_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000F3CF},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a690_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000F3CF},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_CNTL, 0x8AA8AA82},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{REG_A6XX_GPU_GMU_AO_GMU_CGC_DELAY_CNTL, 0x10111},
	{REG_A6XX_GPU_GMU_AO_GMU_CGC_HYST_CNTL, 0x5555},
	{}
};

/* For a615, a616, a618, a619, a630, a640 and a680 */
static const u32 a630_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00000, 0x04ff),
	A6XX_PROTECT_RDONLY(0x00501, 0x0005),
	A6XX_PROTECT_RDONLY(0x0050b, 0x02f4),
	A6XX_PROTECT_NORDWR(0x0050e, 0x0000),
	A6XX_PROTECT_NORDWR(0x00510, 0x0000),
	A6XX_PROTECT_NORDWR(0x00534, 0x0000),
	A6XX_PROTECT_NORDWR(0x00800, 0x0082),
	A6XX_PROTECT_NORDWR(0x008a0, 0x0008),
	A6XX_PROTECT_NORDWR(0x008ab, 0x0024),
	A6XX_PROTECT_RDONLY(0x008de, 0x00ae),
	A6XX_PROTECT_NORDWR(0x00900, 0x004d),
	A6XX_PROTECT_NORDWR(0x0098d, 0x0272),
	A6XX_PROTECT_NORDWR(0x00e00, 0x0001),
	A6XX_PROTECT_NORDWR(0x00e03, 0x000c),
	A6XX_PROTECT_NORDWR(0x03c00, 0x00c3),
	A6XX_PROTECT_RDONLY(0x03cc4, 0x1fff),
	A6XX_PROTECT_NORDWR(0x08630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x08e00, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e08, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e50, 0x001f),
	A6XX_PROTECT_NORDWR(0x09624, 0x01db),
	A6XX_PROTECT_NORDWR(0x09e70, 0x0001),
	A6XX_PROTECT_NORDWR(0x09e78, 0x0187),
	A6XX_PROTECT_NORDWR(0x0a630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae50, 0x032f),
	A6XX_PROTECT_NORDWR(0x0b604, 0x0000),
	A6XX_PROTECT_NORDWR(0x0be02, 0x0001),
	A6XX_PROTECT_NORDWR(0x0be20, 0x17df),
	A6XX_PROTECT_NORDWR(0x0f000, 0x0bff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x11c00, 0x0000), /* note: infinite range */
};
DECLARE_ADRENO_PROTECT(a630_protect, 32);

static const u32 a650_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00000, 0x04ff),
	A6XX_PROTECT_RDONLY(0x00501, 0x0005),
	A6XX_PROTECT_RDONLY(0x0050b, 0x02f4),
	A6XX_PROTECT_NORDWR(0x0050e, 0x0000),
	A6XX_PROTECT_NORDWR(0x00510, 0x0000),
	A6XX_PROTECT_NORDWR(0x00534, 0x0000),
	A6XX_PROTECT_NORDWR(0x00800, 0x0082),
	A6XX_PROTECT_NORDWR(0x008a0, 0x0008),
	A6XX_PROTECT_NORDWR(0x008ab, 0x0024),
	A6XX_PROTECT_RDONLY(0x008de, 0x00ae),
	A6XX_PROTECT_NORDWR(0x00900, 0x004d),
	A6XX_PROTECT_NORDWR(0x0098d, 0x0272),
	A6XX_PROTECT_NORDWR(0x00e00, 0x0001),
	A6XX_PROTECT_NORDWR(0x00e03, 0x000c),
	A6XX_PROTECT_NORDWR(0x03c00, 0x00c3),
	A6XX_PROTECT_RDONLY(0x03cc4, 0x1fff),
	A6XX_PROTECT_NORDWR(0x08630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x08e00, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e08, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e50, 0x001f),
	A6XX_PROTECT_NORDWR(0x08e80, 0x027f),
	A6XX_PROTECT_NORDWR(0x09624, 0x01db),
	A6XX_PROTECT_NORDWR(0x09e60, 0x0011),
	A6XX_PROTECT_NORDWR(0x09e78, 0x0187),
	A6XX_PROTECT_NORDWR(0x0a630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae50, 0x032f),
	A6XX_PROTECT_NORDWR(0x0b604, 0x0000),
	A6XX_PROTECT_NORDWR(0x0b608, 0x0007),
	A6XX_PROTECT_NORDWR(0x0be02, 0x0001),
	A6XX_PROTECT_NORDWR(0x0be20, 0x17df),
	A6XX_PROTECT_NORDWR(0x0f000, 0x0bff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x18400, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1a800, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1f400, 0x0443),
	A6XX_PROTECT_RDONLY(0x1f844, 0x007b),
	A6XX_PROTECT_NORDWR(0x1f887, 0x001b),
	A6XX_PROTECT_NORDWR(0x1f8c0, 0x0000), /* note: infinite range */
};
DECLARE_ADRENO_PROTECT(a650_protect, 48);

/* These are for a635 and a660 */
static const u32 a660_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00000, 0x04ff),
	A6XX_PROTECT_RDONLY(0x00501, 0x0005),
	A6XX_PROTECT_RDONLY(0x0050b, 0x02f4),
	A6XX_PROTECT_NORDWR(0x0050e, 0x0000),
	A6XX_PROTECT_NORDWR(0x00510, 0x0000),
	A6XX_PROTECT_NORDWR(0x00534, 0x0000),
	A6XX_PROTECT_NORDWR(0x00800, 0x0082),
	A6XX_PROTECT_NORDWR(0x008a0, 0x0008),
	A6XX_PROTECT_NORDWR(0x008ab, 0x0024),
	A6XX_PROTECT_RDONLY(0x008de, 0x00ae),
	A6XX_PROTECT_NORDWR(0x00900, 0x004d),
	A6XX_PROTECT_NORDWR(0x0098d, 0x0272),
	A6XX_PROTECT_NORDWR(0x00e00, 0x0001),
	A6XX_PROTECT_NORDWR(0x00e03, 0x000c),
	A6XX_PROTECT_NORDWR(0x03c00, 0x00c3),
	A6XX_PROTECT_RDONLY(0x03cc4, 0x1fff),
	A6XX_PROTECT_NORDWR(0x08630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x08e00, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e08, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e50, 0x001f),
	A6XX_PROTECT_NORDWR(0x08e80, 0x027f),
	A6XX_PROTECT_NORDWR(0x09624, 0x01db),
	A6XX_PROTECT_NORDWR(0x09e60, 0x0011),
	A6XX_PROTECT_NORDWR(0x09e78, 0x0187),
	A6XX_PROTECT_NORDWR(0x0a630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae50, 0x012f),
	A6XX_PROTECT_NORDWR(0x0b604, 0x0000),
	A6XX_PROTECT_NORDWR(0x0b608, 0x0006),
	A6XX_PROTECT_NORDWR(0x0be02, 0x0001),
	A6XX_PROTECT_NORDWR(0x0be20, 0x015f),
	A6XX_PROTECT_NORDWR(0x0d000, 0x05ff),
	A6XX_PROTECT_NORDWR(0x0f000, 0x0bff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x18400, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1a400, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1f400, 0x0443),
	A6XX_PROTECT_RDONLY(0x1f844, 0x007b),
	A6XX_PROTECT_NORDWR(0x1f860, 0x0000),
	A6XX_PROTECT_NORDWR(0x1f887, 0x001b),
	A6XX_PROTECT_NORDWR(0x1f8c0, 0x0000), /* note: infinite range */
};
DECLARE_ADRENO_PROTECT(a660_protect, 48);

/* These are for a690 */
static const u32 a690_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00000, 0x004ff),
	A6XX_PROTECT_RDONLY(0x00501, 0x00001),
	A6XX_PROTECT_RDONLY(0x0050b, 0x002f4),
	A6XX_PROTECT_NORDWR(0x0050e, 0x00000),
	A6XX_PROTECT_NORDWR(0x00510, 0x00000),
	A6XX_PROTECT_NORDWR(0x00534, 0x00000),
	A6XX_PROTECT_NORDWR(0x00800, 0x00082),
	A6XX_PROTECT_NORDWR(0x008a0, 0x00008),
	A6XX_PROTECT_NORDWR(0x008ab, 0x00024),
	A6XX_PROTECT_RDONLY(0x008de, 0x000ae),
	A6XX_PROTECT_NORDWR(0x00900, 0x0004d),
	A6XX_PROTECT_NORDWR(0x0098d, 0x00272),
	A6XX_PROTECT_NORDWR(0x00e00, 0x00001),
	A6XX_PROTECT_NORDWR(0x00e03, 0x0000c),
	A6XX_PROTECT_NORDWR(0x03c00, 0x000c3),
	A6XX_PROTECT_RDONLY(0x03cc4, 0x01fff),
	A6XX_PROTECT_NORDWR(0x08630, 0x001cf),
	A6XX_PROTECT_NORDWR(0x08e00, 0x00000),
	A6XX_PROTECT_NORDWR(0x08e08, 0x00007),
	A6XX_PROTECT_NORDWR(0x08e50, 0x0001f),
	A6XX_PROTECT_NORDWR(0x08e80, 0x0027f),
	A6XX_PROTECT_NORDWR(0x09624, 0x001db),
	A6XX_PROTECT_NORDWR(0x09e60, 0x00011),
	A6XX_PROTECT_NORDWR(0x09e78, 0x00187),
	A6XX_PROTECT_NORDWR(0x0a630, 0x001cf),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x00000),
	A6XX_PROTECT_NORDWR(0x0ae50, 0x0012f),
	A6XX_PROTECT_NORDWR(0x0b604, 0x00000),
	A6XX_PROTECT_NORDWR(0x0b608, 0x00006),
	A6XX_PROTECT_NORDWR(0x0be02, 0x00001),
	A6XX_PROTECT_NORDWR(0x0be20, 0x0015f),
	A6XX_PROTECT_NORDWR(0x0d000, 0x005ff),
	A6XX_PROTECT_NORDWR(0x0f000, 0x00bff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x01fff),
	A6XX_PROTECT_NORDWR(0x11c00, 0x00000), /*note: infiite range */
};
DECLARE_ADRENO_PROTECT(a690_protect, 48);

static const struct adreno_info a6xx_gpus[] = {
	{
		.chip_ids = ADRENO_CHIP_IDS(0x06010000),
		.family = ADRENO_6XX_GEN1,
		.revn = 610,
		.fw = {
			[ADRENO_FW_SQE] = "a630_sqe.fw",
		},
		.gmem = (SZ_128K + SZ_4K),
		.quirks = ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.init = a6xx_gpu_init,
		.zapfw = "a610_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a612_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00080000,
		},
		/*
		 * There are (at least) three SoCs implementing A610: SM6125
		 * (trinket), SM6115 (bengal) and SM6225 (khaje). Trinket does
		 * not have speedbinning, as only a single SKU exists and we
		 * don't support khaje upstream yet.  Hence, this matching
		 * table is only valid for bengal.
		 */
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 206, 1 },
			{ 200, 2 },
			{ 157, 3 },
			{ 127, 4 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06010500),
		.family = ADRENO_6XX_GEN1,
		.revn = 615,
		.fw = {
			[ADRENO_FW_SQE] = "a630_sqe.fw",
			[ADRENO_FW_GMU] = "a630_gmu.bin",
		},
		.gmem = SZ_512K,
		.quirks = ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.init = a6xx_gpu_init,
		.zapfw = "a615_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a615_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x0018000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			/*
			 * The default speed bin (0) has the same values as
			 * speed bin 90 which goes up to 432 MHz.
			 */
			{ 0,   0 },
			{ 90,  0 },
			{ 105, 1 },
			{ 146, 2 },
			{ 163, 3 },
		),
	}, {
		.machine = "qcom,sm7150",
		.chip_ids = ADRENO_CHIP_IDS(0x06010800),
		.family = ADRENO_6XX_GEN1,
		.fw = {
			[ADRENO_FW_SQE] = "a630_sqe.fw",
			[ADRENO_FW_GMU] = "a630_gmu.bin",
		},
		.gmem = SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.init = a6xx_gpu_init,
		.zapfw = "a615_zap.mbn",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a615_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x00180000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 128, 1 },
			{ 146, 2 },
			{ 167, 3 },
			{ 172, 4 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06010800),
		.family = ADRENO_6XX_GEN1,
		.revn = 618,
		.fw = {
			[ADRENO_FW_SQE] = "a630_sqe.fw",
			[ADRENO_FW_GMU] = "a630_gmu.bin",
		},
		.gmem = SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.init = a6xx_gpu_init,
		.a6xx = &(const struct a6xx_info) {
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x00180000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 169, 1 },
			{ 174, 2 },
		),
	}, {
		.machine = "qcom,sm4350",
		.chip_ids = ADRENO_CHIP_IDS(0x06010900),
		.family = ADRENO_6XX_GEN1,
		.revn = 619,
		.fw = {
			[ADRENO_FW_SQE] = "a630_sqe.fw",
			[ADRENO_FW_GMU] = "a619_gmu.bin",
		},
		.gmem = SZ_512K,
		.quirks = ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.init = a6xx_gpu_init,
		.zapfw = "a615_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a615_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x00018000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 138, 1 },
			{ 92,  2 },
		),
	}, {
		.machine = "qcom,sm6375",
		.chip_ids = ADRENO_CHIP_IDS(0x06010901),
		.family = ADRENO_6XX_GEN1,
		.revn = 619,
		.fw = {
			[ADRENO_FW_SQE] = "a630_sqe.fw",
			[ADRENO_FW_GMU] = "a619_gmu.bin",
		},
		.gmem = SZ_512K,
		.quirks = ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.init = a6xx_gpu_init,
		.zapfw = "a615_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a615_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x00018000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 190, 1 },
			{ 177, 2 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06010900),
		.family = ADRENO_6XX_GEN1,
		.revn = 619,
		.fw = {
			[ADRENO_FW_SQE] = "a630_sqe.fw",
			[ADRENO_FW_GMU] = "a619_gmu.bin",
		},
		.gmem = SZ_512K,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.init = a6xx_gpu_init,
		.zapfw = "a615_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a615_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x00018000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 120, 4 },
			{ 138, 3 },
			{ 169, 2 },
			{ 180, 1 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06020100),
		.family = ADRENO_6XX_GEN3,
		.fw = {
			[ADRENO_FW_SQE] = "a650_sqe.fw",
			[ADRENO_FW_GMU] = "a621_gmu.bin",
		},
		.gmem = SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV,
		.init = a6xx_gpu_init,
		.zapfw = "a620_zap.mbn",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a620_hwcg,
			.protect = &a650_protect,
			.gmu_cgc_mode = 0x00020200,
			.prim_fifo_threshold = 0x00010000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0, 0 },
			{ 137, 1 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06020300),
		.family = ADRENO_6XX_GEN3,
		.fw = {
			[ADRENO_FW_SQE] = "a650_sqe.fw",
			[ADRENO_FW_GMU] = "a623_gmu.bin",
		},
		.gmem = SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.init = a6xx_gpu_init,
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a690_hwcg,
			.protect = &a650_protect,
			.gmu_cgc_mode = 0x00020200,
			.prim_fifo_threshold = 0x00010000,
			.bcms = (const struct a6xx_bcm[]) {
				{ .name = "SH0", .buswidth = 16 },
				{ .name = "MC0", .buswidth = 4 },
				{
					.name = "ACV",
					.fixed = true,
					.perfmode = BIT(3),
				},
				{ /* sentinel */ },
			},
		},
	}, {
		.chip_ids = ADRENO_CHIP_IDS(
			0x06030001,
			0x06030002
		),
		.family = ADRENO_6XX_GEN1,
		.revn = 630,
		.fw = {
			[ADRENO_FW_SQE] = "a630_sqe.fw",
			[ADRENO_FW_GMU] = "a630_gmu.bin",
		},
		.gmem = SZ_1M,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.init = a6xx_gpu_init,
		.zapfw = "a630_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a630_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00180000,
		},
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06040001),
		.family = ADRENO_6XX_GEN2,
		.revn = 640,
		.fw = {
			[ADRENO_FW_SQE] = "a630_sqe.fw",
			[ADRENO_FW_GMU] = "a640_gmu.bin",
		},
		.gmem = SZ_1M,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.init = a6xx_gpu_init,
		.zapfw = "a640_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a640_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00180000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0, 0 },
			{ 1, 1 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06050002),
		.family = ADRENO_6XX_GEN3,
		.revn = 650,
		.fw = {
			[ADRENO_FW_SQE] = "a650_sqe.fw",
			[ADRENO_FW_GMU] = "a650_gmu.bin",
		},
		.gmem = SZ_1M + SZ_128K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.init = a6xx_gpu_init,
		.zapfw = "a650_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a650_hwcg,
			.protect = &a650_protect,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00300200,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0, 0 },
			{ 1, 1 },
			{ 2, 3 }, /* Yep, 2 and 3 are swapped! :/ */
			{ 3, 2 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06060001),
		.family = ADRENO_6XX_GEN4,
		.revn = 660,
		.fw = {
			[ADRENO_FW_SQE] = "a660_sqe.fw",
			[ADRENO_FW_GMU] = "a660_gmu.bin",
		},
		.gmem = SZ_1M + SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.init = a6xx_gpu_init,
		.zapfw = "a660_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a660_hwcg,
			.protect = &a660_protect,
			.gmu_cgc_mode = 0x00020000,
			.prim_fifo_threshold = 0x00300200,
		},
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06060300),
		.family = ADRENO_6XX_GEN4,
		.fw = {
			[ADRENO_FW_SQE] = "a660_sqe.fw",
			[ADRENO_FW_GMU] = "a663_gmu.bin",
		},
		.gmem = SZ_1M + SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.init = a6xx_gpu_init,
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a690_hwcg,
			.protect = &a660_protect,
			.gmu_cgc_mode = 0x00020200,
			.prim_fifo_threshold = 0x00300200,
		},
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06030500),
		.family = ADRENO_6XX_GEN4,
		.fw = {
			[ADRENO_FW_SQE] = "a660_sqe.fw",
			[ADRENO_FW_GMU] = "a660_gmu.bin",
		},
		.gmem = SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.init = a6xx_gpu_init,
		.zapfw = "a660_zap.mbn",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a660_hwcg,
			.protect = &a660_protect,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00200200,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 117, 0 },
			{ 129, 4 },
			{ 172, 2 }, /* Called speedbin 1 downstream, but let's not break things! */
			{ 190, 1 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06080001),
		.family = ADRENO_6XX_GEN2,
		.revn = 680,
		.fw = {
			[ADRENO_FW_SQE] = "a630_sqe.fw",
			[ADRENO_FW_GMU] = "a640_gmu.bin",
		},
		.gmem = SZ_2M,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.init = a6xx_gpu_init,
		.zapfw = "a640_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a640_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00200200,
		},
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06090000),
		.family = ADRENO_6XX_GEN4,
		.fw = {
			[ADRENO_FW_SQE] = "a660_sqe.fw",
			[ADRENO_FW_GMU] = "a660_gmu.bin",
		},
		.gmem = SZ_4M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.init = a6xx_gpu_init,
		.zapfw = "a690_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a690_hwcg,
			.protect = &a690_protect,
			.gmu_cgc_mode = 0x00020200,
			.prim_fifo_threshold = 0x00800200,
		},
	}
};
DECLARE_ADRENO_GPULIST(a6xx);

static const struct adreno_reglist a702_hwcg[] = {
	{ REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000081 },
	{ REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000f3cf },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01202222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040f00 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x05522022 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222 },
	{ REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x02222222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002 },
	{ REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004 },
	{ REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002 },
	{ REG_A6XX_RBBM_ISDB_CNT, 0x00000182 },
	{ REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_FCHE, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_FCHE, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_FCHE, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_GLC, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GLC, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GLC, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_MHUB, 0x00000002 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_MHUB, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_MHUB, 0x00000000 },
	{}
};

static const struct adreno_reglist a730_hwcg[] = {
	{ REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02022222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000f3cf },
	{ REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222220 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x44000f00 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00555555 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00440044 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222 },
	{ REG_A7XX_RBBM_CLOCK_MODE2_GRAS, 0x00000222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_GRAS, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x02222223 },
	{ REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_GPC, 0x00222222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_VFD, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004 },
	{ REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_LRZ, 0x55555552 },
	{ REG_A7XX_RBBM_CLOCK_MODE_CP, 0x00000223 },
	{ REG_A6XX_RBBM_CLOCK_CNTL, 0x8aa8aa82 },
	{ REG_A6XX_RBBM_ISDB_CNT, 0x00000182 },
	{ REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555 },
	{},
};

static const struct adreno_reglist a740_hwcg[] = {
	{ REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x22022222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x003cf3cf },
	{ REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222220 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_UCHE, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000444 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x44000f00 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00555555 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00440044 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222 },
	{ REG_A7XX_RBBM_CLOCK_MODE2_GRAS, 0x00000222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_GRAS, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x02222223 },
	{ REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00222222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_GPC, 0x00222222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_VFD, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004 },
	{ REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_LRZ, 0x55555552 },
	{ REG_A7XX_RBBM_CLOCK_HYST2_VFD, 0x00000000 },
	{ REG_A7XX_RBBM_CLOCK_MODE_CP, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL, 0x8aa8aa82 },
	{ REG_A6XX_RBBM_ISDB_CNT, 0x00000182 },
	{ REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555 },
	{},
};

static const u32 a730_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00000, 0x04ff),
	A6XX_PROTECT_RDONLY(0x0050b, 0x0058),
	A6XX_PROTECT_NORDWR(0x0050e, 0x0000),
	A6XX_PROTECT_NORDWR(0x00510, 0x0000),
	A6XX_PROTECT_NORDWR(0x00534, 0x0000),
	A6XX_PROTECT_RDONLY(0x005fb, 0x009d),
	A6XX_PROTECT_NORDWR(0x00699, 0x01e9),
	A6XX_PROTECT_NORDWR(0x008a0, 0x0008),
	A6XX_PROTECT_NORDWR(0x008ab, 0x0024),
	/* 0x008d0-0x008dd and 0x008e0-0x008e6 are unprotected on purpose for tools like perfetto */
	A6XX_PROTECT_NORDWR(0x008de, 0x0001),
	A6XX_PROTECT_RDONLY(0x008e7, 0x014b),
	A6XX_PROTECT_NORDWR(0x00900, 0x004d),
	A6XX_PROTECT_NORDWR(0x0098d, 0x00b2),
	A6XX_PROTECT_NORDWR(0x00a41, 0x01be),
	A6XX_PROTECT_NORDWR(0x00df0, 0x0001),
	A6XX_PROTECT_NORDWR(0x00e01, 0x0000),
	A6XX_PROTECT_NORDWR(0x00e07, 0x0008),
	A6XX_PROTECT_NORDWR(0x03c00, 0x00c3),
	A6XX_PROTECT_RDONLY(0x03cc4, 0x1fff),
	A6XX_PROTECT_NORDWR(0x08630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x08e00, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e08, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e50, 0x001f),
	A6XX_PROTECT_NORDWR(0x08e80, 0x0280),
	A6XX_PROTECT_NORDWR(0x09624, 0x01db),
	A6XX_PROTECT_NORDWR(0x09e40, 0x0000),
	A6XX_PROTECT_NORDWR(0x09e64, 0x000d),
	A6XX_PROTECT_NORDWR(0x09e78, 0x0187),
	A6XX_PROTECT_NORDWR(0x0a630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae50, 0x000f),
	A6XX_PROTECT_NORDWR(0x0ae66, 0x0003),
	A6XX_PROTECT_NORDWR(0x0ae6f, 0x0003),
	A6XX_PROTECT_NORDWR(0x0b604, 0x0003),
	A6XX_PROTECT_NORDWR(0x0ec00, 0x0fff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x18400, 0x0053),
	A6XX_PROTECT_RDONLY(0x18454, 0x0004),
	A6XX_PROTECT_NORDWR(0x18459, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1a459, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1c459, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1f400, 0x0443),
	A6XX_PROTECT_RDONLY(0x1f844, 0x007b),
	A6XX_PROTECT_NORDWR(0x1f860, 0x0000),
	A6XX_PROTECT_NORDWR(0x1f878, 0x002a),
	/* CP_PROTECT_REG[45, 46] are left untouched! */
	0,
	0,
	A6XX_PROTECT_NORDWR(0x1f8c0, 0x00000),
};
DECLARE_ADRENO_PROTECT(a730_protect, 48);

static const uint32_t a7xx_pwrup_reglist_regs[] = {
	REG_A6XX_UCHE_TRAP_BASE,
	REG_A6XX_UCHE_TRAP_BASE + 1,
	REG_A6XX_UCHE_WRITE_THRU_BASE,
	REG_A6XX_UCHE_WRITE_THRU_BASE + 1,
	REG_A6XX_UCHE_GMEM_RANGE_MIN,
	REG_A6XX_UCHE_GMEM_RANGE_MIN + 1,
	REG_A6XX_UCHE_GMEM_RANGE_MAX,
	REG_A6XX_UCHE_GMEM_RANGE_MAX + 1,
	REG_A6XX_UCHE_CACHE_WAYS,
	REG_A6XX_UCHE_MODE_CNTL,
	REG_A6XX_RB_NC_MODE_CNTL,
	REG_A6XX_RB_CMP_DBG_ECO_CNTL,
	REG_A7XX_GRAS_NC_MODE_CNTL,
	REG_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE,
	REG_A6XX_UCHE_GBIF_GX_CONFIG,
	REG_A6XX_UCHE_CLIENT_PF,
	REG_A6XX_TPL1_DBG_ECO_CNTL1,
};

DECLARE_ADRENO_REGLIST_LIST(a7xx_pwrup_reglist);

static const struct adreno_info a7xx_gpus[] = {
	{
		.chip_ids = ADRENO_CHIP_IDS(0x07000200),
		.family = ADRENO_6XX_GEN1, /* NOT a mistake! */
		.fw = {
			[ADRENO_FW_SQE] = "a702_sqe.fw",
		},
		.gmem = SZ_128K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_HW_APRIV,
		.init = a6xx_gpu_init,
		.zapfw = "a702_zap.mbn",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a702_hwcg,
			.protect = &a650_protect,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x0000c000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 236, 1 },
			{ 178, 2 },
			{ 142, 3 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x07030001),
		.family = ADRENO_7XX_GEN1,
		.fw = {
			[ADRENO_FW_SQE] = "a730_sqe.fw",
			[ADRENO_FW_GMU] = "gmu_gen70000.bin",
		},
		.gmem = SZ_2M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV |
			  ADRENO_QUIRK_PREEMPTION,
		.init = a6xx_gpu_init,
		.zapfw = "a730_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a730_hwcg,
			.protect = &a730_protect,
			.pwrup_reglist = &a7xx_pwrup_reglist,
			.gmu_cgc_mode = 0x00020000,
		},
		.preempt_record_size = 2860 * SZ_1K,
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x43050a01), /* "C510v2" */
		.family = ADRENO_7XX_GEN2,
		.fw = {
			[ADRENO_FW_SQE] = "a740_sqe.fw",
			[ADRENO_FW_GMU] = "gmu_gen70200.bin",
		},
		.gmem = 3 * SZ_1M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV |
			  ADRENO_QUIRK_PREEMPTION,
		.init = a6xx_gpu_init,
		.zapfw = "a740_zap.mdt",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a740_hwcg,
			.protect = &a730_protect,
			.pwrup_reglist = &a7xx_pwrup_reglist,
			.gmu_chipid = 0x7020100,
			.gmu_cgc_mode = 0x00020202,
			.bcms = (const struct a6xx_bcm[]) {
				{ .name = "SH0", .buswidth = 16 },
				{ .name = "MC0", .buswidth = 4 },
				{
					.name = "ACV",
					.fixed = true,
					.perfmode = BIT(3),
					.perfmode_bw = 16500000,
				},
				{ /* sentinel */ },
			},
		},
		.preempt_record_size = 4192 * SZ_1K,
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x43050c01), /* "C512v2" */
		.family = ADRENO_7XX_GEN2,
		.fw = {
			[ADRENO_FW_SQE] = "gen70500_sqe.fw",
			[ADRENO_FW_GMU] = "gen70500_gmu.bin",
		},
		.gmem = 3 * SZ_1M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV |
			  ADRENO_QUIRK_PREEMPTION,
		.init = a6xx_gpu_init,
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a740_hwcg,
			.protect = &a730_protect,
			.pwrup_reglist = &a7xx_pwrup_reglist,
			.gmu_chipid = 0x7050001,
			.gmu_cgc_mode = 0x00020202,
		},
		.preempt_record_size = 4192 * SZ_1K,
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x43051401), /* "C520v2" */
		.family = ADRENO_7XX_GEN3,
		.fw = {
			[ADRENO_FW_SQE] = "gen70900_sqe.fw",
			[ADRENO_FW_GMU] = "gmu_gen70900.bin",
		},
		.gmem = 3 * SZ_1M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV |
			  ADRENO_QUIRK_PREEMPTION,
		.init = a6xx_gpu_init,
		.zapfw = "gen70900_zap.mbn",
		.a6xx = &(const struct a6xx_info) {
			.protect = &a730_protect,
			.pwrup_reglist = &a7xx_pwrup_reglist,
			.gmu_chipid = 0x7090100,
			.gmu_cgc_mode = 0x00020202,
			.bcms = (const struct a6xx_bcm[]) {
				{ .name = "SH0", .buswidth = 16 },
				{ .name = "MC0", .buswidth = 4 },
				{
					.name = "ACV",
					.fixed = true,
					.perfmode = BIT(2),
					.perfmode_bw = 10687500,
				},
				{ /* sentinel */ },
			},
		},
		.preempt_record_size = 3572 * SZ_1K,
	}
};
DECLARE_ADRENO_GPULIST(a7xx);

static inline __always_unused void __build_asserts(void)
{
	BUILD_BUG_ON(a630_protect.count > a630_protect.count_max);
	BUILD_BUG_ON(a650_protect.count > a650_protect.count_max);
	BUILD_BUG_ON(a660_protect.count > a660_protect.count_max);
	BUILD_BUG_ON(a690_protect.count > a690_protect.count_max);
	BUILD_BUG_ON(a730_protect.count > a730_protect.count_max);
}
