/* SPDX-License-Identifier: GPL-2.0 */
/* Register definitions for MaxLinear GSW1xx series switches
 *
 * Copyright (C) 2025 Daniel Golle <daniel@makrotopia.org>
 * Copyright (C) 2023 - 2024 MaxLinear Inc.
 */
#ifndef __MXL_GSW1XX_H
#define __MXL_GSW1XX_H

#include <linux/bitfield.h>

#define GSW1XX_PORTS				6
/* Port used for RGMII or optional RMII */
#define GSW1XX_MII_PORT				5
/* Port used for SGMII */
#define GSW1XX_SGMII_PORT			4

#define GSW1XX_SYS_CLK_FREQ			340000000

/* SMDIO switch register base address */
#define GSW1XX_SMDIO_BADR			0x1f
#define  GSW1XX_SMDIO_BADR_UNKNOWN		-1

/* GSW1XX SGMII PCS */
#define GSW1XX_SGMII_BASE			0xd000
#define GSW1XX_SGMII_PHY_HWBU_CTRL		0x009
#define  GSW1XX_SGMII_PHY_HWBU_CTRL_EN_HWBU_FSM	BIT(0)
#define  GSW1XX_SGMII_PHY_HWBU_CTRL_HW_FSM_EN	BIT(3)
#define GSW1XX_SGMII_TBI_TXANEGH		0x300
#define GSW1XX_SGMII_TBI_TXANEGL		0x301
#define GSW1XX_SGMII_TBI_ANEGCTL		0x304
#define  GSW1XX_SGMII_TBI_ANEGCTL_LT		GENMASK(1, 0)
#define   GSW1XX_SGMII_TBI_ANEGCTL_LT_10US	0
#define   GSW1XX_SGMII_TBI_ANEGCTL_LT_1_6MS	1
#define   GSW1XX_SGMII_TBI_ANEGCTL_LT_5MS	2
#define   GSW1XX_SGMII_TBI_ANEGCTL_LT_10MS	3
#define  GSW1XX_SGMII_TBI_ANEGCTL_ANEGEN	BIT(2)
#define  GSW1XX_SGMII_TBI_ANEGCTL_RANEG		BIT(3)
#define  GSW1XX_SGMII_TBI_ANEGCTL_OVRABL	BIT(4)
#define  GSW1XX_SGMII_TBI_ANEGCTL_OVRANEG	BIT(5)
#define  GSW1XX_SGMII_TBI_ANEGCTL_ANMODE	GENMASK(7, 6)
#define   GSW1XX_SGMII_TBI_ANEGCTL_ANMODE_1000BASEX	1
#define   GSW1XX_SGMII_TBI_ANEGCTL_ANMODE_SGMII_PHY	2
#define   GSW1XX_SGMII_TBI_ANEGCTL_ANMODE_SGMII_MAC	3
#define  GSW1XX_SGMII_TBI_ANEGCTL_BCOMP		BIT(15)

#define GSW1XX_SGMII_TBI_TBICTL			0x305
#define  GSW1XX_SGMII_TBI_TBICTL_INITTBI	BIT(0)
#define  GSW1XX_SGMII_TBI_TBICTL_ENTBI		BIT(1)
#define  GSW1XX_SGMII_TBI_TBICTL_CRSTRR		BIT(4)
#define  GSW1XX_SGMII_TBI_TBICTL_CRSOFF		BIT(5)
#define GSW1XX_SGMII_TBI_TBISTAT		0x309
#define  GSW1XX_SGMII_TBI_TBISTAT_LINK		BIT(0)
#define  GSW1XX_SGMII_TBI_TBISTAT_AN_COMPLETE	BIT(1)
#define GSW1XX_SGMII_TBI_LPSTAT			0x30a
#define  GSW1XX_SGMII_TBI_LPSTAT_DUPLEX		BIT(0)
#define  GSW1XX_SGMII_TBI_LPSTAT_PAUSE_RX	BIT(1)
#define  GSW1XX_SGMII_TBI_LPSTAT_PAUSE_TX	BIT(2)
#define  GSW1XX_SGMII_TBI_LPSTAT_SPEED		GENMASK(6, 5)
#define   GSW1XX_SGMII_TBI_LPSTAT_SPEED_10	0
#define   GSW1XX_SGMII_TBI_LPSTAT_SPEED_100	1
#define   GSW1XX_SGMII_TBI_LPSTAT_SPEED_1000	2
#define   GSW1XX_SGMII_TBI_LPSTAT_SPEED_NOSGMII	3
#define GSW1XX_SGMII_PHY_D			0x100
#define GSW1XX_SGMII_PHY_A			0x101
#define GSW1XX_SGMII_PHY_C			0x102
#define  GSW1XX_SGMII_PHY_STATUS		BIT(0)
#define  GSW1XX_SGMII_PHY_READ			BIT(4)
#define  GSW1XX_SGMII_PHY_WRITE			BIT(8)
#define  GSW1XX_SGMII_PHY_RESET_N		BIT(12)
#define GSW1XX_SGMII_PCS_RXB_CTL		0x401
#define  GSW1XX_SGMII_PCS_RXB_CTL_INIT_RX_RXB	BIT(1)
#define GSW1XX_SGMII_PCS_TXB_CTL		0x404
#define  GSW1XX_SGMII_PCS_TXB_CTL_INIT_TX_TXB	BIT(1)

#define GSW1XX_SGMII_PHY_RX0_CFG2		0x004
#define  GSW1XX_SGMII_PHY_RX0_CFG2_EQ		GENMASK(2, 0)
#define   GSW1XX_SGMII_PHY_RX0_CFG2_EQ_DEF	2
#define  GSW1XX_SGMII_PHY_RX0_CFG2_INVERT	BIT(3)
#define  GSW1XX_SGMII_PHY_RX0_CFG2_LOS_EN	BIT(4)
#define  GSW1XX_SGMII_PHY_RX0_CFG2_TERM_EN	BIT(5)
#define  GSW1XX_SGMII_PHY_RX0_CFG2_FILT_CNT	GENMASK(12, 6)
#define   GSW1XX_SGMII_PHY_RX0_CFG2_FILT_CNT_DEF	20

#define GSW1XX_SGMII_PHY_TX0_CFG3		0x007
#define  GSW1XX_SGMII_PHY_TX0_CFG3_VBOOST_EN	BIT(12)
#define  GSW1XX_SGMII_PHY_TX0_CFG3_VBOOST_LEVEL	GENMASK(11, 9)
#define   GSW1XX_SGMII_PHY_TX0_CFG3_VBOOST_LEVEL_DEF	4
#define  GSW1XX_SGMII_PHY_TX0_CFG3_INVERT	BIT(8)

/* GSW1XX PDI Registers */
#define GSW1XX_SWITCH_BASE			0xe000

/* GSW1XX MII Registers */
#define GSW1XX_RGMII_BASE			0xf100

/* GSW1XX GPIO Registers */
#define GSW1XX_GPIO_BASE			0xf300
#define GPIO_ALTSEL0				0x83
#define GPIO_ALTSEL0_EXTPHY_MUX_VAL		0x03c3
#define GPIO_ALTSEL1				0x84
#define GPIO_ALTSEL1_EXTPHY_MUX_VAL		0x003f

/* MDIO bus controller */
#define GSW1XX_MMDIO_BASE			0xf400

/* generic IC registers */
#define GSW1XX_SHELL_BASE			0xfa00
#define  GSW1XX_SHELL_RST_REQ			0x01
#define   GSW1XX_RST_REQ_SGMII_SHELL		BIT(5)
/* RGMII PAD Slew Control Register */
#define  GSW1XX_SHELL_RGMII_SLEW_CFG		0x78
#define   RGMII_SLEW_CFG_RX_2_5_V		BIT(4)
#define   RGMII_SLEW_CFG_TX_2_5_V		BIT(5)

/* SGMII clock related settings */
#define GSW1XX_CLK_BASE				0xf900
#define  GSW1XX_CLK_NCO_CTRL			0x68
#define   GSW1XX_SGMII_HSP_MASK			GENMASK(3, 2)
#define   GSW1XX_SGMII_SEL			BIT(1)
#define   GSW1XX_SGMII_1G			0x0
#define   GSW1XX_SGMII_2G5			0xc
#define   GSW1XX_SGMII_1G_NCO1			0x0
#define   GSW1XX_SGMII_2G5_NCO2			0x2

#endif /* __MXL_GSW1XX_H */
