
(* The type of tokens. *)

type token = 
  | STRING of (string)
  | RCUR
  | RBRA
  | NULL
  | LCUR
  | LBRA
  | INT of (int)
  | IDENTIFIER of (string)
  | FLOAT of (float)
  | EOF
  | COMMA
  | COLON
  | BOOL of (bool)

(* This exception is raised by the monolithic API functions. *)

exception Error

(* The monolithic API. *)

val json5: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Json_base.t)

val json: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Json_base.t)
