/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericURLContext
implements Context {
    protected Hashtable<Object, Object> environment;

    protected GenericURLContext() {
        this(null);
    }

    protected GenericURLContext(Hashtable<?, ?> environment) {
        this.environment = environment == null ? new Hashtable() : (Hashtable)environment.clone();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.lookup(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            Object object = context.lookup(name.getSuffix(1));
            return object;
        }
        finally {
            context.close();
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        ResolveResult result = this.getRootURLContext(name, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            Object object = context.lookup(result.getRemainingName());
            return object;
        }
        finally {
            context.close();
        }
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.lookupLink(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            Object object = context.lookupLink(name.getSuffix(1));
            return object;
        }
        finally {
            context.close();
        }
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        ResolveResult result = this.getRootURLContext(name, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            Object object = context.lookupLink(result.getRemainingName());
            return object;
        }
        finally {
            context.close();
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            this.bind(name.get(0), obj);
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.bind(name.getSuffix(1), obj);
            }
            finally {
                context.close();
            }
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        ResolveResult result = this.getRootURLContext(name, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            context.bind(result.getRemainingName(), obj);
        }
        finally {
            context.close();
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            this.rebind(name.get(0), obj);
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.rebind(name.getSuffix(1), obj);
            }
            finally {
                context.close();
            }
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        ResolveResult result = this.getRootURLContext(name, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            context.rebind(result.getRemainingName(), obj);
        }
        finally {
            context.close();
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            this.unbind(name.get(0));
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.unbind(name.getSuffix(1));
            }
            finally {
                context.close();
            }
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        ResolveResult result = this.getRootURLContext(name, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            context.unbind(result.getRemainingName());
        }
        finally {
            context.close();
        }
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.createSubcontext(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            Context context2 = context.createSubcontext(name.getSuffix(1));
            return context2;
        }
        finally {
            context.close();
        }
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        ResolveResult result = this.getRootURLContext(name, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            Context context2 = context.createSubcontext(result.getRemainingName());
            return context2;
        }
        finally {
            context.close();
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            this.destroySubcontext(name.get(0));
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.destroySubcontext(name.getSuffix(1));
            }
            finally {
                context.close();
            }
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        ResolveResult result = this.getRootURLContext(name, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            context.destroySubcontext(result.getRemainingName());
        }
        finally {
            context.close();
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        if (!(oldName instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", oldName));
        }
        if (!(newName instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", newName));
        }
        if (oldName.size() == 1 ^ newName.size() != 1) {
            throw new OperationNotSupportedException(Messages.getString("jndi.27", oldName, newName));
        }
        if (oldName.size() == 1) {
            this.rename(oldName.get(0), newName.get(0));
        } else {
            if (!this.urlEquals(oldName.get(0), oldName.get(0))) {
                throw new OperationNotSupportedException(Messages.getString("jndi.28", oldName, newName));
            }
            Context context = this.getContinuationContext(oldName);
            try {
                context.rename(oldName.getSuffix(1), newName.getSuffix(1));
            }
            finally {
                context.close();
            }
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        String newPrefix;
        String oldPrefix = this.getURLPrefix(oldName);
        if (!this.urlEquals(oldPrefix, newPrefix = this.getURLPrefix(newName))) {
            throw new OperationNotSupportedException(Messages.getString("jndi.29", oldName, newName));
        }
        ResolveResult result = this.getRootURLContext(oldName, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            context.rename(result.getRemainingName(), this.getURLSuffix(newPrefix, newName));
        }
        finally {
            context.close();
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.list(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = context.list(name.getSuffix(1));
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        ResolveResult result = this.getRootURLContext(name, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = context.list(result.getRemainingName());
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.listBindings(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings(name.getSuffix(1));
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        ResolveResult result = this.getRootURLContext(name, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings(result.getRemainingName());
            return namingEnumeration;
        }
        finally {
            context.close();
        }
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.26", name));
        }
        if (name.size() == 1) {
            return this.getNameParser(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            NameParser nameParser = context.getNameParser(name.getSuffix(1));
            return nameParser;
        }
        finally {
            context.close();
        }
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        ResolveResult result = this.getRootURLContext(name, this.environment);
        Context context = (Context)result.getResolvedObj();
        try {
            NameParser nameParser = context.getNameParser(result.getRemainingName());
            return nameParser;
        }
        finally {
            context.close();
        }
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return ((Name)prefix.clone()).addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) {
        return prefix.length() < 1 ? name : (name.length() < 1 ? prefix : String.valueOf(prefix) + '/' + name);
    }

    @Override
    public String getNameInNamespace() {
        return "";
    }

    @Override
    public Hashtable<?, ?> getEnvironment() {
        return (Hashtable)this.environment.clone();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    @Override
    public void close() {
        this.environment = null;
    }

    protected Context getContinuationContext(Name name) throws NamingException {
        return NamingManager.getContinuationContext(this.createCannotProceedException(name));
    }

    protected final CannotProceedException createCannotProceedException(Name name) throws NamingException {
        CannotProceedException cpe = new CannotProceedException();
        cpe.setResolvedObj(this.lookup(name.get(0)));
        cpe.setEnvironment(this.environment);
        return cpe;
    }

    protected abstract ResolveResult getRootURLContext(String var1, Hashtable<?, ?> var2) throws NamingException;

    protected boolean urlEquals(String url1, String url2) {
        return url1.equals(url2);
    }

    protected String getURLPrefix(String url) throws NamingException {
        int index = url.indexOf(58);
        if (index < 0) {
            throw new OperationNotSupportedException(Messages.getString("jndi.2A", url));
        }
        if (url.startsWith("//", ++index)) {
            int slashPos = url.indexOf(47, index + 2);
            index = slashPos >= 0 ? slashPos : url.length();
        }
        return url.substring(0, index);
    }

    protected Name getURLSuffix(String prefix, String url) throws NamingException {
        int length = prefix.length();
        if (length >= url.length() - 1) {
            return new CompositeName();
        }
        String suffix = url.substring(url.charAt(length) == '/' ? length + 1 : length);
        try {
            return new CompositeName().add(GenericURLContext.decodeURLString(suffix));
        }
        catch (IllegalArgumentException e) {
            throw (InvalidNameException)new InvalidNameException().initCause(e);
        }
    }

    protected static final String decodeURLString(String str) throws IllegalArgumentException {
        int length = str.length();
        byte[] bytes = new byte[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            char c;
            if ((c = str.charAt(i++)) == '%') {
                int next = i + 2;
                if (next > length) {
                    new IllegalArgumentException(Messages.getString("jndi.2B", str));
                }
                try {
                    bytes[index++] = (byte)Integer.parseInt(str.substring(i, next), 16);
                }
                catch (NumberFormatException e) {
                    throw (IllegalArgumentException)new IllegalArgumentException(Messages.getString("jndi.2B", str)).initCause(e);
                }
                i = next;
                continue;
            }
            bytes[index++] = (byte)c;
        }
        return new String(bytes, 0, index);
    }
}

