/* ----- core/inv3sntrup1013, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_inv3sntrup1013_checksums[] = {
  "c0ca4000b778d934025bb5cdc7b051f6f82600f30ccee2f9bfc39162647480df",
  "a6adb01164dcef4fd539877c8964b38ba3bcea1cef00a9d9e410b9c40bdab2e5",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_inv3sntrup1013_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_inv3sntrup1013_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_inv3sntrup1013_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_inv3sntrup1013_CONSTBYTES

static void *storage_core_inv3sntrup1013_h;
static unsigned char *test_core_inv3sntrup1013_h;
static void *storage_core_inv3sntrup1013_n;
static unsigned char *test_core_inv3sntrup1013_n;
static void *storage_core_inv3sntrup1013_k;
static unsigned char *test_core_inv3sntrup1013_k;
static void *storage_core_inv3sntrup1013_c;
static unsigned char *test_core_inv3sntrup1013_c;
static void *storage_core_inv3sntrup1013_h2;
static unsigned char *test_core_inv3sntrup1013_h2;
static void *storage_core_inv3sntrup1013_n2;
static unsigned char *test_core_inv3sntrup1013_n2;
static void *storage_core_inv3sntrup1013_k2;
static unsigned char *test_core_inv3sntrup1013_k2;
static void *storage_core_inv3sntrup1013_c2;
static unsigned char *test_core_inv3sntrup1013_c2;

#define precomputed_core_inv3sntrup1013_NUM 5

static const unsigned char precomputed_core_inv3sntrup1013_h[precomputed_core_inv3sntrup1013_NUM][crypto_core_OUTPUTBYTES] = {
  {1,0,0,0,255,255,1,255,1,255,1,1,0,1,1,0,1,255,255,255,255,255,1,0,1,1,0,1,255,0,1,255,0,255,1,1,0,1,255,0,255,0,0,255,0,0,255,0,0,0,255,255,0,1,0,255,1,255,1,0,0,1,255,0,0,255,255,255,255,1,1,1,0,1,255,255,1,255,255,0,1,255,0,1,255,0,1,255,1,1,1,255,1,1,0,255,1,255,255,0,0,1,255,0,0,255,1,0,0,255,1,1,0,0,1,1,255,1,255,255,1,1,255,1,255,255,1,255,0,255,0,1,1,1,255,1,1,0,1,1,255,1,0,0,1,255,0,0,0,255,0,1,0,0,0,0,0,1,0,255,1,255,1,0,1,1,0,0,0,0,1,0,1,0,255,0,0,255,255,1,255,1,1,0,1,1,0,0,0,0,255,0,0,0,1,0,255,255,0,0,1,255,255,255,1,1,0,255,0,0,1,0,255,1,255,255,255,1,1,255,1,1,255,255,0,0,0,255,0,0,1,0,255,255,255,1,255,255,1,0,0,0,255,0,1,0,1,255,255,255,255,1,1,0,0,1,0,255,255,255,0,0,255,255,0,0,1,1,1,0,255,0,1,1,0,0,255,1,0,1,1,255,255,1,1,0,1,255,0,1,1,255,0,255,1,255,0,0,0,255,0,255,1,0,1,1,255,0,0,255,0,1,255,0,1,0,255,255,0,0,255,255,0,0,255,0,0,1,1,255,1,1,255,255,255,255,1,0,255,255,0,1,0,255,1,255,0,0,0,255,0,255,0,1,255,0,1,0,255,1,1,1,1,1,255,255,1,1,0,1,255,255,0,255,1,1,255,255,0,0,0,255,1,0,0,0,1,1,1,1,0,0,0,255,0,0,1,1,0,255,0,0,255,0,1,255,1,1,1,1,1,255,0,255,255,255,255,0,1,1,255,0,255,255,0,255,1,255,255,0,0,0,0,1,0,255,255,0,1,0,255,0,1,255,255,0,255,1,0,255,255,1,0,0,1,1,1,255,1,1,255,1,0,1,1,255,1,1,0,255,1,1,255,255,1,255,255,0,0,1,255,0,0,255,0,1,1,255,255,1,0,0,0,255,0,0,1,1,0,255,255,255,1,0,1,255,1,0,255,1,1,255,255,0,0,255,0,0,255,1,255,0,1,0,255,255,1,0,255,0,1,1,1,255,1,1,0,255,1,255,255,1,0,255,0,255,0,0,0,255,255,255,255,0,1,1,0,0,255,1,255,1,1,255,1,0,255,0,255,0,0,0,0,1,0,0,1,255,1,0,1,255,1,0,1,0,1,0,0,1,1,1,1,255,1,0,255,1,255,255,1,1,255,0,1,255,1,255,1,1,1,1,255,255,0,1,1,255,255,255,1,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,1,0,1,0,1,1,0,0,0,0,0,0,0,1,255,255,0,255,255,0,0,1,0,1,255,255,255,0,0,1,1,255,0,0,0,255,0,1,0,255,0,0,255,255,0,0,0,255,0,1,0,0,0,0,255,0,255,1,1,255,0,255,255,255,1,0,1,0,0,1,1,255,1,255,255,1,0,255,0,255,255,255,0,1,1,1,1,1,0,255,0,1,0,255,255,1,0,0,1,0,1,255,1,255,1,0,255,255,1,255,1,1,0,255,1,255,1,0,0,1,0,0,0,255,0,0,1,1,255,1,255,1,1,255,1,1,1,0,255,0,255,0,1,255,255,1,0,255,255,255,0,1,0,0,1,0,0,255,1,255,255,0,255,1,0,1,0,255,1,0,255,1,1,1,1,0,255,0,0,0,1,255,0,255,0,0,0,255,1,0,255,0,1,1,0,1,1,0,255,1,0,0,1,1,1,0,1,255,1,0,0,0,255,0,1,1,1,0,255,255,1,255,1,1,255,0,0,255,1,255,255,1,1,255,0,1,255,0,255,255,1,1,0,255,255,255,255,1,0,0,255,0,0,255,1,255,1,1,0,255,255,255,0,255,1,255,255,0,255,1,255,0,255,0,0,0,255,1,1,255,255,1,0,1,0,1,1,255,1,255,0,255,0,255,255,0,255,255,0,0,255,0,255,0,255,0,0,255,255,0,1,1,255,1,0,255,255,1,1,1,255,1,1,1,255,0,1,1,255,0,255,1,255,1,255,255,1,255,1,1,0,1,1,255,1,1,255,255,255,1,1,0,0,0,255,0,0,1,255,0,1,1,255,0,1,0,1,0,1,0,0,1,1,1,255,1,0},
  {0,0,255,255,255,255,0,1,255,0,1,1,255,0,255,255,1,255,255,0,1,0,1,1,0,0,255,255,1,1,0,1,1,1,1,0,255,1,0,255,0,255,0,0,1,255,0,1,0,255,1,1,0,0,255,1,0,1,0,0,0,255,255,1,255,1,0,0,1,1,1,255,0,255,0,255,1,255,255,0,255,1,1,255,1,1,1,1,255,0,1,1,1,0,1,0,1,1,0,1,0,1,255,255,255,255,0,0,1,0,255,255,255,1,0,255,0,1,255,1,0,0,0,0,255,0,255,255,255,0,255,1,1,1,1,1,1,255,0,255,1,1,1,1,255,1,0,1,0,1,1,1,1,255,0,255,1,1,255,0,255,0,1,1,0,255,1,1,1,1,1,255,255,0,1,0,255,0,0,1,1,255,1,1,0,255,0,0,255,255,255,255,1,1,255,255,0,1,255,255,0,1,0,255,1,255,255,1,1,255,0,0,1,255,1,1,1,1,1,255,1,0,1,0,0,1,1,1,255,0,255,1,255,0,255,0,255,255,0,0,0,255,1,0,255,0,255,1,0,1,1,255,0,255,0,0,0,0,255,0,255,1,0,0,1,0,0,255,255,1,1,255,0,0,255,0,1,255,255,255,1,0,255,255,255,0,1,1,1,255,0,0,1,0,1,0,255,0,255,1,255,255,1,1,255,255,255,0,1,0,255,255,255,255,255,1,255,255,0,1,255,1,1,255,255,1,0,1,1,255,255,255,0,255,255,255,255,1,255,255,0,1,1,255,255,0,0,0,0,1,1,0,1,1,255,1,255,1,255,1,0,0,255,0,255,255,255,0,255,1,255,255,0,255,0,1,0,255,255,0,255,255,1,1,1,255,1,0,1,255,255,1,0,0,255,0,255,0,0,0,255,1,255,255,255,255,0,0,255,255,1,255,1,1,255,0,1,255,255,0,0,255,255,255,255,1,255,255,0,255,0,255,1,1,255,1,255,1,255,255,255,255,255,0,1,0,255,1,255,0,0,0,0,0,1,255,255,0,255,255,1,1,0,1,1,0,255,255,0,255,1,0,0,1,255,1,1,255,1,0,255,255,0,255,1,0,1,255,255,0,0,255,255,0,255,1,0,0,0,255,1,1,255,255,255,0,1,0,255,1,0,255,0,0,0,255,1,0,255,1,255,1,1,255,255,255,0,255,255,0,255,0,1,255,1,1,0,1,1,1,0,255,1,1,0,0,0,0,255,0,0,1,0,1,255,1,0,0,1,1,255,1,255,0,255,255,1,0,1,0,0,1,0,0,0,1,1,0,255,255,0,0,1,1,255,0,0,1,1,0,1,1,255,255,0,1,255,0,255,255,1,255,255,0,255,255,1,0,255,0,0,1,1,255,0,0,255,1,0,255,255,0,1,1,255,1,1,0,0,0,1,0,255,255,1,255,255,1,255,0,1,255,0,255,255,0,0,1,255,255,0,0,255,0,1,0,1,255,1,0,1,0,1,1,255,1,0,1,0,1,1,0,255,0,1,255,0,0,0,255,255,1,0,1,1,0,255,0,1,255,1,255,0,255,255,255,0,0,255,1,255,1,255,1,0,1,255,255,1,0,1,0,1,1,1,0,0,255,1,1,1,255,0,255,1,1,0,0,0,0,0,255,1,1,255,255,0,1,0,255,0,1,255,1,255,1,1,1,1,1,1,1,255,255,255,0,1,0,255,1,1,0,1,255,1,1,255,1,0,0,0,0,255,255,1,1,255,1,255,0,1,0,0,255,255,1,255,1,1,1,255,0,255,1,0,255,1,0,1,255,255,1,0,1,0,1,0,255,255,1,1,1,1,255,0,255,1,1,0,1,1,255,255,255,1,255,0,1,1,255,0,0,1,255,0,1,1,255,0,255,0,0,1,0,0,1,255,255,0,1,1,1,0,255,255,255,255,255,1,0,1,255,0,1,0,255,255,1,255,0,1,1,0,255,0,0,255,0,255,1,1,0,255,1,0,1,255,1,1,0,1,0,0,1,0,255,1,0,1,1,1,0,0,255,1,1,255,1,255,0,0,0,255,1,0,1,1,255,1,1,0,1,0,0,255,255,255,1,1,255,0,255,1,1,255,0,1,255,0,1,1,0,1,255,0,255,0,1,1,255,255,255,255,0,0,255,255,1,255,0,1,255,0,0,255,255,255,255,0,255,0,1,0,255,0,1,255,255,1,0,1,255,1,1,1,0,1,1,1,255,255,255,255,0,0,255,0,1,255,255,0,0,255,0,255,0,1,1,1,255,0,255,255,0},
  {0,255,255,0,1,0,255,0,1,255,1,1,1,0,255,0,255,1,0,255,255,255,1,0,255,1,0,0,0,0,0,0,1,0,1,255,0,255,255,1,1,1,255,0,255,255,0,1,0,1,255,255,0,0,0,0,255,1,0,0,1,0,255,1,0,0,255,1,0,1,0,0,1,1,255,255,255,1,255,1,255,1,0,0,1,255,0,255,1,1,0,1,0,1,255,1,255,255,1,0,255,255,0,255,0,255,1,1,1,0,0,0,0,255,0,255,0,1,255,255,0,0,1,255,255,1,0,255,0,255,0,1,1,255,0,255,255,255,255,0,255,255,0,0,255,255,1,0,0,0,0,255,255,255,255,0,1,255,0,255,255,0,1,255,1,0,255,0,255,255,1,0,0,1,1,255,255,255,255,0,1,0,1,1,1,255,0,0,0,255,0,255,255,0,0,0,255,255,1,1,1,255,255,0,255,0,255,1,1,255,0,0,255,255,255,1,255,255,255,1,0,255,255,1,0,255,0,0,1,255,1,1,0,0,1,255,1,0,1,255,1,255,1,0,0,0,1,0,255,0,0,1,0,0,1,255,255,0,0,1,1,0,1,1,0,1,1,1,255,1,1,0,1,1,1,255,255,255,1,255,1,255,0,255,0,0,255,0,0,0,0,255,255,0,1,1,1,255,0,0,1,255,1,255,255,0,0,0,255,1,1,255,1,0,1,255,1,0,255,1,255,255,1,1,0,0,255,1,255,0,255,0,0,1,255,1,1,0,0,255,0,255,255,0,255,1,1,255,255,0,255,1,255,0,1,1,1,0,255,255,0,0,0,255,0,1,0,1,1,0,255,0,255,1,255,255,1,0,0,255,0,0,255,255,255,0,0,255,255,1,0,1,0,1,1,1,0,1,0,1,0,0,255,0,1,0,0,255,0,0,255,0,1,1,1,1,1,0,255,255,0,255,255,255,0,1,255,255,255,0,1,0,255,1,1,255,1,0,1,0,0,1,0,255,255,1,0,0,0,0,0,255,1,1,0,1,0,0,1,1,255,0,0,1,1,1,0,0,1,0,1,0,255,255,255,1,1,0,1,255,0,1,255,1,255,1,1,1,0,1,255,0,255,255,0,255,1,1,255,1,0,1,1,255,1,0,255,255,255,255,255,255,1,255,0,0,255,1,0,0,255,0,1,1,1,0,0,0,0,1,255,1,0,1,255,255,0,1,255,0,1,1,255,1,255,0,0,0,255,255,0,0,0,0,255,0,255,255,255,255,1,1,1,0,0,1,0,0,0,1,1,1,1,0,255,255,1,0,1,0,255,255,255,1,1,255,0,255,255,0,255,1,1,1,255,255,1,1,255,0,255,1,0,1,1,1,255,0,255,1,1,0,1,255,1,255,255,1,0,255,255,0,1,255,1,0,0,255,1,1,255,1,1,1,1,0,0,255,0,255,1,255,255,0,1,255,0,1,1,1,1,0,1,1,0,1,255,0,0,0,255,255,255,1,0,0,255,0,1,1,255,0,1,1,1,255,1,255,255,0,255,0,1,255,255,255,1,0,0,1,1,255,255,0,0,255,0,1,1,255,255,0,0,0,1,1,0,255,0,0,1,0,255,0,255,0,0,0,1,1,1,0,1,0,1,0,1,0,0,1,0,0,0,1,0,255,255,0,0,255,1,255,0,0,1,0,1,255,255,255,1,1,0,0,1,1,1,1,255,0,1,255,0,255,1,255,0,1,255,1,0,255,1,0,255,1,0,255,1,0,1,1,0,1,255,0,1,0,0,255,255,1,1,255,0,1,1,1,0,255,0,0,255,255,255,0,1,1,255,255,0,1,0,1,255,0,1,0,0,255,1,0,0,0,255,1,0,0,255,255,255,1,1,0,255,1,0,1,255,255,255,0,0,1,0,0,1,0,255,1,255,0,1,255,255,0,1,1,255,1,0,1,1,1,0,1,1,255,0,0,255,255,1,0,1,255,1,0,255,0,0,255,1,1,0,255,255,1,255,1,0,0,255,255,0,255,1,0,255,255,1,0,0,1,0,255,1,0,0,1,0,255,255,1,0,0,1,0,0,255,1,255,1,255,0,0,1,255,1,0,255,1,255,0,0,0,255,0,255,1,0,0,0,0,1,0,1,0,0,0,1,255,255,255,1,0,1,255,0,255,0,1,255,1,1,1,0,0,255,255,255,0,1,0,255,255,1,0,0,0,0,1,255,1,1,255,1,0,1,0,0,0,0,1,0,1,1,1,0,0,255,0,1,1,0,255,1,0,255,1,255,1,1,0},
  {1,1,0,1,0,1,0,1,0,255,0,1,0,255,255,255,255,1,0,1,0,1,0,255,255,1,1,255,0,1,0,1,0,1,0,255,1,255,0,0,1,0,0,0,255,1,1,0,255,255,255,1,0,0,1,1,1,255,255,0,255,255,0,0,255,0,0,255,0,1,1,0,0,255,0,255,0,1,0,0,255,0,255,255,1,255,1,255,0,0,0,1,1,0,1,0,0,0,0,0,255,255,1,0,255,0,255,1,1,0,255,255,0,1,255,1,1,0,255,1,0,0,0,255,0,255,255,255,255,255,0,1,255,255,255,255,255,0,1,0,255,0,0,255,0,1,255,255,255,0,0,0,255,0,255,0,255,255,1,1,1,1,0,1,1,1,0,1,1,0,255,255,255,255,255,255,0,255,1,255,255,1,1,1,0,0,1,255,0,1,1,255,1,255,0,0,255,0,1,0,255,0,1,255,255,1,1,0,255,0,255,255,1,255,255,1,0,0,255,1,1,1,255,255,255,255,0,1,255,0,0,1,1,255,255,0,1,1,0,0,0,0,0,1,1,0,255,0,0,255,255,0,1,0,1,0,0,0,255,0,1,255,1,255,0,255,1,0,255,0,255,1,255,255,255,255,0,0,1,1,255,1,0,255,255,255,255,255,1,0,255,1,255,0,0,1,1,1,0,1,255,1,0,0,255,0,1,0,1,255,1,1,255,0,255,255,255,255,0,0,1,255,255,1,1,1,0,1,0,255,0,1,255,0,0,255,1,0,0,255,1,1,0,0,0,255,1,1,1,255,1,1,255,0,255,255,255,255,1,0,255,255,255,0,1,0,1,255,255,1,0,0,255,255,255,0,1,0,1,1,0,255,1,255,1,255,0,0,1,255,0,255,255,1,255,0,1,0,0,1,0,1,255,1,0,255,255,0,1,0,255,1,0,1,0,1,255,255,1,255,0,255,255,1,0,255,1,255,0,255,255,1,255,0,255,0,0,1,1,1,0,1,0,0,0,1,255,255,0,1,0,1,0,0,255,1,0,0,255,1,0,255,0,1,1,0,1,1,255,0,0,255,255,1,255,0,255,0,1,255,0,255,1,0,1,0,0,255,1,1,0,255,255,1,255,1,1,0,0,255,255,0,1,0,1,255,255,255,1,1,1,255,0,1,255,1,1,255,0,1,1,255,1,0,0,255,255,255,1,255,1,0,1,255,255,1,255,0,0,255,255,1,255,1,255,0,1,1,0,0,1,0,0,0,1,1,1,0,0,0,0,255,1,1,255,255,1,255,0,1,1,1,255,1,1,255,255,255,1,0,255,255,0,1,255,0,0,0,0,255,0,255,0,255,1,0,0,1,1,0,255,0,0,0,1,0,1,1,1,1,0,255,255,0,1,255,1,255,255,0,0,0,1,255,0,1,0,255,1,0,0,255,0,1,255,255,0,0,0,255,0,0,1,0,0,1,255,1,1,0,0,1,0,0,1,1,0,255,1,255,0,255,255,255,255,0,255,1,0,0,255,1,1,1,255,1,0,255,1,1,0,0,1,0,1,1,255,0,1,1,1,1,255,1,255,0,1,1,1,1,1,0,1,255,1,1,0,1,255,0,1,0,255,255,255,1,0,255,255,1,255,0,0,1,1,0,255,0,0,255,0,0,1,255,0,0,1,1,1,0,1,1,255,1,255,0,255,255,255,255,255,255,0,255,1,1,255,0,255,255,0,255,1,0,255,1,1,255,0,255,0,0,0,0,255,0,0,1,1,255,0,255,255,255,0,0,1,1,1,0,255,255,1,1,1,255,1,0,255,1,0,255,255,1,255,255,1,1,255,0,1,0,0,255,255,255,0,255,255,255,0,0,1,0,255,1,0,0,255,1,255,255,255,0,255,0,255,0,255,255,255,255,0,255,255,1,255,0,255,255,0,1,255,1,0,0,0,255,0,1,0,0,1,1,1,255,0,255,0,1,255,0,255,1,0,0,1,0,0,0,1,0,0,255,1,0,1,1,1,0,0,1,255,255,0,1,1,1,255,0,0,1,255,1,1,0,0,255,0,0,1,255,1,255,255,255,1,255,0,0,0,0,255,255,0,0,255,255,1,1,0,0,0,1,1,0,1,1,1,0,1,1,1,255,0,255,1,1,0,0,255,1,255,1,255,255,0,0,255,0,0,0,1,1,0,255,0,255,0,0,0,1,255,0,0,255,0,0,1,255,1,1,0,1,1,0,0,255,1,255,255,1,0,0,1,1,1,255,1,0,0,255,1,255,255,1,255,0,255,255,255,0,255,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255},
} ;

static const unsigned char precomputed_core_inv3sntrup1013_n[precomputed_core_inv3sntrup1013_NUM][crypto_core_INPUTBYTES] = {
  {24,117,228,237,236,149,109,235,73,118,166,234,104,156,140,12,127,125,22,179,102,74,135,170,248,5,224,247,68,192,201,126,227,132,57,55,213,20,206,135,19,5,122,192,77,63,148,78,189,203,117,2,14,142,235,150,198,90,152,220,197,192,165,143,20,116,49,201,135,228,187,203,181,254,38,190,44,250,219,84,135,235,16,30,200,235,104,182,57,35,76,91,21,109,144,170,255,50,243,73,127,108,231,22,101,170,192,78,241,115,93,184,235,75,225,6,72,166,38,218,87,40,10,1,29,126,90,96,231,223,219,56,207,124,181,54,191,86,110,158,179,55,168,40,208,75,75,195,202,140,169,196,47,82,11,81,175,81,227,72,157,171,29,162,106,42,192,230,7,227,125,33,150,62,6,181,166,20,151,104,71,127,174,93,234,89,240,120,111,108,105,59,138,186,11,183,98,159,206,39,32,52,237,20,98,144,15,122,242,59,115,154,25,56,152,111,19,6,102,109,219,59,89,217,83,82,161,21,28,221,85,151,212,64,100,194,166,45,130,158,172,89,87,225,119,172,78,242,103,21,110,94,186,143,53,1,181,5,49,117,238,226,106,147,208,13,242,55,110,84,174,36,92,144,218,192,34,72,46,18,142,55,94,127,124,217,167,196,72,47,176,75,138,196,66,219,125,39,40,199,89,86,128,227,74,38,35,217,101,159,245,113,199,250,99,111,4,59,206,86,136,121,191,3,66,53,148,66,5,94,100,62,102,242,37,230,45,236,2,67,106,97,158,189,254,143,104,97,253,12,212,23,55,188,209,120,45,147,175,93,141,106,241,225,245,218,223,223,131,2,55,100,181,72,55,41,135,172,143,41,100,233,224,242,4,187,246,117,243,145,120,133,236,120,156,134,39,76,50,215,31,247,19,235,60,80,176,45,232,108,157,91,181,41,19,175,130,222,210,177,191,90,11,10,150,235,191,231,228,54,223,206,168,87,101,164,185,120,94,204,36,182,82,177,65,252,28,61,35,248,204,40,238,205,6,56,104,60,56,135,120,1,227,35,197,137,224,59,17,107,28,133,218,88,37,143,148,35,187,245,113,209,132,47,232,143,120,70,27,93,39,110,17,142,193,95,247,12,7,41,247,21,169,137,109,192,115,161,5,125,28,108,238,140,225,52,210,216,210,249,40,197,203,85,187,72,6,239,18,177,226,105,100,223,103,179,67,9,108,153,104,213,36,163,252,117,158,156,179,32,68,139,182,142,225,147,47,23,43,196,100,16,189,155,245,129,44,134,124,174,209,34,46,144,103,240,186,198,136,107,82,217,65,228,77,216,203,202,135,201,144,191,34,3,110,200,243,122,4,96,176,196,210,48,202,42,93,123,158,143,111,152,39,146,98,239,85,0,4,1,153,116,33,114,107,211,238,27,66,89,76,179,250,250,205,10,181,133,248,94,241,168,86,238,126,59,66,241,161,166,193,216,91,45,107,202,33,73,56,64,183,154,93,3,162,16,243,208,2,72,24,103,252,126,148,111,227,216,157,171,165,44,179,22,95,79,82,121,61,26,140,84,249,0,81,229,106,62,119,151,52,109,241,254,157,106,128,230,194,147,130,80,241,118,210,59,227,158,131,235,73,215,140,87,185,27,4,88,164,201,90,138,238,243,98,98,175,42,150,169,10,230,115,216,235,86,80,155,228,242,235,216,47,148,240,194,195,44,163,216,51,143,174,79,109,233,163,84,89,195,243,152,204,141,21,39,88,154,159,120,235,157,229,185,81,109,71,245,100,107,162,61,62,13,149,239,100,40,200,217,158,207,194,144,131,238,2,247,249,38,252,85,92,160,181,121,223,208,51,85,76,204,5,231,22,195,72,161,106,216,229,85,53,122,250,242,109,198,12,46,58,85,237,233,220,235,251,4,207,173,193,191,10,143,152,130,79,147,62,128,191,55,238,190,21,249,250,89,198,8,230,137,40,151,5,76,202,150,116,160,113,42,239,119,36,234,3,75,157,106,83,247,113,196,88,53,106,144,252,92,144,34,65,238,212,180,10,49,120,114,160,101,104,120,188,64,17,135,255,110,142,100,175,253,146,32,8,237,145,119,178,192,201,128,240,18,83,220,254,217,178,225,18,169,232,94,216,211,121,206,210,220,169,209,194,177,111,238,243,64,9,245,196,16,0,107,87,142,9,233,203,119,81,12,1,104,228,171,96,146,196,35,200,30,49,35,108,50,91,172,14,112,37,206,107,33,178,245,67,88,151,52,120,210,3,124,176,26,205,1,99,15,134},
  {245,79,240,241,16,69,141,237,63,68,152,94,111,212,116,172,151,114,85,172,28,66,224,135,165,29,212,5,78,239,103,174,164,121,120,208,121,45,175,87,240,124,10,249,58,169,170,217,101,47,233,48,157,161,226,83,233,1,75,12,3,34,154,245,63,127,143,17,135,223,185,192,226,252,69,246,112,205,20,247,142,79,166,87,95,237,13,107,17,194,192,216,37,106,92,7,229,135,136,197,36,188,251,211,121,43,39,104,182,33,232,78,124,50,164,187,211,119,243,11,181,100,202,139,197,157,106,213,44,18,245,138,34,179,49,201,138,59,86,151,147,255,63,137,236,144,91,70,153,208,23,228,35,93,3,130,248,191,212,169,201,91,135,195,237,189,67,214,251,244,217,105,58,39,142,119,57,52,60,174,235,246,120,97,161,241,202,62,82,119,220,77,239,95,150,159,125,47,86,172,127,72,222,106,174,4,137,99,172,90,67,83,136,183,30,41,38,189,173,137,99,216,190,212,243,1,50,66,83,158,209,34,185,147,210,19,95,237,223,243,61,49,160,230,119,4,132,179,211,137,159,235,59,16,162,240,132,16,168,110,163,21,70,3,13,207,76,4,131,112,184,143,82,219,95,116,122,50,123,124,126,76,210,201,229,98,26,163,230,136,128,197,15,86,85,117,177,157,132,155,233,119,116,227,182,19,161,3,8,251,253,220,53,178,12,110,171,138,77,253,201,240,87,108,115,185,33,190,59,251,198,71,203,132,171,31,62,118,49,126,60,193,130,78,224,241,206,14,254,185,152,211,205,194,175,156,67,194,165,86,207,52,249,103,145,107,158,102,203,192,24,71,61,63,151,203,62,217,1,187,169,146,9,74,66,172,231,161,189,28,134,199,41,103,125,113,74,100,198,42,49,140,66,31,18,118,145,154,25,243,115,229,117,94,160,11,173,203,135,224,214,137,178,233,40,178,157,48,63,83,62,204,155,21,169,159,97,206,183,143,191,140,90,164,50,254,46,239,208,66,37,176,215,34,138,26,229,174,55,182,7,238,0,13,135,129,148,167,0,22,248,102,150,70,245,2,203,60,4,150,53,192,220,131,203,40,26,76,134,58,213,217,151,199,225,130,196,25,208,161,91,187,149,169,242,178,24,31,244,99,61,237,208,226,45,69,224,27,234,154,10,199,199,10,146,117,157,223,2,114,48,2,136,211,15,129,97,185,33,158,145,35,174,191,34,49,15,120,13,236,171,66,187,35,143,70,202,37,53,207,148,142,142,38,91,182,179,109,45,227,157,13,185,18,91,28,142,84,148,70,232,246,82,159,115,211,161,176,114,216,98,122,244,5,253,156,144,2,65,134,144,183,50,198,245,132,245,233,142,95,120,230,150,108,25,139,250,61,224,208,42,255,82,134,194,117,88,244,30,158,102,231,158,231,91,249,48,91,41,31,135,213,107,109,247,21,231,156,92,142,208,148,145,89,136,21,81,136,183,6,76,167,156,235,88,86,27,125,250,122,47,111,34,36,131,113,176,248,56,179,86,28,164,131,105,18,242,232,68,182,107,181,192,179,74,44,30,158,103,77,5,54,199,33,176,202,72,232,221,237,2,115,239,207,51,242,127,181,194,248,195,158,107,61,68,84,125,191,207,113,27,96,165,144,41,221,131,222,197,52,181,163,111,172,66,158,27,150,57,150,130,179,226,90,37,225,99,108,61,20,208,157,223,133,111,132,221,78,180,31,46,193,174,80,194,163,170,2,55,217,33,19,225,184,236,141,255,50,45,249,198,182,129,139,168,146,204,64,158,54,117,71,105,109,64,50,184,135,193,129,244,120,47,181,136,85,233,235,250,132,222,197,45,239,129,144,130,65,183,10,125,237,209,11,212,14,119,25,70,14,190,47,138,92,122,8,83,92,97,79,248,115,23,113,225,98,35,49,189,94,63,215,105,18,185,34,56,78,1,240,244,68,213,227,161,48,130,68,17,132,136,141,181,217,160,107,116,180,212,179,106,1,53,113,199,244,75,50,149,244,92,119,70,122,225,108,8,118,2,64,187,94,116,236,23,169,144,182,174,254,157,172,155,127,72,192,28,10,19,194,220,54,58,168,235,178,75,4,177,105,141,220,39,103,151,154,232,31,115,245,239,7,100,158,203,222,208,192,209,132,117,216,199,34,223,132,235,114,232,254,250,121,44,132,1,105,39,5,19,246,66,202,142,102,215,236,241,24,139,91,167,128,17,141,220,65,23,9,45,131,47,189,184,255,30,198,172,249,201,234,12,202,192},
  {174,126,126,41,183,62,79,152,197,105,202,255,166,183,139,128,33,67,240,69,133,176,49,47,221,61,169,74,88,53,136,192,208,227,38,132,199,127,135,32,129,210,155,12,102,159,14,153,236,46,109,226,234,236,125,143,254,120,85,180,115,92,137,35,191,169,163,118,70,222,157,125,58,176,222,109,109,54,177,200,91,125,111,97,225,80,133,239,24,194,111,130,183,84,194,199,90,252,151,47,19,7,112,151,30,1,51,37,195,211,138,118,233,10,245,190,49,36,74,237,181,23,5,163,251,199,86,43,223,107,205,245,88,253,228,70,46,215,100,176,44,9,41,233,239,35,255,36,235,24,115,163,196,188,74,83,87,39,227,67,243,82,73,65,158,132,233,195,235,21,17,151,71,99,53,7,175,202,68,110,180,227,165,105,185,215,95,144,109,69,74,202,106,225,218,102,143,217,100,12,36,193,81,2,7,29,6,211,17,150,71,111,24,165,236,197,99,169,15,79,114,67,50,101,171,55,185,100,13,111,127,102,59,81,183,170,17,56,181,73,190,3,128,228,26,48,184,126,34,82,204,68,0,243,129,75,178,4,183,105,177,11,146,150,33,109,231,93,230,110,122,208,109,196,92,192,132,109,167,166,11,114,39,213,78,252,194,250,140,49,239,146,88,184,178,206,210,149,121,101,78,120,197,77,5,222,166,42,86,113,172,68,4,119,32,233,194,244,232,67,50,82,253,161,206,20,145,82,120,2,15,22,228,60,136,153,146,226,166,184,154,2,150,13,243,2,148,175,149,65,139,17,212,119,174,102,151,237,179,180,164,18,84,28,247,226,221,148,68,83,34,190,38,60,223,198,138,89,74,10,22,126,144,102,66,50,200,83,14,81,11,6,36,106,117,177,36,184,120,105,30,95,218,35,100,214,233,183,3,194,240,39,229,7,235,190,183,51,72,197,39,247,9,49,25,250,35,119,129,184,114,126,215,206,99,9,156,120,143,160,188,48,231,105,128,104,131,25,207,109,12,154,135,174,180,86,49,200,178,193,105,0,23,89,31,17,92,208,48,62,75,170,231,114,181,120,200,237,28,181,194,100,251,64,114,147,218,38,119,83,68,54,241,245,243,7,194,249,198,136,46,248,111,234,180,52,207,177,37,209,202,116,24,249,225,252,94,63,45,68,136,42,90,95,239,166,243,156,181,107,38,195,69,18,237,120,33,136,117,140,216,219,235,74,127,139,100,170,94,95,60,31,179,188,127,31,247,149,191,41,128,218,17,128,105,133,211,99,198,95,200,10,177,127,23,26,49,62,97,149,79,132,77,53,191,130,7,96,64,127,183,49,238,241,162,250,214,249,170,88,55,36,49,204,13,12,134,140,8,50,250,141,98,232,118,40,59,76,187,100,183,48,36,239,94,176,97,247,238,94,202,245,100,177,245,127,179,127,87,127,191,157,3,164,200,10,72,136,187,4,99,179,24,21,119,19,16,240,139,36,179,78,102,194,138,68,8,46,196,55,234,149,224,130,80,243,103,166,144,16,128,189,28,51,152,106,12,189,218,211,81,12,142,47,3,152,98,238,18,25,105,39,25,191,57,209,49,22,225,199,98,219,6,250,139,4,222,51,244,196,168,61,68,195,24,67,238,145,112,123,216,228,13,58,250,78,246,79,47,14,24,188,226,85,26,0,144,73,173,147,239,45,97,250,176,133,70,154,235,54,225,75,110,107,159,16,63,207,67,23,13,107,27,56,46,65,162,89,164,131,62,118,104,150,244,145,184,79,127,203,160,62,198,60,152,168,181,39,151,7,146,205,185,70,124,218,188,144,84,62,205,74,58,14,53,154,98,30,133,213,11,178,209,147,254,21,190,237,66,166,108,129,27,122,122,4,115,151,21,215,115,115,31,250,168,157,88,37,28,243,184,191,209,65,44,103,79,52,59,138,207,211,230,27,211,157,206,168,53,60,155,29,81,172,109,191,105,191,255,15,250,131,238,220,78,84,111,175,125,200,57,160,222,86,10,254,138,237,0,3,84,77,82,136,41,177,23,119,111,113,170,7,25,59,83,117,152,139,222,178,109,112,141,131,78,3,230,195,8,21,13,152,17,40,21,15,83,84,11,19,228,174,27,222,228,252,36,214,182,130,90,12,157,43,142,29,30,189,84,216,144,228,242,207,228,118,15,41,128,165,35,230,181,97,227,223,97,176,172,51,55,56,102,5,72,38,51,154,57,242,188,88,237,53,173,60,109,128,107,118,108,25,226,116,86,18,65,5,238,233,177,16,16},
  {95,74,118,227,52,231,24,183,242,32,136,51,156,239,88,116,35,179,44,230,207,158,21,58,160,1,34,88,255,236,27,63,219,206,219,250,45,90,159,59,40,65,109,195,126,205,53,110,150,128,88,208,143,248,40,53,251,102,224,180,8,225,144,27,127,23,241,117,60,13,193,94,233,0,173,39,107,162,91,125,252,79,4,179,137,65,192,165,88,64,56,129,193,18,239,146,90,112,62,129,228,163,244,146,114,119,53,202,168,38,150,151,97,129,43,18,206,245,109,28,251,23,203,148,32,14,167,34,167,91,229,158,147,105,74,25,46,154,32,173,21,190,94,37,161,245,97,94,91,11,252,179,99,249,157,180,134,0,252,30,64,242,27,113,235,213,121,200,246,181,133,67,194,97,245,207,227,22,171,139,226,13,96,176,187,118,148,221,45,231,130,1,43,92,195,100,103,107,95,24,3,143,13,242,50,27,1,123,36,100,31,55,247,151,228,150,78,179,113,98,103,156,143,32,216,161,143,227,119,216,205,132,25,142,105,236,185,216,225,202,138,24,11,211,85,68,16,140,80,196,237,81,143,35,124,66,82,117,194,72,138,160,234,119,173,246,239,39,176,190,191,47,186,3,172,36,238,44,68,110,232,245,141,116,122,255,57,58,197,117,215,227,246,199,92,174,232,16,61,2,87,235,20,28,233,193,244,11,114,92,128,230,64,52,227,213,19,170,176,90,8,11,191,216,237,191,205,47,87,52,99,242,228,127,179,162,52,238,252,238,80,95,107,214,215,211,128,244,19,150,70,225,243,119,91,106,85,181,99,205,148,124,241,130,88,170,109,117,0,156,152,245,27,19,192,7,229,26,103,132,123,139,246,212,238,232,57,58,50,61,55,18,233,119,222,228,138,22,106,66,159,231,141,211,54,71,2,198,232,173,157,120,249,112,67,9,6,192,202,201,50,204,220,221,15,69,242,55,60,141,50,146,31,19,52,193,118,184,127,136,212,53,144,25,79,193,144,109,253,81,220,7,64,186,178,234,170,76,51,158,65,20,227,47,253,210,247,148,115,254,249,192,160,224,143,249,13,178,200,248,17,99,178,201,133,164,185,110,179,241,2,252,106,244,81,206,40,6,96,190,245,251,3,145,234,13,68,58,214,129,41,131,124,223,118,76,115,106,150,169,10,84,203,113,112,76,60,178,215,60,77,238,74,141,63,180,188,178,182,158,149,32,73,205,11,60,84,181,83,151,255,239,36,6,103,214,218,255,176,220,206,79,192,194,218,23,169,66,101,120,61,132,82,214,123,245,252,158,93,177,232,83,95,68,149,25,110,16,169,188,49,14,19,192,236,221,91,87,33,92,185,210,253,220,39,149,224,200,203,109,89,122,160,42,229,186,84,84,183,149,246,25,30,150,192,40,161,102,35,145,190,107,48,164,212,231,8,95,215,37,246,147,32,62,103,137,224,188,143,30,9,177,75,39,197,189,212,85,215,254,220,107,171,176,202,238,237,136,52,196,250,159,187,211,123,52,189,213,66,121,20,109,99,114,98,120,136,235,186,119,48,131,130,92,57,124,58,108,145,118,206,173,111,115,237,83,25,43,34,191,75,191,130,148,186,230,246,89,218,76,244,8,63,134,67,121,161,3,188,31,50,249,218,224,120,251,160,221,86,115,207,115,107,203,87,158,146,166,174,16,92,116,23,233,43,207,11,207,17,209,151,237,214,32,164,205,249,127,242,58,180,144,84,74,115,105,88,90,87,123,136,224,117,97,166,38,53,58,21,57,246,86,212,89,247,28,129,124,174,114,172,249,121,63,241,93,225,235,207,40,238,79,244,163,17,198,46,139,10,1,63,162,254,232,75,7,88,253,170,138,109,65,5,140,46,213,248,235,125,137,28,36,113,102,41,194,83,199,55,208,241,36,128,102,217,88,34,78,155,124,153,95,25,225,59,100,206,178,98,151,60,106,254,210,116,54,238,159,178,228,137,113,242,173,54,77,255,231,162,174,200,80,251,173,163,140,155,162,171,4,223,169,129,41,74,111,75,187,200,89,31,100,93,228,5,233,133,50,254,191,14,83,183,194,120,229,186,160,18,194,5,235,228,18,218,88,245,237,108,234,217,206,109,142,25,1,4,23,73,205,81,187,208,159,231,184,158,185,65,61,104,13,13,152,9,219,194,49,107,140,176,15,203,154,144,105,121,117,15,50,152,81,28,152,116,16,47,185,21,142,51,226,211,202,55,174,85,187,120,93,123,104,39,212,64,161,132,54,106,75,136,255,138},
  {255,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
} ;

static const unsigned char precomputed_core_inv3sntrup1013_k[precomputed_core_inv3sntrup1013_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_inv3sntrup1013_c[precomputed_core_inv3sntrup1013_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
  {},
} ;

static void test_core_inv3sntrup1013_impl(long long impl)
{
  unsigned char *h = test_core_inv3sntrup1013_h;
  unsigned char *n = test_core_inv3sntrup1013_n;
  unsigned char *k = test_core_inv3sntrup1013_k;
  unsigned char *c = test_core_inv3sntrup1013_c;
  unsigned char *h2 = test_core_inv3sntrup1013_h2;
  unsigned char *n2 = test_core_inv3sntrup1013_n2;
  unsigned char *k2 = test_core_inv3sntrup1013_k2;
  unsigned char *c2 = test_core_inv3sntrup1013_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup1013_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_inv3sntrup1013(impl);
    printf("core_inv3sntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup1013_implementation(impl),ntruprime_dispatch_core_inv3sntrup1013_compiler(impl));
  } else {
    crypto_core = ntruprime_core_inv3sntrup1013;
    printf("core_inv3sntrup1013 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup1013_implementation(),ntruprime_core_inv3sntrup1013_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_inv3sntrup1013_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_inv3sntrup1013_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_inv3sntrup1013_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_inv3sntrup1013_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_inv3sntrup1013_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_inv3sntrup1013_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_inv3sntrup1013_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_inv3sntrup1013_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_inv3sntrup1013_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_inv3sntrup1013_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_inv3sntrup1013(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup1013")) return;
  storage_core_inv3sntrup1013_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_inv3sntrup1013_h = aligned(storage_core_inv3sntrup1013_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_inv3sntrup1013_n = callocplus(crypto_core_INPUTBYTES);
  test_core_inv3sntrup1013_n = aligned(storage_core_inv3sntrup1013_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_inv3sntrup1013_k = callocplus(crypto_core_KEYBYTES);
  test_core_inv3sntrup1013_k = aligned(storage_core_inv3sntrup1013_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_inv3sntrup1013_c = callocplus(crypto_core_CONSTBYTES);
  test_core_inv3sntrup1013_c = aligned(storage_core_inv3sntrup1013_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_inv3sntrup1013_h2 = callocplus(maxalloc);
  test_core_inv3sntrup1013_h2 = aligned(storage_core_inv3sntrup1013_h2,crypto_core_OUTPUTBYTES);
  storage_core_inv3sntrup1013_n2 = callocplus(maxalloc);
  test_core_inv3sntrup1013_n2 = aligned(storage_core_inv3sntrup1013_n2,crypto_core_INPUTBYTES);
  storage_core_inv3sntrup1013_k2 = callocplus(maxalloc);
  test_core_inv3sntrup1013_k2 = aligned(storage_core_inv3sntrup1013_k2,crypto_core_KEYBYTES);
  storage_core_inv3sntrup1013_c2 = callocplus(maxalloc);
  test_core_inv3sntrup1013_c2 = aligned(storage_core_inv3sntrup1013_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_inv3sntrup1013 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup1013();++impl)
      forked(test_core_inv3sntrup1013_impl,impl);
    ++test_core_inv3sntrup1013_h;
    ++test_core_inv3sntrup1013_n;
    ++test_core_inv3sntrup1013_k;
    ++test_core_inv3sntrup1013_c;
    ++test_core_inv3sntrup1013_h2;
    ++test_core_inv3sntrup1013_n2;
    ++test_core_inv3sntrup1013_k2;
    ++test_core_inv3sntrup1013_c2;
  }
  free(storage_core_inv3sntrup1013_c2);
  free(storage_core_inv3sntrup1013_k2);
  free(storage_core_inv3sntrup1013_n2);
  free(storage_core_inv3sntrup1013_h2);
  free(storage_core_inv3sntrup1013_c);
  free(storage_core_inv3sntrup1013_k);
  free(storage_core_inv3sntrup1013_n);
  free(storage_core_inv3sntrup1013_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

