
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file XmlSceneNodeAttributes.h
    \\brief Definition of XmlSceneNode Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "XmlSceneNodeWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



XmlSceneNodeWrapper::XmlSceneNodeWrapper(): xmlscenenode_(new XmlSceneNode())


{


	

}
XmlSceneNodeWrapper::XmlSceneNodeWrapper(XmlSceneNode* xmlscenenode): xmlscenenode_(xmlscenenode)
{

	
}

XmlSceneNodeWrapper::~XmlSceneNodeWrapper()
{

}

void XmlSceneNodeWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("SCENE_NODE_BOTTOM") ) {
		string bottom_value = request("SCENE_NODE_BOTTOM");
		xmlscenenode_->bottom_ = bottom_value;
		}
	if  (request.countValues("SCENE_NODE_LEFT") ) {
		string left_value = request("SCENE_NODE_LEFT");
		xmlscenenode_->left_ = left_value;
		}
	if  (request.countValues("SCENE_NODE_WIDTH") ) {
		string width_value = request("SCENE_NODE_WIDTH");
		xmlscenenode_->width_ = width_value;
		}
	if  (request.countValues("SCENE_NODE_HEIGHT") ) {
		string height_value = request("SCENE_NODE_HEIGHT");
		xmlscenenode_->height_ = height_value;
		}
	if  (request.countValues("SCENE_NODE_MARGIN_BOTTOM") ) {
		string margin_bottom_value = request("SCENE_NODE_MARGIN_BOTTOM");
		xmlscenenode_->margin_bottom_ = margin_bottom_value;
		}
	if  (request.countValues("SCENE_NODE_MARGIN_LEFT") ) {
		string margin_left_value = request("SCENE_NODE_MARGIN_LEFT");
		xmlscenenode_->margin_left_ = margin_left_value;
		}
	if  (request.countValues("SCENE_NODE_MARGIN_RIGHT") ) {
		string margin_right_value = request("SCENE_NODE_MARGIN_RIGHT");
		xmlscenenode_->margin_right_ = margin_right_value;
		}
	if  (request.countValues("SCENE_NODE_MARGIN_TOP") ) {
		string margin_top_value = request("SCENE_NODE_MARGIN_TOP");
		xmlscenenode_->margin_top_ = margin_top_value;
		}
	if  (request.countValues("SCENE_NODE_BORDER_BOTTOM") ) {
		string border_bottom_value = request("SCENE_NODE_BORDER_BOTTOM");
		xmlscenenode_->border_bottom_ = border_bottom_value;
		}
	if  (request.countValues("SCENE_NODE_BORDER_LEFT") ) {
		string border_left_value = request("SCENE_NODE_BORDER_LEFT");
		xmlscenenode_->border_left_ = border_left_value;
		}
	if  (request.countValues("SCENE_NODE_BORDER_RIGHT") ) {
		string border_right_value = request("SCENE_NODE_BORDER_RIGHT");
		xmlscenenode_->border_right_ = border_right_value;
		}
	if  (request.countValues("SCENE_NODE_BORDER") ) {
		string border_value = request("SCENE_NODE_BORDER");
		
		xmlscenenode_->border_ = MagTranslator<string, bool>()(border_value);
		
		}
	if  (request.countValues("SCENE_NODE_BORDER_TOP") ) {
		string border_top_value = request("SCENE_NODE_BORDER_TOP");
		xmlscenenode_->border_top_ = border_top_value;
		}
	if  (request.countValues("SCENE_NODE_BORDER_THICKNESS") ) {
		int border_thickness_value = request("SCENE_NODE_BORDER_THICKNESS");
		xmlscenenode_->border_thickness_ = border_thickness_value;
		}
	if  (request.countValues("SCENE_NODE_PADDING_BOTTOM") ) {
		string padding_bottom_value = request("SCENE_NODE_PADDING_BOTTOM");
		xmlscenenode_->padding_bottom_ = padding_bottom_value;
		}
	if  (request.countValues("SCENE_NODE_PADDING_LEFT") ) {
		string padding_left_value = request("SCENE_NODE_PADDING_LEFT");
		xmlscenenode_->padding_left_ = padding_left_value;
		}
	if  (request.countValues("SCENE_NODE_PADDING_RIGHT") ) {
		string padding_right_value = request("SCENE_NODE_PADDING_RIGHT");
		xmlscenenode_->padding_right_ = padding_right_value;
		}
	if  (request.countValues("SCENE_NODE_PADDING_TOP") ) {
		string padding_top_value = request("SCENE_NODE_PADDING_TOP");
		xmlscenenode_->padding_top_ = padding_top_value;
		}
	
	
	if  (request.countValues("VIEW_DISPLAY") ) {
		string display_value = request("VIEW_DISPLAY");
		xmlscenenode_->display_ = MagTranslator<string, DisplayType>()(display_value);
	}
		
	if  (request.countValues("SCENE_NODE_BACKGROUND_COLOUR") ) {
		string background_value = request("SCENE_NODE_BACKGROUND_COLOUR");
		xmlscenenode_->background_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(background_value));
	}
		
	if  (request.countValues("SCENE_NODE_BORDER_COLOUR") ) {
		string border_colour_value = request("SCENE_NODE_BORDER_COLOUR");
		xmlscenenode_->border_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(border_colour_value));
	}
		
	
	if  (request.countValues("SCENE_NODE_BORDER_STYLE") ) {
		string border_style_value = request("SCENE_NODE_BORDER_STYLE");
		xmlscenenode_->border_style_ = MagTranslator<string, LineStyle>()(border_style_value);
	}
		
	if  (request.countValues("SCENE_NODE_PADDING_COLOUR") ) {
		string padding_colour_value = request("SCENE_NODE_PADDING_COLOUR");
		xmlscenenode_->padding_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(padding_colour_value));
	}
		
	
		string page_id_value = request.countValues("SCENE_NODE_ID_LINE") ?  (string) request("SCENE_NODE_ID_LINE") : "on";
	MagLog::debug() << " SCENE_NODE_ID_LINE set to " << page_id_value << endl;
	NoPageIDWrapper* page_id_wrapper = 0;
	try
	{
		page_id_wrapper = SimpleFactory<NoPageIDWrapper>::create(page_id_value);
	}
	 catch (NoFactoryException&) {
		if (MagicsGlobal::strict()) {
            throw;
        }
		MagLog::warning() << "[" << page_id_value << "] is not a valid value for page_id: reset to default -> [on]" << endl;
		page_id_wrapper = SimpleFactory<NoPageIDWrapper>::create("on");
	}
	page_id_wrapper->set(request);
	xmlscenenode_->page_id_ =  unique_ptr<NoPageID>(page_id_wrapper->object());
	delete page_id_wrapper;
	
}

void XmlSceneNodeWrapper::print(ostream& out)  const
{
	out << "XmlSceneNodeWrapper[]";
}







#include "PageIDWrapper.h"
static SimpleObjectMaker<PageID, NoPageID> XmlSceneNode_scene_node_id_line_pageid ("pageid");
static SimpleObjectMaker<PageIDWrapper, NoPageIDWrapper> XmlSceneNode_scene_node_id_line_pageid_wrapper ("pageid");


#include "NoPageIDWrapper.h"

static SimpleObjectMaker<NoPageIDWrapper> XmlSceneNode_scene_node_id_line_nopageid_Wrapper("nopageid");



