"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Montevideo"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Montevideo", { offset: true, expect: "America/Fortaleza" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Montevideo", { abbr: true, expect: "America/Fortaleza" }),

	"1908" : helpers.makeTestYear("America/Montevideo", [
		["1908-06-10T03:44:50+00:00", "23:59:59", "LMT", 13491 / 60],
		["1908-06-10T03:44:51+00:00", "00:00:00", "MMT", 13491 / 60]
	]),

	"1920" : helpers.makeTestYear("America/Montevideo", [
		["1920-05-01T03:44:50+00:00", "23:59:59", "MMT", 13491 / 60],
		["1920-05-01T03:44:51+00:00", "23:44:51", "-04", 240]
	]),

	"1923" : helpers.makeTestYear("America/Montevideo", [
		["1923-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1923-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1924" : helpers.makeTestYear("America/Montevideo", [
		["1924-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1924-04-01T03:00:00+00:00", "23:30:00", "-0330", 210],
		["1924-10-01T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1924-10-01T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1925" : helpers.makeTestYear("America/Montevideo", [
		["1925-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1925-04-01T03:00:00+00:00", "23:30:00", "-0330", 210],
		["1925-10-01T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1925-10-01T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1926" : helpers.makeTestYear("America/Montevideo", [
		["1926-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1926-04-01T03:00:00+00:00", "23:30:00", "-0330", 210]
	]),

	"1933" : helpers.makeTestYear("America/Montevideo", [
		["1933-10-29T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1933-10-29T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1934" : helpers.makeTestYear("America/Montevideo", [
		["1934-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1934-04-01T03:00:00+00:00", "23:30:00", "-0330", 210],
		["1934-10-28T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1934-10-28T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1935" : helpers.makeTestYear("America/Montevideo", [
		["1935-03-31T02:59:59+00:00", "23:59:59", "-03", 180],
		["1935-03-31T03:00:00+00:00", "23:30:00", "-0330", 210],
		["1935-10-27T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1935-10-27T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1936" : helpers.makeTestYear("America/Montevideo", [
		["1936-03-29T02:59:59+00:00", "23:59:59", "-03", 180],
		["1936-03-29T03:00:00+00:00", "23:30:00", "-0330", 210],
		["1936-10-25T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1936-10-25T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1937" : helpers.makeTestYear("America/Montevideo", [
		["1937-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["1937-03-28T03:00:00+00:00", "23:30:00", "-0330", 210],
		["1937-10-31T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1937-10-31T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1938" : helpers.makeTestYear("America/Montevideo", [
		["1938-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["1938-03-27T03:00:00+00:00", "23:30:00", "-0330", 210],
		["1938-10-30T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1938-10-30T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1939" : helpers.makeTestYear("America/Montevideo", [
		["1939-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["1939-03-26T03:00:00+00:00", "23:30:00", "-0330", 210],
		["1939-10-01T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1939-10-01T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1940" : helpers.makeTestYear("America/Montevideo", [
		["1940-03-31T02:59:59+00:00", "23:59:59", "-03", 180],
		["1940-03-31T03:00:00+00:00", "23:30:00", "-0330", 210],
		["1940-10-27T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1940-10-27T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1941" : helpers.makeTestYear("America/Montevideo", [
		["1941-03-30T02:59:59+00:00", "23:59:59", "-03", 180],
		["1941-03-30T03:00:00+00:00", "23:30:00", "-0330", 210],
		["1941-08-01T03:29:59+00:00", "23:59:59", "-0330", 210],
		["1941-08-01T03:30:00+00:00", "00:30:00", "-03", 180]
	]),

	"1942" : helpers.makeTestYear("America/Montevideo", [
		["1942-12-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["1942-12-14T03:00:00+00:00", "00:30:00", "-0230", 150]
	]),

	"1943" : helpers.makeTestYear("America/Montevideo", [
		["1943-03-14T02:29:59+00:00", "23:59:59", "-0230", 150],
		["1943-03-14T02:30:00+00:00", "23:30:00", "-03", 180]
	]),

	"1959" : helpers.makeTestYear("America/Montevideo", [
		["1959-05-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["1959-05-24T03:00:00+00:00", "00:30:00", "-0230", 150],
		["1959-11-15T02:29:59+00:00", "23:59:59", "-0230", 150],
		["1959-11-15T02:30:00+00:00", "23:30:00", "-03", 180]
	]),

	"1960" : helpers.makeTestYear("America/Montevideo", [
		["1960-01-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["1960-01-17T03:00:00+00:00", "01:00:00", "-02", 120],
		["1960-03-06T01:59:59+00:00", "23:59:59", "-02", 120],
		["1960-03-06T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"1965" : helpers.makeTestYear("America/Montevideo", [
		["1965-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["1965-04-04T03:00:00+00:00", "01:00:00", "-02", 120],
		["1965-09-26T01:59:59+00:00", "23:59:59", "-02", 120],
		["1965-09-26T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"1968" : helpers.makeTestYear("America/Montevideo", [
		["1968-05-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["1968-05-27T03:00:00+00:00", "00:30:00", "-0230", 150],
		["1968-12-01T02:29:59+00:00", "23:59:59", "-0230", 150],
		["1968-12-01T02:30:00+00:00", "23:30:00", "-03", 180]
	]),

	"1970" : helpers.makeTestYear("America/Montevideo", [
		["1970-04-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["1970-04-25T03:00:00+00:00", "01:00:00", "-02", 120],
		["1970-06-14T01:59:59+00:00", "23:59:59", "-02", 120],
		["1970-06-14T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"1972" : helpers.makeTestYear("America/Montevideo", [
		["1972-04-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["1972-04-23T03:00:00+00:00", "01:00:00", "-02", 120],
		["1972-07-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["1972-07-16T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"1974" : helpers.makeTestYear("America/Montevideo", [
		["1974-01-13T02:59:59+00:00", "23:59:59", "-03", 180],
		["1974-01-13T03:00:00+00:00", "01:30:00", "-0130", 90],
		["1974-03-10T01:29:59+00:00", "23:59:59", "-0130", 90],
		["1974-03-10T01:30:00+00:00", "23:00:00", "-0230", 150],
		["1974-09-01T02:29:59+00:00", "23:59:59", "-0230", 150],
		["1974-09-01T02:30:00+00:00", "23:30:00", "-03", 180],
		["1974-12-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["1974-12-22T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1975" : helpers.makeTestYear("America/Montevideo", [
		["1975-03-30T01:59:59+00:00", "23:59:59", "-02", 120],
		["1975-03-30T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"1976" : helpers.makeTestYear("America/Montevideo", [
		["1976-12-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["1976-12-19T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1977" : helpers.makeTestYear("America/Montevideo", [
		["1977-03-06T01:59:59+00:00", "23:59:59", "-02", 120],
		["1977-03-06T02:00:00+00:00", "23:00:00", "-03", 180],
		["1977-12-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["1977-12-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1978" : helpers.makeTestYear("America/Montevideo", [
		["1978-03-05T01:59:59+00:00", "23:59:59", "-02", 120],
		["1978-03-05T02:00:00+00:00", "23:00:00", "-03", 180],
		["1978-12-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["1978-12-17T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1979" : helpers.makeTestYear("America/Montevideo", [
		["1979-03-04T01:59:59+00:00", "23:59:59", "-02", 120],
		["1979-03-04T02:00:00+00:00", "23:00:00", "-03", 180],
		["1979-04-29T02:59:59+00:00", "23:59:59", "-03", 180],
		["1979-04-29T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1980" : helpers.makeTestYear("America/Montevideo", [
		["1980-03-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["1980-03-16T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"1987" : helpers.makeTestYear("America/Montevideo", [
		["1987-12-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["1987-12-14T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1988" : helpers.makeTestYear("America/Montevideo", [
		["1988-02-28T01:59:59+00:00", "23:59:59", "-02", 120],
		["1988-02-28T02:00:00+00:00", "23:00:00", "-03", 180],
		["1988-12-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["1988-12-11T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1989" : helpers.makeTestYear("America/Montevideo", [
		["1989-03-05T01:59:59+00:00", "23:59:59", "-02", 120],
		["1989-03-05T02:00:00+00:00", "23:00:00", "-03", 180],
		["1989-10-29T02:59:59+00:00", "23:59:59", "-03", 180],
		["1989-10-29T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1990" : helpers.makeTestYear("America/Montevideo", [
		["1990-02-25T01:59:59+00:00", "23:59:59", "-02", 120],
		["1990-02-25T02:00:00+00:00", "23:00:00", "-03", 180],
		["1990-10-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["1990-10-21T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1991" : helpers.makeTestYear("America/Montevideo", [
		["1991-03-03T01:59:59+00:00", "23:59:59", "-02", 120],
		["1991-03-03T02:00:00+00:00", "23:00:00", "-03", 180],
		["1991-10-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["1991-10-27T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1992" : helpers.makeTestYear("America/Montevideo", [
		["1992-03-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1992-03-01T02:00:00+00:00", "23:00:00", "-03", 180],
		["1992-10-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["1992-10-18T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1993" : helpers.makeTestYear("America/Montevideo", [
		["1993-02-28T01:59:59+00:00", "23:59:59", "-02", 120],
		["1993-02-28T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"2004" : helpers.makeTestYear("America/Montevideo", [
		["2004-09-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2004-09-19T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2005" : helpers.makeTestYear("America/Montevideo", [
		["2005-03-27T03:59:59+00:00", "01:59:59", "-02", 120],
		["2005-03-27T04:00:00+00:00", "01:00:00", "-03", 180],
		["2005-10-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2005-10-09T05:00:00+00:00", "03:00:00", "-02", 120]
	]),

	"2006" : helpers.makeTestYear("America/Montevideo", [
		["2006-03-12T03:59:59+00:00", "01:59:59", "-02", 120],
		["2006-03-12T04:00:00+00:00", "01:00:00", "-03", 180],
		["2006-10-01T04:59:59+00:00", "01:59:59", "-03", 180],
		["2006-10-01T05:00:00+00:00", "03:00:00", "-02", 120]
	]),

	"2007" : helpers.makeTestYear("America/Montevideo", [
		["2007-03-11T03:59:59+00:00", "01:59:59", "-02", 120],
		["2007-03-11T04:00:00+00:00", "01:00:00", "-03", 180],
		["2007-10-07T04:59:59+00:00", "01:59:59", "-03", 180],
		["2007-10-07T05:00:00+00:00", "03:00:00", "-02", 120]
	]),

	"2008" : helpers.makeTestYear("America/Montevideo", [
		["2008-03-09T03:59:59+00:00", "01:59:59", "-02", 120],
		["2008-03-09T04:00:00+00:00", "01:00:00", "-03", 180],
		["2008-10-05T04:59:59+00:00", "01:59:59", "-03", 180],
		["2008-10-05T05:00:00+00:00", "03:00:00", "-02", 120]
	]),

	"2009" : helpers.makeTestYear("America/Montevideo", [
		["2009-03-08T03:59:59+00:00", "01:59:59", "-02", 120],
		["2009-03-08T04:00:00+00:00", "01:00:00", "-03", 180],
		["2009-10-04T04:59:59+00:00", "01:59:59", "-03", 180],
		["2009-10-04T05:00:00+00:00", "03:00:00", "-02", 120]
	]),

	"2010" : helpers.makeTestYear("America/Montevideo", [
		["2010-03-14T03:59:59+00:00", "01:59:59", "-02", 120],
		["2010-03-14T04:00:00+00:00", "01:00:00", "-03", 180],
		["2010-10-03T04:59:59+00:00", "01:59:59", "-03", 180],
		["2010-10-03T05:00:00+00:00", "03:00:00", "-02", 120]
	]),

	"2011" : helpers.makeTestYear("America/Montevideo", [
		["2011-03-13T03:59:59+00:00", "01:59:59", "-02", 120],
		["2011-03-13T04:00:00+00:00", "01:00:00", "-03", 180],
		["2011-10-02T04:59:59+00:00", "01:59:59", "-03", 180],
		["2011-10-02T05:00:00+00:00", "03:00:00", "-02", 120]
	]),

	"2012" : helpers.makeTestYear("America/Montevideo", [
		["2012-03-11T03:59:59+00:00", "01:59:59", "-02", 120],
		["2012-03-11T04:00:00+00:00", "01:00:00", "-03", 180],
		["2012-10-07T04:59:59+00:00", "01:59:59", "-03", 180],
		["2012-10-07T05:00:00+00:00", "03:00:00", "-02", 120]
	]),

	"2013" : helpers.makeTestYear("America/Montevideo", [
		["2013-03-10T03:59:59+00:00", "01:59:59", "-02", 120],
		["2013-03-10T04:00:00+00:00", "01:00:00", "-03", 180],
		["2013-10-06T04:59:59+00:00", "01:59:59", "-03", 180],
		["2013-10-06T05:00:00+00:00", "03:00:00", "-02", 120]
	]),

	"2014" : helpers.makeTestYear("America/Montevideo", [
		["2014-03-09T03:59:59+00:00", "01:59:59", "-02", 120],
		["2014-03-09T04:00:00+00:00", "01:00:00", "-03", 180],
		["2014-10-05T04:59:59+00:00", "01:59:59", "-03", 180],
		["2014-10-05T05:00:00+00:00", "03:00:00", "-02", 120]
	]),

	"2015" : helpers.makeTestYear("America/Montevideo", [
		["2015-03-08T03:59:59+00:00", "01:59:59", "-02", 120],
		["2015-03-08T04:00:00+00:00", "01:00:00", "-03", 180]
	])
};