#ifndef OPEN62541_CERTIFICATES_H
#define OPEN62541_CERTIFICATES_H

#include <open62541/types.h>

_UA_BEGIN_DECLS

#define CLIENT_CERT_DER_LENGTH 1030
UA_Byte CLIENT_CERT_DER_DATA[CLIENT_CERT_DER_LENGTH] = {
  0x30, 0x82, 0x04, 0x02, 0x30, 0x82, 0x02, 0xea, 0xa0, 0x03, 0x02, 0x01,
  0x02, 0x02, 0x14, 0x36, 0xbb, 0x70, 0x44, 0x14, 0xdf, 0x1f, 0xad, 0xe7,
  0xe7, 0xc8, 0x69, 0x52, 0x60, 0x0e, 0xcb, 0x46, 0x73, 0xcb, 0x7a, 0x30,
  0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b,
  0x05, 0x00, 0x30, 0x54, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04,
  0x06, 0x13, 0x02, 0x44, 0x45, 0x31, 0x0d, 0x30, 0x0b, 0x06, 0x03, 0x55,
  0x04, 0x07, 0x0c, 0x04, 0x48, 0x65, 0x72, 0x65, 0x31, 0x12, 0x30, 0x10,
  0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x09, 0x6f, 0x70, 0x65, 0x6e, 0x36,
  0x32, 0x35, 0x34, 0x31, 0x31, 0x22, 0x30, 0x20, 0x06, 0x03, 0x55, 0x04,
  0x03, 0x0c, 0x19, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35, 0x34, 0x31,
  0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x40, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
  0x68, 0x6f, 0x73, 0x74, 0x30, 0x1e, 0x17, 0x0d, 0x32, 0x33, 0x31, 0x31,
  0x30, 0x38, 0x31, 0x35, 0x31, 0x33, 0x33, 0x32, 0x5a, 0x17, 0x0d, 0x33,
  0x33, 0x31, 0x31, 0x30, 0x35, 0x31, 0x35, 0x31, 0x33, 0x33, 0x32, 0x5a,
  0x30, 0x54, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x44, 0x45, 0x31, 0x0d, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x04, 0x07,
  0x0c, 0x04, 0x48, 0x65, 0x72, 0x65, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03,
  0x55, 0x04, 0x0a, 0x0c, 0x09, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35,
  0x34, 0x31, 0x31, 0x22, 0x30, 0x20, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c,
  0x19, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35, 0x34, 0x31, 0x53, 0x65,
  0x72, 0x76, 0x65, 0x72, 0x40, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x68, 0x6f,
  0x73, 0x74, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86,
  0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01,
  0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xcf,
  0xe9, 0xd9, 0x66, 0x9a, 0x06, 0xa1, 0x6d, 0x87, 0x90, 0x44, 0xca, 0xdc,
  0xff, 0x4a, 0xe4, 0x1c, 0x0a, 0x5e, 0xe9, 0x62, 0xe4, 0x08, 0x6b, 0x83,
  0x23, 0xdc, 0x76, 0xe3, 0xe1, 0xbe, 0x73, 0x0a, 0xb6, 0x1a, 0x07, 0x8b,
  0x80, 0x7f, 0xe2, 0x87, 0x6f, 0x8f, 0xf2, 0xe3, 0xf5, 0x64, 0x83, 0xe5,
  0x6f, 0x83, 0x2b, 0xb4, 0x9d, 0xd6, 0xf2, 0x6f, 0xa2, 0x2a, 0x78, 0x6c,
  0xcf, 0xba, 0x9d, 0xd1, 0xca, 0xad, 0xa2, 0xed, 0xd0, 0x52, 0x53, 0x6c,
  0x09, 0x72, 0xe8, 0xcc, 0xb5, 0xb6, 0x99, 0xea, 0xf9, 0x04, 0x04, 0xee,
  0x42, 0x12, 0x18, 0x8a, 0x20, 0xbb, 0x05, 0xce, 0xe1, 0x32, 0x54, 0x5a,
  0x99, 0x9d, 0x27, 0xe6, 0xae, 0xd5, 0x4a, 0xa4, 0xf2, 0x6b, 0x96, 0xee,
  0x5a, 0x27, 0x7e, 0xbf, 0x3d, 0x19, 0xd0, 0xcd, 0x2e, 0xa3, 0xc9, 0xe3,
  0x64, 0x67, 0x23, 0x94, 0x07, 0xb7, 0x20, 0x22, 0x9d, 0xd4, 0x13, 0x76,
  0xec, 0x76, 0xc2, 0xe2, 0xbe, 0xfe, 0x99, 0x1a, 0x37, 0x28, 0x56, 0x8d,
  0x10, 0x46, 0xd7, 0xb3, 0x62, 0xa8, 0x86, 0x46, 0x16, 0xf4, 0x7d, 0x07,
  0x20, 0x6f, 0xd4, 0xa2, 0x7a, 0xd8, 0xd0, 0xf1, 0x90, 0xd7, 0xd2, 0xa7,
  0x58, 0x69, 0xdd, 0x49, 0x44, 0xe3, 0x97, 0xd7, 0x25, 0x6a, 0x67, 0x70,
  0x3c, 0xc7, 0xaa, 0xfd, 0xb6, 0xe4, 0x14, 0xb9, 0x76, 0x55, 0x34, 0x7d,
  0x45, 0x66, 0xfb, 0xf9, 0x3a, 0x0b, 0x47, 0xb3, 0xca, 0x66, 0xed, 0xe7,
  0xa6, 0x68, 0x38, 0x57, 0xd1, 0x6b, 0xc2, 0x4e, 0x70, 0x25, 0xf9, 0xcd,
  0x76, 0x00, 0x5c, 0x54, 0x63, 0xa2, 0xa5, 0x74, 0x4b, 0xde, 0xc1, 0xa7,
  0x43, 0x1a, 0x0e, 0x9e, 0x80, 0x07, 0x2b, 0x5b, 0x4f, 0x7c, 0xd3, 0xb6,
  0x8e, 0xd7, 0x3a, 0x59, 0xcd, 0x16, 0xd8, 0xf2, 0xeb, 0xc3, 0x56, 0x1f,
  0xde, 0x2e, 0x5d, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x81, 0xcb, 0x30,
  0x81, 0xc8, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04,
  0x14, 0x03, 0x6f, 0x5c, 0x80, 0x4d, 0x2a, 0x06, 0xe3, 0x3b, 0x60, 0xf4,
  0x1c, 0xe5, 0xcc, 0xa2, 0xeb, 0xe7, 0xcf, 0x20, 0x19, 0x30, 0x1f, 0x06,
  0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x03, 0x6f,
  0x5c, 0x80, 0x4d, 0x2a, 0x06, 0xe3, 0x3b, 0x60, 0xf4, 0x1c, 0xe5, 0xcc,
  0xa2, 0xeb, 0xe7, 0xcf, 0x20, 0x19, 0x30, 0x09, 0x06, 0x03, 0x55, 0x1d,
  0x13, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x1d, 0x0f,
  0x04, 0x04, 0x03, 0x02, 0x02, 0xf4, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d,
  0x25, 0x04, 0x16, 0x30, 0x14, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05,
  0x07, 0x03, 0x01, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05, 0x07, 0x03,
  0x02, 0x30, 0x4f, 0x06, 0x03, 0x55, 0x1d, 0x11, 0x04, 0x48, 0x30, 0x46,
  0x82, 0x0a, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x62, 0x6f, 0x78,
  0x82, 0x0a, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x62, 0x6f, 0x78,
  0x87, 0x04, 0x0a, 0x00, 0x02, 0x0f, 0x87, 0x04, 0xc0, 0xa8, 0x38, 0x65,
  0x86, 0x20, 0x75, 0x72, 0x6e, 0x3a, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32,
  0x35, 0x34, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x61,
  0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x30, 0x0d,
  0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05,
  0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0xc4, 0xb5, 0xd3, 0x3f, 0xaa, 0x26,
  0x9a, 0xb2, 0xc3, 0x9a, 0xaf, 0xcf, 0xd2, 0x9b, 0xf0, 0x83, 0x39, 0x95,
  0x91, 0x1b, 0x72, 0xcc, 0x2f, 0xa7, 0x3e, 0x08, 0x19, 0xbf, 0x9b, 0xbe,
  0xd3, 0x45, 0xea, 0x50, 0xb2, 0x5d, 0xab, 0x19, 0x57, 0x61, 0x55, 0x0a,
  0x59, 0x0b, 0x46, 0xbd, 0x88, 0xa2, 0x5a, 0xd1, 0xb7, 0x55, 0x8e, 0x27,
  0xb6, 0xff, 0x75, 0x09, 0x43, 0x25, 0x83, 0x82, 0x23, 0xa9, 0xc1, 0x98,
  0x0b, 0x0b, 0xd5, 0xe7, 0x36, 0xbb, 0xe8, 0xf9, 0xf7, 0x2c, 0xd1, 0x1f,
  0x19, 0x9a, 0x87, 0x82, 0x5f, 0xb8, 0x95, 0xe0, 0x60, 0xcd, 0xf1, 0xdf,
  0x66, 0xb8, 0xbe, 0xae, 0xc8, 0x1f, 0x94, 0x34, 0x9f, 0x87, 0x80, 0x29,
  0xbd, 0x08, 0x19, 0x7a, 0x47, 0x4d, 0x5c, 0xdb, 0x00, 0x5d, 0xee, 0x87,
  0x8e, 0xc2, 0x3d, 0xb0, 0x72, 0xfb, 0xbf, 0x1a, 0xf9, 0xde, 0x76, 0xf1,
  0xba, 0x3f, 0xed, 0x97, 0x17, 0xc5, 0xc7, 0x4b, 0x94, 0x03, 0x8a, 0x63,
  0x66, 0xd3, 0x49, 0x35, 0x30, 0x97, 0x1c, 0x37, 0x83, 0x08, 0xb3, 0x9f,
  0x5d, 0xf7, 0xd4, 0x40, 0x63, 0xc5, 0xc2, 0x54, 0x9a, 0x87, 0x59, 0x17,
  0x7f, 0x78, 0x02, 0xa4, 0xcb, 0x0b, 0x18, 0x32, 0xc0, 0x74, 0x94, 0xbe,
  0x07, 0x29, 0x18, 0x1e, 0x65, 0x9f, 0x3c, 0x6a, 0x9a, 0x7b, 0xce, 0xff,
  0x21, 0x79, 0x40, 0x03, 0x79, 0xd5, 0xa5, 0xb9, 0xbf, 0xc9, 0xba, 0x29,
  0x18, 0xc9, 0xf8, 0x93, 0x69, 0xb1, 0x86, 0xc9, 0x32, 0x1a, 0x67, 0x2f,
  0x60, 0xaa, 0xdd, 0x0e, 0xb0, 0xb4, 0x1d, 0x44, 0x71, 0xc3, 0x89, 0x48,
  0xab, 0xc7, 0x36, 0xf8, 0xfc, 0xf2, 0x95, 0x07, 0xd1, 0x68, 0x2b, 0xe4,
  0x16, 0x82, 0x63, 0x90, 0x58, 0xf1, 0x10, 0xf4, 0x33, 0xf8, 0xb8, 0x5d,
  0x29, 0x95, 0x73, 0xf7, 0xc9, 0x97, 0xdb, 0x23, 0x6c, 0x01
};

#define CLIENT_KEY_DER_LENGTH 1218
UA_Byte CLIENT_KEY_DER_DATA[CLIENT_KEY_DER_LENGTH] = {
  0x30, 0x82, 0x04, 0xbe, 0x02, 0x01, 0x00, 0x30, 0x0d, 0x06, 0x09, 0x2a,
  0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x04, 0x82,
  0x04, 0xa8, 0x30, 0x82, 0x04, 0xa4, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01,
  0x01, 0x00, 0xcf, 0xe9, 0xd9, 0x66, 0x9a, 0x06, 0xa1, 0x6d, 0x87, 0x90,
  0x44, 0xca, 0xdc, 0xff, 0x4a, 0xe4, 0x1c, 0x0a, 0x5e, 0xe9, 0x62, 0xe4,
  0x08, 0x6b, 0x83, 0x23, 0xdc, 0x76, 0xe3, 0xe1, 0xbe, 0x73, 0x0a, 0xb6,
  0x1a, 0x07, 0x8b, 0x80, 0x7f, 0xe2, 0x87, 0x6f, 0x8f, 0xf2, 0xe3, 0xf5,
  0x64, 0x83, 0xe5, 0x6f, 0x83, 0x2b, 0xb4, 0x9d, 0xd6, 0xf2, 0x6f, 0xa2,
  0x2a, 0x78, 0x6c, 0xcf, 0xba, 0x9d, 0xd1, 0xca, 0xad, 0xa2, 0xed, 0xd0,
  0x52, 0x53, 0x6c, 0x09, 0x72, 0xe8, 0xcc, 0xb5, 0xb6, 0x99, 0xea, 0xf9,
  0x04, 0x04, 0xee, 0x42, 0x12, 0x18, 0x8a, 0x20, 0xbb, 0x05, 0xce, 0xe1,
  0x32, 0x54, 0x5a, 0x99, 0x9d, 0x27, 0xe6, 0xae, 0xd5, 0x4a, 0xa4, 0xf2,
  0x6b, 0x96, 0xee, 0x5a, 0x27, 0x7e, 0xbf, 0x3d, 0x19, 0xd0, 0xcd, 0x2e,
  0xa3, 0xc9, 0xe3, 0x64, 0x67, 0x23, 0x94, 0x07, 0xb7, 0x20, 0x22, 0x9d,
  0xd4, 0x13, 0x76, 0xec, 0x76, 0xc2, 0xe2, 0xbe, 0xfe, 0x99, 0x1a, 0x37,
  0x28, 0x56, 0x8d, 0x10, 0x46, 0xd7, 0xb3, 0x62, 0xa8, 0x86, 0x46, 0x16,
  0xf4, 0x7d, 0x07, 0x20, 0x6f, 0xd4, 0xa2, 0x7a, 0xd8, 0xd0, 0xf1, 0x90,
  0xd7, 0xd2, 0xa7, 0x58, 0x69, 0xdd, 0x49, 0x44, 0xe3, 0x97, 0xd7, 0x25,
  0x6a, 0x67, 0x70, 0x3c, 0xc7, 0xaa, 0xfd, 0xb6, 0xe4, 0x14, 0xb9, 0x76,
  0x55, 0x34, 0x7d, 0x45, 0x66, 0xfb, 0xf9, 0x3a, 0x0b, 0x47, 0xb3, 0xca,
  0x66, 0xed, 0xe7, 0xa6, 0x68, 0x38, 0x57, 0xd1, 0x6b, 0xc2, 0x4e, 0x70,
  0x25, 0xf9, 0xcd, 0x76, 0x00, 0x5c, 0x54, 0x63, 0xa2, 0xa5, 0x74, 0x4b,
  0xde, 0xc1, 0xa7, 0x43, 0x1a, 0x0e, 0x9e, 0x80, 0x07, 0x2b, 0x5b, 0x4f,
  0x7c, 0xd3, 0xb6, 0x8e, 0xd7, 0x3a, 0x59, 0xcd, 0x16, 0xd8, 0xf2, 0xeb,
  0xc3, 0x56, 0x1f, 0xde, 0x2e, 0x5d, 0x02, 0x03, 0x01, 0x00, 0x01, 0x02,
  0x82, 0x01, 0x00, 0x16, 0x6a, 0xa6, 0x2f, 0xf3, 0xc7, 0x67, 0x3c, 0x41,
  0xf3, 0x82, 0x17, 0x45, 0x40, 0x99, 0x38, 0x82, 0xf5, 0x73, 0x4a, 0x42,
  0x89, 0x47, 0x87, 0x1f, 0xfa, 0x8b, 0xd8, 0x9d, 0xb5, 0x47, 0x2d, 0x6c,
  0x28, 0x3a, 0x22, 0x3a, 0x1e, 0x3e, 0xab, 0x93, 0xe2, 0xa9, 0x68, 0x8c,
  0xbf, 0x76, 0x78, 0xea, 0x11, 0xdd, 0xd8, 0xa6, 0x7e, 0xa6, 0x20, 0x39,
  0x7d, 0x08, 0x8b, 0x37, 0x60, 0x26, 0x44, 0xc1, 0xcb, 0xd2, 0x70, 0xd0,
  0xa7, 0x37, 0x59, 0x1b, 0x3a, 0xe1, 0x92, 0xcc, 0x0f, 0x83, 0x82, 0x90,
  0xdd, 0x0c, 0x5b, 0xe3, 0xbc, 0x67, 0xeb, 0x11, 0x69, 0x7a, 0x00, 0xa4,
  0x4f, 0x8f, 0x77, 0x9c, 0xd5, 0x17, 0x26, 0xa8, 0x2e, 0x8d, 0x7c, 0xa0,
  0xd0, 0x2a, 0x5d, 0x79, 0x91, 0x6a, 0xd4, 0xb5, 0x95, 0xc6, 0xe4, 0xc6,
  0x5a, 0x92, 0xfa, 0x3f, 0x74, 0x21, 0xd2, 0xaa, 0x31, 0x32, 0xc3, 0x28,
  0x70, 0xd9, 0x86, 0x7f, 0x85, 0x6b, 0x1b, 0xa8, 0x7c, 0x8a, 0x1f, 0xb6,
  0x4c, 0xe2, 0xb6, 0x55, 0xd1, 0x61, 0x10, 0xc0, 0x8e, 0x39, 0x6f, 0x9f,
  0xac, 0xde, 0x0f, 0xb0, 0x4d, 0x9a, 0x29, 0x60, 0x8c, 0x2a, 0xfb, 0x44,
  0x08, 0x5a, 0x04, 0xc3, 0x03, 0x75, 0xb0, 0x9f, 0xb0, 0x25, 0xe1, 0xda,
  0x1f, 0x2f, 0xd8, 0xe6, 0xb5, 0x09, 0x93, 0x1a, 0xb5, 0x0f, 0xdd, 0xbd,
  0xa1, 0xab, 0x48, 0x85, 0x94, 0xe8, 0x9c, 0x70, 0x8d, 0xfc, 0xf8, 0xf1,
  0xa9, 0xe2, 0x16, 0x6c, 0x27, 0xba, 0x39, 0xe5, 0x06, 0x96, 0xf4, 0x46,
  0x6f, 0x0d, 0x08, 0xc9, 0xeb, 0xd1, 0x24, 0x01, 0x07, 0x08, 0xa6, 0x0e,
  0xee, 0xeb, 0xeb, 0x6e, 0xc7, 0xaf, 0x90, 0x8a, 0x8b, 0xf1, 0x0f, 0x75,
  0xcd, 0xef, 0xec, 0x6c, 0xaf, 0x7e, 0xf1, 0x64, 0xb8, 0x9d, 0x57, 0xd2,
  0x58, 0xb3, 0x73, 0xa9, 0x0c, 0xe3, 0x81, 0x02, 0x81, 0x81, 0x00, 0xee,
  0xde, 0xc3, 0x6d, 0x83, 0xf3, 0xe3, 0x69, 0x31, 0x27, 0xbb, 0x62, 0x9d,
  0xd6, 0xfb, 0xc4, 0x3b, 0x55, 0x5c, 0xf4, 0x2a, 0xcb, 0xdb, 0x99, 0x14,
  0x18, 0xe7, 0xa6, 0x2c, 0xee, 0x98, 0x89, 0x4f, 0x8a, 0xe6, 0xc7, 0xf6,
  0x66, 0x65, 0x89, 0x05, 0x24, 0xd5, 0x68, 0x1f, 0x61, 0x09, 0x26, 0xc8,
  0xc2, 0x2b, 0x9d, 0x9d, 0xb7, 0x34, 0x65, 0x05, 0x1b, 0x86, 0xbd, 0xe9,
  0x44, 0x3a, 0x44, 0x62, 0x98, 0x84, 0xe4, 0x09, 0x95, 0xc4, 0x18, 0x42,
  0x74, 0xb5, 0xb3, 0x62, 0xaa, 0x7d, 0x70, 0x85, 0x6e, 0x57, 0x38, 0x58,
  0x96, 0x67, 0x93, 0x71, 0x9a, 0xc6, 0x71, 0x08, 0xcf, 0x43, 0x59, 0x5f,
  0x7b, 0x5a, 0x78, 0x89, 0x40, 0x71, 0xd3, 0x8f, 0xe0, 0xd7, 0xfb, 0x9b,
  0xf4, 0x70, 0x5c, 0x87, 0x48, 0x7b, 0x77, 0xf5, 0x1a, 0xa2, 0xde, 0x21,
  0xa6, 0x90, 0xcc, 0x2f, 0x4f, 0x1d, 0x8d, 0x02, 0x81, 0x81, 0x00, 0xde,
  0xd2, 0xc6, 0x79, 0x21, 0x90, 0xca, 0x61, 0x76, 0x2a, 0xb2, 0x23, 0xb4,
  0x13, 0x54, 0x86, 0x6a, 0xaa, 0xa6, 0x91, 0xaa, 0xf8, 0xd6, 0xb6, 0xcf,
  0x6d, 0xef, 0xfa, 0xec, 0x8d, 0x7c, 0x52, 0x66, 0x3a, 0x60, 0xeb, 0x3c,
  0x64, 0xb3, 0xc0, 0x36, 0x72, 0x28, 0xda, 0x1f, 0x5a, 0xfe, 0x17, 0x7e,
  0xf3, 0xcd, 0xac, 0xf6, 0x9b, 0xe1, 0xf5, 0x9a, 0x67, 0x3e, 0xcd, 0xf4,
  0x84, 0xf7, 0x47, 0xe4, 0xdb, 0xc1, 0xf1, 0xec, 0xcc, 0xdf, 0x63, 0xa9,
  0xc0, 0x37, 0x8e, 0xc8, 0x00, 0xf9, 0xb8, 0x8f, 0x58, 0x23, 0xb9, 0x5f,
  0x03, 0x92, 0x7e, 0xbe, 0x3c, 0x10, 0xfc, 0x63, 0xbe, 0x56, 0x8f, 0xfd,
  0xbc, 0xa1, 0xc3, 0x8c, 0x78, 0x89, 0x5a, 0xca, 0x58, 0xe9, 0xa5, 0x9b,
  0xa7, 0xa5, 0xfe, 0x96, 0xf7, 0xae, 0x42, 0x39, 0x70, 0x38, 0xfb, 0x55,
  0xff, 0x5a, 0x86, 0x02, 0x38, 0x18, 0x11, 0x02, 0x81, 0x80, 0x7a, 0x09,
  0x20, 0xfa, 0xb0, 0x71, 0x47, 0x7b, 0x94, 0x7b, 0x62, 0x06, 0x8d, 0xf1,
  0x29, 0x8b, 0x25, 0x6d, 0x05, 0x22, 0x51, 0x42, 0xf9, 0x1c, 0x09, 0xe2,
  0x77, 0x66, 0xb4, 0x89, 0xe9, 0x30, 0x2d, 0x8d, 0x1f, 0x3e, 0x85, 0xa9,
  0xe6, 0xb1, 0xcc, 0x08, 0xf7, 0x66, 0x4c, 0xb1, 0xbc, 0x85, 0x2e, 0x07,
  0xd5, 0x54, 0x9f, 0x20, 0xdc, 0x09, 0xc8, 0x44, 0x39, 0xe0, 0x88, 0x6e,
  0x2c, 0xfe, 0x87, 0x08, 0xb8, 0xcb, 0xf0, 0x01, 0xad, 0xbf, 0x5f, 0x24,
  0x55, 0x38, 0x22, 0x6e, 0x4b, 0xcb, 0xd2, 0xbf, 0x7e, 0x9b, 0xf0, 0xd6,
  0x56, 0x70, 0x43, 0x97, 0xf9, 0x4e, 0x02, 0x5c, 0x31, 0x62, 0x55, 0x9f,
  0xa5, 0xa6, 0xf3, 0x28, 0x13, 0x7f, 0x2c, 0x80, 0x88, 0x97, 0xa9, 0x23,
  0x86, 0xcc, 0x1e, 0xe9, 0x6e, 0xfa, 0xe8, 0x24, 0x05, 0x95, 0x4a, 0xc7,
  0xd8, 0x2e, 0x18, 0xf5, 0x68, 0x79, 0x02, 0x81, 0x81, 0x00, 0xcb, 0xe5,
  0x4f, 0xdc, 0x94, 0x0c, 0x6c, 0x44, 0xd6, 0xde, 0xa6, 0xf7, 0xe8, 0xd6,
  0x2f, 0x68, 0x78, 0xbf, 0x03, 0x81, 0x14, 0x54, 0x74, 0x16, 0x00, 0xa5,
  0xf7, 0x0d, 0x43, 0xdd, 0x0c, 0x40, 0x52, 0x6f, 0x65, 0x34, 0x9c, 0xa5,
  0x01, 0x9f, 0x07, 0xb3, 0x5b, 0x12, 0x8d, 0xd2, 0xb3, 0xe4, 0x48, 0x35,
  0x4c, 0xa5, 0xd3, 0x5c, 0x3d, 0x5e, 0x83, 0x15, 0xaa, 0xf0, 0xc7, 0xa9,
  0xcc, 0xa5, 0xab, 0x14, 0x34, 0xda, 0xed, 0xf7, 0x63, 0x0b, 0x4d, 0xd0,
  0x28, 0x86, 0xad, 0x19, 0xc7, 0x69, 0x4d, 0x32, 0x38, 0x2e, 0x6e, 0x75,
  0x54, 0x5e, 0x4a, 0x31, 0xa8, 0xd1, 0x6b, 0x6c, 0x46, 0xc5, 0xa8, 0x48,
  0x2e, 0x36, 0x44, 0x9a, 0x20, 0x06, 0x46, 0x57, 0x2a, 0x26, 0x72, 0xd2,
  0xec, 0x20, 0x95, 0x80, 0xbb, 0xa2, 0xb9, 0xf0, 0xa9, 0x13, 0xc4, 0x53,
  0xd0, 0x40, 0x04, 0x53, 0xd4, 0x21, 0x02, 0x81, 0x81, 0x00, 0xc7, 0xf4,
  0x63, 0x08, 0x30, 0xb6, 0x34, 0x62, 0xdd, 0xf1, 0x99, 0x40, 0xa4, 0xc3,
  0x86, 0xe0, 0x58, 0xb9, 0xc2, 0x77, 0x0c, 0x48, 0x8d, 0x86, 0x73, 0x27,
  0xa3, 0x8c, 0xe8, 0x90, 0xed, 0x34, 0x40, 0x03, 0x3b, 0x47, 0x10, 0x40,
  0xe6, 0x2d, 0xb6, 0xa1, 0x86, 0x71, 0xbc, 0x0a, 0xd2, 0x79, 0x0f, 0xe4,
  0xaa, 0x71, 0xc2, 0xee, 0x7f, 0xf7, 0x89, 0x2f, 0xf2, 0xee, 0x79, 0x40,
  0x6c, 0xa2, 0x30, 0x41, 0xda, 0xe7, 0x80, 0x76, 0x0c, 0xf6, 0xb2, 0xfb,
  0x54, 0xf3, 0x45, 0xe5, 0x67, 0xa2, 0x45, 0x06, 0x24, 0x98, 0x4c, 0xbe,
  0xef, 0xc2, 0x10, 0x98, 0x04, 0x0e, 0x6c, 0x3e, 0x23, 0x70, 0x9a, 0x14,
  0xb9, 0x88, 0x2f, 0xa4, 0x2b, 0xec, 0x90, 0x88, 0x0d, 0x75, 0x3b, 0xae,
  0x24, 0x87, 0xfc, 0x25, 0x05, 0xe9, 0xf1, 0xc5, 0xb6, 0xc1, 0xa5, 0x11,
  0x76, 0xd1, 0xee, 0xdb, 0x2e, 0x44
};

#define SERVER_CERT_DER_LENGTH 1030
UA_Byte SERVER_CERT_DER_DATA[SERVER_CERT_DER_LENGTH] = {
  0x30, 0x82, 0x04, 0x02, 0x30, 0x82, 0x02, 0xea, 0xa0, 0x03, 0x02, 0x01,
  0x02, 0x02, 0x14, 0x59, 0x1b, 0x70, 0x7b, 0xac, 0xa0, 0x8e, 0xb0, 0xe1,
  0x4f, 0x06, 0x48, 0xef, 0x91, 0x01, 0x5d, 0xc4, 0x3e, 0xde, 0x0b, 0x30,
  0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b,
  0x05, 0x00, 0x30, 0x54, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04,
  0x06, 0x13, 0x02, 0x44, 0x45, 0x31, 0x0d, 0x30, 0x0b, 0x06, 0x03, 0x55,
  0x04, 0x07, 0x0c, 0x04, 0x48, 0x65, 0x72, 0x65, 0x31, 0x12, 0x30, 0x10,
  0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x09, 0x6f, 0x70, 0x65, 0x6e, 0x36,
  0x32, 0x35, 0x34, 0x31, 0x31, 0x22, 0x30, 0x20, 0x06, 0x03, 0x55, 0x04,
  0x03, 0x0c, 0x19, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35, 0x34, 0x31,
  0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x40, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
  0x68, 0x6f, 0x73, 0x74, 0x30, 0x1e, 0x17, 0x0d, 0x32, 0x33, 0x31, 0x31,
  0x30, 0x38, 0x31, 0x35, 0x31, 0x35, 0x35, 0x34, 0x5a, 0x17, 0x0d, 0x33,
  0x33, 0x31, 0x31, 0x30, 0x35, 0x31, 0x35, 0x31, 0x35, 0x35, 0x34, 0x5a,
  0x30, 0x54, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x44, 0x45, 0x31, 0x0d, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x04, 0x07,
  0x0c, 0x04, 0x48, 0x65, 0x72, 0x65, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03,
  0x55, 0x04, 0x0a, 0x0c, 0x09, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35,
  0x34, 0x31, 0x31, 0x22, 0x30, 0x20, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c,
  0x19, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35, 0x34, 0x31, 0x53, 0x65,
  0x72, 0x76, 0x65, 0x72, 0x40, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x68, 0x6f,
  0x73, 0x74, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86,
  0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01,
  0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xcf,
  0x37, 0x8d, 0x67, 0xf0, 0x28, 0x1a, 0x6b, 0x58, 0x15, 0x19, 0x80, 0x2e,
  0xf8, 0xcc, 0xad, 0x85, 0xa1, 0x9c, 0x2f, 0x39, 0x5b, 0x1b, 0xbc, 0xe3,
  0x02, 0xa5, 0xac, 0x71, 0xfe, 0xce, 0xa8, 0x59, 0x6a, 0x3c, 0x4c, 0xef,
  0xf8, 0x9a, 0x75, 0x3f, 0x77, 0x63, 0xe1, 0x1c, 0x52, 0xbc, 0x13, 0x2c,
  0xfb, 0xdd, 0x80, 0x3a, 0x4f, 0x69, 0xaa, 0x7f, 0x77, 0xca, 0x99, 0x1f,
  0x1a, 0x42, 0xb5, 0x3f, 0x54, 0xa3, 0x9a, 0x38, 0x85, 0xc5, 0x12, 0x87,
  0xd7, 0xe2, 0x58, 0x36, 0x6b, 0xd1, 0xf1, 0xcf, 0xa0, 0x66, 0x08, 0x98,
  0xdc, 0xaf, 0x46, 0x66, 0xee, 0x36, 0x91, 0x50, 0x21, 0x20, 0xd6, 0xc4,
  0xbb, 0x2d, 0x0b, 0x25, 0x05, 0xeb, 0x0e, 0xcf, 0x2f, 0x15, 0x5e, 0xa5,
  0x97, 0x3f, 0x37, 0xc2, 0xf1, 0x2f, 0xd1, 0x8f, 0xd4, 0xc4, 0x76, 0x79,
  0x70, 0xbb, 0x73, 0xb4, 0x18, 0xa9, 0x1e, 0xc6, 0xde, 0x2e, 0x77, 0xe9,
  0x8b, 0x67, 0x01, 0xd8, 0x97, 0x55, 0xa2, 0x78, 0x35, 0xa7, 0x80, 0xcd,
  0xe7, 0x70, 0xa3, 0x84, 0xfc, 0x0d, 0x87, 0xaf, 0xc7, 0x6d, 0xa1, 0xa6,
  0x8a, 0x8a, 0x1e, 0x2f, 0xa9, 0x31, 0x00, 0x34, 0xda, 0xe9, 0x4c, 0x6d,
  0x96, 0x4c, 0x00, 0x16, 0xab, 0x75, 0x94, 0x73, 0x97, 0x1d, 0x02, 0xfb,
  0x7f, 0x1f, 0x1c, 0x20, 0xc4, 0xb9, 0x72, 0x32, 0xeb, 0x43, 0x1c, 0x43,
  0x9e, 0x88, 0xc1, 0x3c, 0xab, 0x27, 0x95, 0x61, 0x78, 0x0b, 0xea, 0x39,
  0x29, 0x0b, 0xb7, 0xdb, 0xcd, 0xe5, 0x43, 0xfa, 0x9a, 0x8b, 0x14, 0x9e,
  0x4e, 0xd8, 0x64, 0x0f, 0x95, 0xea, 0xed, 0xac, 0xa2, 0x80, 0xb9, 0xa4,
  0x89, 0x7f, 0x30, 0x39, 0x53, 0xad, 0x3d, 0x5d, 0xf6, 0x27, 0xc5, 0x5a,
  0x95, 0xaa, 0x47, 0xbc, 0xe4, 0xfe, 0x1b, 0x1e, 0x23, 0x76, 0xa5, 0x2d,
  0xf7, 0x6a, 0xa9, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x81, 0xcb, 0x30,
  0x81, 0xc8, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04,
  0x14, 0xb4, 0x1f, 0xa6, 0xe1, 0x8b, 0x56, 0x14, 0xe9, 0x9e, 0xf5, 0xbe,
  0x3d, 0x00, 0xa8, 0xb4, 0x49, 0xa6, 0x98, 0x12, 0xc2, 0x30, 0x1f, 0x06,
  0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xb4, 0x1f,
  0xa6, 0xe1, 0x8b, 0x56, 0x14, 0xe9, 0x9e, 0xf5, 0xbe, 0x3d, 0x00, 0xa8,
  0xb4, 0x49, 0xa6, 0x98, 0x12, 0xc2, 0x30, 0x09, 0x06, 0x03, 0x55, 0x1d,
  0x13, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x1d, 0x0f,
  0x04, 0x04, 0x03, 0x02, 0x02, 0xf4, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d,
  0x25, 0x04, 0x16, 0x30, 0x14, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05,
  0x07, 0x03, 0x01, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05, 0x07, 0x03,
  0x02, 0x30, 0x4f, 0x06, 0x03, 0x55, 0x1d, 0x11, 0x04, 0x48, 0x30, 0x46,
  0x82, 0x0a, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x62, 0x6f, 0x78,
  0x82, 0x0a, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x62, 0x6f, 0x78,
  0x87, 0x04, 0x0a, 0x00, 0x02, 0x0f, 0x87, 0x04, 0xc0, 0xa8, 0x38, 0x65,
  0x86, 0x20, 0x75, 0x72, 0x6e, 0x3a, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32,
  0x35, 0x34, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x61,
  0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x30, 0x0d,
  0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05,
  0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x73, 0xfc, 0x75, 0xb9, 0xba, 0x6a,
  0x7d, 0x20, 0xbb, 0xec, 0x7f, 0xa1, 0xdd, 0xbc, 0xf8, 0x70, 0x94, 0x67,
  0x3f, 0xd3, 0xf3, 0x01, 0x3b, 0xe2, 0x8b, 0x12, 0x21, 0xec, 0xb6, 0x47,
  0x93, 0x9f, 0xa5, 0x6e, 0xf0, 0x88, 0x17, 0x69, 0x10, 0x08, 0xd0, 0xd8,
  0x7a, 0x82, 0x70, 0x1a, 0x1b, 0xf3, 0xa8, 0x40, 0x1f, 0xa0, 0xe2, 0x81,
  0x4c, 0x1d, 0x8a, 0x37, 0xdf, 0x02, 0xcb, 0x42, 0xb4, 0xcf, 0xb8, 0x5c,
  0x78, 0x87, 0x0a, 0x26, 0x7d, 0x64, 0x2d, 0x07, 0x6a, 0xa1, 0x0a, 0xd8,
  0xa6, 0x76, 0xbe, 0x9f, 0x54, 0x37, 0x4a, 0x4e, 0x00, 0x8f, 0x46, 0xab,
  0xc7, 0x6c, 0x32, 0xbc, 0xfa, 0x3a, 0x05, 0xd4, 0xef, 0x7e, 0x57, 0xac,
  0x22, 0x3c, 0x06, 0xad, 0x2b, 0x68, 0x39, 0x01, 0x7f, 0xdb, 0xa5, 0x18,
  0xed, 0x15, 0x9c, 0x64, 0x38, 0x30, 0xcd, 0x01, 0x0f, 0xd0, 0xc6, 0x2d,
  0x7d, 0x7f, 0x1e, 0xde, 0x8b, 0xea, 0x29, 0x17, 0x9a, 0x16, 0x07, 0x03,
  0xd9, 0xe4, 0x01, 0x86, 0xd6, 0xd2, 0xdd, 0xa0, 0xb6, 0x6c, 0xca, 0x68,
  0x88, 0xdd, 0xfe, 0x85, 0x60, 0x64, 0xf2, 0x54, 0x37, 0x83, 0x7d, 0x53,
  0x24, 0xe0, 0x0c, 0x87, 0x82, 0x93, 0xb6, 0x3a, 0x4c, 0xf3, 0xe3, 0xfc,
  0x0f, 0x6c, 0xcf, 0xce, 0x22, 0x8d, 0x38, 0x28, 0x0c, 0x47, 0xa4, 0x99,
  0x2f, 0x7d, 0xbd, 0x21, 0xc9, 0xd3, 0xd8, 0x55, 0xfe, 0x87, 0xba, 0x13,
  0x12, 0x89, 0xa0, 0x0f, 0xa7, 0x83, 0x35, 0x79, 0xb8, 0xa5, 0xb0, 0xbb,
  0xcd, 0xa5, 0xfd, 0x7d, 0x8e, 0x65, 0xb3, 0xc3, 0x3c, 0xe5, 0x59, 0x27,
  0xdc, 0xf6, 0x0f, 0xe6, 0xc5, 0x01, 0xe1, 0xe8, 0x12, 0x08, 0xd4, 0xf0,
  0x63, 0x1d, 0x37, 0xb8, 0xc0, 0x24, 0xbe, 0x90, 0x97, 0x35, 0x6e, 0xb7,
  0xee, 0xcb, 0x30, 0x0f, 0x10, 0x52, 0x47, 0x10, 0x8b, 0xc3
};

#define SERVER_KEY_DER_LENGTH 1218
UA_Byte SERVER_KEY_DER_DATA[SERVER_KEY_DER_LENGTH] = {
  0x30, 0x82, 0x04, 0xbe, 0x02, 0x01, 0x00, 0x30, 0x0d, 0x06, 0x09, 0x2a,
  0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x04, 0x82,
  0x04, 0xa8, 0x30, 0x82, 0x04, 0xa4, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01,
  0x01, 0x00, 0xcf, 0x37, 0x8d, 0x67, 0xf0, 0x28, 0x1a, 0x6b, 0x58, 0x15,
  0x19, 0x80, 0x2e, 0xf8, 0xcc, 0xad, 0x85, 0xa1, 0x9c, 0x2f, 0x39, 0x5b,
  0x1b, 0xbc, 0xe3, 0x02, 0xa5, 0xac, 0x71, 0xfe, 0xce, 0xa8, 0x59, 0x6a,
  0x3c, 0x4c, 0xef, 0xf8, 0x9a, 0x75, 0x3f, 0x77, 0x63, 0xe1, 0x1c, 0x52,
  0xbc, 0x13, 0x2c, 0xfb, 0xdd, 0x80, 0x3a, 0x4f, 0x69, 0xaa, 0x7f, 0x77,
  0xca, 0x99, 0x1f, 0x1a, 0x42, 0xb5, 0x3f, 0x54, 0xa3, 0x9a, 0x38, 0x85,
  0xc5, 0x12, 0x87, 0xd7, 0xe2, 0x58, 0x36, 0x6b, 0xd1, 0xf1, 0xcf, 0xa0,
  0x66, 0x08, 0x98, 0xdc, 0xaf, 0x46, 0x66, 0xee, 0x36, 0x91, 0x50, 0x21,
  0x20, 0xd6, 0xc4, 0xbb, 0x2d, 0x0b, 0x25, 0x05, 0xeb, 0x0e, 0xcf, 0x2f,
  0x15, 0x5e, 0xa5, 0x97, 0x3f, 0x37, 0xc2, 0xf1, 0x2f, 0xd1, 0x8f, 0xd4,
  0xc4, 0x76, 0x79, 0x70, 0xbb, 0x73, 0xb4, 0x18, 0xa9, 0x1e, 0xc6, 0xde,
  0x2e, 0x77, 0xe9, 0x8b, 0x67, 0x01, 0xd8, 0x97, 0x55, 0xa2, 0x78, 0x35,
  0xa7, 0x80, 0xcd, 0xe7, 0x70, 0xa3, 0x84, 0xfc, 0x0d, 0x87, 0xaf, 0xc7,
  0x6d, 0xa1, 0xa6, 0x8a, 0x8a, 0x1e, 0x2f, 0xa9, 0x31, 0x00, 0x34, 0xda,
  0xe9, 0x4c, 0x6d, 0x96, 0x4c, 0x00, 0x16, 0xab, 0x75, 0x94, 0x73, 0x97,
  0x1d, 0x02, 0xfb, 0x7f, 0x1f, 0x1c, 0x20, 0xc4, 0xb9, 0x72, 0x32, 0xeb,
  0x43, 0x1c, 0x43, 0x9e, 0x88, 0xc1, 0x3c, 0xab, 0x27, 0x95, 0x61, 0x78,
  0x0b, 0xea, 0x39, 0x29, 0x0b, 0xb7, 0xdb, 0xcd, 0xe5, 0x43, 0xfa, 0x9a,
  0x8b, 0x14, 0x9e, 0x4e, 0xd8, 0x64, 0x0f, 0x95, 0xea, 0xed, 0xac, 0xa2,
  0x80, 0xb9, 0xa4, 0x89, 0x7f, 0x30, 0x39, 0x53, 0xad, 0x3d, 0x5d, 0xf6,
  0x27, 0xc5, 0x5a, 0x95, 0xaa, 0x47, 0xbc, 0xe4, 0xfe, 0x1b, 0x1e, 0x23,
  0x76, 0xa5, 0x2d, 0xf7, 0x6a, 0xa9, 0x02, 0x03, 0x01, 0x00, 0x01, 0x02,
  0x82, 0x01, 0x00, 0x03, 0x0b, 0x7a, 0xed, 0x73, 0x0e, 0xf3, 0xcc, 0x6d,
  0xff, 0xe9, 0x5f, 0x03, 0xd1, 0xae, 0x18, 0x42, 0xa5, 0x6c, 0x49, 0x19,
  0x5b, 0xa8, 0x5d, 0xaf, 0x2c, 0x43, 0xc8, 0xf3, 0xe7, 0xdd, 0x9b, 0x85,
  0xac, 0xd4, 0xf4, 0x00, 0x76, 0xb3, 0xb6, 0x53, 0x57, 0x6a, 0xc5, 0x4d,
  0x08, 0x3e, 0x31, 0x3d, 0xf0, 0xf9, 0x81, 0x3f, 0xda, 0x18, 0xe0, 0x63,
  0x7d, 0x1c, 0x22, 0x01, 0xdd, 0xfd, 0xea, 0xf1, 0xe2, 0x49, 0x81, 0x23,
  0xa1, 0x7b, 0x92, 0xd9, 0x22, 0x27, 0xf6, 0x49, 0xde, 0x6d, 0xb8, 0x52,
  0xe7, 0xb5, 0x78, 0x1c, 0xde, 0xe9, 0x48, 0x6c, 0x8c, 0xc5, 0x8a, 0x7f,
  0x15, 0xed, 0x88, 0x9a, 0x5d, 0x71, 0xbc, 0xff, 0x2f, 0x46, 0x13, 0xf2,
  0xa1, 0x6b, 0x7b, 0xf7, 0x8c, 0xf0, 0x65, 0xde, 0x5c, 0x72, 0xea, 0x6e,
  0x65, 0x9e, 0xf9, 0x6a, 0xb1, 0x68, 0x5f, 0xbb, 0xde, 0xbc, 0xe5, 0x6b,
  0x19, 0x8a, 0x4a, 0x03, 0x6d, 0x14, 0x1f, 0xfd, 0xe0, 0x05, 0x13, 0x0e,
  0x70, 0x0c, 0xf7, 0xa7, 0xbb, 0x2e, 0x87, 0x1f, 0xac, 0x87, 0x16, 0x06,
  0x4b, 0x81, 0x1e, 0x97, 0x43, 0xc5, 0x6f, 0x7c, 0x6d, 0x90, 0x43, 0xd5,
  0x25, 0x1e, 0x2e, 0x0f, 0xf4, 0xe6, 0x1a, 0xfc, 0xe2, 0x88, 0x7d, 0xd3,
  0x82, 0x92, 0x51, 0xf7, 0x31, 0x32, 0xab, 0xf9, 0x9a, 0x1d, 0x7e, 0x94,
  0x57, 0xd0, 0xac, 0xf8, 0x5a, 0x80, 0xd1, 0xb7, 0x7e, 0x3b, 0xcc, 0x29,
  0x1f, 0x23, 0xf1, 0xa4, 0x1d, 0x11, 0xa4, 0x02, 0x62, 0xcb, 0x4f, 0x6e,
  0x01, 0x24, 0x46, 0x15, 0xec, 0x85, 0xb8, 0xe8, 0x47, 0xef, 0x70, 0x81,
  0xf0, 0x94, 0xb4, 0x2a, 0xbd, 0x6f, 0xf0, 0xa0, 0xbb, 0x54, 0xdb, 0xf9,
  0xb6, 0xf2, 0x25, 0x3a, 0x58, 0x8d, 0xc7, 0xb1, 0x99, 0x6b, 0x0d, 0x1a,
  0x5a, 0xf5, 0xf8, 0xbc, 0x2f, 0x01, 0x0d, 0x02, 0x81, 0x81, 0x00, 0xf2,
  0x90, 0x20, 0xf2, 0x2b, 0x6c, 0xf6, 0x84, 0xc6, 0xe3, 0xe1, 0x34, 0xcb,
  0xfe, 0x77, 0xa1, 0x50, 0xf8, 0x6e, 0xaf, 0x83, 0x8e, 0x06, 0xe1, 0x70,
  0x72, 0xec, 0xfb, 0x0e, 0x86, 0x18, 0x15, 0x9a, 0x1f, 0x76, 0xa7, 0xb5,
  0x86, 0x7a, 0x4e, 0xc5, 0x80, 0xc7, 0xa8, 0x1d, 0x14, 0xbf, 0xc0, 0xef,
  0x70, 0xca, 0xa8, 0xfc, 0x39, 0xc8, 0xe8, 0x16, 0xe2, 0x0e, 0x52, 0x49,
  0xe6, 0x00, 0x46, 0x6d, 0x42, 0x83, 0x7e, 0x10, 0xc4, 0x75, 0x6c, 0x5f,
  0xe8, 0x16, 0x92, 0x54, 0xab, 0x06, 0xfb, 0x66, 0xe3, 0x63, 0x8e, 0x04,
  0xed, 0x8a, 0xa9, 0xe4, 0x7d, 0xe0, 0xdd, 0x04, 0x8a, 0xcf, 0xa0, 0x06,
  0xcd, 0xc8, 0x4a, 0xc9, 0x16, 0xb0, 0xbf, 0x29, 0x6c, 0x94, 0x9b, 0x1c,
  0x50, 0xf3, 0xea, 0x8a, 0x24, 0xf7, 0xbe, 0x9a, 0x3e, 0x14, 0x24, 0xee,
  0xe7, 0xad, 0x7d, 0x95, 0xb0, 0xd5, 0x1b, 0x02, 0x81, 0x81, 0x00, 0xda,
  0xb2, 0x2b, 0x6a, 0x2b, 0xe2, 0x7a, 0xd6, 0x63, 0xd7, 0x5b, 0x27, 0x5b,
  0x1b, 0x6e, 0xb0, 0x3f, 0xd5, 0xaf, 0x32, 0x6c, 0x63, 0x74, 0xd3, 0x12,
  0x87, 0x6e, 0xd0, 0x7e, 0x66, 0x9e, 0x5c, 0x17, 0xc8, 0xd0, 0x09, 0xf7,
  0x80, 0x35, 0xc9, 0xc8, 0x42, 0xb1, 0x4c, 0xcf, 0xfa, 0xd4, 0x91, 0x52,
  0x99, 0x35, 0x3b, 0x8e, 0x3f, 0x42, 0x38, 0x38, 0x1d, 0xec, 0x99, 0xf8,
  0xdd, 0xa5, 0x84, 0x7b, 0xd9, 0x72, 0xfe, 0x80, 0xb7, 0x4c, 0xc5, 0x9a,
  0xde, 0xa0, 0xdd, 0x97, 0xbe, 0x26, 0x79, 0xfd, 0x9b, 0xa2, 0x59, 0x5d,
  0x77, 0x3a, 0x93, 0x14, 0x92, 0x0e, 0xce, 0x8d, 0x58, 0x45, 0xfc, 0x33,
  0x7f, 0x7b, 0x5b, 0x99, 0x5c, 0x4b, 0xa2, 0x10, 0x2d, 0xea, 0xd4, 0x14,
  0xbd, 0x6e, 0x4a, 0xdd, 0xca, 0x40, 0x29, 0x11, 0x57, 0xc9, 0xa8, 0x2f,
  0xbf, 0x8d, 0xb0, 0x31, 0x77, 0x6f, 0x8b, 0x02, 0x81, 0x81, 0x00, 0x87,
  0xe5, 0x41, 0xe0, 0x0b, 0x7e, 0x4f, 0x9a, 0xd2, 0x07, 0x27, 0xcc, 0x39,
  0xa1, 0xc6, 0x8a, 0x45, 0x5f, 0xfa, 0x3b, 0x30, 0xfc, 0x28, 0x54, 0xb3,
  0x78, 0x5f, 0xd6, 0xc4, 0x2b, 0x52, 0x60, 0xff, 0xe9, 0x32, 0xc4, 0x01,
  0x0a, 0x67, 0x89, 0xac, 0x53, 0x5b, 0x08, 0x8f, 0xca, 0x69, 0x28, 0x01,
  0xbd, 0xf2, 0x7c, 0xbc, 0x5a, 0xef, 0x79, 0x40, 0x20, 0xc4, 0x1f, 0x4c,
  0x31, 0xa4, 0xe3, 0xd0, 0x20, 0xdc, 0xa4, 0x8b, 0x66, 0x55, 0xd7, 0x32,
  0xe0, 0x47, 0x8d, 0x12, 0x0c, 0x83, 0xab, 0xe3, 0xd7, 0xef, 0x95, 0xc8,
  0xa3, 0x00, 0xf5, 0xf0, 0x02, 0xaa, 0x31, 0x89, 0x72, 0xef, 0xa1, 0xdb,
  0x4d, 0xfd, 0x32, 0x10, 0xf9, 0x3a, 0x6a, 0xcf, 0x1d, 0x7b, 0x20, 0x6f,
  0xbb, 0xd6, 0xfc, 0x07, 0x0b, 0x71, 0x15, 0x83, 0x3a, 0xd6, 0x74, 0x5e,
  0xb8, 0xc3, 0xd5, 0x41, 0x41, 0x42, 0x13, 0x02, 0x81, 0x80, 0x5a, 0x9c,
  0xcb, 0xe4, 0x37, 0xbe, 0xa5, 0x0a, 0xc3, 0x5f, 0x6d, 0x83, 0x46, 0xfa,
  0x7c, 0xc8, 0x46, 0x0a, 0xb1, 0x86, 0x80, 0xe6, 0x4c, 0x77, 0x50, 0x0c,
  0x11, 0x5c, 0x0d, 0xa3, 0x53, 0x25, 0xf1, 0x2c, 0xe1, 0x15, 0xe0, 0x18,
  0x9d, 0x30, 0xb7, 0xea, 0xfa, 0x2f, 0x4b, 0x55, 0x30, 0x51, 0xee, 0x19,
  0x50, 0xb7, 0x16, 0x5f, 0x1b, 0x7e, 0xd3, 0xb1, 0x82, 0x60, 0xe1, 0x7e,
  0x64, 0xa0, 0x19, 0xf8, 0xa4, 0xee, 0xd2, 0x42, 0x20, 0x6b, 0x17, 0x99,
  0xfa, 0xa9, 0x15, 0xc0, 0x51, 0x8c, 0xe6, 0x09, 0x60, 0x21, 0x0a, 0xda,
  0xe5, 0xc8, 0x1f, 0x13, 0xcd, 0x52, 0xc3, 0xb9, 0xb9, 0x75, 0x9f, 0x98,
  0xc8, 0x71, 0xd1, 0x7f, 0x2e, 0x4f, 0x3d, 0xc8, 0xe8, 0xad, 0x6a, 0xd2,
  0x7a, 0x2a, 0x46, 0xef, 0x0f, 0xda, 0x74, 0x37, 0x1d, 0x74, 0xb4, 0x23,
  0xf7, 0xfe, 0xf2, 0xdf, 0xfb, 0xb5, 0x02, 0x81, 0x81, 0x00, 0xc3, 0x5a,
  0x06, 0xad, 0x8a, 0xed, 0xdf, 0x11, 0xda, 0x20, 0x8b, 0x47, 0x82, 0x5e,
  0xe4, 0x01, 0x9b, 0x52, 0x9c, 0x7b, 0x30, 0x04, 0x7f, 0x48, 0xce, 0xaf,
  0x46, 0x81, 0xa3, 0x07, 0xe8, 0xcc, 0x8a, 0x97, 0x9f, 0x1f, 0x10, 0xe2,
  0xf9, 0xf7, 0x66, 0x90, 0x1d, 0xd4, 0x82, 0x45, 0x1f, 0x32, 0x3b, 0xc1,
  0x7c, 0xc1, 0xfb, 0x74, 0x4e, 0x64, 0xab, 0xe0, 0xd0, 0x17, 0x99, 0xfc,
  0xc4, 0x24, 0xd3, 0xca, 0xae, 0x0a, 0x20, 0xa3, 0xa3, 0x9c, 0x05, 0x45,
  0xb3, 0x64, 0x75, 0x94, 0xa4, 0x99, 0x3a, 0x43, 0xbd, 0x98, 0x58, 0xdb,
  0x06, 0xec, 0x6d, 0xa7, 0x55, 0xd7, 0x6e, 0x29, 0xe2, 0x93, 0xdb, 0xd9,
  0x52, 0x71, 0x50, 0xdb, 0x87, 0xb2, 0x5b, 0x86, 0x7e, 0x20, 0x74, 0x39,
  0x45, 0x81, 0xba, 0x94, 0x27, 0x6a, 0x11, 0x67, 0xaa, 0xff, 0x5b, 0xcd,
  0xec, 0x5f, 0x7a, 0x5b, 0xfe, 0x10
};

#define CLIENT_CERT_AUTH_DER_LENGTH 1030
UA_Byte CLIENT_CERT_AUTH_DER_DATA[CLIENT_CERT_AUTH_DER_LENGTH] = {
  0x30, 0x82, 0x04, 0x02, 0x30, 0x82, 0x02, 0xea, 0xa0, 0x03, 0x02, 0x01,
  0x02, 0x02, 0x14, 0x02, 0x99, 0xb0, 0x8f, 0x9a, 0x61, 0x96, 0x15, 0xe9,
  0x76, 0xaf, 0x5a, 0x88, 0x61, 0x65, 0x32, 0xa9, 0xff, 0x94, 0x3f, 0x30,
  0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b,
  0x05, 0x00, 0x30, 0x54, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04,
  0x06, 0x13, 0x02, 0x44, 0x45, 0x31, 0x0d, 0x30, 0x0b, 0x06, 0x03, 0x55,
  0x04, 0x07, 0x0c, 0x04, 0x48, 0x65, 0x72, 0x65, 0x31, 0x12, 0x30, 0x10,
  0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x09, 0x6f, 0x70, 0x65, 0x6e, 0x36,
  0x32, 0x35, 0x34, 0x31, 0x31, 0x22, 0x30, 0x20, 0x06, 0x03, 0x55, 0x04,
  0x03, 0x0c, 0x19, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35, 0x34, 0x31,
  0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x40, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
  0x68, 0x6f, 0x73, 0x74, 0x30, 0x1e, 0x17, 0x0d, 0x32, 0x33, 0x31, 0x31,
  0x30, 0x38, 0x31, 0x35, 0x31, 0x39, 0x30, 0x33, 0x5a, 0x17, 0x0d, 0x33,
  0x33, 0x31, 0x31, 0x30, 0x35, 0x31, 0x35, 0x31, 0x39, 0x30, 0x33, 0x5a,
  0x30, 0x54, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x44, 0x45, 0x31, 0x0d, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x04, 0x07,
  0x0c, 0x04, 0x48, 0x65, 0x72, 0x65, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03,
  0x55, 0x04, 0x0a, 0x0c, 0x09, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35,
  0x34, 0x31, 0x31, 0x22, 0x30, 0x20, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c,
  0x19, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32, 0x35, 0x34, 0x31, 0x53, 0x65,
  0x72, 0x76, 0x65, 0x72, 0x40, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x68, 0x6f,
  0x73, 0x74, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86,
  0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01,
  0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xdb,
  0xb4, 0xe3, 0xe6, 0xd3, 0x93, 0x25, 0xe5, 0x7c, 0xe2, 0x64, 0x78, 0xa7,
  0x88, 0x5b, 0x63, 0x6c, 0x4f, 0x18, 0x10, 0x41, 0x1f, 0x4c, 0x35, 0xeb,
  0x3c, 0x33, 0x3b, 0x40, 0x18, 0x79, 0x30, 0x99, 0x3c, 0x7a, 0x9e, 0xd7,
  0xbe, 0x2e, 0x77, 0xba, 0x2b, 0x0f, 0x05, 0xb1, 0xec, 0xea, 0x55, 0xbe,
  0x4e, 0xce, 0x9a, 0x64, 0xc4, 0xde, 0x5b, 0x25, 0x38, 0x45, 0x7f, 0x49,
  0xa5, 0xf3, 0x8c, 0x5a, 0xb9, 0xa6, 0xf2, 0x1d, 0xf4, 0x83, 0x5d, 0xba,
  0x44, 0x6b, 0x13, 0x16, 0xbb, 0xf9, 0x20, 0x7e, 0x97, 0xfc, 0xb5, 0xfa,
  0x3a, 0x9c, 0x56, 0xc3, 0xaa, 0x27, 0xc1, 0x15, 0xa2, 0x80, 0xd5, 0xb4,
  0x62, 0xe0, 0x5b, 0xe8, 0x4e, 0x38, 0xde, 0x2a, 0xc8, 0x2e, 0x27, 0x2f,
  0x3c, 0x0e, 0x6f, 0x31, 0xe0, 0xc7, 0x1b, 0x60, 0x83, 0xc1, 0xe8, 0xf3,
  0x71, 0x6d, 0x42, 0xc2, 0xf2, 0x57, 0x32, 0xdb, 0xd8, 0x2f, 0xf2, 0xdc,
  0x8f, 0x6b, 0x5f, 0xb4, 0x1f, 0xac, 0x02, 0xa9, 0x6e, 0xa8, 0x71, 0xf8,
  0x85, 0x01, 0x85, 0x52, 0x2a, 0x83, 0x18, 0xf8, 0xc4, 0x43, 0x46, 0xda,
  0xc2, 0xc2, 0xc2, 0xc8, 0xdc, 0x8f, 0x2a, 0xe2, 0xc5, 0xe7, 0xe0, 0x5d,
  0x9a, 0xdb, 0xb4, 0x48, 0x69, 0x22, 0xd9, 0xdb, 0x71, 0x65, 0xcd, 0x57,
  0x06, 0xf8, 0x2e, 0x29, 0x5a, 0xee, 0x22, 0x9d, 0xce, 0x68, 0xe5, 0xcf,
  0x07, 0x27, 0x99, 0xca, 0x80, 0x15, 0xf0, 0xdf, 0x72, 0x04, 0xa3, 0x8e,
  0xee, 0xae, 0x28, 0x27, 0x4e, 0xb0, 0x08, 0x38, 0x3c, 0x55, 0x8e, 0xea,
  0x52, 0x36, 0xb2, 0xfc, 0x27, 0x5d, 0xfb, 0x42, 0xb6, 0x2e, 0x89, 0xda,
  0x86, 0x7d, 0x2a, 0xe2, 0x3f, 0x93, 0x3a, 0x38, 0xda, 0xd1, 0xc7, 0x8a,
  0x9b, 0xfc, 0x6f, 0x9c, 0x76, 0xd2, 0x00, 0x0c, 0x26, 0x72, 0x74, 0x0f,
  0x29, 0xfd, 0xeb, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x81, 0xcb, 0x30,
  0x81, 0xc8, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04,
  0x14, 0x05, 0x79, 0x6d, 0x2e, 0x93, 0xaf, 0x23, 0x28, 0xd1, 0xcd, 0xe3,
  0xe6, 0xd8, 0x33, 0x08, 0x97, 0x32, 0x41, 0xb4, 0xe8, 0x30, 0x1f, 0x06,
  0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x05, 0x79,
  0x6d, 0x2e, 0x93, 0xaf, 0x23, 0x28, 0xd1, 0xcd, 0xe3, 0xe6, 0xd8, 0x33,
  0x08, 0x97, 0x32, 0x41, 0xb4, 0xe8, 0x30, 0x09, 0x06, 0x03, 0x55, 0x1d,
  0x13, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x1d, 0x0f,
  0x04, 0x04, 0x03, 0x02, 0x02, 0xf4, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d,
  0x25, 0x04, 0x16, 0x30, 0x14, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05,
  0x07, 0x03, 0x01, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05, 0x07, 0x03,
  0x02, 0x30, 0x4f, 0x06, 0x03, 0x55, 0x1d, 0x11, 0x04, 0x48, 0x30, 0x46,
  0x82, 0x0a, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x62, 0x6f, 0x78,
  0x82, 0x0a, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x62, 0x6f, 0x78,
  0x87, 0x04, 0x0a, 0x00, 0x02, 0x0f, 0x87, 0x04, 0xc0, 0xa8, 0x38, 0x65,
  0x86, 0x20, 0x75, 0x72, 0x6e, 0x3a, 0x6f, 0x70, 0x65, 0x6e, 0x36, 0x32,
  0x35, 0x34, 0x31, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x61,
  0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x30, 0x0d,
  0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05,
  0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x32, 0x5d, 0x3f, 0xcf, 0x97, 0x58,
  0x8e, 0x18, 0x1f, 0xeb, 0xbe, 0x11, 0xb4, 0xae, 0x8a, 0x7f, 0x44, 0xc2,
  0xd2, 0x69, 0xa9, 0x93, 0x51, 0x41, 0x69, 0x1f, 0xbe, 0x01, 0x5c, 0x69,
  0x13, 0xbf, 0xf6, 0xde, 0x48, 0xb8, 0xea, 0xbd, 0x28, 0x5d, 0x7f, 0x5c,
  0x02, 0x8d, 0x77, 0x11, 0x27, 0x7b, 0xeb, 0x2b, 0x8b, 0xd6, 0x9b, 0xa4,
  0xa5, 0x83, 0x11, 0x89, 0x41, 0x64, 0x00, 0x6b, 0x32, 0x6d, 0xa4, 0xf1,
  0xde, 0xac, 0xad, 0x66, 0x87, 0x43, 0x84, 0x96, 0x31, 0xe5, 0x16, 0x50,
  0x76, 0xad, 0xed, 0xf8, 0xe4, 0xdf, 0xc9, 0x20, 0xa4, 0xc1, 0xf2, 0xd0,
  0x40, 0x47, 0x9c, 0xb9, 0x6f, 0x8d, 0xf3, 0xb7, 0x17, 0x39, 0xbc, 0x69,
  0x99, 0x0f, 0xf6, 0x19, 0xf5, 0xdd, 0xca, 0x94, 0xe0, 0x71, 0x4b, 0x94,
  0x35, 0x53, 0x2f, 0xf1, 0xcf, 0x62, 0x45, 0x91, 0x36, 0x4b, 0xb6, 0xdf,
  0x91, 0xb7, 0x37, 0x44, 0x01, 0x95, 0xf2, 0xc7, 0x44, 0x8f, 0x98, 0x4a,
  0x04, 0x41, 0x7a, 0x1b, 0x28, 0x74, 0x3e, 0xbc, 0x56, 0x49, 0x8e, 0x94,
  0xdf, 0x6f, 0xee, 0x52, 0xaa, 0x99, 0xe2, 0x15, 0xa9, 0xa8, 0xe1, 0x3e,
  0x32, 0x3a, 0xf8, 0x3f, 0x0a, 0x76, 0x85, 0x45, 0x2e, 0x8d, 0x4d, 0xed,
  0xc5, 0xdb, 0xe1, 0xf8, 0x79, 0x5d, 0xc1, 0xef, 0x13, 0x8a, 0x5f, 0x18,
  0x30, 0xc6, 0x88, 0xef, 0x6d, 0x66, 0x27, 0x5b, 0x00, 0x99, 0xb0, 0x6e,
  0xc8, 0x29, 0x8a, 0x90, 0xdd, 0x55, 0x48, 0x66, 0x14, 0xbb, 0xda, 0x02,
  0x1f, 0x36, 0x54, 0x11, 0xa0, 0x21, 0x26, 0xc1, 0x54, 0xd3, 0xbd, 0x16,
  0xba, 0xa6, 0x72, 0x56, 0xcd, 0x4e, 0x5e, 0xd1, 0x30, 0x25, 0xe7, 0xea,
  0x93, 0x13, 0x63, 0x33, 0x1e, 0x39, 0x5a, 0x3b, 0x95, 0xdf, 0x6c, 0x84,
  0x8f, 0x1d, 0xe0, 0x9f, 0xcf, 0xc6, 0xab, 0x7c, 0x55, 0xb5
};

#define CLIENT_KEY_AUTH_DER_LENGTH 1218
UA_Byte CLIENT_KEY_AUTH_DER_DATA[CLIENT_KEY_AUTH_DER_LENGTH] = {
  0x30, 0x82, 0x04, 0xbe, 0x02, 0x01, 0x00, 0x30, 0x0d, 0x06, 0x09, 0x2a,
  0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x04, 0x82,
  0x04, 0xa8, 0x30, 0x82, 0x04, 0xa4, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01,
  0x01, 0x00, 0xdb, 0xb4, 0xe3, 0xe6, 0xd3, 0x93, 0x25, 0xe5, 0x7c, 0xe2,
  0x64, 0x78, 0xa7, 0x88, 0x5b, 0x63, 0x6c, 0x4f, 0x18, 0x10, 0x41, 0x1f,
  0x4c, 0x35, 0xeb, 0x3c, 0x33, 0x3b, 0x40, 0x18, 0x79, 0x30, 0x99, 0x3c,
  0x7a, 0x9e, 0xd7, 0xbe, 0x2e, 0x77, 0xba, 0x2b, 0x0f, 0x05, 0xb1, 0xec,
  0xea, 0x55, 0xbe, 0x4e, 0xce, 0x9a, 0x64, 0xc4, 0xde, 0x5b, 0x25, 0x38,
  0x45, 0x7f, 0x49, 0xa5, 0xf3, 0x8c, 0x5a, 0xb9, 0xa6, 0xf2, 0x1d, 0xf4,
  0x83, 0x5d, 0xba, 0x44, 0x6b, 0x13, 0x16, 0xbb, 0xf9, 0x20, 0x7e, 0x97,
  0xfc, 0xb5, 0xfa, 0x3a, 0x9c, 0x56, 0xc3, 0xaa, 0x27, 0xc1, 0x15, 0xa2,
  0x80, 0xd5, 0xb4, 0x62, 0xe0, 0x5b, 0xe8, 0x4e, 0x38, 0xde, 0x2a, 0xc8,
  0x2e, 0x27, 0x2f, 0x3c, 0x0e, 0x6f, 0x31, 0xe0, 0xc7, 0x1b, 0x60, 0x83,
  0xc1, 0xe8, 0xf3, 0x71, 0x6d, 0x42, 0xc2, 0xf2, 0x57, 0x32, 0xdb, 0xd8,
  0x2f, 0xf2, 0xdc, 0x8f, 0x6b, 0x5f, 0xb4, 0x1f, 0xac, 0x02, 0xa9, 0x6e,
  0xa8, 0x71, 0xf8, 0x85, 0x01, 0x85, 0x52, 0x2a, 0x83, 0x18, 0xf8, 0xc4,
  0x43, 0x46, 0xda, 0xc2, 0xc2, 0xc2, 0xc8, 0xdc, 0x8f, 0x2a, 0xe2, 0xc5,
  0xe7, 0xe0, 0x5d, 0x9a, 0xdb, 0xb4, 0x48, 0x69, 0x22, 0xd9, 0xdb, 0x71,
  0x65, 0xcd, 0x57, 0x06, 0xf8, 0x2e, 0x29, 0x5a, 0xee, 0x22, 0x9d, 0xce,
  0x68, 0xe5, 0xcf, 0x07, 0x27, 0x99, 0xca, 0x80, 0x15, 0xf0, 0xdf, 0x72,
  0x04, 0xa3, 0x8e, 0xee, 0xae, 0x28, 0x27, 0x4e, 0xb0, 0x08, 0x38, 0x3c,
  0x55, 0x8e, 0xea, 0x52, 0x36, 0xb2, 0xfc, 0x27, 0x5d, 0xfb, 0x42, 0xb6,
  0x2e, 0x89, 0xda, 0x86, 0x7d, 0x2a, 0xe2, 0x3f, 0x93, 0x3a, 0x38, 0xda,
  0xd1, 0xc7, 0x8a, 0x9b, 0xfc, 0x6f, 0x9c, 0x76, 0xd2, 0x00, 0x0c, 0x26,
  0x72, 0x74, 0x0f, 0x29, 0xfd, 0xeb, 0x02, 0x03, 0x01, 0x00, 0x01, 0x02,
  0x82, 0x01, 0x00, 0x04, 0x20, 0xe4, 0x8d, 0x70, 0x59, 0x5a, 0x03, 0x73,
  0x72, 0xcf, 0x9f, 0x82, 0xca, 0x69, 0xa9, 0x37, 0x1e, 0x4f, 0x5d, 0xf2,
  0xd3, 0x53, 0x3b, 0xca, 0x25, 0x51, 0xf3, 0x21, 0x93, 0xb4, 0x27, 0x49,
  0x21, 0xdd, 0x4e, 0x01, 0xd0, 0xd5, 0x8f, 0xb3, 0x64, 0x5e, 0xbe, 0x65,
  0x27, 0x06, 0x0a, 0x41, 0x6e, 0xba, 0xac, 0x25, 0x0b, 0x9c, 0x00, 0x0b,
  0x75, 0x80, 0xbc, 0xd1, 0x15, 0xf8, 0xbb, 0x20, 0xf3, 0x4f, 0x23, 0x4a,
  0x93, 0xcf, 0x2a, 0x22, 0x37, 0x69, 0xe9, 0xac, 0x6a, 0x30, 0xd6, 0xbe,
  0xfa, 0x3d, 0x29, 0xf0, 0x3f, 0x4c, 0xb3, 0xc6, 0xae, 0x7a, 0x5b, 0xc2,
  0xfb, 0xd0, 0x3e, 0xf3, 0xca, 0x4d, 0xdb, 0xfc, 0x44, 0x08, 0x06, 0x88,
  0xb8, 0x45, 0x41, 0xc0, 0x3d, 0xf9, 0x29, 0x76, 0xbe, 0xfa, 0x0e, 0xd6,
  0x23, 0xf3, 0xaf, 0x5c, 0x6f, 0xbb, 0xb5, 0x5e, 0xf3, 0x6d, 0xd7, 0x02,
  0x65, 0x40, 0x92, 0xbb, 0x1c, 0xf4, 0x3f, 0x71, 0xfd, 0x07, 0x83, 0xac,
  0xf5, 0x98, 0xa3, 0x26, 0x79, 0x87, 0xd9, 0xdc, 0x6c, 0x87, 0x11, 0xca,
  0xb2, 0x23, 0xaa, 0xe6, 0xc3, 0x9f, 0x2b, 0x6b, 0x60, 0x5b, 0x27, 0xbd,
  0xc5, 0xd4, 0x71, 0x52, 0xca, 0x28, 0xe2, 0xd3, 0xe0, 0xe2, 0xae, 0x96,
  0x45, 0x67, 0xaa, 0x16, 0x42, 0x46, 0xe6, 0x9e, 0x93, 0x35, 0x30, 0x61,
  0x5c, 0xdb, 0x9b, 0x4a, 0x3c, 0x8f, 0x82, 0x2c, 0xc0, 0x36, 0x1b, 0x5d,
  0x76, 0x5e, 0x3c, 0xc2, 0x99, 0x8a, 0x5e, 0x00, 0x84, 0xce, 0xec, 0x90,
  0xc7, 0xeb, 0xac, 0xd4, 0xe6, 0xb9, 0x7a, 0x3a, 0x6f, 0xad, 0x83, 0xed,
  0x4e, 0x7a, 0x3b, 0x51, 0xa6, 0x3c, 0xaa, 0xc3, 0x98, 0xac, 0xbb, 0x24,
  0x8c, 0x47, 0xaf, 0xf6, 0xc0, 0x96, 0xd2, 0x51, 0xc4, 0xa1, 0xef, 0x40,
  0xf7, 0xbd, 0x31, 0x3d, 0x4c, 0xa6, 0xe1, 0x02, 0x81, 0x81, 0x00, 0xf8,
  0xb0, 0x9f, 0x21, 0x0e, 0xc4, 0xef, 0x4a, 0x93, 0x5d, 0xc9, 0x5b, 0x6c,
  0x0d, 0x7e, 0x2d, 0x08, 0x2d, 0xf1, 0xfc, 0x48, 0x7b, 0x25, 0x37, 0xb7,
  0x84, 0xea, 0x0b, 0x8a, 0xd8, 0x4f, 0xff, 0xd2, 0x05, 0x1f, 0x0d, 0xc7,
  0x8b, 0x6d, 0x7c, 0x85, 0xa7, 0x41, 0xb9, 0x9b, 0x58, 0xc4, 0xa5, 0xdf,
  0x9a, 0xc8, 0x3d, 0xef, 0x76, 0x12, 0xfa, 0xe0, 0xda, 0x4e, 0x82, 0xc2,
  0xa3, 0x1f, 0xc5, 0x58, 0x29, 0x14, 0xaa, 0x00, 0xb8, 0x59, 0x40, 0x8e,
  0xac, 0x88, 0x0c, 0x1d, 0x8b, 0xa4, 0x0b, 0xb1, 0x16, 0xc8, 0x69, 0xf3,
  0xaa, 0x55, 0xd9, 0x4b, 0x27, 0x5b, 0x3a, 0xb4, 0xc6, 0x7d, 0xeb, 0x28,
  0xd6, 0xe7, 0xf0, 0x94, 0x41, 0x17, 0x25, 0x81, 0x6e, 0x44, 0x1c, 0x92,
  0x0d, 0x18, 0x41, 0xf9, 0xac, 0xac, 0xe9, 0xae, 0xb4, 0xd7, 0xcd, 0x10,
  0xdd, 0x17, 0xec, 0x93, 0x16, 0x12, 0xa1, 0x02, 0x81, 0x81, 0x00, 0xe2,
  0x2a, 0x2b, 0xb0, 0xeb, 0xaf, 0xcd, 0x2c, 0xe1, 0x76, 0xd7, 0x62, 0xa5,
  0x5d, 0x81, 0xd6, 0x88, 0x77, 0xd6, 0x64, 0x4a, 0x5b, 0x98, 0x04, 0xd9,
  0xbd, 0x3f, 0x07, 0xe0, 0x7d, 0x39, 0x11, 0x38, 0x5e, 0x8d, 0x17, 0x9c,
  0xd3, 0x1e, 0x5f, 0x6e, 0x0a, 0xbe, 0x41, 0x9c, 0x63, 0xb6, 0xc3, 0xa2,
  0xde, 0x6c, 0x9b, 0x5f, 0x97, 0x4e, 0x68, 0x4b, 0xf7, 0xe3, 0xca, 0x25,
  0xf4, 0x84, 0x3c, 0xaa, 0x09, 0x42, 0xe8, 0x40, 0x30, 0x89, 0x53, 0xcb,
  0xc9, 0x2f, 0xdb, 0xc3, 0xa4, 0xbc, 0x40, 0xa7, 0xf0, 0xb8, 0x0a, 0x6c,
  0xcc, 0x1c, 0x08, 0x3c, 0x9f, 0x4b, 0x1b, 0xff, 0xe3, 0x6e, 0x8a, 0x5e,
  0x98, 0x61, 0xc4, 0xd9, 0x6f, 0xa2, 0xb8, 0x83, 0x56, 0x7d, 0x68, 0x03,
  0x6d, 0xbd, 0xa0, 0xea, 0x1a, 0x53, 0x63, 0x4c, 0x74, 0x9a, 0xe9, 0x4f,
  0x45, 0x29, 0xae, 0xc6, 0x6a, 0x91, 0x0b, 0x02, 0x81, 0x80, 0x1f, 0xeb,
  0xab, 0xc1, 0x36, 0x80, 0x18, 0xa6, 0xdd, 0xdb, 0x7f, 0xe8, 0xf8, 0x29,
  0x93, 0x34, 0x7c, 0x84, 0x49, 0x37, 0x34, 0xa6, 0x79, 0xd4, 0x78, 0xfd,
  0xda, 0x7c, 0xb8, 0xc9, 0xa3, 0x1b, 0x16, 0xfe, 0x09, 0x4a, 0x5f, 0x7e,
  0x8a, 0x03, 0x1d, 0xb4, 0xa6, 0x3f, 0x08, 0xad, 0x90, 0x30, 0x2a, 0x4f,
  0x57, 0xbc, 0x7b, 0x6c, 0x10, 0x6b, 0x9b, 0x48, 0xea, 0x22, 0xe6, 0x90,
  0xc1, 0x97, 0x37, 0x05, 0xae, 0xdd, 0x53, 0x52, 0x56, 0x42, 0x6f, 0x0d,
  0xbe, 0x38, 0xaf, 0xe2, 0x28, 0xa0, 0x47, 0x8e, 0xc1, 0x12, 0xb8, 0x6f,
  0xf8, 0xac, 0xf7, 0x74, 0x89, 0xc5, 0x33, 0x46, 0xf7, 0x0a, 0xa4, 0x27,
  0x51, 0x86, 0x13, 0xc1, 0x77, 0x13, 0x1d, 0x55, 0xe5, 0xf0, 0x34, 0xde,
  0xf1, 0x6a, 0x26, 0x7d, 0xff, 0x83, 0xcf, 0x24, 0xef, 0x3e, 0x27, 0x17,
  0xf9, 0xe6, 0x27, 0xcb, 0x01, 0x81, 0x02, 0x81, 0x81, 0x00, 0xb8, 0x19,
  0xe3, 0xde, 0xec, 0xbb, 0xfa, 0xa4, 0xa2, 0x13, 0xff, 0x58, 0x49, 0x8c,
  0x48, 0x78, 0xbe, 0x35, 0xee, 0xcb, 0x4c, 0xcc, 0x2a, 0x7f, 0x28, 0x4f,
  0xa8, 0xd3, 0x5c, 0xa6, 0x12, 0xa2, 0x35, 0xe4, 0xa1, 0xad, 0xaa, 0xf7,
  0x20, 0x2e, 0x46, 0x81, 0x70, 0x46, 0x30, 0x6b, 0xeb, 0x06, 0x6d, 0xb9,
  0xe9, 0x66, 0xc0, 0xf5, 0x85, 0xd9, 0xd8, 0x9d, 0x3d, 0x4b, 0xfc, 0x81,
  0x82, 0x73, 0x6f, 0x66, 0x82, 0x94, 0x54, 0x4c, 0x2e, 0x3d, 0x8c, 0x11,
  0x85, 0x67, 0xbb, 0x66, 0x89, 0xe7, 0x87, 0xcd, 0xa7, 0xc2, 0xb4, 0xb5,
  0xa1, 0xcc, 0x02, 0xad, 0x18, 0x92, 0xfe, 0x45, 0xc0, 0x61, 0xda, 0x86,
  0xe8, 0x6f, 0x39, 0x20, 0x6a, 0xb1, 0x10, 0x18, 0x83, 0x94, 0xfb, 0xd5,
  0x85, 0x1b, 0x4b, 0xf5, 0x8a, 0x13, 0xb6, 0xd4, 0xe4, 0x95, 0x2e, 0xf5,
  0xf9, 0xec, 0x4f, 0x8f, 0xc7, 0xe9, 0x02, 0x81, 0x81, 0x00, 0x93, 0xc0,
  0x5d, 0x4e, 0x69, 0x53, 0x1f, 0xd8, 0x8d, 0x5f, 0xeb, 0xa3, 0x3e, 0xdc,
  0x56, 0x9f, 0x98, 0x98, 0xb4, 0xdd, 0x36, 0x37, 0xea, 0xfc, 0xaa, 0xbd,
  0x88, 0xce, 0x23, 0x37, 0x44, 0xf1, 0x5e, 0xb1, 0x02, 0xf2, 0xed, 0xe6,
  0xcb, 0x8f, 0x17, 0x23, 0xad, 0x49, 0x3e, 0xb2, 0x28, 0x56, 0xbc, 0x08,
  0x93, 0x89, 0xe7, 0x1e, 0xf2, 0xb6, 0xf7, 0x61, 0x94, 0x48, 0xa0, 0x2d,
  0x8c, 0x34, 0xbb, 0xbc, 0x9f, 0x35, 0xa9, 0x3d, 0xc6, 0xd1, 0x8a, 0xcc,
  0x7b, 0xd4, 0x96, 0x4a, 0x1c, 0x39, 0xd5, 0x45, 0x0b, 0xb3, 0xc3, 0xbc,
  0xa3, 0xc5, 0x36, 0xce, 0x2f, 0x79, 0x3a, 0x65, 0xf3, 0x5b, 0x89, 0x18,
  0x29, 0xc3, 0xd0, 0x7c, 0xcf, 0x9e, 0x4b, 0x2e, 0x0a, 0x62, 0x00, 0x4a,
  0x3c, 0xf1, 0x3e, 0xe1, 0xb8, 0x71, 0x37, 0x87, 0x6c, 0xc2, 0x14, 0x63,
  0x23, 0x24, 0xd7, 0x6e, 0x8b, 0x3c
};

_UA_END_DECLS

#endif //OPEN62541_CERTIFICATES_H
