// Copyright (C) 2017 The Qt Company Ltd.
// Copyright (C) 2015-2016 Oleksandr Tymoshenko <gonzo@bluezbox.com>
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#ifndef QBSDKEYBOARD_DEFAULTMAP_P_H
#define QBSDKEYBOARD_DEFAULTMAP_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "qnamespace.h"

// no QT_BEGIN_NAMESPACE, since we include it internally...
using namespace QBsdKeyboardMap;

#define QCTRL(x)    ((x) | Qt::ControlModifier)
#define QALT(x)     ((x) | Qt::AltModifier)
#define QKEYPAD(x)  ((x) | Qt::KeypadModifier)

const QBsdKeyboardMap::Mapping keymapDefault[] = {
    {   1, 0xffff, Qt::Key_Escape,              ModPlain,                        NoFlags, 0x0000 },
    {   2, 0x0031, Qt::Key_1,                   ModPlain,                        NoFlags, 0x0000 },
    {   2, 0x0021, Qt::Key_Exclam,              ModShift,                        NoFlags, 0x0000 },
    {   3, 0x0032, Qt::Key_2,                   ModPlain,                        NoFlags, 0x0000 },
    {   3, 0x0040, Qt::Key_At,                  ModShift,                        NoFlags, 0x0000 },
    {   3, 0x0040, Qt::Key_At,                  ModAltGr,                        NoFlags, 0x0000 },
    {   4, 0x0033, Qt::Key_3,                   ModPlain,                        NoFlags, 0x0000 },
    {   4, 0x0023, Qt::Key_NumberSign,          ModShift,                        NoFlags, 0x0000 },
    {   4, 0xffff, Qt::Key_Escape,              ModControl,                      NoFlags, 0x0000 },
    {   5, 0x0034, Qt::Key_4,                   ModPlain,                        NoFlags, 0x0000 },
    {   5, 0x0024, Qt::Key_Dollar,              ModShift,                        NoFlags, 0x0000 },
    {   5, 0x0024, Qt::Key_Dollar,              ModAltGr,                        NoFlags, 0x0000 },
    {   5, 0x005c, QCTRL(Qt::Key_Backslash),    ModControl,                      NoFlags, 0x0000 },
    {   6, 0x0035, Qt::Key_5,                   ModPlain,                        NoFlags, 0x0000 },
    {   6, 0x0025, Qt::Key_Percent,             ModShift,                        NoFlags, 0x0000 },
    {   6, 0x005d, QCTRL(Qt::Key_BracketRight), ModControl,                      NoFlags, 0x0000 },
    {   7, 0x0036, Qt::Key_6,                   ModPlain,                        NoFlags, 0x0000 },
    {   7, 0x005e, Qt::Key_AsciiCircum,         ModShift,                        NoFlags, 0x0000 },
    {   7, 0x005e, QCTRL(Qt::Key_AsciiCircum),  ModControl,                      NoFlags, 0x0000 },
    {   8, 0x0037, Qt::Key_7,                   ModPlain,                        NoFlags, 0x0000 },
    {   8, 0x0026, Qt::Key_Ampersand,           ModShift,                        NoFlags, 0x0000 },
    {   8, 0x007b, Qt::Key_BraceLeft,           ModAltGr,                        NoFlags, 0x0000 },
    {   8, 0x005f, QCTRL(Qt::Key_Underscore),   ModControl,                      NoFlags, 0x0000 },
    {   9, 0x0038, Qt::Key_8,                   ModPlain,                        NoFlags, 0x0000 },
    {   9, 0x002a, Qt::Key_Asterisk,            ModShift,                        NoFlags, 0x0000 },
    {   9, 0x005b, Qt::Key_BracketLeft,         ModAltGr,                        NoFlags, 0x0000 },
    {   9, 0xffff, Qt::Key_Backspace,           ModControl,                      NoFlags, 0x0000 },
    {  10, 0x0039, Qt::Key_9,                   ModPlain,                        NoFlags, 0x0000 },
    {  10, 0x0028, Qt::Key_ParenLeft,           ModShift,                        NoFlags, 0x0000 },
    {  10, 0x005d, Qt::Key_BracketRight,        ModAltGr,                        NoFlags, 0x0000 },
    {  11, 0x0030, Qt::Key_0,                   ModPlain,                        NoFlags, 0x0000 },
    {  11, 0x0029, Qt::Key_ParenRight,          ModShift,                        NoFlags, 0x0000 },
    {  11, 0x007d, Qt::Key_BraceRight,          ModAltGr,                        NoFlags, 0x0000 },
    {  12, 0x002d, Qt::Key_Minus,               ModPlain,                        NoFlags, 0x0000 },
    {  12, 0x005f, Qt::Key_Underscore,          ModShift,                        NoFlags, 0x0000 },
    {  12, 0x005c, Qt::Key_Backslash,           ModAltGr,                        NoFlags, 0x0000 },
    {  12, 0x005f, QCTRL(Qt::Key_Underscore),   ModControl,                      NoFlags, 0x0000 },
    {  12, 0x005f, QCTRL(Qt::Key_Underscore),   ModShift | ModControl,           NoFlags, 0x0000 },
    {  13, 0x003d, Qt::Key_Equal,               ModPlain,                        NoFlags, 0x0000 },
    {  13, 0x002b, Qt::Key_Plus,                ModShift,                        NoFlags, 0x0000 },
    {  14, 0xffff, Qt::Key_Backspace,           ModPlain,                        NoFlags, 0x0000 },
    {  15, 0xffff, Qt::Key_Tab,                 ModPlain,                        NoFlags, 0x0000 },
    {  16, 0x0071, Qt::Key_Q,                   ModPlain,                        IsLetter, 0x0000 },
    {  16, 0x0051, Qt::Key_Q,                   ModShift,                        IsLetter, 0x0000 },
    {  16, 0x0071, Qt::Key_Q,                   ModAltGr,                        IsLetter, 0x0000 },
    {  16, 0x0051, Qt::Key_Q,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  16, 0x0071, QCTRL(Qt::Key_Q),            ModControl,                      IsLetter, 0x0000 },
    {  16, 0x0071, QCTRL(Qt::Key_Q),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  16, 0x0071, QCTRL(Qt::Key_Q),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  16, 0x0071, QCTRL(Qt::Key_Q),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  16, 0x0071, QALT(Qt::Key_Q),             ModAlt,                          IsLetter, 0x0000 },
    {  16, 0x0071, QALT(Qt::Key_Q),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  16, 0x0071, QALT(Qt::Key_Q),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  16, 0x0071, QALT(Qt::Key_Q),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  16, 0x0071, QCTRL(QALT(Qt::Key_Q)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  16, 0x0071, QCTRL(QALT(Qt::Key_Q)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  16, 0x0071, QCTRL(QALT(Qt::Key_Q)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  16, 0x0071, QCTRL(QALT(Qt::Key_Q)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  17, 0x0077, Qt::Key_W,                   ModPlain,                        IsLetter, 0x0000 },
    {  17, 0x0057, Qt::Key_W,                   ModShift,                        IsLetter, 0x0000 },
    {  17, 0x0077, Qt::Key_W,                   ModAltGr,                        IsLetter, 0x0000 },
    {  17, 0x0057, Qt::Key_W,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  17, 0x0077, QCTRL(Qt::Key_W),            ModControl,                      IsLetter, 0x0000 },
    {  17, 0x0077, QCTRL(Qt::Key_W),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  17, 0x0077, QCTRL(Qt::Key_W),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  17, 0x0077, QCTRL(Qt::Key_W),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  17, 0x0077, QALT(Qt::Key_W),             ModAlt,                          IsLetter, 0x0000 },
    {  17, 0x0077, QALT(Qt::Key_W),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  17, 0x0077, QALT(Qt::Key_W),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  17, 0x0077, QALT(Qt::Key_W),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  17, 0x0077, QCTRL(QALT(Qt::Key_W)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  17, 0x0077, QCTRL(QALT(Qt::Key_W)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  17, 0x0077, QCTRL(QALT(Qt::Key_W)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  17, 0x0077, QCTRL(QALT(Qt::Key_W)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  18, 0x0065, Qt::Key_E,                   ModPlain,                        IsLetter, 0x0000 },
    {  18, 0x0045, Qt::Key_E,                   ModShift,                        IsLetter, 0x0000 },
    {  18, 0x0065, Qt::Key_E,                   ModAltGr,                        IsLetter, 0x0000 },
    {  18, 0x0045, Qt::Key_E,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  18, 0x0065, QCTRL(Qt::Key_E),            ModControl,                      IsLetter, 0x0000 },
    {  18, 0x0065, QCTRL(Qt::Key_E),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  18, 0x0065, QCTRL(Qt::Key_E),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  18, 0x0065, QCTRL(Qt::Key_E),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  18, 0x0065, QALT(Qt::Key_E),             ModAlt,                          IsLetter, 0x0000 },
    {  18, 0x0065, QALT(Qt::Key_E),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  18, 0x0065, QALT(Qt::Key_E),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  18, 0x0065, QALT(Qt::Key_E),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  18, 0x0065, QCTRL(QALT(Qt::Key_E)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  18, 0x0065, QCTRL(QALT(Qt::Key_E)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  18, 0x0065, QCTRL(QALT(Qt::Key_E)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  18, 0x0065, QCTRL(QALT(Qt::Key_E)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  19, 0x0072, Qt::Key_R,                   ModPlain,                        IsLetter, 0x0000 },
    {  19, 0x0052, Qt::Key_R,                   ModShift,                        IsLetter, 0x0000 },
    {  19, 0x0072, Qt::Key_R,                   ModAltGr,                        IsLetter, 0x0000 },
    {  19, 0x0052, Qt::Key_R,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  19, 0x0072, QCTRL(Qt::Key_R),            ModControl,                      IsLetter, 0x0000 },
    {  19, 0x0072, QCTRL(Qt::Key_R),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  19, 0x0072, QCTRL(Qt::Key_R),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  19, 0x0072, QCTRL(Qt::Key_R),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  19, 0x0072, QALT(Qt::Key_R),             ModAlt,                          IsLetter, 0x0000 },
    {  19, 0x0072, QALT(Qt::Key_R),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  19, 0x0072, QALT(Qt::Key_R),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  19, 0x0072, QALT(Qt::Key_R),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  19, 0x0072, QCTRL(QALT(Qt::Key_R)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  19, 0x0072, QCTRL(QALT(Qt::Key_R)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  19, 0x0072, QCTRL(QALT(Qt::Key_R)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  19, 0x0072, QCTRL(QALT(Qt::Key_R)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  20, 0x0074, Qt::Key_T,                   ModPlain,                        IsLetter, 0x0000 },
    {  20, 0x0054, Qt::Key_T,                   ModShift,                        IsLetter, 0x0000 },
    {  20, 0x0074, Qt::Key_T,                   ModAltGr,                        IsLetter, 0x0000 },
    {  20, 0x0054, Qt::Key_T,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  20, 0x0074, QCTRL(Qt::Key_T),            ModControl,                      IsLetter, 0x0000 },
    {  20, 0x0074, QCTRL(Qt::Key_T),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  20, 0x0074, QCTRL(Qt::Key_T),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  20, 0x0074, QCTRL(Qt::Key_T),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  20, 0x0074, QALT(Qt::Key_T),             ModAlt,                          IsLetter, 0x0000 },
    {  20, 0x0074, QALT(Qt::Key_T),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  20, 0x0074, QALT(Qt::Key_T),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  20, 0x0074, QALT(Qt::Key_T),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  20, 0x0074, QCTRL(QALT(Qt::Key_T)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  20, 0x0074, QCTRL(QALT(Qt::Key_T)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  20, 0x0074, QCTRL(QALT(Qt::Key_T)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  20, 0x0074, QCTRL(QALT(Qt::Key_T)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  21, 0x0079, Qt::Key_Y,                   ModPlain,                        IsLetter, 0x0000 },
    {  21, 0x0059, Qt::Key_Y,                   ModShift,                        IsLetter, 0x0000 },
    {  21, 0x0079, Qt::Key_Y,                   ModAltGr,                        IsLetter, 0x0000 },
    {  21, 0x0059, Qt::Key_Y,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  21, 0x0079, QCTRL(Qt::Key_Y),            ModControl,                      IsLetter, 0x0000 },
    {  21, 0x0079, QCTRL(Qt::Key_Y),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  21, 0x0079, QCTRL(Qt::Key_Y),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  21, 0x0079, QCTRL(Qt::Key_Y),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  21, 0x0079, QALT(Qt::Key_Y),             ModAlt,                          IsLetter, 0x0000 },
    {  21, 0x0079, QALT(Qt::Key_Y),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  21, 0x0079, QALT(Qt::Key_Y),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  21, 0x0079, QALT(Qt::Key_Y),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  21, 0x0079, QCTRL(QALT(Qt::Key_Y)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  21, 0x0079, QCTRL(QALT(Qt::Key_Y)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  21, 0x0079, QCTRL(QALT(Qt::Key_Y)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  21, 0x0079, QCTRL(QALT(Qt::Key_Y)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  22, 0x0075, Qt::Key_U,                   ModPlain,                        IsLetter, 0x0000 },
    {  22, 0x0055, Qt::Key_U,                   ModShift,                        IsLetter, 0x0000 },
    {  22, 0x0075, Qt::Key_U,                   ModAltGr,                        IsLetter, 0x0000 },
    {  22, 0x0055, Qt::Key_U,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  22, 0x0075, QCTRL(Qt::Key_U),            ModControl,                      IsLetter, 0x0000 },
    {  22, 0x0075, QCTRL(Qt::Key_U),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  22, 0x0075, QCTRL(Qt::Key_U),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  22, 0x0075, QCTRL(Qt::Key_U),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  22, 0x0075, QALT(Qt::Key_U),             ModAlt,                          IsLetter, 0x0000 },
    {  22, 0x0075, QALT(Qt::Key_U),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  22, 0x0075, QALT(Qt::Key_U),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  22, 0x0075, QALT(Qt::Key_U),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  22, 0x0075, QCTRL(QALT(Qt::Key_U)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  22, 0x0075, QCTRL(QALT(Qt::Key_U)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  22, 0x0075, QCTRL(QALT(Qt::Key_U)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  22, 0x0075, QCTRL(QALT(Qt::Key_U)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  23, 0x0069, Qt::Key_I,                   ModPlain,                        IsLetter, 0x0000 },
    {  23, 0x0049, Qt::Key_I,                   ModShift,                        IsLetter, 0x0000 },
    {  23, 0x0069, Qt::Key_I,                   ModAltGr,                        IsLetter, 0x0000 },
    {  23, 0x0049, Qt::Key_I,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  23, 0x0069, QCTRL(Qt::Key_I),            ModControl,                      IsLetter, 0x0000 },
    {  23, 0x0069, QCTRL(Qt::Key_I),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  23, 0x0069, QCTRL(Qt::Key_I),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  23, 0x0069, QCTRL(Qt::Key_I),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  23, 0x0069, QALT(Qt::Key_I),             ModAlt,                          IsLetter, 0x0000 },
    {  23, 0x0069, QALT(Qt::Key_I),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  23, 0x0069, QALT(Qt::Key_I),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  23, 0x0069, QALT(Qt::Key_I),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  23, 0x0069, QCTRL(QALT(Qt::Key_I)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  23, 0x0069, QCTRL(QALT(Qt::Key_I)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  23, 0x0069, QCTRL(QALT(Qt::Key_I)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  23, 0x0069, QCTRL(QALT(Qt::Key_I)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  24, 0x006f, Qt::Key_O,                   ModPlain,                        IsLetter, 0x0000 },
    {  24, 0x004f, Qt::Key_O,                   ModShift,                        IsLetter, 0x0000 },
    {  24, 0x006f, Qt::Key_O,                   ModAltGr,                        IsLetter, 0x0000 },
    {  24, 0x004f, Qt::Key_O,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  24, 0x006f, QCTRL(Qt::Key_O),            ModControl,                      IsLetter, 0x0000 },
    {  24, 0x006f, QCTRL(Qt::Key_O),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  24, 0x006f, QCTRL(Qt::Key_O),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  24, 0x006f, QCTRL(Qt::Key_O),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  24, 0x006f, QALT(Qt::Key_O),             ModAlt,                          IsLetter, 0x0000 },
    {  24, 0x006f, QALT(Qt::Key_O),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  24, 0x006f, QALT(Qt::Key_O),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  24, 0x006f, QALT(Qt::Key_O),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  24, 0x006f, QCTRL(QALT(Qt::Key_O)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  24, 0x006f, QCTRL(QALT(Qt::Key_O)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  24, 0x006f, QCTRL(QALT(Qt::Key_O)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  24, 0x006f, QCTRL(QALT(Qt::Key_O)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  25, 0x0070, Qt::Key_P,                   ModPlain,                        IsLetter, 0x0000 },
    {  25, 0x0050, Qt::Key_P,                   ModShift,                        IsLetter, 0x0000 },
    {  25, 0x0070, Qt::Key_P,                   ModAltGr,                        IsLetter, 0x0000 },
    {  25, 0x0050, Qt::Key_P,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  25, 0x0070, QCTRL(Qt::Key_P),            ModControl,                      IsLetter, 0x0000 },
    {  25, 0x0070, QCTRL(Qt::Key_P),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  25, 0x0070, QCTRL(Qt::Key_P),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  25, 0x0070, QCTRL(Qt::Key_P),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  25, 0x0070, QALT(Qt::Key_P),             ModAlt,                          IsLetter, 0x0000 },
    {  25, 0x0070, QALT(Qt::Key_P),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  25, 0x0070, QALT(Qt::Key_P),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  25, 0x0070, QALT(Qt::Key_P),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  25, 0x0070, QCTRL(QALT(Qt::Key_P)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  25, 0x0070, QCTRL(QALT(Qt::Key_P)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  25, 0x0070, QCTRL(QALT(Qt::Key_P)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  25, 0x0070, QCTRL(QALT(Qt::Key_P)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  26, 0x005b, Qt::Key_BracketLeft,         ModPlain,                        NoFlags, 0x0000 },
    {  26, 0x007b, Qt::Key_BraceLeft,           ModShift,                        NoFlags, 0x0000 },
    {  26, 0xffff, Qt::Key_Escape,              ModControl,                      NoFlags, 0x0000 },
    {  27, 0x005d, Qt::Key_BracketRight,        ModPlain,                        NoFlags, 0x0000 },
    {  27, 0x007d, Qt::Key_BraceRight,          ModShift,                        NoFlags, 0x0000 },
    {  27, 0x007e, Qt::Key_AsciiTilde,          ModAltGr,                        NoFlags, 0x0000 },
    {  27, 0x005d, QCTRL(Qt::Key_BracketRight), ModControl,                      NoFlags, 0x0000 },
    {  28, 0xffff, Qt::Key_Return,              ModPlain,                        NoFlags, 0x0000 },
    {  28, 0x006d, QCTRL(QALT(Qt::Key_M)),      ModAlt,                          NoFlags, 0x0000 },
    {  29, 0xffff, Qt::Key_Control,             ModPlain,                        IsModifier, ModControl },
    {  30, 0x0061, Qt::Key_A,                   ModPlain,                        IsLetter, 0x0000 },
    {  30, 0x0041, Qt::Key_A,                   ModShift,                        IsLetter, 0x0000 },
    {  30, 0x0061, Qt::Key_A,                   ModAltGr,                        IsLetter, 0x0000 },
    {  30, 0x0041, Qt::Key_A,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  30, 0x0061, QCTRL(Qt::Key_A),            ModControl,                      IsLetter, 0x0000 },
    {  30, 0x0061, QCTRL(Qt::Key_A),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  30, 0x0061, QCTRL(Qt::Key_A),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  30, 0x0061, QCTRL(Qt::Key_A),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  30, 0x0061, QALT(Qt::Key_A),             ModAlt,                          IsLetter, 0x0000 },
    {  30, 0x0061, QALT(Qt::Key_A),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  30, 0x0061, QALT(Qt::Key_A),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  30, 0x0061, QALT(Qt::Key_A),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  30, 0x0061, QCTRL(QALT(Qt::Key_A)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  30, 0x0061, QCTRL(QALT(Qt::Key_A)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  30, 0x0061, QCTRL(QALT(Qt::Key_A)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  30, 0x0061, QCTRL(QALT(Qt::Key_A)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  31, 0x0073, Qt::Key_S,                   ModPlain,                        IsLetter, 0x0000 },
    {  31, 0x0053, Qt::Key_S,                   ModShift,                        IsLetter, 0x0000 },
    {  31, 0x0073, Qt::Key_S,                   ModAltGr,                        IsLetter, 0x0000 },
    {  31, 0x0053, Qt::Key_S,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  31, 0x0073, QCTRL(Qt::Key_S),            ModControl,                      IsLetter, 0x0000 },
    {  31, 0x0073, QCTRL(Qt::Key_S),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  31, 0x0073, QCTRL(Qt::Key_S),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  31, 0x0073, QCTRL(Qt::Key_S),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  31, 0x0073, QALT(Qt::Key_S),             ModAlt,                          IsLetter, 0x0000 },
    {  31, 0x0073, QALT(Qt::Key_S),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  31, 0x0073, QALT(Qt::Key_S),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  31, 0x0073, QALT(Qt::Key_S),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  31, 0x0073, QCTRL(QALT(Qt::Key_S)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  31, 0x0073, QCTRL(QALT(Qt::Key_S)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  31, 0x0073, QCTRL(QALT(Qt::Key_S)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  31, 0x0073, QCTRL(QALT(Qt::Key_S)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  32, 0x0064, Qt::Key_D,                   ModPlain,                        IsLetter, 0x0000 },
    {  32, 0x0044, Qt::Key_D,                   ModShift,                        IsLetter, 0x0000 },
    {  32, 0x0064, Qt::Key_D,                   ModAltGr,                        IsLetter, 0x0000 },
    {  32, 0x0044, Qt::Key_D,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  32, 0x0064, QCTRL(Qt::Key_D),            ModControl,                      IsLetter, 0x0000 },
    {  32, 0x0064, QCTRL(Qt::Key_D),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  32, 0x0064, QCTRL(Qt::Key_D),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  32, 0x0064, QCTRL(Qt::Key_D),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  32, 0x0064, QALT(Qt::Key_D),             ModAlt,                          IsLetter, 0x0000 },
    {  32, 0x0064, QALT(Qt::Key_D),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  32, 0x0064, QALT(Qt::Key_D),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  32, 0x0064, QALT(Qt::Key_D),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  32, 0x0064, QCTRL(QALT(Qt::Key_D)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  32, 0x0064, QCTRL(QALT(Qt::Key_D)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  32, 0x0064, QCTRL(QALT(Qt::Key_D)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  32, 0x0064, QCTRL(QALT(Qt::Key_D)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  33, 0x0066, Qt::Key_F,                   ModPlain,                        IsLetter, 0x0000 },
    {  33, 0x0046, Qt::Key_F,                   ModShift,                        IsLetter, 0x0000 },
    {  33, 0x0066, Qt::Key_F,                   ModAltGr,                        IsLetter, 0x0000 },
    {  33, 0x0046, Qt::Key_F,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  33, 0x0066, QCTRL(Qt::Key_F),            ModControl,                      IsLetter, 0x0000 },
    {  33, 0x0066, QCTRL(Qt::Key_F),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  33, 0x0066, QCTRL(Qt::Key_F),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  33, 0x0066, QCTRL(Qt::Key_F),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  33, 0x0066, QALT(Qt::Key_F),             ModAlt,                          IsLetter, 0x0000 },
    {  33, 0x0066, QALT(Qt::Key_F),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  33, 0x0066, QALT(Qt::Key_F),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  33, 0x0066, QALT(Qt::Key_F),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  33, 0x0066, QCTRL(QALT(Qt::Key_F)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  33, 0x0066, QCTRL(QALT(Qt::Key_F)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  33, 0x0066, QCTRL(QALT(Qt::Key_F)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  33, 0x0066, QCTRL(QALT(Qt::Key_F)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  34, 0x0067, Qt::Key_G,                   ModPlain,                        IsLetter, 0x0000 },
    {  34, 0x0047, Qt::Key_G,                   ModShift,                        IsLetter, 0x0000 },
    {  34, 0x0067, Qt::Key_G,                   ModAltGr,                        IsLetter, 0x0000 },
    {  34, 0x0047, Qt::Key_G,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  34, 0x0067, QCTRL(Qt::Key_G),            ModControl,                      IsLetter, 0x0000 },
    {  34, 0x0067, QCTRL(Qt::Key_G),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  34, 0x0067, QCTRL(Qt::Key_G),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  34, 0x0067, QCTRL(Qt::Key_G),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  34, 0x0067, QALT(Qt::Key_G),             ModAlt,                          IsLetter, 0x0000 },
    {  34, 0x0067, QALT(Qt::Key_G),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  34, 0x0067, QALT(Qt::Key_G),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  34, 0x0067, QALT(Qt::Key_G),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  34, 0x0067, QCTRL(QALT(Qt::Key_G)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  34, 0x0067, QCTRL(QALT(Qt::Key_G)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  34, 0x0067, QCTRL(QALT(Qt::Key_G)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  34, 0x0067, QCTRL(QALT(Qt::Key_G)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  35, 0x0068, Qt::Key_H,                   ModPlain,                        IsLetter, 0x0000 },
    {  35, 0x0048, Qt::Key_H,                   ModShift,                        IsLetter, 0x0000 },
    {  35, 0x0068, Qt::Key_H,                   ModAltGr,                        IsLetter, 0x0000 },
    {  35, 0x0048, Qt::Key_H,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  35, 0x0068, QCTRL(Qt::Key_H),            ModControl,                      IsLetter, 0x0000 },
    {  35, 0x0068, QCTRL(Qt::Key_H),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  35, 0x0068, QCTRL(Qt::Key_H),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  35, 0x0068, QCTRL(Qt::Key_H),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  35, 0x0068, QALT(Qt::Key_H),             ModAlt,                          IsLetter, 0x0000 },
    {  35, 0x0068, QALT(Qt::Key_H),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  35, 0x0068, QALT(Qt::Key_H),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  35, 0x0068, QALT(Qt::Key_H),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  35, 0x0068, QCTRL(QALT(Qt::Key_H)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  35, 0x0068, QCTRL(QALT(Qt::Key_H)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  35, 0x0068, QCTRL(QALT(Qt::Key_H)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  35, 0x0068, QCTRL(QALT(Qt::Key_H)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  36, 0x006a, Qt::Key_J,                   ModPlain,                        IsLetter, 0x0000 },
    {  36, 0x004a, Qt::Key_J,                   ModShift,                        IsLetter, 0x0000 },
    {  36, 0x006a, Qt::Key_J,                   ModAltGr,                        IsLetter, 0x0000 },
    {  36, 0x004a, Qt::Key_J,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  36, 0x006a, QCTRL(Qt::Key_J),            ModControl,                      IsLetter, 0x0000 },
    {  36, 0x006a, QCTRL(Qt::Key_J),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  36, 0x006a, QCTRL(Qt::Key_J),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  36, 0x006a, QCTRL(Qt::Key_J),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  36, 0x006a, QALT(Qt::Key_J),             ModAlt,                          IsLetter, 0x0000 },
    {  36, 0x006a, QALT(Qt::Key_J),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  36, 0x006a, QALT(Qt::Key_J),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  36, 0x006a, QALT(Qt::Key_J),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  36, 0x006a, QCTRL(QALT(Qt::Key_J)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  36, 0x006a, QCTRL(QALT(Qt::Key_J)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  36, 0x006a, QCTRL(QALT(Qt::Key_J)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  36, 0x006a, QCTRL(QALT(Qt::Key_J)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  37, 0x006b, Qt::Key_K,                   ModPlain,                        IsLetter, 0x0000 },
    {  37, 0x004b, Qt::Key_K,                   ModShift,                        IsLetter, 0x0000 },
    {  37, 0x006b, Qt::Key_K,                   ModAltGr,                        IsLetter, 0x0000 },
    {  37, 0x004b, Qt::Key_K,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  37, 0x006b, QCTRL(Qt::Key_K),            ModControl,                      IsLetter, 0x0000 },
    {  37, 0x006b, QCTRL(Qt::Key_K),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  37, 0x006b, QCTRL(Qt::Key_K),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  37, 0x006b, QCTRL(Qt::Key_K),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  37, 0x006b, QALT(Qt::Key_K),             ModAlt,                          IsLetter, 0x0000 },
    {  37, 0x006b, QALT(Qt::Key_K),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  37, 0x006b, QALT(Qt::Key_K),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  37, 0x006b, QALT(Qt::Key_K),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  37, 0x006b, QCTRL(QALT(Qt::Key_K)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  37, 0x006b, QCTRL(QALT(Qt::Key_K)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  37, 0x006b, QCTRL(QALT(Qt::Key_K)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  37, 0x006b, QCTRL(QALT(Qt::Key_K)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  38, 0x006c, Qt::Key_L,                   ModPlain,                        IsLetter, 0x0000 },
    {  38, 0x004c, Qt::Key_L,                   ModShift,                        IsLetter, 0x0000 },
    {  38, 0x006c, Qt::Key_L,                   ModAltGr,                        IsLetter, 0x0000 },
    {  38, 0x004c, Qt::Key_L,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  38, 0x006c, QCTRL(Qt::Key_L),            ModControl,                      IsLetter, 0x0000 },
    {  38, 0x006c, QCTRL(Qt::Key_L),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  38, 0x006c, QCTRL(Qt::Key_L),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  38, 0x006c, QCTRL(Qt::Key_L),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  38, 0x006c, QALT(Qt::Key_L),             ModAlt,                          IsLetter, 0x0000 },
    {  38, 0x006c, QALT(Qt::Key_L),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  38, 0x006c, QALT(Qt::Key_L),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  38, 0x006c, QALT(Qt::Key_L),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  38, 0x006c, QCTRL(QALT(Qt::Key_L)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  38, 0x006c, QCTRL(QALT(Qt::Key_L)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  38, 0x006c, QCTRL(QALT(Qt::Key_L)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  38, 0x006c, QCTRL(QALT(Qt::Key_L)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  39, 0x003b, Qt::Key_Semicolon,           ModPlain,                        NoFlags, 0x0000 },
    {  39, 0x003a, Qt::Key_Colon,               ModShift,                        NoFlags, 0x0000 },
    {  40, 0x0027, Qt::Key_Apostrophe,          ModPlain,                        NoFlags, 0x0000 },
    {  40, 0x0022, Qt::Key_QuoteDbl,            ModShift,                        NoFlags, 0x0000 },
    {  40, 0x0067, QCTRL(Qt::Key_G),            ModControl,                      NoFlags, 0x0000 },
    {  41, 0x0060, Qt::Key_QuoteLeft,           ModPlain,                        NoFlags, 0x0000 },
    {  41, 0x007e, Qt::Key_AsciiTilde,          ModShift,                        NoFlags, 0x0000 },
    {  42, 0xffff, Qt::Key_Shift,               ModPlain,                        IsModifier, ModShift },
    {  43, 0x005c, Qt::Key_Backslash,           ModPlain,                        NoFlags, 0x0000 },
    {  43, 0x007c, Qt::Key_Bar,                 ModShift,                        NoFlags, 0x0000 },
    {  43, 0x005c, QCTRL(Qt::Key_Backslash),    ModControl,                      NoFlags, 0x0000 },
    {  44, 0x007a, Qt::Key_Z,                   ModPlain,                        IsLetter, 0x0000 },
    {  44, 0x005a, Qt::Key_Z,                   ModShift,                        IsLetter, 0x0000 },
    {  44, 0x007a, Qt::Key_Z,                   ModAltGr,                        IsLetter, 0x0000 },
    {  44, 0x005a, Qt::Key_Z,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  44, 0x007a, QCTRL(Qt::Key_Z),            ModControl,                      IsLetter, 0x0000 },
    {  44, 0x007a, QCTRL(Qt::Key_Z),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  44, 0x007a, QCTRL(Qt::Key_Z),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  44, 0x007a, QCTRL(Qt::Key_Z),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  44, 0x007a, QALT(Qt::Key_Z),             ModAlt,                          IsLetter, 0x0000 },
    {  44, 0x007a, QALT(Qt::Key_Z),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  44, 0x007a, QALT(Qt::Key_Z),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  44, 0x007a, QALT(Qt::Key_Z),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  44, 0x007a, QCTRL(QALT(Qt::Key_Z)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  44, 0x007a, QCTRL(QALT(Qt::Key_Z)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  44, 0x007a, QCTRL(QALT(Qt::Key_Z)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  44, 0x007a, QCTRL(QALT(Qt::Key_Z)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  45, 0x0078, Qt::Key_X,                   ModPlain,                        IsLetter, 0x0000 },
    {  45, 0x0058, Qt::Key_X,                   ModShift,                        IsLetter, 0x0000 },
    {  45, 0x0078, Qt::Key_X,                   ModAltGr,                        IsLetter, 0x0000 },
    {  45, 0x0058, Qt::Key_X,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  45, 0x0078, QCTRL(Qt::Key_X),            ModControl,                      IsLetter, 0x0000 },
    {  45, 0x0078, QCTRL(Qt::Key_X),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  45, 0x0078, QCTRL(Qt::Key_X),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  45, 0x0078, QCTRL(Qt::Key_X),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  45, 0x0078, QALT(Qt::Key_X),             ModAlt,                          IsLetter, 0x0000 },
    {  45, 0x0078, QALT(Qt::Key_X),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  45, 0x0078, QALT(Qt::Key_X),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  45, 0x0078, QALT(Qt::Key_X),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  45, 0x0078, QCTRL(QALT(Qt::Key_X)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  45, 0x0078, QCTRL(QALT(Qt::Key_X)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  45, 0x0078, QCTRL(QALT(Qt::Key_X)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  45, 0x0078, QCTRL(QALT(Qt::Key_X)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  46, 0x0063, Qt::Key_C,                   ModPlain,                        IsLetter, 0x0000 },
    {  46, 0x0043, Qt::Key_C,                   ModShift,                        IsLetter, 0x0000 },
    {  46, 0x0063, Qt::Key_C,                   ModAltGr,                        IsLetter, 0x0000 },
    {  46, 0x0043, Qt::Key_C,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  46, 0x0063, QCTRL(Qt::Key_C),            ModControl,                      IsLetter, 0x0000 },
    {  46, 0x0063, QCTRL(Qt::Key_C),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  46, 0x0063, QCTRL(Qt::Key_C),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  46, 0x0063, QCTRL(Qt::Key_C),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  46, 0x0063, QALT(Qt::Key_C),             ModAlt,                          IsLetter, 0x0000 },
    {  46, 0x0063, QALT(Qt::Key_C),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  46, 0x0063, QALT(Qt::Key_C),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  46, 0x0063, QALT(Qt::Key_C),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  46, 0x0063, QCTRL(QALT(Qt::Key_C)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  46, 0x0063, QCTRL(QALT(Qt::Key_C)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  46, 0x0063, QCTRL(QALT(Qt::Key_C)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  46, 0x0063, QCTRL(QALT(Qt::Key_C)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  47, 0x0076, Qt::Key_V,                   ModPlain,                        IsLetter, 0x0000 },
    {  47, 0x0056, Qt::Key_V,                   ModShift,                        IsLetter, 0x0000 },
    {  47, 0x0076, Qt::Key_V,                   ModAltGr,                        IsLetter, 0x0000 },
    {  47, 0x0056, Qt::Key_V,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  47, 0x0076, QCTRL(Qt::Key_V),            ModControl,                      IsLetter, 0x0000 },
    {  47, 0x0076, QCTRL(Qt::Key_V),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  47, 0x0076, QCTRL(Qt::Key_V),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  47, 0x0076, QCTRL(Qt::Key_V),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  47, 0x0076, QALT(Qt::Key_V),             ModAlt,                          IsLetter, 0x0000 },
    {  47, 0x0076, QALT(Qt::Key_V),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  47, 0x0076, QALT(Qt::Key_V),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  47, 0x0076, QALT(Qt::Key_V),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  47, 0x0076, QCTRL(QALT(Qt::Key_V)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  47, 0x0076, QCTRL(QALT(Qt::Key_V)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  47, 0x0076, QCTRL(QALT(Qt::Key_V)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  47, 0x0076, QCTRL(QALT(Qt::Key_V)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  48, 0x0062, Qt::Key_B,                   ModPlain,                        IsLetter, 0x0000 },
    {  48, 0x0042, Qt::Key_B,                   ModShift,                        IsLetter, 0x0000 },
    {  48, 0x0062, Qt::Key_B,                   ModAltGr,                        IsLetter, 0x0000 },
    {  48, 0x0042, Qt::Key_B,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  48, 0x0062, QCTRL(Qt::Key_B),            ModControl,                      IsLetter, 0x0000 },
    {  48, 0x0062, QCTRL(Qt::Key_B),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  48, 0x0062, QCTRL(Qt::Key_B),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  48, 0x0062, QCTRL(Qt::Key_B),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  48, 0x0062, QALT(Qt::Key_B),             ModAlt,                          IsLetter, 0x0000 },
    {  48, 0x0062, QALT(Qt::Key_B),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  48, 0x0062, QALT(Qt::Key_B),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  48, 0x0062, QALT(Qt::Key_B),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  48, 0x0062, QCTRL(QALT(Qt::Key_B)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  48, 0x0062, QCTRL(QALT(Qt::Key_B)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  48, 0x0062, QCTRL(QALT(Qt::Key_B)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  48, 0x0062, QCTRL(QALT(Qt::Key_B)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  49, 0x006e, Qt::Key_N,                   ModPlain,                        IsLetter, 0x0000 },
    {  49, 0x004e, Qt::Key_N,                   ModShift,                        IsLetter, 0x0000 },
    {  49, 0x006e, Qt::Key_N,                   ModAltGr,                        IsLetter, 0x0000 },
    {  49, 0x004e, Qt::Key_N,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  49, 0x006e, QCTRL(Qt::Key_N),            ModControl,                      IsLetter, 0x0000 },
    {  49, 0x006e, QCTRL(Qt::Key_N),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  49, 0x006e, QCTRL(Qt::Key_N),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  49, 0x006e, QCTRL(Qt::Key_N),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  49, 0x006e, QALT(Qt::Key_N),             ModAlt,                          IsLetter, 0x0000 },
    {  49, 0x006e, QALT(Qt::Key_N),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  49, 0x006e, QALT(Qt::Key_N),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  49, 0x006e, QALT(Qt::Key_N),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  49, 0x006e, QCTRL(QALT(Qt::Key_N)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  49, 0x006e, QCTRL(QALT(Qt::Key_N)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  49, 0x006e, QCTRL(QALT(Qt::Key_N)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  49, 0x006e, QCTRL(QALT(Qt::Key_N)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  50, 0x006d, Qt::Key_M,                   ModPlain,                        IsLetter, 0x0000 },
    {  50, 0x004d, Qt::Key_M,                   ModShift,                        IsLetter, 0x0000 },
    {  50, 0x006d, Qt::Key_M,                   ModAltGr,                        IsLetter, 0x0000 },
    {  50, 0x004d, Qt::Key_M,                   ModShift | ModAltGr,             IsLetter, 0x0000 },
    {  50, 0x006d, QCTRL(Qt::Key_M),            ModControl,                      IsLetter, 0x0000 },
    {  50, 0x006d, QCTRL(Qt::Key_M),            ModShift | ModControl,           IsLetter, 0x0000 },
    {  50, 0x006d, QCTRL(Qt::Key_M),            ModAltGr | ModControl,           IsLetter, 0x0000 },
    {  50, 0x006d, QCTRL(Qt::Key_M),            ModShift | ModAltGr | ModControl, IsLetter, 0x0000 },
    {  50, 0x006d, QALT(Qt::Key_M),             ModAlt,                          IsLetter, 0x0000 },
    {  50, 0x006d, QALT(Qt::Key_M),             ModShift | ModAlt,               IsLetter, 0x0000 },
    {  50, 0x006d, QALT(Qt::Key_M),             ModAltGr | ModAlt,               IsLetter, 0x0000 },
    {  50, 0x006d, QALT(Qt::Key_M),             ModShift | ModAltGr | ModAlt,    IsLetter, 0x0000 },
    {  50, 0x006d, QCTRL(QALT(Qt::Key_M)),      ModControl | ModAlt,             IsLetter, 0x0000 },
    {  50, 0x006d, QCTRL(QALT(Qt::Key_M)),      ModShift | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  50, 0x006d, QCTRL(QALT(Qt::Key_M)),      ModAltGr | ModControl | ModAlt,  IsLetter, 0x0000 },
    {  50, 0x006d, QCTRL(QALT(Qt::Key_M)),      ModShift | ModAltGr | ModControl | ModAlt, IsLetter, 0x0000 },
    {  51, 0x002c, Qt::Key_Comma,               ModPlain,                        NoFlags, 0x0000 },
    {  51, 0x003c, Qt::Key_Less,                ModShift,                        NoFlags, 0x0000 },
    {  52, 0x002e, Qt::Key_Period,              ModPlain,                        NoFlags, 0x0000 },
    {  52, 0x003e, Qt::Key_Greater,             ModShift,                        NoFlags, 0x0000 },
    {  52, 0xffff, Qt::Key_Multi_key,           ModAltGr,                        NoFlags, 0x0000 },
    {  53, 0x002f, Qt::Key_Slash,               ModPlain,                        NoFlags, 0x0000 },
    {  53, 0x003f, Qt::Key_Question,            ModShift,                        NoFlags, 0x0000 },
    {  53, 0xffff, Qt::Key_Backspace,           ModControl,                      NoFlags, 0x0000 },
    {  54, 0xffff, Qt::Key_Shift,               ModPlain,                        IsModifier, ModShift },
    {  55, 0x002a, QKEYPAD(Qt::Key_Asterisk),   ModPlain,                        NoFlags, 0x0000 },
    {  56, 0xffff, Qt::Key_Alt,                 ModPlain,                        IsModifier, ModAlt },
    {  57, 0x0020, Qt::Key_Space,               ModPlain,                        NoFlags, 0x0000 },
    {  58, 0xffff, Qt::Key_CapsLock,            ModPlain,                        NoFlags, 0x0000 },
    {  59, 0xffff, Qt::Key_F1,                  ModPlain,                        NoFlags, 0x0000 },
    {  59, 0xffff, Qt::Key_F13,                 ModShift,                        NoFlags, 0x0000 },
    {  59, 0xffff, Qt::Key_F25,                 ModControl,                      NoFlags, 0x0000 },
    {  60, 0xffff, Qt::Key_F2,                  ModPlain,                        NoFlags, 0x0000 },
    {  60, 0xffff, Qt::Key_F14,                 ModShift,                        NoFlags, 0x0000 },
    {  60, 0xffff, Qt::Key_F26,                 ModControl,                      NoFlags, 0x0000 },
    {  61, 0xffff, Qt::Key_F3,                  ModPlain,                        NoFlags, 0x0000 },
    {  61, 0xffff, Qt::Key_F15,                 ModShift,                        NoFlags, 0x0000 },
    {  61, 0xffff, Qt::Key_F27,                 ModControl,                      NoFlags, 0x0000 },
    {  62, 0xffff, Qt::Key_F4,                  ModPlain,                        NoFlags, 0x0000 },
    {  62, 0xffff, Qt::Key_F16,                 ModShift,                        NoFlags, 0x0000 },
    {  62, 0xffff, Qt::Key_F28,                 ModControl,                      NoFlags, 0x0000 },
    {  63, 0xffff, Qt::Key_F5,                  ModPlain,                        NoFlags, 0x0000 },
    {  63, 0xffff, Qt::Key_F17,                 ModShift,                        NoFlags, 0x0000 },
    {  63, 0xffff, Qt::Key_F29,                 ModControl,                      NoFlags, 0x0000 },
    {  64, 0xffff, Qt::Key_F6,                  ModPlain,                        NoFlags, 0x0000 },
    {  64, 0xffff, Qt::Key_F18,                 ModShift,                        NoFlags, 0x0000 },
    {  64, 0xffff, Qt::Key_F30,                 ModControl,                      NoFlags, 0x0000 },
    {  65, 0xffff, Qt::Key_F7,                  ModPlain,                        NoFlags, 0x0000 },
    {  65, 0xffff, Qt::Key_F19,                 ModShift,                        NoFlags, 0x0000 },
    {  65, 0xffff, Qt::Key_F31,                 ModControl,                      NoFlags, 0x0000 },
    {  66, 0xffff, Qt::Key_F8,                  ModPlain,                        NoFlags, 0x0000 },
    {  66, 0xffff, Qt::Key_F20,                 ModShift,                        NoFlags, 0x0000 },
    {  66, 0xffff, Qt::Key_F32,                 ModControl,                      NoFlags, 0x0000 },
    {  67, 0xffff, Qt::Key_F9,                  ModPlain,                        NoFlags, 0x0000 },
    {  67, 0xffff, Qt::Key_F21,                 ModShift,                        NoFlags, 0x0000 },
    {  67, 0xffff, Qt::Key_F33,                 ModControl,                      NoFlags, 0x0000 },
    {  68, 0xffff, Qt::Key_F10,                 ModPlain,                        NoFlags, 0x0000 },
    {  68, 0xffff, Qt::Key_F22,                 ModShift,                        NoFlags, 0x0000 },
    {  68, 0xffff, Qt::Key_F34,                 ModControl,                      NoFlags, 0x0000 },
    {  69, 0xffff, Qt::Key_NumLock,             ModPlain,                        NoFlags, 0x0000 },
    {  70, 0xffff, Qt::Key_ScrollLock,          ModPlain,                        NoFlags, 0x0000 },
    {  70, 0xffff, Qt::Key_ScrollLock,          ModAlt,                          NoFlags, 0x0000 },
    {  71, 0x0037, QKEYPAD(Qt::Key_7),          ModPlain,                        NoFlags, 0x0000 },
    {  72, 0x0038, QKEYPAD(Qt::Key_8),          ModPlain,                        NoFlags, 0x0000 },
    {  73, 0x0039, QKEYPAD(Qt::Key_9),          ModPlain,                        NoFlags, 0x0000 },
    {  74, 0x002d, QKEYPAD(Qt::Key_Minus),      ModPlain,                        NoFlags, 0x0000 },
    {  75, 0x0034, QKEYPAD(Qt::Key_4),          ModPlain,                        NoFlags, 0x0000 },
    {  76, 0x0035, QKEYPAD(Qt::Key_5),          ModPlain,                        NoFlags, 0x0000 },
    {  77, 0x0036, QKEYPAD(Qt::Key_6),          ModPlain,                        NoFlags, 0x0000 },
    {  78, 0x002b, QKEYPAD(Qt::Key_Plus),       ModPlain,                        NoFlags, 0x0000 },
    {  79, 0x0031, QKEYPAD(Qt::Key_1),          ModPlain,                        NoFlags, 0x0000 },
    {  80, 0x0032, QKEYPAD(Qt::Key_2),          ModPlain,                        NoFlags, 0x0000 },
    {  81, 0x0033, QKEYPAD(Qt::Key_3),          ModPlain,                        NoFlags, 0x0000 },
    {  82, 0x0030, QKEYPAD(Qt::Key_0),          ModPlain,                        NoFlags, 0x0000 },
    {  83, 0x002e, QKEYPAD(Qt::Key_Period),     ModPlain,                        NoFlags, 0x0000 },
    {  86, 0x003c, Qt::Key_Less,                ModPlain,                        NoFlags, 0x0000 },
    {  86, 0x003e, Qt::Key_Greater,             ModShift,                        NoFlags, 0x0000 },
    {  86, 0x007c, Qt::Key_Bar,                 ModAltGr,                        NoFlags, 0x0000 },
    {  87, 0xffff, Qt::Key_F11,                 ModPlain,                        NoFlags, 0x0000 },
    {  87, 0xffff, Qt::Key_F23,                 ModShift,                        NoFlags, 0x0000 },
    {  87, 0xffff, Qt::Key_F35,                 ModControl,                      NoFlags, 0x0000 },
    {  88, 0xffff, Qt::Key_F12,                 ModPlain,                        NoFlags, 0x0000 },
    {  88, 0xffff, Qt::Key_F24,                 ModShift,                        NoFlags, 0x0000 },
    {  89, 0xffff, QKEYPAD(Qt::Key_Enter),      ModPlain,                        NoFlags, 0x0000 },
    {  90, 0xffff, Qt::Key_Control,             ModPlain,                        IsModifier, ModControl },
    {  91, 0x002f, QKEYPAD(Qt::Key_Slash),      ModPlain,                        NoFlags, 0x0000 },
    {  92, 0x005c, QCTRL(Qt::Key_Backslash),    ModPlain,                        NoFlags, 0x0000 },
    {  93, 0xffff, Qt::Key_AltGr,               ModPlain,                        IsModifier, ModAltGr },
    {  94, 0xffff, Qt::Key_Home,                ModPlain,                        NoFlags, 0x0000 },
    {  95, 0xffff, Qt::Key_Up,                  ModPlain,                        NoFlags, 0x0000 },
    {  96, 0xffff, Qt::Key_PageUp,              ModPlain,                        NoFlags, 0x0000 },
    {  97, 0xffff, Qt::Key_Left,                ModPlain,                        NoFlags, 0x0000 },
    {  98, 0xffff, Qt::Key_Right,               ModPlain,                        NoFlags, 0x0000 },
    {  99, 0xffff, Qt::Key_End,                 ModPlain,                        NoFlags, 0x0000 },
    { 100, 0xffff, Qt::Key_Down,                ModPlain,                        NoFlags, 0x0000 },
    { 101, 0xffff, Qt::Key_PageDown,            ModPlain,                        NoFlags, 0x0000 },
    { 102, 0xffff, Qt::Key_Insert,              ModPlain,                        NoFlags, 0x0000 },
    { 103, 0xffff, Qt::Key_Delete,              ModPlain,                        NoFlags, 0x0000 },
};

#endif // QBSDKEYBOARD_DEFAULTMAP_P_H
