#!/bin/sh

set -e
export XDG_CACHE_HOME="${AUTOPKGTEST_TMP}"
export XDG_DATA_HOME="${AUTOPKGTEST_TMP}"
export XDG_CONFIG_HOME="${AUTOPKGTEST_TMP}"
export TMPDIR="${AUTOPKGTEST_TMP}"

cp -r libqtile test ${AUTOPKGTEST_TMP}
cd ${AUTOPKGTEST_TMP}

if python3 -c "import libcst" 2>/dev/null; then
	echo "libcst is available, running all tests including migrations"
        for p in $(py3versions -s); do
           PYTHONPATH=. $p -m pytest test/ -k 'not test_hook and not test_bar'
        done
else
       echo "libcst is not available, skipping migration tests"
       for p in $(py3versions -s); do
               PYTHONPATH=. $p -m pytest test/ --ignore=test/migrate/ -k 'not test_hook and not test_bar'
       done
fi

