// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQRSHL_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SQRSHL_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_sqrshl_4S[] = {
  0x00007e00, 0x00007f00, 0x007ffd00, 0x00000000,
  0x00007e00, 0x00007f00, 0x007ffd00, 0x00000000,
  0x00007e00, 0x00007f00, 0x00fffa00, 0x00000000,
  0x00007e00, 0x0000fe00, 0x01fff400, 0x00000000,
  0x0000fc00, 0x0001fc00, 0x7fffffff, 0x00000000,
  0x0001f800, 0x7fffffff, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x7fffffff, 0x000fffa0, 0x00000000,
  0x7fffffff, 0x00000fe0, 0x001fff40, 0x00000000,
  0x00000fc0, 0x00001fc0, 0x003ffe80, 0x00000000,
  0x00001f80, 0x00003f80, 0x7fffffff, 0x00000000,
  0x00003f00, 0x7fffffff, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x7fffffff, 0x000fffa0, 0x00000000,
  0x7fffffff, 0x00000fe0, 0x001fff40, 0x00000000,
  0x00000fc0, 0x00001fc0, 0x003ffe80, 0x00000000,
  0x00001f80, 0x00003f80, 0x007ffd00, 0x00000000,
  0x00003f00, 0x00007f00, 0x00fffa00, 0x00000000,
  0x00007e00, 0x0000fe00, 0x00000000, 0x00000000,
  0x0000fc00, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x007ffd00, 0x00000000,
  0x00000000, 0x00007f00, 0x00fffa00, 0x00000000,
  0x00007e00, 0x0000fe00, 0x01fff400, 0x00000000,
  0x0000fc00, 0x0001fc00, 0x03ffe800, 0x00000000,
  0x0001f800, 0x0003f800, 0x00000000, 0x00000000,
  0x0003f000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x000fffa0, 0x00000000,
  0x00000000, 0x00000fe0, 0x001fff40, 0x00000000,
  0x00000fe0, 0x001fff40, 0x00000000, 0x00000001,
  0x00001fc0, 0x003ffe80, 0x00000000, 0x00000002,
  0x00003f80, 0x007ffd00, 0x00000000, 0x00000004,
  0x00007f00, 0x00fffa00, 0x00000000, 0x7fffffff,
  0x0000fe00, 0x01fff400, 0x00000000, 0x7fffffff,
  0x0001fc00, 0x7fffffff, 0x00000000, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x00000000, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x000fffa0, 0x00000000, 0x00000001,
  0x00000fe0, 0x001fff40, 0x00000000, 0x7fffffff,
  0x00001fc0, 0x003ffe80, 0x00000000, 0x7fffffff,
  0x00003f80, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x000fffa0, 0x00000000, 0x00000001,
  0x00000fe0, 0x001fff40, 0x00000000, 0x00000001,
  0x00001fc0, 0x003ffe80, 0x00000000, 0x00000002,
  0x00003f80, 0x007ffd00, 0x00000000, 0x00000000,
  0x00007f00, 0x00fffa00, 0x00000000, 0x00000000,
  0x0000fe00, 0x00000000, 0x00000000, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000002,
  0x00000000, 0x007ffd00, 0x00000000, 0x00000004,
  0x00007f00, 0x00fffa00, 0x00000000, 0x00000008,
  0x0000fe00, 0x01fff400, 0x00000000, 0x00000000,
  0x0001fc00, 0x03ffe800, 0x00000000, 0x00000000,
  0x0003f800, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x000fffa0, 0x00000000, 0x00000001,
  0x000fffa0, 0x00000000, 0x00000001, 0x00000002,
  0x001fff40, 0x00000000, 0x00000001, 0x00000004,
  0x003ffe80, 0x00000000, 0x00000002, 0x00000008,
  0x007ffd00, 0x00000000, 0x00000004, 0x7fffffff,
  0x00fffa00, 0x00000000, 0x7fffffff, 0x7fffffff,
  0x01fff400, 0x00000000, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x00000000, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x00000000, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0x00000001,
  0x7fffffff, 0x00000000, 0x00000000, 0x00000001,
  0x000fffa0, 0x00000000, 0x00000001, 0x7fffffff,
  0x001fff40, 0x00000000, 0x7fffffff, 0x7fffffff,
  0x003ffe80, 0x00000000, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0x00000001,
  0x7fffffff, 0x00000000, 0x00000000, 0x00000001,
  0x000fffa0, 0x00000000, 0x00000001, 0x00000002,
  0x001fff40, 0x00000000, 0x00000001, 0x00000004,
  0x003ffe80, 0x00000000, 0x00000002, 0x00000000,
  0x007ffd00, 0x00000000, 0x00000000, 0x00000000,
  0x00fffa00, 0x00000000, 0x00000000, 0x00000002,
  0x00000000, 0x00000000, 0x00000001, 0x00000004,
  0x00000000, 0x00000000, 0x00000002, 0x00000008,
  0x007ffd00, 0x00000000, 0x00000004, 0x00000010,
  0x00fffa00, 0x00000000, 0x00000008, 0x00000000,
  0x01fff400, 0x00000000, 0x00000000, 0x00000000,
  0x03ffe800, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000001,
  0x00000000, 0x00000000, 0x00000001, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000040,
  0x00000000, 0x00000001, 0x00000004, 0x00000080,
  0x00000000, 0x00000002, 0x00000008, 0x7fffffff,
  0x00000000, 0x00000004, 0x7fffffff, 0x7fffffff,
  0x00000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x00000000, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x00000000, 0x7fffffff, 0x7fffffff, 0x00000004,
  0x00000000, 0x7fffffff, 0x00000000, 0x00000008,
  0x00000000, 0x00000000, 0x00000001, 0x00000010,
  0x00000000, 0x00000000, 0x00000001, 0x7fffffff,
  0x00000000, 0x00000001, 0x7fffffff, 0x7fffffff,
  0x00000000, 0x7fffffff, 0x7fffffff, 0x00000004,
  0x00000000, 0x7fffffff, 0x00000000, 0x00000008,
  0x00000000, 0x00000000, 0x00000001, 0x00000010,
  0x00000000, 0x00000000, 0x00000001, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000040,
  0x00000000, 0x00000001, 0x00000004, 0x00000000,
  0x00000000, 0x00000002, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000020,
  0x00000000, 0x00000000, 0x00000002, 0x00000040,
  0x00000000, 0x00000001, 0x00000004, 0x00000080,
  0x00000000, 0x00000002, 0x00000008, 0x00000100,
  0x00000000, 0x00000004, 0x00000010, 0x00000000,
  0x00000000, 0x00000008, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000004,
  0x00000000, 0x00000000, 0x00000000, 0x00000008,
  0x00000000, 0x00000000, 0x00000001, 0x00000010,
  0x00000000, 0x00000001, 0x00000010, 0x0000007d,
  0x00000000, 0x00000001, 0x00000020, 0x000000fa,
  0x00000001, 0x00000002, 0x00000040, 0x000001f4,
  0x00000001, 0x00000004, 0x00000080, 0x7fffffff,
  0x00000002, 0x00000008, 0x7fffffff, 0x7fffffff,
  0x00000004, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000010,
  0x7fffffff, 0x7fffffff, 0x00000004, 0x0000001f,
  0x7fffffff, 0x00000000, 0x00000008, 0x0000003f,
  0x00000000, 0x00000001, 0x00000010, 0x7fffffff,
  0x00000000, 0x00000001, 0x7fffffff, 0x7fffffff,
  0x00000001, 0x7fffffff, 0x7fffffff, 0x00000010,
  0x7fffffff, 0x7fffffff, 0x00000004, 0x0000001f,
  0x7fffffff, 0x00000000, 0x00000008, 0x0000003f,
  0x00000000, 0x00000001, 0x00000010, 0x0000007d,
  0x00000000, 0x00000001, 0x00000020, 0x000000fa,
  0x00000001, 0x00000002, 0x00000040, 0x00000000,
  0x00000001, 0x00000004, 0x00000000, 0x00000000,
  0x00000002, 0x00000000, 0x00000000, 0x0000007d,
  0x00000000, 0x00000000, 0x00000020, 0x000000fa,
  0x00000000, 0x00000002, 0x00000040, 0x000001f4,
  0x00000001, 0x00000004, 0x00000080, 0x000003e8,
  0x00000002, 0x00000008, 0x00000100, 0x00000000,
  0x00000004, 0x00000010, 0x00000000, 0x00000000,
  0x00000008, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0x00000000, 0x00000000, 0x00000004, 0x0000001f,
  0x00000000, 0x00000000, 0x00000008, 0x0000003f,
  0x00000000, 0x00000008, 0x0000003f, 0x0000007e,
  0x00000001, 0x00000010, 0x0000007d, 0x000000fc,
  0x00000001, 0x00000020, 0x000000fa, 0x000001f8,
  0x00000002, 0x00000040, 0x000001f4, 0x7fffffff,
  0x00000004, 0x00000080, 0x7fffffff, 0x7fffffff,
  0x00000008, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000010,
  0x7fffffff, 0x7fffffff, 0x00000010, 0x00000020,
  0x7fffffff, 0x00000004, 0x0000001f, 0x0000003f,
  0x00000000, 0x00000008, 0x0000003f, 0x7fffffff,
  0x00000001, 0x00000010, 0x7fffffff, 0x7fffffff,
  0x00000001, 0x7fffffff, 0x7fffffff, 0x00000010,
  0x7fffffff, 0x7fffffff, 0x00000010, 0x00000020,
  0x7fffffff, 0x00000004, 0x0000001f, 0x0000003f,
  0x00000000, 0x00000008, 0x0000003f, 0x0000007e,
  0x00000001, 0x00000010, 0x0000007d, 0x000000fc,
  0x00000001, 0x00000020, 0x000000fa, 0x00000000,
  0x00000002, 0x00000040, 0x00000000, 0x00000000,
  0x00000004, 0x00000000, 0x00000000, 0x0000007e,
  0x00000000, 0x00000000, 0x0000007d, 0x000000fc,
  0x00000000, 0x00000020, 0x000000fa, 0x000001f8,
  0x00000002, 0x00000040, 0x000001f4, 0x000003f0,
  0x00000004, 0x00000080, 0x000003e8, 0x00000000,
  0x00000008, 0x00000100, 0x00000000, 0x00000000,
  0x00000010, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0x00000000, 0x00000000, 0x00000010, 0x00000020,
  0x00000000, 0x00000004, 0x0000001f, 0x0000003f,
  0x00000004, 0x0000001f, 0x0000003f, 0x0000007f,
  0x00000008, 0x0000003f, 0x0000007e, 0x000000fe,
  0x00000010, 0x0000007d, 0x000000fc, 0x000001fc,
  0x00000020, 0x000000fa, 0x000001f8, 0x7fffffff,
  0x00000040, 0x000001f4, 0x7fffffff, 0x7fffffff,
  0x00000080, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000010,
  0x7fffffff, 0x7fffffff, 0x00000010, 0x00000020,
  0x7fffffff, 0x00000010, 0x00000020, 0x00000040,
  0x00000004, 0x0000001f, 0x0000003f, 0x7fffffff,
  0x00000008, 0x0000003f, 0x7fffffff, 0x7fffffff,
  0x00000010, 0x7fffffff, 0x7fffffff, 0x00000010,
  0x7fffffff, 0x7fffffff, 0x00000010, 0x00000020,
  0x7fffffff, 0x00000010, 0x00000020, 0x00000040,
  0x00000004, 0x0000001f, 0x0000003f, 0x0000007f,
  0x00000008, 0x0000003f, 0x0000007e, 0x000000fe,
  0x00000010, 0x0000007d, 0x000000fc, 0x00000000,
  0x00000020, 0x000000fa, 0x00000000, 0x00000000,
  0x00000040, 0x00000000, 0x00000000, 0x0000007f,
  0x00000000, 0x00000000, 0x0000007e, 0x000000fe,
  0x00000000, 0x0000007d, 0x000000fc, 0x000001fc,
  0x00000020, 0x000000fa, 0x000001f8, 0x000003f8,
  0x00000040, 0x000001f4, 0x000003f0, 0x00000000,
  0x00000080, 0x000003e8, 0x00000000, 0x00000000,
  0x00000100, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0x00000000, 0x00000000, 0x00000010, 0x00000020,
  0x00000000, 0x00000010, 0x00000020, 0x00000040,
  0x00000010, 0x00000020, 0x00000040, 0x00007ffd,
  0x0000001f, 0x0000003f, 0x0000007f, 0x0000fffa,
  0x0000003f, 0x0000007e, 0x000000fe, 0x0001fff4,
  0x0000007d, 0x000000fc, 0x000001fc, 0x7fffffff,
  0x000000fa, 0x000001f8, 0x7fffffff, 0x7fffffff,
  0x000001f4, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00001000,
  0x7fffffff, 0x7fffffff, 0x00000010, 0x00001fff,
  0x7fffffff, 0x00000010, 0x00000020, 0x00003fff,
  0x00000010, 0x00000020, 0x00000040, 0x7fffffff,
  0x0000001f, 0x0000003f, 0x7fffffff, 0x7fffffff,
  0x0000003f, 0x7fffffff, 0x7fffffff, 0x00001000,
  0x7fffffff, 0x7fffffff, 0x00000010, 0x00001fff,
  0x7fffffff, 0x00000010, 0x00000020, 0x00003fff,
  0x00000010, 0x00000020, 0x00000040, 0x00007ffd,
  0x0000001f, 0x0000003f, 0x0000007f, 0x0000fffa,
  0x0000003f, 0x0000007e, 0x000000fe, 0x00000000,
  0x0000007d, 0x000000fc, 0x00000000, 0x00000000,
  0x000000fa, 0x00000000, 0x00000000, 0x00007ffd,
  0x00000000, 0x00000000, 0x0000007f, 0x0000fffa,
  0x00000000, 0x0000007e, 0x000000fe, 0x0001fff4,
  0x0000007d, 0x000000fc, 0x000001fc, 0x0003ffe8,
  0x000000fa, 0x000001f8, 0x000003f8, 0x00000000,
  0x000001f4, 0x000003f0, 0x00000000, 0x00000000,
  0x000003e8, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00001000,
  0x00000000, 0x00000000, 0x00000010, 0x00001fff,
  0x00000000, 0x00000010, 0x00000020, 0x00003fff,
  0x00000010, 0x00000020, 0x00003fff, 0x00007ffe,
  0x00000020, 0x00000040, 0x00007ffd, 0x0000fffc,
  0x0000003f, 0x0000007f, 0x0000fffa, 0x0001fff8,
  0x0000007e, 0x000000fe, 0x0001fff4, 0x7fffffff,
  0x000000fc, 0x000001fc, 0x7fffffff, 0x7fffffff,
  0x000001f8, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00001000,
  0x7fffffff, 0x7fffffff, 0x00001000, 0x00002000,
  0x7fffffff, 0x00000010, 0x00001fff, 0x00003fff,
  0x00000010, 0x00000020, 0x00003fff, 0x7fffffff,
  0x00000020, 0x00000040, 0x7fffffff, 0x7fffffff,
  0x0000003f, 0x7fffffff, 0x7fffffff, 0x00001000,
  0x7fffffff, 0x7fffffff, 0x00001000, 0x00002000,
  0x7fffffff, 0x00000010, 0x00001fff, 0x00003fff,
  0x00000010, 0x00000020, 0x00003fff, 0x00007ffe,
  0x00000020, 0x00000040, 0x00007ffd, 0x0000fffc,
  0x0000003f, 0x0000007f, 0x0000fffa, 0x00000000,
  0x0000007e, 0x000000fe, 0x00000000, 0x00000000,
  0x000000fc, 0x00000000, 0x00000000, 0x00007ffe,
  0x00000000, 0x00000000, 0x00007ffd, 0x0000fffc,
  0x00000000, 0x0000007f, 0x0000fffa, 0x0001fff8,
  0x0000007e, 0x000000fe, 0x0001fff4, 0x0003fff0,
  0x000000fc, 0x000001fc, 0x0003ffe8, 0x00000000,
  0x000001f8, 0x000003f8, 0x00000000, 0x00000000,
  0x000003f0, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00001000,
  0x00000000, 0x00000000, 0x00001000, 0x00002000,
  0x00000000, 0x00000010, 0x00001fff, 0x00003fff,
  0x00000010, 0x00001fff, 0x00003fff, 0x00007fff,
  0x00000020, 0x00003fff, 0x00007ffe, 0x0000fffe,
  0x00000040, 0x00007ffd, 0x0000fffc, 0x0001fffc,
  0x0000007f, 0x0000fffa, 0x0001fff8, 0x7fffffff,
  0x000000fe, 0x0001fff4, 0x7fffffff, 0x7fffffff,
  0x000001fc, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00001000,
  0x7fffffff, 0x7fffffff, 0x00001000, 0x00002000,
  0x7fffffff, 0x00001000, 0x00002000, 0x00004000,
  0x00000010, 0x00001fff, 0x00003fff, 0x7fffffff,
  0x00000020, 0x00003fff, 0x7fffffff, 0x7fffffff,
  0x00000040, 0x7fffffff, 0x7fffffff, 0x00001000,
  0x7fffffff, 0x7fffffff, 0x00001000, 0x00002000,
  0x7fffffff, 0x00001000, 0x00002000, 0x00004000,
  0x00000010, 0x00001fff, 0x00003fff, 0x00007fff,
  0x00000020, 0x00003fff, 0x00007ffe, 0x0000fffe,
  0x00000040, 0x00007ffd, 0x0000fffc, 0x00000000,
  0x0000007f, 0x0000fffa, 0x00000000, 0x00000000,
  0x000000fe, 0x00000000, 0x00000000, 0x00007fff,
  0x00000000, 0x00000000, 0x00007ffe, 0x0000fffe,
  0x00000000, 0x00007ffd, 0x0000fffc, 0x0001fffc,
  0x0000007f, 0x0000fffa, 0x0001fff8, 0x0003fff8,
  0x000000fe, 0x0001fff4, 0x0003fff0, 0x00000000,
  0x000001fc, 0x0003ffe8, 0x00000000, 0x00000000,
  0x000003f8, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00001000,
  0x00000000, 0x00000000, 0x00001000, 0x00002000,
  0x00000000, 0x00001000, 0x00002000, 0x00004000,
  0x00001000, 0x00002000, 0x00004000, 0x33333333,
  0x00001fff, 0x00003fff, 0x00007fff, 0x66666666,
  0x00003fff, 0x00007ffe, 0x0000fffe, 0x7fffffff,
  0x00007ffd, 0x0000fffc, 0x0001fffc, 0x7fffffff,
  0x0000fffa, 0x0001fff8, 0x7fffffff, 0x7fffffff,
  0x0001fff4, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x06666666,
  0x7fffffff, 0x7fffffff, 0x00001000, 0x0ccccccd,
  0x7fffffff, 0x00001000, 0x00002000, 0x1999999a,
  0x00001000, 0x00002000, 0x00004000, 0x7fffffff,
  0x00001fff, 0x00003fff, 0x7fffffff, 0x7fffffff,
  0x00003fff, 0x7fffffff, 0x7fffffff, 0x06666666,
  0x7fffffff, 0x7fffffff, 0x00001000, 0x0ccccccd,
  0x7fffffff, 0x00001000, 0x00002000, 0x1999999a,
  0x00001000, 0x00002000, 0x00004000, 0x33333333,
  0x00001fff, 0x00003fff, 0x00007fff, 0x66666666,
  0x00003fff, 0x00007ffe, 0x0000fffe, 0x00000000,
  0x00007ffd, 0x0000fffc, 0x00000000, 0x00000000,
  0x0000fffa, 0x00000000, 0x00000000, 0x33333333,
  0x00000000, 0x00000000, 0x00007fff, 0x66666666,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x7fffffff,
  0x00007ffd, 0x0000fffc, 0x0001fffc, 0x7fffffff,
  0x0000fffa, 0x0001fff8, 0x0003fff8, 0x00000000,
  0x0001fff4, 0x0003fff0, 0x00000000, 0x00000000,
  0x0003ffe8, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x06666666,
  0x00000000, 0x00000000, 0x00001000, 0x0ccccccd,
  0x00000000, 0x00001000, 0x00002000, 0x1999999a,
  0x00001000, 0x00002000, 0x1999999a, 0x55555555,
  0x00002000, 0x00004000, 0x33333333, 0x7fffffff,
  0x00003fff, 0x00007fff, 0x66666666, 0x7fffffff,
  0x00007ffe, 0x0000fffe, 0x7fffffff, 0x7fffffff,
  0x0000fffc, 0x0001fffc, 0x7fffffff, 0x7fffffff,
  0x0001fff8, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0aaaaaab,
  0x7fffffff, 0x7fffffff, 0x06666666, 0x15555555,
  0x7fffffff, 0x00001000, 0x0ccccccd, 0x2aaaaaab,
  0x00001000, 0x00002000, 0x1999999a, 0x7fffffff,
  0x00002000, 0x00004000, 0x7fffffff, 0x7fffffff,
  0x00003fff, 0x7fffffff, 0x7fffffff, 0x0aaaaaab,
  0x7fffffff, 0x7fffffff, 0x06666666, 0x15555555,
  0x7fffffff, 0x00001000, 0x0ccccccd, 0x2aaaaaab,
  0x00001000, 0x00002000, 0x1999999a, 0x55555555,
  0x00002000, 0x00004000, 0x33333333, 0x7fffffff,
  0x00003fff, 0x00007fff, 0x66666666, 0x00000000,
  0x00007ffe, 0x0000fffe, 0x00000000, 0x00000000,
  0x0000fffc, 0x00000000, 0x00000000, 0x55555555,
  0x00000000, 0x00000000, 0x33333333, 0x7fffffff,
  0x00000000, 0x00007fff, 0x66666666, 0x7fffffff,
  0x00007ffe, 0x0000fffe, 0x7fffffff, 0x7fffffff,
  0x0000fffc, 0x0001fffc, 0x7fffffff, 0x00000000,
  0x0001fff8, 0x0003fff8, 0x00000000, 0x00000000,
  0x0003fff0, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x0aaaaaab,
  0x00000000, 0x00000000, 0x06666666, 0x15555555,
  0x00000000, 0x00001000, 0x0ccccccd, 0x2aaaaaab,
  0x00001000, 0x0ccccccd, 0x2aaaaaab, 0x7ffffffd,
  0x00002000, 0x1999999a, 0x55555555, 0x7fffffff,
  0x00004000, 0x33333333, 0x7fffffff, 0x7fffffff,
  0x00007fff, 0x66666666, 0x7fffffff, 0x7fffffff,
  0x0000fffe, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x0001fffc, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x10000000,
  0x7fffffff, 0x7fffffff, 0x0aaaaaab, 0x1fffffff,
  0x7fffffff, 0x06666666, 0x15555555, 0x3fffffff,
  0x00001000, 0x0ccccccd, 0x2aaaaaab, 0x7fffffff,
  0x00002000, 0x1999999a, 0x7fffffff, 0x7fffffff,
  0x00004000, 0x7fffffff, 0x7fffffff, 0x10000000,
  0x7fffffff, 0x7fffffff, 0x0aaaaaab, 0x1fffffff,
  0x7fffffff, 0x06666666, 0x15555555, 0x3fffffff,
  0x00001000, 0x0ccccccd, 0x2aaaaaab, 0x7ffffffd,
  0x00002000, 0x1999999a, 0x55555555, 0x7fffffff,
  0x00004000, 0x33333333, 0x7fffffff, 0x00000000,
  0x00007fff, 0x66666666, 0x00000000, 0x00000000,
  0x0000fffe, 0x00000000, 0x00000000, 0x7ffffffd,
  0x00000000, 0x00000000, 0x55555555, 0x7fffffff,
  0x00000000, 0x33333333, 0x7fffffff, 0x7fffffff,
  0x00007fff, 0x66666666, 0x7fffffff, 0x7fffffff,
  0x0000fffe, 0x7fffffff, 0x7fffffff, 0x00000000,
  0x0001fffc, 0x7fffffff, 0x00000000, 0x00000000,
  0x0003fff8, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x10000000,
  0x00000000, 0x00000000, 0x0aaaaaab, 0x1fffffff,
  0x00000000, 0x06666666, 0x15555555, 0x3fffffff,
  0x06666666, 0x15555555, 0x3fffffff, 0x7ffffffe,
  0x0ccccccd, 0x2aaaaaab, 0x7ffffffd, 0x7fffffff,
  0x1999999a, 0x55555555, 0x7fffffff, 0x7fffffff,
  0x33333333, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x66666666, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x10000000,
  0x7fffffff, 0x7fffffff, 0x10000000, 0x20000000,
  0x7fffffff, 0x0aaaaaab, 0x1fffffff, 0x3fffffff,
  0x06666666, 0x15555555, 0x3fffffff, 0x7fffffff,
  0x0ccccccd, 0x2aaaaaab, 0x7fffffff, 0x7fffffff,
  0x1999999a, 0x7fffffff, 0x7fffffff, 0x10000000,
  0x7fffffff, 0x7fffffff, 0x10000000, 0x20000000,
  0x7fffffff, 0x0aaaaaab, 0x1fffffff, 0x3fffffff,
  0x06666666, 0x15555555, 0x3fffffff, 0x7ffffffe,
  0x0ccccccd, 0x2aaaaaab, 0x7ffffffd, 0x7fffffff,
  0x1999999a, 0x55555555, 0x7fffffff, 0x00000000,
  0x33333333, 0x7fffffff, 0x00000000, 0x00000000,
  0x66666666, 0x00000000, 0x00000000, 0x7ffffffe,
  0x00000000, 0x00000000, 0x7ffffffd, 0x7fffffff,
  0x00000000, 0x55555555, 0x7fffffff, 0x7fffffff,
  0x33333333, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x66666666, 0x7fffffff, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x10000000,
  0x00000000, 0x00000000, 0x10000000, 0x20000000,
  0x00000000, 0x0aaaaaab, 0x1fffffff, 0x3fffffff,
  0x0aaaaaab, 0x1fffffff, 0x3fffffff, 0x7fffffff,
  0x15555555, 0x3fffffff, 0x7ffffffe, 0x7fffffff,
  0x2aaaaaab, 0x7ffffffd, 0x7fffffff, 0x7fffffff,
  0x55555555, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x10000000,
  0x7fffffff, 0x7fffffff, 0x10000000, 0x20000000,
  0x7fffffff, 0x10000000, 0x20000000, 0x40000000,
  0x0aaaaaab, 0x1fffffff, 0x3fffffff, 0x7fffffff,
  0x15555555, 0x3fffffff, 0x7fffffff, 0x7fffffff,
  0x2aaaaaab, 0x7fffffff, 0x7fffffff, 0x10000000,
  0x7fffffff, 0x7fffffff, 0x10000000, 0x20000000,
  0x7fffffff, 0x10000000, 0x20000000, 0x40000000,
  0x0aaaaaab, 0x1fffffff, 0x3fffffff, 0x7fffffff,
  0x15555555, 0x3fffffff, 0x7ffffffe, 0x7fffffff,
  0x2aaaaaab, 0x7ffffffd, 0x7fffffff, 0x00000000,
  0x55555555, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0x7fffffff,
  0x00000000, 0x00000000, 0x7ffffffe, 0x7fffffff,
  0x00000000, 0x7ffffffd, 0x7fffffff, 0x7fffffff,
  0x55555555, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x10000000,
  0x00000000, 0x00000000, 0x10000000, 0x20000000,
  0x00000000, 0x10000000, 0x20000000, 0x40000000,
  0x10000000, 0x20000000, 0x40000000, 0x80000000,
  0x1fffffff, 0x3fffffff, 0x7fffffff, 0x80000000,
  0x3fffffff, 0x7ffffffe, 0x7fffffff, 0x80000000,
  0x7ffffffd, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0xf0000000,
  0x7fffffff, 0x7fffffff, 0x10000000, 0xe0000000,
  0x7fffffff, 0x10000000, 0x20000000, 0xc0000000,
  0x10000000, 0x20000000, 0x40000000, 0x80000000,
  0x1fffffff, 0x3fffffff, 0x7fffffff, 0x80000000,
  0x3fffffff, 0x7fffffff, 0x7fffffff, 0xf0000000,
  0x7fffffff, 0x7fffffff, 0x10000000, 0xe0000000,
  0x7fffffff, 0x10000000, 0x20000000, 0xc0000000,
  0x10000000, 0x20000000, 0x40000000, 0x80000000,
  0x1fffffff, 0x3fffffff, 0x7fffffff, 0x80000000,
  0x3fffffff, 0x7ffffffe, 0x7fffffff, 0x00000000,
  0x7ffffffd, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0x80000000,
  0x00000000, 0x00000000, 0x7fffffff, 0x80000000,
  0x00000000, 0x7ffffffe, 0x7fffffff, 0x80000000,
  0x7ffffffd, 0x7fffffff, 0x7fffffff, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xf0000000,
  0x00000000, 0x00000000, 0x10000000, 0xe0000000,
  0x00000000, 0x10000000, 0x20000000, 0xc0000000,
  0x10000000, 0x20000000, 0xc0000000, 0x80000001,
  0x20000000, 0x40000000, 0x80000000, 0x80000000,
  0x3fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7ffffffe, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0xf0000000,
  0x7fffffff, 0x7fffffff, 0xf0000000, 0xe0000000,
  0x7fffffff, 0x10000000, 0xe0000000, 0xc0000001,
  0x10000000, 0x20000000, 0xc0000000, 0x80000000,
  0x20000000, 0x40000000, 0x80000000, 0x80000000,
  0x3fffffff, 0x7fffffff, 0x80000000, 0xf0000000,
  0x7fffffff, 0x7fffffff, 0xf0000000, 0xe0000000,
  0x7fffffff, 0x10000000, 0xe0000000, 0xc0000001,
  0x10000000, 0x20000000, 0xc0000000, 0x80000001,
  0x20000000, 0x40000000, 0x80000000, 0x80000000,
  0x3fffffff, 0x7fffffff, 0x80000000, 0x00000000,
  0x7ffffffe, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0x80000001,
  0x00000000, 0x00000000, 0x80000000, 0x80000000,
  0x00000000, 0x7fffffff, 0x80000000, 0x80000000,
  0x7ffffffe, 0x7fffffff, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x80000000, 0x00000000,
  0x7fffffff, 0x7fffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xf0000000,
  0x00000000, 0x00000000, 0xf0000000, 0xe0000000,
  0x00000000, 0x10000000, 0xe0000000, 0xc0000001,
  0x10000000, 0xe0000000, 0xc0000001, 0xaaaaaaaa,
  0x20000000, 0xc0000000, 0x80000001, 0x80000000,
  0x40000000, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0xf5555555,
  0x7fffffff, 0x80000000, 0xf0000000, 0xeaaaaaab,
  0x7fffffff, 0xf0000000, 0xe0000000, 0xd5555555,
  0x10000000, 0xe0000000, 0xc0000001, 0x80000000,
  0x20000000, 0xc0000000, 0x80000000, 0x80000000,
  0x40000000, 0x80000000, 0x80000000, 0xf5555555,
  0x7fffffff, 0x80000000, 0xf0000000, 0xeaaaaaab,
  0x7fffffff, 0xf0000000, 0xe0000000, 0xd5555555,
  0x10000000, 0xe0000000, 0xc0000001, 0xaaaaaaaa,
  0x20000000, 0xc0000000, 0x80000001, 0x80000000,
  0x40000000, 0x80000000, 0x80000000, 0x00000000,
  0x7fffffff, 0x80000000, 0x00000000, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0xaaaaaaaa,
  0x00000000, 0x00000000, 0x80000001, 0x80000000,
  0x00000000, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x80000000, 0x80000000, 0x00000000,
  0x7fffffff, 0x80000000, 0x00000000, 0x00000000,
  0x7fffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xf5555555,
  0x00000000, 0x00000000, 0xf0000000, 0xeaaaaaab,
  0x00000000, 0xf0000000, 0xe0000000, 0xd5555555,
  0xf0000000, 0xe0000000, 0xd5555555, 0xcccccccc,
  0xe0000000, 0xc0000001, 0xaaaaaaaa, 0x99999998,
  0xc0000000, 0x80000001, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0xf999999a,
  0x80000000, 0x80000000, 0xf5555555, 0xf3333333,
  0x80000000, 0xf0000000, 0xeaaaaaab, 0xe6666666,
  0xf0000000, 0xe0000000, 0xd5555555, 0x80000000,
  0xe0000000, 0xc0000001, 0x80000000, 0x80000000,
  0xc0000000, 0x80000000, 0x80000000, 0xf999999a,
  0x80000000, 0x80000000, 0xf5555555, 0xf3333333,
  0x80000000, 0xf0000000, 0xeaaaaaab, 0xe6666666,
  0xf0000000, 0xe0000000, 0xd5555555, 0xcccccccc,
  0xe0000000, 0xc0000001, 0xaaaaaaaa, 0x99999998,
  0xc0000000, 0x80000001, 0x80000000, 0x00000000,
  0x80000000, 0x80000000, 0x00000000, 0x00000000,
  0x80000000, 0x00000000, 0x00000000, 0xcccccccc,
  0x00000000, 0x00000000, 0xaaaaaaaa, 0x99999998,
  0x00000000, 0x80000001, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x00000000,
  0x80000000, 0x80000000, 0x00000000, 0x00000000,
  0x80000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xf999999a,
  0x00000000, 0x00000000, 0xf5555555, 0xf3333333,
  0x00000000, 0xf0000000, 0xeaaaaaab, 0xe6666666,
  0xf0000000, 0xeaaaaaab, 0xe6666666, 0xffff8000,
  0xe0000000, 0xd5555555, 0xcccccccc, 0xffff0000,
  0xc0000001, 0xaaaaaaaa, 0x99999998, 0xfffe0000,
  0x80000001, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0xfffff000,
  0x80000000, 0x80000000, 0xf999999a, 0xffffe000,
  0x80000000, 0xf5555555, 0xf3333333, 0xffffc000,
  0xf0000000, 0xeaaaaaab, 0xe6666666, 0x80000000,
  0xe0000000, 0xd5555555, 0x80000000, 0x80000000,
  0xc0000001, 0x80000000, 0x80000000, 0xfffff000,
  0x80000000, 0x80000000, 0xf999999a, 0xffffe000,
  0x80000000, 0xf5555555, 0xf3333333, 0xffffc000,
  0xf0000000, 0xeaaaaaab, 0xe6666666, 0xffff8000,
  0xe0000000, 0xd5555555, 0xcccccccc, 0xffff0000,
  0xc0000001, 0xaaaaaaaa, 0x99999998, 0x00000000,
  0x80000001, 0x80000000, 0x00000000, 0x00000000,
  0x80000000, 0x00000000, 0x00000000, 0xffff8000,
  0x00000000, 0x00000000, 0xcccccccc, 0xffff0000,
  0x00000000, 0xaaaaaaaa, 0x99999998, 0xfffe0000,
  0x80000001, 0x80000000, 0x80000000, 0xfffc0000,
  0x80000000, 0x80000000, 0x80000000, 0x00000000,
  0x80000000, 0x80000000, 0x00000000, 0x00000000,
  0x80000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xfffff000,
  0x00000000, 0x00000000, 0xf999999a, 0xffffe000,
  0x00000000, 0xf5555555, 0xf3333333, 0xffffc000,
  0xf5555555, 0xf3333333, 0xffffc000, 0xffff8001,
  0xeaaaaaab, 0xe6666666, 0xffff8000, 0xffff0002,
  0xd5555555, 0xcccccccc, 0xffff0000, 0xfffe0004,
  0xaaaaaaaa, 0x99999998, 0xfffe0000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0xfffff000,
  0x80000000, 0x80000000, 0xfffff000, 0xffffe000,
  0x80000000, 0xf999999a, 0xffffe000, 0xffffc001,
  0xf5555555, 0xf3333333, 0xffffc000, 0x80000000,
  0xeaaaaaab, 0xe6666666, 0x80000000, 0x80000000,
  0xd5555555, 0x80000000, 0x80000000, 0xfffff000,
  0x80000000, 0x80000000, 0xfffff000, 0xffffe000,
  0x80000000, 0xf999999a, 0xffffe000, 0xffffc001,
  0xf5555555, 0xf3333333, 0xffffc000, 0xffff8001,
  0xeaaaaaab, 0xe6666666, 0xffff8000, 0xffff0002,
  0xd5555555, 0xcccccccc, 0xffff0000, 0x00000000,
  0xaaaaaaaa, 0x99999998, 0x00000000, 0x00000000,
  0x80000000, 0x00000000, 0x00000000, 0xffff8001,
  0x00000000, 0x00000000, 0xffff8000, 0xffff0002,
  0x00000000, 0xcccccccc, 0xffff0000, 0xfffe0004,
  0xaaaaaaaa, 0x99999998, 0xfffe0000, 0xfffc0008,
  0x80000000, 0x80000000, 0xfffc0000, 0x00000000,
  0x80000000, 0x80000000, 0x00000000, 0x00000000,
  0x80000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xfffff000,
  0x00000000, 0x00000000, 0xfffff000, 0xffffe000,
  0x00000000, 0xf999999a, 0xffffe000, 0xffffc001,
  0xf999999a, 0xffffe000, 0xffffc001, 0xffff8002,
  0xf3333333, 0xffffc000, 0xffff8001, 0xffff0004,
  0xe6666666, 0xffff8000, 0xffff0002, 0xfffe0008,
  0xcccccccc, 0xffff0000, 0xfffe0004, 0x80000000,
  0x99999998, 0xfffe0000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0xfffff000,
  0x80000000, 0x80000000, 0xfffff000, 0xffffe001,
  0x80000000, 0xfffff000, 0xffffe000, 0xffffc001,
  0xf999999a, 0xffffe000, 0xffffc001, 0x80000000,
  0xf3333333, 0xffffc000, 0x80000000, 0x80000000,
  0xe6666666, 0x80000000, 0x80000000, 0xfffff000,
  0x80000000, 0x80000000, 0xfffff000, 0xffffe001,
  0x80000000, 0xfffff000, 0xffffe000, 0xffffc001,
  0xf999999a, 0xffffe000, 0xffffc001, 0xffff8002,
  0xf3333333, 0xffffc000, 0xffff8001, 0xffff0004,
  0xe6666666, 0xffff8000, 0xffff0002, 0x00000000,
  0xcccccccc, 0xffff0000, 0x00000000, 0x00000000,
  0x99999998, 0x00000000, 0x00000000, 0xffff8002,
  0x00000000, 0x00000000, 0xffff8001, 0xffff0004,
  0x00000000, 0xffff8000, 0xffff0002, 0xfffe0008,
  0xcccccccc, 0xffff0000, 0xfffe0004, 0xfffc0010,
  0x99999998, 0xfffe0000, 0xfffc0008, 0x00000000,
  0x80000000, 0xfffc0000, 0x00000000, 0x00000000,
  0x80000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xfffff000,
  0x00000000, 0x00000000, 0xfffff000, 0xffffe001,
  0x00000000, 0xfffff000, 0xffffe000, 0xffffc001,
  0xfffff000, 0xffffe000, 0xffffc001, 0xffff8003,
  0xffffe000, 0xffffc001, 0xffff8002, 0xffff0006,
  0xffffc000, 0xffff8001, 0xffff0004, 0xfffe000c,
  0xffff8000, 0xffff0002, 0xfffe0008, 0x80000000,
  0xffff0000, 0xfffe0004, 0x80000000, 0x80000000,
  0xfffe0000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0xfffff000,
  0x80000000, 0x80000000, 0xfffff000, 0xffffe001,
  0x80000000, 0xfffff000, 0xffffe001, 0xffffc002,
  0xfffff000, 0xffffe000, 0xffffc001, 0x80000000,
  0xffffe000, 0xffffc001, 0x80000000, 0x80000000,
  0xffffc000, 0x80000000, 0x80000000, 0xfffff000,
  0x80000000, 0x80000000, 0xfffff000, 0xffffe001,
  0x80000000, 0xfffff000, 0xffffe001, 0xffffc002,
  0xfffff000, 0xffffe000, 0xffffc001, 0xffff8003,
  0xffffe000, 0xffffc001, 0xffff8002, 0xffff0006,
  0xffffc000, 0xffff8001, 0xffff0004, 0x00000000,
  0xffff8000, 0xffff0002, 0x00000000, 0x00000000,
  0xffff0000, 0x00000000, 0x00000000, 0xffff8003,
  0x00000000, 0x00000000, 0xffff8002, 0xffff0006,
  0x00000000, 0xffff8001, 0xffff0004, 0xfffe000c,
  0xffff8000, 0xffff0002, 0xfffe0008, 0xfffc0018,
  0xffff0000, 0xfffe0004, 0xfffc0010, 0x00000000,
  0xfffe0000, 0xfffc0008, 0x00000000, 0x00000000,
  0xfffc0000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xfffff000,
  0x00000000, 0x00000000, 0xfffff000, 0xffffe001,
  0x00000000, 0xfffff000, 0xffffe001, 0xffffc002,
  0xfffff000, 0xffffe001, 0xffffc002, 0xffffff80,
  0xffffe000, 0xffffc001, 0xffff8003, 0xffffff00,
  0xffffc001, 0xffff8002, 0xffff0006, 0xfffffe00,
  0xffff8001, 0xffff0004, 0xfffe000c, 0x80000000,
  0xffff0002, 0xfffe0008, 0x80000000, 0x80000000,
  0xfffe0004, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0xfffffff0,
  0x80000000, 0x80000000, 0xfffff000, 0xffffffe0,
  0x80000000, 0xfffff000, 0xffffe001, 0xffffffc0,
  0xfffff000, 0xffffe001, 0xffffc002, 0x80000000,
  0xffffe000, 0xffffc001, 0x80000000, 0x80000000,
  0xffffc001, 0x80000000, 0x80000000, 0xfffffff0,
  0x80000000, 0x80000000, 0xfffff000, 0xffffffe0,
  0x80000000, 0xfffff000, 0xffffe001, 0xffffffc0,
  0xfffff000, 0xffffe001, 0xffffc002, 0xffffff80,
  0xffffe000, 0xffffc001, 0xffff8003, 0xffffff00,
  0xffffc001, 0xffff8002, 0xffff0006, 0x00000000,
  0xffff8001, 0xffff0004, 0x00000000, 0x00000000,
  0xffff0002, 0x00000000, 0x00000000, 0xffffff80,
  0x00000000, 0x00000000, 0xffff8003, 0xffffff00,
  0x00000000, 0xffff8002, 0xffff0006, 0xfffffe00,
  0xffff8001, 0xffff0004, 0xfffe000c, 0xfffffc00,
  0xffff0002, 0xfffe0008, 0xfffc0018, 0x00000000,
  0xfffe0004, 0xfffc0010, 0x00000000, 0x00000000,
  0xfffc0008, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xfffffff0,
  0x00000000, 0x00000000, 0xfffff000, 0xffffffe0,
  0x00000000, 0xfffff000, 0xffffe001, 0xffffffc0,
  0xfffff000, 0xffffe001, 0xffffffc0, 0xffffff81,
  0xffffe001, 0xffffc002, 0xffffff80, 0xffffff02,
  0xffffc001, 0xffff8003, 0xffffff00, 0xfffffe04,
  0xffff8002, 0xffff0006, 0xfffffe00, 0x80000000,
  0xffff0004, 0xfffe000c, 0x80000000, 0x80000000,
  0xfffe0008, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0xfffffff0,
  0x80000000, 0x80000000, 0xfffffff0, 0xffffffe0,
  0x80000000, 0xfffff000, 0xffffffe0, 0xffffffc1,
  0xfffff000, 0xffffe001, 0xffffffc0, 0x80000000,
  0xffffe001, 0xffffc002, 0x80000000, 0x80000000,
  0xffffc001, 0x80000000, 0x80000000, 0xfffffff0,
  0x80000000, 0x80000000, 0xfffffff0, 0xffffffe0,
  0x80000000, 0xfffff000, 0xffffffe0, 0xffffffc1,
  0xfffff000, 0xffffe001, 0xffffffc0, 0xffffff81,
  0xffffe001, 0xffffc002, 0xffffff80, 0xffffff02,
  0xffffc001, 0xffff8003, 0xffffff00, 0x00000000,
  0xffff8002, 0xffff0006, 0x00000000, 0x00000000,
  0xffff0004, 0x00000000, 0x00000000, 0xffffff81,
  0x00000000, 0x00000000, 0xffffff80, 0xffffff02,
  0x00000000, 0xffff8003, 0xffffff00, 0xfffffe04,
  0xffff8002, 0xffff0006, 0xfffffe00, 0xfffffc08,
  0xffff0004, 0xfffe000c, 0xfffffc00, 0x00000000,
  0xfffe0008, 0xfffc0018, 0x00000000, 0x00000000,
  0xfffc0010, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xfffffff0,
  0x00000000, 0x00000000, 0xfffffff0, 0xffffffe0,
  0x00000000, 0xfffff000, 0xffffffe0, 0xffffffc1,
  0xfffff000, 0xffffffe0, 0xffffffc1, 0xffffff82,
  0xffffe001, 0xffffffc0, 0xffffff81, 0xffffff04,
  0xffffc002, 0xffffff80, 0xffffff02, 0xfffffe08,
  0xffff8003, 0xffffff00, 0xfffffe04, 0x80000000,
  0xffff0006, 0xfffffe00, 0x80000000, 0x80000000,
  0xfffe000c, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0xfffffff0,
  0x80000000, 0x80000000, 0xfffffff0, 0xffffffe1,
  0x80000000, 0xfffffff0, 0xffffffe0, 0xffffffc1,
  0xfffff000, 0xffffffe0, 0xffffffc1, 0x80000000,
  0xffffe001, 0xffffffc0, 0x80000000, 0x80000000,
  0xffffc002, 0x80000000, 0x80000000, 0xfffffff0,
  0x80000000, 0x80000000, 0xfffffff0, 0xffffffe1,
  0x80000000, 0xfffffff0, 0xffffffe0, 0xffffffc1,
  0xfffff000, 0xffffffe0, 0xffffffc1, 0xffffff82,
  0xffffe001, 0xffffffc0, 0xffffff81, 0xffffff04,
  0xffffc002, 0xffffff80, 0xffffff02, 0x00000000,
  0xffff8003, 0xffffff00, 0x00000000, 0x00000000,
  0xffff0006, 0x00000000, 0x00000000, 0xffffff82,
  0x00000000, 0x00000000, 0xffffff81, 0xffffff04,
  0x00000000, 0xffffff80, 0xffffff02, 0xfffffe08,
  0xffff8003, 0xffffff00, 0xfffffe04, 0xfffffc10,
  0xffff0006, 0xfffffe00, 0xfffffc08, 0x00000000,
  0xfffe000c, 0xfffffc00, 0x00000000, 0x00000000,
  0xfffc0018, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xfffffff0,
  0x00000000, 0x00000000, 0xfffffff0, 0xffffffe1,
  0x00000000, 0xfffffff0, 0xffffffe0, 0xffffffc1,
  0xfffffff0, 0xffffffe0, 0xffffffc1, 0xffffff83,
  0xffffffe0, 0xffffffc1, 0xffffff82, 0xffffff06,
  0xffffffc0, 0xffffff81, 0xffffff04, 0xfffffe0c,
  0xffffff80, 0xffffff02, 0xfffffe08, 0x80000000,
  0xffffff00, 0xfffffe04, 0x80000000, 0x80000000,
  0xfffffe00, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0xfffffff0,
  0x80000000, 0x80000000, 0xfffffff0, 0xffffffe1,
  0x80000000, 0xfffffff0, 0xffffffe1, 0xffffffc2,
  0xfffffff0, 0xffffffe0, 0xffffffc1, 0x80000000,
  0xffffffe0, 0xffffffc1, 0x80000000, 0x80000000,
  0xffffffc0, 0x80000000, 0x80000000, 0xfffffff0,
  0x80000000, 0x80000000, 0xfffffff0, 0xffffffe1,
  0x80000000, 0xfffffff0, 0xffffffe1, 0xffffffc2,
  0xfffffff0, 0xffffffe0, 0xffffffc1, 0xffffff83,
  0xffffffe0, 0xffffffc1, 0xffffff82, 0xffffff06,
  0xffffffc0, 0xffffff81, 0xffffff04, 0x00000000,
  0xffffff80, 0xffffff02, 0x00000000, 0x00000000,
  0xffffff00, 0x00000000, 0x00000000, 0xffffff83,
  0x00000000, 0x00000000, 0xffffff82, 0xffffff06,
  0x00000000, 0xffffff81, 0xffffff04, 0xfffffe0c,
  0xffffff80, 0xffffff02, 0xfffffe08, 0xfffffc18,
  0xffffff00, 0xfffffe04, 0xfffffc10, 0x00000000,
  0xfffffe00, 0xfffffc08, 0x00000000, 0x00000000,
  0xfffffc00, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xfffffff0,
  0x00000000, 0x00000000, 0xfffffff0, 0xffffffe1,
  0x00000000, 0xfffffff0, 0xffffffe1, 0xffffffc2,
  0xfffffff0, 0xffffffe1, 0xffffffc2, 0xffffffe0,
  0xffffffe0, 0xffffffc1, 0xffffff83, 0xffffffc0,
  0xffffffc1, 0xffffff82, 0xffffff06, 0xffffff80,
  0xffffff81, 0xffffff04, 0xfffffe0c, 0x80000000,
  0xffffff02, 0xfffffe08, 0x80000000, 0x80000000,
  0xfffffe04, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0xfffffffc,
  0x80000000, 0x80000000, 0xfffffff0, 0xfffffff8,
  0x80000000, 0xfffffff0, 0xffffffe1, 0xfffffff0,
  0xfffffff0, 0xffffffe1, 0xffffffc2, 0x80000000,
  0xffffffe0, 0xffffffc1, 0x80000000, 0x80000000,
  0xffffffc1, 0x80000000, 0x80000000, 0xfffffffc,
  0x80000000, 0x80000000, 0xfffffff0, 0xfffffff8,
  0x80000000, 0xfffffff0, 0xffffffe1, 0xfffffff0,
  0xfffffff0, 0xffffffe1, 0xffffffc2, 0xffffffe0,
  0xffffffe0, 0xffffffc1, 0xffffff83, 0xffffffc0,
  0xffffffc1, 0xffffff82, 0xffffff06, 0x00000000,
  0xffffff81, 0xffffff04, 0x00000000, 0x00000000,
  0xffffff02, 0x00000000, 0x00000000, 0xffffffe0,
  0x00000000, 0x00000000, 0xffffff83, 0xffffffc0,
  0x00000000, 0xffffff82, 0xffffff06, 0xffffff80,
  0xffffff81, 0xffffff04, 0xfffffe0c, 0xffffff00,
  0xffffff02, 0xfffffe08, 0xfffffc18, 0x00000000,
  0xfffffe04, 0xfffffc10, 0x00000000, 0x00000000,
  0xfffffc08, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xfffffffc,
  0x00000000, 0x00000000, 0xfffffff0, 0xfffffff8,
  0x00000000, 0xfffffff0, 0xffffffe1, 0xfffffff0,
  0xfffffff0, 0xffffffe1, 0xfffffff0, 0xfffffffd,
  0xffffffe1, 0xffffffc2, 0xffffffe0, 0xfffffffa,
  0xffffffc1, 0xffffff83, 0xffffffc0, 0xfffffff4,
  0xffffff82, 0xffffff06, 0xffffff80, 0x80000000,
  0xffffff04, 0xfffffe0c, 0x80000000, 0x80000000,
  0xfffffe08, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x00000000,
  0x80000000, 0x80000000, 0xfffffffc, 0xffffffff,
  0x80000000, 0xfffffff0, 0xfffffff8, 0xffffffff,
  0xfffffff0, 0xffffffe1, 0xfffffff0, 0x80000000,
  0xffffffe1, 0xffffffc2, 0x80000000, 0x80000000,
  0xffffffc1, 0x80000000, 0x80000000, 0x00000000,
  0x80000000, 0x80000000, 0xfffffffc, 0xffffffff,
  0x80000000, 0xfffffff0, 0xfffffff8, 0xffffffff,
  0xfffffff0, 0xffffffe1, 0xfffffff0, 0xfffffffd,
  0xffffffe1, 0xffffffc2, 0xffffffe0, 0xfffffffa,
  0xffffffc1, 0xffffff83, 0xffffffc0, 0x00000000,
  0xffffff82, 0xffffff06, 0x00000000, 0x00000000,
  0xffffff04, 0x00000000, 0x00000000, 0xfffffffd,
  0x00000000, 0x00000000, 0xffffffe0, 0xfffffffa,
  0x00000000, 0xffffff83, 0xffffffc0, 0xfffffff4,
  0xffffff82, 0xffffff06, 0xffffff80, 0xffffffe8,
  0xffffff04, 0xfffffe0c, 0xffffff00, 0x00000000,
  0xfffffe08, 0xfffffc18, 0x00000000, 0x00000000,
  0xfffffc10, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0xfffffffc, 0xffffffff,
  0x00000000, 0xfffffff0, 0xfffffff8, 0xffffffff,
  0xfffffff0, 0xfffffff8, 0xffffffff, 0xfffffffe,
  0xffffffe1, 0xfffffff0, 0xfffffffd, 0xfffffffc,
  0xffffffc2, 0xffffffe0, 0xfffffffa, 0xfffffff8,
  0xffffff83, 0xffffffc0, 0xfffffff4, 0x80000000,
  0xffffff06, 0xffffff80, 0x80000000, 0x80000000,
  0xfffffe0c, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x00000000,
  0x80000000, 0x80000000, 0x00000000, 0x00000000,
  0x80000000, 0xfffffffc, 0xffffffff, 0xffffffff,
  0xfffffff0, 0xfffffff8, 0xffffffff, 0x80000000,
  0xffffffe1, 0xfffffff0, 0x80000000, 0x80000000,
  0xffffffc2, 0x80000000, 0x80000000, 0x00000000,
  0x80000000, 0x80000000, 0x00000000, 0x00000000,
  0x80000000, 0xfffffffc, 0xffffffff, 0xffffffff,
  0xfffffff0, 0xfffffff8, 0xffffffff, 0xfffffffe,
  0xffffffe1, 0xfffffff0, 0xfffffffd, 0xfffffffc,
  0xffffffc2, 0xffffffe0, 0xfffffffa, 0x00000000,
  0xffffff83, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffff06, 0x00000000, 0x00000000, 0xfffffffe,
  0x00000000, 0x00000000, 0xfffffffd, 0xfffffffc,
  0x00000000, 0xffffffe0, 0xfffffffa, 0xfffffff8,
  0xffffff83, 0xffffffc0, 0xfffffff4, 0xfffffff0,
  0xffffff06, 0xffffff80, 0xffffffe8, 0x00000000,
  0xfffffe0c, 0xffffff00, 0x00000000, 0x00000000,
  0xfffffc18, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0xfffffffc, 0xffffffff, 0xffffffff,
  0xfffffffc, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffff8, 0xffffffff, 0xfffffffe, 0xfffffffe,
  0xfffffff0, 0xfffffffd, 0xfffffffc, 0xfffffffc,
  0xffffffe0, 0xfffffffa, 0xfffffff8, 0x80000000,
  0xffffffc0, 0xfffffff4, 0x80000000, 0x80000000,
  0xffffff80, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x00000000,
  0x80000000, 0x80000000, 0x00000000, 0x00000000,
  0x80000000, 0x00000000, 0x00000000, 0x00000000,
  0xfffffffc, 0xffffffff, 0xffffffff, 0x80000000,
  0xfffffff8, 0xffffffff, 0x80000000, 0x80000000,
  0xfffffff0, 0x80000000, 0x80000000, 0x00000000,
  0x80000000, 0x80000000, 0x00000000, 0x00000000,
  0x80000000, 0x00000000, 0x00000000, 0x00000000,
  0xfffffffc, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffff8, 0xffffffff, 0xfffffffe, 0xfffffffe,
  0xfffffff0, 0xfffffffd, 0xfffffffc, 0x00000000,
  0xffffffe0, 0xfffffffa, 0x00000000, 0x00000000,
  0xffffffc0, 0x00000000, 0x00000000, 0xffffffff,
  0x00000000, 0x00000000, 0xfffffffe, 0xfffffffe,
  0x00000000, 0xfffffffd, 0xfffffffc, 0xfffffffc,
  0xffffffe0, 0xfffffffa, 0xfffffff8, 0xfffffff8,
  0xffffffc0, 0xfffffff4, 0xfffffff0, 0x00000000,
  0xffffff80, 0xffffffe8, 0x00000000, 0x00000000,
  0xffffff00, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
};
const unsigned kExpectedCount_NEON_sqrshl_4S = 961;

#endif  // VIXL_SIM_SQRSHL_4S_TRACE_AARCH64_H_
