/* ----------------------------------------------------------------------- *
 *
 *   Copyright 2008 rPath, Inc. - All Rights Reserved
 *   Copyright 2010 Intel Corporation; author: H. Peter Anvin
 *
 *   Permission is hereby granted, free of charge, to any person
 *   obtaining a copy of this software and associated documentation
 *   files (the "Software"), to deal in the Software without
 *   restriction, including without limitation the rights to use,
 *   copy, modify, merge, publish, distribute, sublicense, and/or
 *   sell copies of the Software, and to permit persons to whom
 *   the Software is furnished to do so, subject to the following
 *   conditions:
 *
 *   The above copyright notice and this permission notice shall
 *   be included in all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 *   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 *   HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 *   OTHER DEALINGS IN THE SOFTWARE.
 *
 * ----------------------------------------------------------------------- */

/*
 * Stub to work around Grub, or other loaders which can't load directly
 * into low memory.  This code needs four parameters which should
 * immediately precede it: source of code to be copied, target of code
 * to be copied, length of code to be copied, post-copy entry point.
 */
		/* Parameters */
		.section ".startupinfo","a",@progbits
mv_entry:	.long	0
mv_move:	.long	0, 0, 0			/* Setup code */
		.long	0, 0, 0			/* zImage kernel code */
		.long	0, 0, 0			/* Null terminator */

		/* We will be entered in flat 32-bit protected mode... */
		.section ".start","ax",@progbits
		.globl	_start
		.code32
_start:
		call	1f
1:		pushfl
		pushl	%ecx
		pushl	%ebx
		pushl	%esi
		pushl	%edi
		movl	(5*4)(%esp), %ebx
		subl	$1b, %ebx

		movl	mv_entry(%ebx), %ecx
		movl	%ecx, (5*4)(%esp)	/* Where to go next */

		addl	$mv_move, %ebx
2:
		movl	(%ebx), %edi
		movl	4(%ebx), %esi
		movl	8(%ebx), %ecx
		addl	$3, %ecx
		shrl	$2, %ecx
		jz	3f			/* Zero length = we're done */

		cld
		rep ; movsl

		addl	$12, %ebx
		jmp	2b
	
3:
		popl	%edi
		popl	%esi
		popl	%ebx
		popl	%ecx
		popfl
		retl				/* Goes to the entry point */
