#include <udposix.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <xgks.h>

/* GKS i/o defines */

#define WS_ID  1
#define INDEV  2
#define PET 2


main()
{
    static Glimit   echo_area = {.0, 1280.0, 0.0, 1024.0};
    Gloc            loc;
    Glocrec         r;

    /* GKS Initialization */

    gopengks(stderr, 0);
    gopenws(WS_ID, (char*)NULL, (char*)NULL);
    gactivatews(WS_ID);

    /* initialize locator */

    loc.position.x = 0.5;
    loc.position.y = 0.5;
    loc.transform = 0;

    ginitloc(WS_ID, INDEV, &loc, PET, &echo_area, &r);
    gsetlocmode(WS_ID, INDEV, GREQUEST, GECHO);

    for (;;) {
	Gqloc            response;

	(void) greqloc(WS_ID, INDEV, &response);
	
	if (response.status == GNONE)
	    break;

	(void) printf("%f %f\n", response.loc.position.x, 
		      response.loc.position.y);
    }

    /* wait for carriage return */

    errno	= 0;
    if (getchar() == EOF)
	perror("getchar()");

    /* termination */

    gdeactivatews(WS_ID);
    gclosews(WS_ID);
    gclosegks();

    return EXIT_SUCCESS;
}
