#!/usr/bin/perl

#  Yudit Unicode Editor Source File
#
#  Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#
# This script makes a precompose map.
# In order to run the script you need to get
#  ftp://ftp.unicode.org/Public/UNIDATA/UnicodeData.txt
# as and input.
# encode composing chars -> precomposed char
# decode precomposed char -> composing chars

die "No version specified." if ($#ARGV == -1);
$VERSION=shift;


@encodes = ();
@decodes = ();

while (<>)
{
  @_ = split(';', $_);
  next if ($#_ < 6);
  $plain = $_[0];
  $plain = hex $plain;
  next if ($plain > 0xffff);

  $components = $_[5];
  # Added for kanji aliases
  if ($_[1] =~ /KANGXI RADICAL/) {
    $components =~ s/<compat> //; 
  }
  next if (length ($components)==0);
  @compose = split (' ', $components);
  if ($#compose <=0) {
        @compose = ($components);
  }
  $good = 1;
  @hexcomp = ();
  for (@compose)
  {
    if ($_ !~ /^[0-9A-Fa-f]{4}/)
    {
      $good = 0;
      last;
    }
    push (@hexcomp, $_);
  }
  next if ($good == 0);
  next if ($#hexcomp < 0);
  next if ($#hexcomp <= 0 && $_[1] !~ /KANGXI RADICAL/);
  

  $key = sprintf ("%04X", $plain);
  
  #
  # make it utf-8 - dont
  # 
  #if ($plain >= 0x0800)
  #{
  #   $key = sprintf ("%02X %02X %02X", 
  #       0xe0 | ($plain>>12), 0x80 | (($plain>>6)&0x3f), 0x80 | ($plain&0x3f));
  #}
  #elsif ($plain >= 0x80)
  #{
  #   $key = sprintf ("%02X %02X", 0xc0 | ($plain>>6), 0x80 | ($plain&0x3f));
  #}
  #else
  #{
  #   $key = sprintf ("%02X", $plain);
  #}
  # For KANGXI RADICAL we reverse - the compose is the main.
  if ($_[1] =~ /KANGXI RADICAL/) 
  {
    push (@encodes, $key . " -> " . join (' ', @hexcomp));
    push (@decodes, join (' ', @hexcomp) . " -> " . $key);
  } else {
    push (@decodes, $key . " -> " . join (' ', @hexcomp));
    push (@encodes, join (' ', @hexcomp) . " -> " . $key);
  }
 
}
@full_date = localtime(time);
$year = $full_date[5] + 1900;
$mon = $full_date[4] + 1;
$mday = $full_date[3];
$date = sprintf ("%4d-%02d-%02d", $year, $mon, $mday);
$name="precompose1.my";

print <<EOD;
#
# generated by $0 $date
# decoder
# This file is should be used from yudit-3.0.8 and up.
# precompose.mys is kept in mytool directory for compatibility
# with older versions.
#
NAME=$name
COMM=autogenerated by $0 $date from
COMM=ftp://ftp.unicode.org/Public/$VERSION/uc/UnicodeData.txt 
TYPE=0
SECTION=decompose
ENCODE=0
KEY_WIDTH=1
VALUE_WIDTH=1
KEY_LENGTH=0
VALUE_LENGTH=0
EOD
print join ("$/", @decodes);
print "$/";
#
# Jamos 
# From: Miikka-Markus Alhonen <Miikka-Markus.Alhonen@tigatieto.com>
# 2001-12-24
#
$syl = 0xac00;
for ($i = 0x1100; $i <= 0x1112; $i++) {
   for ($j = 0x1161; $j <= 0x1175; $j++) {
      for ($k = 0x11a7; $k <= 0x11c2; $k++) {
          printf ("%04X -> %04X %04X",$syl,$i,$j);
          printf (" %04X",$k) if $k != 0x11a7;
          print "\n";
          $syl++;
      }
   }
}

print <<EOD;
#
# encoder
#
SECTION=compose
ENCODE=1
KEY_WIDTH=1
VALUE_WIDTH=1
KEY_LENGTH=0
VALUE_LENGTH=0
EOD
print join ("$/", @encodes);
print "$/";
#
# Jamos
# From: Miikka-Markus Alhonen <Miikka-Markus.Alhonen@tigatieto.com>
# 2001-12-24
$syl = 0xac00;
for ($i = 0x1100; $i <= 0x1112; $i++) {
   for ($j = 0x1161; $j <= 0x1175; $j++) {
      for ($k = 0x11a7; $k <= 0x11c2; $k++) {
          printf ("%04X %04X ",$i,$j);
          printf ("%04X ",$k) if $k != 0x11a7;
          printf ("-> %04X\n",$syl);
          $syl++;
      }
   }
}
print "#END$/";
