/*
 *   iswraid.h Copyright (C) 2003,2004 Intel Corporation. 
 *   All rights reserved.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   You should have received a copy of the GNU General Public License
 *   (for example /usr/src/linux/COPYING); if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors: Boji Tony Kannanthanam 
 *            < boji dot t dot kannanthanam at intel dot com >
 *            Martins Krikis
 *            < martins dot krikis at intel dot com >
 */

//                           "12345678901234567890123456789012"
#define MPB_SIGNATURE	     "Intel Raid ISM Cfg Sig. "
#define MPB_VERSION_RAID0                             "1.0.00"
#define MPB_VERSION_RAID1                             "1.1.00"
#define MPB_VERSION_RAID2                             "1.2.00"
#define MAX_SIGNATURE_LENGTH  32
#define MAX_RAID_SERIAL_LEN   16
#define ISW_DISK_BLOCK_SIZE  512

struct MpbSerial {
	char serial[MAX_RAID_SERIAL_LEN];
};

/* DISK CONFIGURATION INFO */
struct _MpbDisk {
	struct MpbSerial serial;	// ascii serial number
	u32 totalBlocks;	// total blocks
	u32 scsiId;		// scsi ID
	u32 status;		// spare, configured, failed, useable, etc.
#define	MPB_DISK_FILLERS	(5)	// filler space reserved for
	u32 filler[MPB_DISK_FILLERS];	//   future expansion
};

/* RAID MAP CONFIGURATION INFO */
struct _MpbRaidMap {
	u32 pbaOfLba0;		// start address of partition
	u32 blocksPerMember;	// blocks per member
	u32 numDataStripes;	// number of data stripes
	u16 blocksPerStrip;
	u8 mapState;		// Normal, Uninitialized, Degraded, Failed
	u8 raidLevel;		// 0, 1
	u8 numMembers;		// number of member disks
	u8 reserved[3];
#define MPB_RAID_MAP_FILLERS	(7)	// expansion area
	u32 filler[MPB_RAID_MAP_FILLERS];	// expansion area
	u32 diskOrdTbl[1];      // diskOrdTbl[numMembers], top byte special
};

/* RAID VOLUME INFO */
struct _MpbRaidVol {
	u32 reserved[2];
	u8 migrState;		// Normal or Migrating
	u8 migrType;		// Initializing, Rebuilding, ...
	u8 dirty;
	u8 fill[1];
#define	MPB_RAID_VOL_FILLERS	(5)	// expansion area keeps the loMap
	u32 filler[MPB_RAID_VOL_FILLERS];
	struct _MpbRaidMap loMap;
	// here comes another one if migrState
};

/* RAID DEVICE CONFIGURATION INFO */
struct _MpbRaidDev {
	struct MpbSerial serial;	// serial number
	u32 numDataBlocksLo;	// Data blocks on device (low 32 bits)
	u32 numDataBlocksHi;	// Data blocks on device (high 32 bits)
	u32 status;		// Persistent RaidDev status
	u32 reservedBlocks;	// Reserved blocks at beginning of volume
#define	MPB_RAID_DEV_FILLERS	(12)
	u32 filler[MPB_RAID_DEV_FILLERS];
	struct _MpbRaidVol raidVol;
};

struct RaidCfgSig {
	char text[MAX_SIGNATURE_LENGTH];
};

struct _RaidMpb {
	struct RaidCfgSig sig;
	u32 checkSum;	   // MPB Checksum
	u32 mpbSize;	   // Size of MPB
	u32 familyNum;	   // Checksum from first time this config was written
	u32 generationNum; // Incremented each time this array's MPB is written
	u32 reserved[2];
	u8 numDisks;	   // Number of configured disks
	u8 numRaidDevs;    // Number of configured volumes
	u8 fill[2];
#define RAID_MPB_FILLERS	(39)
	u32 filler[RAID_MPB_FILLERS];
	struct _MpbDisk diskTbl[1]; // diskTbl[numDisks]
	// here comes _MpbRaidDev[numRaidDevs]
};
